/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileLanguageProvider;
import org.jetbrains.kotlin.idea.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.ClearScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.StopScratchAction;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0012\u001a\u00020\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00130\u0015J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u0004\u0018\u00010\u0017J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010'\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "actionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "isInteractiveCheckbox", "Ljavax/swing/JCheckBox;", "isMakeBeforeRunCheckbox", "isReplCheckbox", "moduleChooser", "Lcom/intellij/application/options/ModulesComboBox;", "moduleSeparator", "Ljavax/swing/JSeparator;", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "addModuleListener", "", "f", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/module/Module;", "changeMakeModuleCheckboxVisibility", "isVisible", "", "createActionsToolbar", "createModuleChooser", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "getModule", "setInteractiveMode", "isSelected", "setMakeBeforeRun", "setModule", "module", "setReplMode", "updateToolbar", "Companion", "idea-jvm"})
public final class ScratchTopPanel
extends JPanel
implements Disposable {
    private final ModulesComboBox moduleChooser;
    private final JCheckBox isReplCheckbox;
    private final JCheckBox isMakeBeforeRunCheckbox;
    private final JCheckBox isInteractiveCheckbox;
    private final JSeparator moduleSeparator;
    private final ActionToolbar actionsToolbar;
    @NotNull
    private final ScratchFile scratchFile;
    public static final Companion Companion = new Companion(null);

    public void dispose() {
        ScratchUtilsKt.removeScratchPanel(this.scratchFile.getEditor());
    }

    @Nullable
    public final Module getModule() {
        return this.moduleChooser.getSelectedModule();
    }

    public final void setModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.moduleChooser.setSelectedModule(module);
    }

    public final void addModuleListener(@NotNull Function2<? super PsiFile, ? super Module, Unit> f2) {
        Intrinsics.checkParameterIsNotNull(f2, (String)"f");
        this.moduleChooser.addActionListener(new ActionListener(this, f2){
            final /* synthetic */ ScratchTopPanel this$0;
            final /* synthetic */ Function2 $f;

            public final void actionPerformed(ActionEvent it) {
                Module selectedModule = ScratchTopPanel.access$getModuleChooser$p(this.this$0).getSelectedModule();
                ScratchTopPanel.access$changeMakeModuleCheckboxVisibility(this.this$0, selectedModule != null);
                PsiFile psiFile = this.this$0.getScratchFile().getPsiFile();
                if (psiFile != null) {
                    this.$f.invoke((Object)psiFile, (Object)selectedModule);
                }
            }
            {
                this.this$0 = scratchTopPanel;
                this.$f = function2;
            }
        });
    }

    public final void setReplMode(boolean isSelected) {
        this.isReplCheckbox.setSelected(isSelected);
    }

    public final void setMakeBeforeRun(boolean isSelected) {
        this.isMakeBeforeRunCheckbox.setSelected(isSelected);
    }

    public final void setInteractiveMode(boolean isSelected) {
        this.isInteractiveCheckbox.setSelected(isSelected);
    }

    private final void changeMakeModuleCheckboxVisibility(boolean isVisible) {
        this.isMakeBeforeRunCheckbox.setVisible(isVisible);
        this.moduleSeparator.setVisible(isVisible);
    }

    public final void updateToolbar() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ ScratchTopPanel this$0;

            public final void run() {
                ScratchTopPanel.access$getActionsToolbar$p(this.this$0).updateActionsImmediately();
            }
            {
                this.this$0 = scratchTopPanel;
            }
        });
    }

    private final ActionToolbar createActionsToolbar() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup $this$apply = defaultActionGroup;
        boolean bl3 = false;
        $this$apply.add((AnAction)new RunScratchAction());
        $this$apply.add((AnAction)new StopScratchAction());
        $this$apply.addSeparator();
        $this$apply.add((AnAction)new ClearScratchAction());
        DefaultActionGroup toolbarGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarGroup, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026LBAR, toolbarGroup, true)");
        return actionToolbar;
    }

    /*
     * WARNING - void declaration
     */
    private final ModulesComboBox createModuleChooser(Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ModulesComboBox modulesComboBox = new ModulesComboBox();
        boolean bl = false;
        boolean bl2 = false;
        ModulesComboBox $this$apply = modulesComboBox;
        boolean bl3 = false;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] moduleArray2 = moduleArray;
        ModulesComboBox modulesComboBox2 = $this$apply;
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var13_13 = $this$filterTo$iv$iv;
        int n = ((void)var13_13).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var13_13[j];
            boolean bl4 = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            if (!(IdeaModuleInfosKt.productionSourceInfo((Module)v2) != null || IdeaModuleInfosKt.testSourceInfo((Module)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        modulesComboBox2.setModules((Collection)list2);
        $this$apply.allowEmptySelection("<no module>");
        return modulesComboBox;
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    private ScratchTopPanel(ScratchFile scratchFile) {
        super((LayoutManager)new HorizontalLayout(5));
        this.scratchFile = scratchFile;
        this.actionsToolbar = this.createActionsToolbar();
        this.add(this.actionsToolbar.getComponent());
        this.moduleChooser = this.createModuleChooser(this.scratchFile.getProject());
        this.add(new JLabel("Use classpath of module"));
        this.add((Component)this.moduleChooser);
        this.isMakeBeforeRunCheckbox = new JCheckBox("Make before Run");
        this.add(this.isMakeBeforeRunCheckbox);
        this.isMakeBeforeRunCheckbox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(){

                    @NotNull
                    public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$saveOptions, (String)"$receiver");
                        return ScratchFileOptions.copy$default($this$saveOptions, false, isMakeBeforeRunCheckbox.isSelected(), false, 5, null);
                    }
                }));
            }
        });
        this.moduleSeparator = new JSeparator(1);
        this.add(this.moduleSeparator);
        this.changeMakeModuleCheckboxVisibility(false);
        this.isInteractiveCheckbox = new JCheckBox("Interactive mode");
        this.add(this.isInteractiveCheckbox);
        this.isInteractiveCheckbox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(){

                    @NotNull
                    public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$saveOptions, (String)"$receiver");
                        return ScratchFileOptions.copy$default($this$saveOptions, false, false, isInteractiveCheckbox.isSelected(), 3, null);
                    }
                }));
            }
        });
        this.add(new JSeparator(1));
        this.isReplCheckbox = new JCheckBox("Use REPL");
        this.add(this.isReplCheckbox);
        this.isReplCheckbox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                this.getScratchFile().saveOptions((Function1<? super ScratchFileOptions, ScratchFileOptions>)((Function1)new Function1<ScratchFileOptions, ScratchFileOptions>(){

                    @NotNull
                    public final ScratchFileOptions invoke(@NotNull ScratchFileOptions $this$saveOptions) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$saveOptions, (String)"$receiver");
                        return ScratchFileOptions.copy$default($this$saveOptions, isReplCheckbox.isSelected(), false, false, 6, null);
                    }
                }));
            }
        });
        this.add(new JSeparator(1));
        ScratchFileOptions scratchFileOptions = this.scratchFile.getOptions();
        boolean bl = false;
        boolean bl2 = false;
        ScratchFileOptions it = scratchFileOptions;
        boolean bl3 = false;
        this.isReplCheckbox.setSelected(it.isRepl());
        this.isMakeBeforeRunCheckbox.setSelected(it.isMakeBeforeRun());
        this.isInteractiveCheckbox.setSelected(it.isInteractiveMode());
    }

    public static final /* synthetic */ ModulesComboBox access$getModuleChooser$p(ScratchTopPanel $this) {
        return $this.moduleChooser;
    }

    public static final /* synthetic */ void access$changeMakeModuleCheckboxVisibility(ScratchTopPanel $this, boolean isVisible) {
        $this.changeMakeModuleCheckboxVisibility(isVisible);
    }

    public static final /* synthetic */ ActionToolbar access$getActionsToolbar$p(ScratchTopPanel $this) {
        return $this.actionsToolbar;
    }

    public /* synthetic */ ScratchTopPanel(ScratchFile scratchFile, DefaultConstructorMarker $constructor_marker) {
        this(scratchFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel$Companion;", "", "()V", "createPanel", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "idea-jvm"})
    public static final class Companion {
        public final void createPanel(@NotNull Project project, @NotNull VirtualFile virtualFile2, @NotNull TextEditor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiManager.getInstance(p\u2026le(virtualFile) ?: return");
            PsiFile psiFile2 = psiFile;
            Language language = psiFile2.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
            Object object = ScratchFileLanguageProvider.Companion.get(language);
            if (object == null || (object = ((ScratchFileLanguageProvider)object).createFile(project, editor2)) == null) {
                return;
            }
            Object scratchFile = object;
            ScratchUtilsKt.addScratchPanel(editor2, new ScratchTopPanel((ScratchFile)scratchFile, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

