/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.scratch.output.ScratchToolWindowFactory;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandler$WhenMappings;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandlerKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J)\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00040\u0016\u00a2\u0006\u0002\b\u0018H\u0002J\u0014\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/ToolWindowScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandlerAdapter;", "()V", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "error", "message", "", "getToolWindow", "project", "Lcom/intellij/openapi/project/Project;", "handle", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "printToConsole", "print", "Lkotlin/Function1;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lkotlin/ExtensionFunctionType;", "convert", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputType;", "idea-jvm"})
final class ToolWindowScratchOutputHandler
extends ScratchOutputHandlerAdapter {
    public static final ToolWindowScratchOutputHandler INSTANCE;

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(file2, expression2, output){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchOutput $output;

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                Intrinsics.checkParameterIsNotNull((Object)$this$printToConsole, (String)"$receiver");
                PsiFile psiFile = this.$file.getPsiFile();
                if (psiFile != null) {
                    $this$printToConsole.printHyperlink(ToolWindowScratchOutputHandlerKt.access$getLineInfo(psiFile, this.$expression), (HyperlinkInfo)new OpenFileHyperlinkInfo($this$printToConsole.getProject(), psiFile.getVirtualFile(), this.$expression.getLineStart()));
                    $this$printToConsole.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                $this$printToConsole.print(this.$output.getText(), ToolWindowScratchOutputHandler.access$convert(ToolWindowScratchOutputHandler.INSTANCE, this.$output.getType()));
            }
            {
                this.$file = scratchFile;
                this.$expression = scratchExpression;
                this.$output = scratchOutput;
                super(1);
            }
        }));
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.printToConsole(file2, (Function1<? super ConsoleViewImpl, Unit>)((Function1)new Function1<ConsoleViewImpl, Unit>(message2){
            final /* synthetic */ String $message;

            public final void invoke(@NotNull ConsoleViewImpl $this$printToConsole) {
                Intrinsics.checkParameterIsNotNull((Object)$this$printToConsole, (String)"$receiver");
                $this$printToConsole.print(this.$message, ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.$message = string;
                super(1);
            }
        }));
    }

    private final void printToConsole(ScratchFile file2, Function1<? super ConsoleViewImpl, Unit> print2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(file2, print2){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ Function1 $print;

            public final void run() {
                Content[] contents;
                Project project = this.$file.getProject();
                boolean bl = false;
                boolean bl2 = false;
                Project it = project;
                boolean bl3 = false;
                Object object = !it.isDisposed() ? project : null;
                if (object == null) {
                    return;
                }
                Project project2 = object;
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(ToolWindowScratchOutputHandler.INSTANCE, project2);
                if (toolWindow == null) {
                    toolWindow = ToolWindowScratchOutputHandler.access$createToolWindow(ToolWindowScratchOutputHandler.INSTANCE, this.$file);
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contentArray = contentManager.getContents();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentArray, (String)"toolWindow.contentManager.contents");
                Content[] contentArray2 = contents = contentArray;
                int n = contentArray2.length;
                for (int j = 0; j < n; ++j) {
                    Content content2;
                    Content content3 = content2 = contentArray2[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    JComponent component = content3.getComponent();
                    if (!(component instanceof ConsoleViewImpl)) continue;
                    this.$print.invoke((Object)component);
                    ((ConsoleViewImpl)component).print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
                toolWindow2.setAvailable(true, null);
                if (!this.$file.getOptions().isInteractiveMode()) {
                    toolWindow2.show(null);
                }
                LanguageFileType languageFileType = ScratchFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)languageFileType, (String)"ScratchFileType.INSTANCE");
                toolWindow2.setIcon(ExecutionUtil.getLiveIndicator((Icon)languageFileType.getIcon()));
            }
            {
                this.$file = scratchFile;
                this.$print = function1;
            }
        });
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ApplicationManager.getApplication().invokeLater(new Runnable(file2){
            final /* synthetic */ ScratchFile $file;

            public final void run() {
                Content[] contents;
                ToolWindow toolWindow = ToolWindowScratchOutputHandler.access$getToolWindow(ToolWindowScratchOutputHandler.INSTANCE, this.$file.getProject());
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                ContentManager contentManager = toolWindow2.getContentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
                Content[] contentArray = contentManager.getContents();
                Intrinsics.checkExpressionValueIsNotNull((Object)contentArray, (String)"toolWindow.contentManager.contents");
                Content[] contentArray2 = contents = contentArray;
                int n = contentArray2.length;
                for (int j = 0; j < n; ++j) {
                    Content content2;
                    Content content3 = content2 = contentArray2[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"content");
                    JComponent component = content3.getComponent();
                    if (!(component instanceof ConsoleViewImpl)) continue;
                    ((ConsoleViewImpl)component).clear();
                }
                if (!this.$file.getOptions().isInteractiveMode()) {
                    toolWindow2.hide(null);
                }
                LanguageFileType languageFileType = ScratchFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)languageFileType, (String)"ScratchFileType.INSTANCE");
                toolWindow2.setIcon(languageFileType.getIcon());
            }
            {
                this.$file = scratchFile;
            }
        });
    }

    private final ConsoleViewContentType convert(@NotNull ScratchOutputType $this$convert) {
        ConsoleViewContentType consoleViewContentType;
        switch (ToolWindowScratchOutputHandler$WhenMappings.$EnumSwitchMapping$0[$this$convert.ordinal()]) {
            case 1: {
                consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case 2: {
                consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                break;
            }
            case 3: {
                consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return consoleViewContentType;
    }

    private final ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        return toolWindowManager.getToolWindow("Scratch Output");
    }

    private final ToolWindow createToolWindow(ScratchFile file2) {
        Project project = file2.getProject();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.registerToolWindow("Scratch Output", false, ToolWindowAnchor.BOTTOM);
        ToolWindow window2 = toolWindowManager.getToolWindow("Scratch Output");
        ScratchToolWindowFactory scratchToolWindowFactory = new ScratchToolWindowFactory();
        ToolWindow toolWindow = window2;
        Intrinsics.checkExpressionValueIsNotNull((Object)toolWindow, (String)"window");
        scratchToolWindowFactory.createToolWindowContent(project, toolWindow);
        Disposer.register((Disposable)((Disposable)file2.getEditor()), (Disposable)new Disposable(window2){
            final /* synthetic */ ToolWindow $window;

            public final void dispose() {
                this.$window.setAvailable(false, null);
            }
            {
                this.$window = toolWindow;
            }
        });
        return window2;
    }

    private ToolWindowScratchOutputHandler() {
    }

    static {
        ToolWindowScratchOutputHandler toolWindowScratchOutputHandler;
        INSTANCE = toolWindowScratchOutputHandler = new ToolWindowScratchOutputHandler();
    }

    public static final /* synthetic */ ConsoleViewContentType access$convert(ToolWindowScratchOutputHandler $this, ScratchOutputType $this$access_u24convert) {
        return $this.convert($this$access_u24convert);
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow(ToolWindowScratchOutputHandler $this, Project project) {
        return $this.getToolWindow(project);
    }

    public static final /* synthetic */ ToolWindow access$createToolWindow(ToolWindowScratchOutputHandler $this, ScratchFile file2) {
        return $this.createToolWindow(file2);
    }
}

