/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.AbstractPullPushMembersHandler;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoStorage;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownDialog;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessor;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/AbstractPullPushMembersHandler;", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "member", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "reportFinalClassOrObject", "Companion", "TestHelper", "idea"})
public final class KotlinPushDownHandler
extends AbstractPullPushMembersHandler {
    @NotNull
    private static final String PUSH_DOWN_TEST_HELPER_KEY = "PUSH_DOWN_TEST_HELPER_KEY";
    public static final Companion Companion = new Companion(null);

    private final void reportFinalClassOrObject(Project project, Editor editor2, KtClassOrObject classOrObject) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)StringsKt.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)classOrObject, (boolean)false) + " is final")));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message2, (String)KotlinPullUpHandlerKt.getPULL_MEMBERS_UP(), (String)"refactoring.pullMembersUp");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable KtClassOrObject classOrObject, @Nullable KtNamedDeclaration member, @Nullable DataContext dataContext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (classOrObject == null) {
            this.reportWrongContext(project, editor2);
            return;
        }
        if (!(classOrObject instanceof KtClass) || !PsiModificationUtilsKt.isInheritable((KtClass)classOrObject)) {
            this.reportFinalClassOrObject(project, editor2, classOrObject);
            return;
        }
        List list2 = new KotlinMemberInfoStorage(classOrObject, null, 2, null).getClassMemberInfos(classOrObject);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"KotlinMemberInfoStorage(\u2026emberInfos(classOrObject)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv$iv);
            boolean bl = false;
            KotlinMemberInfo kotlinMemberInfo = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
            if (!(!(kotlinMemberInfo.getMember() instanceof KtParameter))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List members2 = (List)destination$iv$iv;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            DataContext dataContext2 = dataContext;
            Object object = dataContext2 != null ? dataContext2.getData(PUSH_DOWN_TEST_HELPER_KEY) : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandler.TestHelper");
            }
            TestHelper helper2 = (TestHelper)object;
            List<KotlinMemberInfo> selectedMembers = helper2.adjustMembers(members2);
            new KotlinPushDownProcessor(project, (KtClass)classOrObject, selectedMembers).run();
        } else {
            void $this$filterTo$iv$iv2;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager manager = psiManager;
            Iterable $this$filter$iv2 = members2;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv$iv);
                boolean bl = false;
                KotlinMemberInfo kotlinMemberInfo = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
                if (!manager.areElementsEquivalent(kotlinMemberInfo.getMember(), (PsiElement)member)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinMemberInfo it = (KotlinMemberInfo)((Object)element$iv);
                boolean bl = false;
                KotlinMemberInfo kotlinMemberInfo = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinMemberInfo), (String)"it");
                kotlinMemberInfo.setChecked(true);
            }
            new KotlinPushDownDialog(project, members2, (KtClass)classOrObject).show();
        }
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        super.invoke(project, elements2, dataContext);
        String string = this.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this::class.java.name");
        KotlinFUSLogger.Companion.log(FUSEventGroups.Refactoring, string);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        super.invoke(project, editor2, file2, dataContext);
        String string = this.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this::class.java.name");
        KotlinFUSLogger.Companion.log(FUSEventGroups.Refactoring, string);
    }

    public KotlinPushDownHandler() {
        String string = KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN();
        String string2 = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RefactoringBundle.messag\u2026ss.to.push.members.from\")");
        super(string, "refactoring.pushMembersDown", string2);
    }

    static {
        PUSH_DOWN_TEST_HELPER_KEY = PUSH_DOWN_TEST_HELPER_KEY;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler$TestHelper;", "", "adjustMembers", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "members", "idea"})
    public static interface TestHelper {
        @NotNull
        public List<KotlinMemberInfo> adjustMembers(@NotNull List<KotlinMemberInfo> var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownHandler$Companion;", "", "()V", "PUSH_DOWN_TEST_HELPER_KEY", "", "getPUSH_DOWN_TEST_HELPER_KEY", "()Ljava/lang/String;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getPUSH_DOWN_TEST_HELPER_KEY() {
            return PUSH_DOWN_TEST_HELPER_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

