/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptorKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallerChooser;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinPrimaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinSecondaryConstructorParameterTableModel;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 B2,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001:\u0001BB'\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0012\u001a\u00020\rH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c0\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0005H\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\u0016\u0010#\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010\u00040\u00040$H\u0014J$\u0010&\u001a\u00020'2\u001a\u0010(\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0)H\u0002J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020'H\u0002J\u0016\u0010/\u001a\u00020\r2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002J(\u00101\u001a\u0004\u0018\u0001022\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0014J\b\u00106\u001a\u00020'H\u0014J \u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014J\b\u0010;\u001a\u00020'H\u0002J\u0016\u0010<\u001a\u0002042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014J\b\u0010>\u001a\u000204H\u0014J\b\u0010?\u001a\u000204H\u0014J\b\u0010@\u001a\u00020\u0014H\u0014J\n\u0010A\u001a\u0004\u0018\u00010\rH\u0014R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelItemBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "methodDescriptor", "context", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "parametersTableModel", "getParametersTableModel", "()Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "calculateSignature", "canRun", "", "createCallerChooser", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallerChooser;", "title", "treeToReuse", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "createParametersInfoModel", "descriptor", "createRefactoringProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createVisibilityControl", "Lcom/intellij/refactoring/ui/ComboBoxVisibilityPanel;", "kotlin.jvm.PlatformType", "getColumnTextMaxLength", "", "nameFunction", "Lkotlin/Function1;", "getDefaultValuesMaxLength", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getMethodDescriptor", "getParamNamesMaxLength", "getPresentationName", "item", "getRowPresentation", "Ljavax/swing/JComponent;", "selected", "", "focused", "getSelectedIdx", "getTableEditor", "Lcom/intellij/util/ui/table/JBTableRowEditor;", "table", "Ljavax/swing/JTable;", "getTypesMaxLength", "isEmptyRow", "row", "isListTableViewSupported", "mayPropagateParameters", "updateSignatureAlarmFired", "validateAndCommitData", "Companion", "idea"})
public final class KotlinChangeSignatureDialog
extends ChangeSignatureDialogBase<KotlinParameterInfo, PsiElement, Visibility, KotlinMethodDescriptor, ParameterTableModelItemBase<KotlinParameterInfo>, KotlinCallableParameterTableModel> {
    private final String commandName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    protected KotlinCallableParameterTableModel createParametersInfoModel(@NotNull KotlinMethodDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myDefaultValueContext");
        return KotlinChangeSignatureDialog.Companion.createParametersInfoModel(descriptor2, psiElement2);
    }

    @NotNull
    protected KtTypeCodeFragment createReturnTypeCodeFragment() {
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor, (String)"myMethod");
        return KotlinChangeSignatureDialog.Companion.createReturnTypeCodeFragment(project, (KotlinMethodDescriptor)methodDescriptor);
    }

    private final KotlinCallableParameterTableModel getParametersTableModel() {
        ParameterTableModelBase parameterTableModelBase = this.myParametersTableModel;
        Intrinsics.checkExpressionValueIsNotNull((Object)parameterTableModelBase, (String)"super.myParametersTableModel");
        return (KotlinCallableParameterTableModel)parameterTableModelBase;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected JComponent getRowPresentation(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> item, boolean selected, boolean focused) {
        void text2;
        String string;
        JPanel panel;
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull(item, (String)"item");
                panel = new JPanel(new BorderLayout());
                if (((KotlinMethodDescriptor)this.myMethod).getKind() != KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR) break block9;
                switch (KotlinChangeSignatureDialog$WhenMappings.$EnumSwitchMapping$0[((KotlinParameterInfo)item.parameter).getValOrVar().ordinal()]) {
                    case 1: {
                        string = "    ";
                        break block10;
                    }
                    case 2: {
                        string = "val ";
                        break block10;
                    }
                    case 3: {
                        string = "var ";
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            string = "";
        }
        String valOrVar = string;
        String parameterName2 = this.getPresentationName(item);
        PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeFragment, (String)"item.typeCodeFragment");
        String typeText = psiCodeFragment.getText();
        PsiCodeFragment psiCodeFragment2 = item.defaultValueCodeFragment;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeFragment2, (String)"item.defaultValueCodeFragment");
        String defaultValue = psiCodeFragment2.getText();
        String string2 = StringUtil.repeatSymbol((char)' ', (int)(this.getParamNamesMaxLength() - parameterName2.length() + 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.repeatSymbol(\u2026parameterName.length + 1)");
        String separator = string2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = valOrVar + parameterName2 + ':' + separator + typeText;
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            text2.element = (String)text2.element + " // default value = " + defaultValue;
        }
        EditorTextField field2 = new EditorTextField(this, (Ref.ObjectRef)text2, ' ' + (String)text2.element, this.getProject(), (FileType)this.getFileType()){
            final /* synthetic */ KotlinChangeSignatureDialog this$0;
            final /* synthetic */ Ref.ObjectRef $text;

            protected boolean shouldHaveBorder() {
                return false;
            }
            {
                this.this$0 = $outer;
                this.$text = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        Font font = editorColorsManager.getGlobalScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"EditorColorsManager.getI\u2026ont(EditorFontType.PLAIN)");
        Font plainFont = font;
        field2.setFont(new Font(plainFont.getFontName(), plainFont.getStyle(), 12));
        if (selected && focused) {
            panel.setBackground(UIUtil.getTableSelectionBackground());
            field2.setAsRendererWithSelection(UIUtil.getTableSelectionBackground(), UIUtil.getTableSelectionForeground());
        } else {
            panel.setBackground(UIUtil.getTableBackground());
            if (selected && !focused) {
                panel.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel.add((Component)field2, "West");
        return panel;
    }

    private final String getPresentationName(ParameterTableModelItemBase<KotlinParameterInfo> item) {
        String string;
        KotlinParameterInfo parameter = (KotlinParameterInfo)item.parameter;
        if (Intrinsics.areEqual((Object)parameter, (Object)this.getParametersTableModel().getReceiver())) {
            string = "<receiver>";
        } else {
            KotlinParameterInfo kotlinParameterInfo = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinParameterInfo, (String)"parameter");
            string = kotlinParameterInfo.getName();
        }
        return string;
    }

    private final int getColumnTextMaxLength(Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String> nameFunction) {
        List list2 = this.getParametersTableModel().getItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"parametersTableModel.items");
        Integer n = (Integer)SequencesKt.max((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<ParameterTableModelItemBase<KotlinParameterInfo>, Integer>(nameFunction){
            final /* synthetic */ Function1 $nameFunction;

            public final int invoke(ParameterTableModelItemBase<KotlinParameterInfo> it) {
                ParameterTableModelItemBase<KotlinParameterInfo> parameterTableModelItemBase = it;
                Intrinsics.checkExpressionValueIsNotNull(parameterTableModelItemBase, (String)"it");
                String string = (String)this.$nameFunction.invoke(parameterTableModelItemBase);
                return string != null ? string.length() : 0;
            }
            {
                this.$nameFunction = function1;
                super(1);
            }
        })));
        return n != null ? n : 0;
    }

    private final int getParamNamesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)new Function1<ParameterTableModelItemBase<KotlinParameterInfo>, String>(this){
            final /* synthetic */ KotlinChangeSignatureDialog this$0;

            @NotNull
            public final String invoke(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return KotlinChangeSignatureDialog.access$getPresentationName(this.this$0, it);
            }
            {
                this.this$0 = kotlinChangeSignatureDialog;
                super(1);
            }
        }));
    }

    private final int getTypesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getTypesMaxLength.1.INSTANCE));
    }

    private final int getDefaultValuesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getDefaultValuesMaxLength.1.INSTANCE));
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected boolean isEmptyRow(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> row) {
        Intrinsics.checkParameterIsNotNull(row, (String)"row");
        Object object = row.parameter;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"row.parameter");
        CharSequence charSequence = ((KotlinParameterInfo)object).getName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            return false;
        }
        Object object2 = row.parameter;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"row.parameter");
        charSequence = ((KotlinParameterInfo)object2).getTypeText();
        bl = false;
        return !(charSequence.length() > 0);
    }

    @NotNull
    protected KotlinCallerChooser createCallerChooser(@NotNull String title, @Nullable Tree treeToReuse, @NotNull Consumer<Set<PsiElement>> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor, (String)"myMethod");
        PsiElement psiElement2 = ((KotlinMethodDescriptor)methodDescriptor).getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myMethod.method");
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        return new KotlinCallerChooser(psiElement2, project, title, treeToReuse, callback2);
    }

    protected boolean mayPropagateParameters() {
        boolean bl;
        block3: {
            List list2 = this.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"parameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinParameterInfo it = (KotlinParameterInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.isNewParameter() && Intrinsics.areEqual((Object)it, (Object)this.getParametersTableModel().getReceiver()) ^ true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    protected JBTableRowEditor getTableEditor(@NotNull JTable table, @NotNull ParameterTableModelItemBase<KotlinParameterInfo> item) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        return new JBTableRowEditor(this, item){
            private final ArrayList<JComponent> components;
            private final EditorTextField nameEditor;
            final /* synthetic */ KotlinChangeSignatureDialog this$0;
            final /* synthetic */ ParameterTableModelItemBase $item;

            private final void updateNameEditor() {
                this.nameEditor.setEnabled(Intrinsics.areEqual((Object)((KotlinParameterInfo)this.$item.parameter), (Object)KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0).getReceiver()) ^ true);
            }

            private final boolean isDefaultColumnEnabled() {
                return ((KotlinParameterInfo)this.$item.parameter).isNewParameter() && Intrinsics.areEqual((Object)((KotlinParameterInfo)this.$item.parameter), (Object)KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0).getReceiver()) ^ true;
            }

            public void prepareEditor(@NotNull JTable table, int row) {
                Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                this.setLayout(new BoxLayout((Container)((Object)this), 0));
                int column = 0;
                for (ColumnInfo columnInfo : KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0).getColumnInfos()) {
                    Document document;
                    JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                    EditorTextField editor2 = null;
                    JComponent component = null;
                    int columnFinal = column;
                    if (KotlinCallableParameterTableModel.isTypeColumn(columnInfo)) {
                        document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0)).getDocument((PsiFile)this.$item.typeCodeFragment);
                        editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0), (FileType)this.this$0.getFileType());
                        component = (JComponent)editor2;
                    } else if (KotlinCallableParameterTableModel.isNameColumn(columnInfo)) {
                        editor2 = this.nameEditor;
                        component = (JComponent)editor2;
                        this.updateNameEditor();
                    } else if (KotlinCallableParameterTableModel.isDefaultValueColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                        document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0)).getDocument((PsiFile)this.$item.defaultValueCodeFragment);
                        editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0), (FileType)this.this$0.getFileType());
                        component = (JComponent)editor2;
                    } else if (KotlinPrimaryConstructorParameterTableModel.isValVarColumn(columnInfo)) {
                        JComboBox<KotlinValVar> comboBox = new JComboBox<KotlinValVar>(KotlinValVar.values());
                        comboBox.setSelectedItem((Object)((Object)((KotlinParameterInfo)this.$item.parameter).getValOrVar()));
                        comboBox.addItemListener(new ItemListener(this, row, columnFinal){
                            final /* synthetic */ getTableEditor.1 this$0;
                            final /* synthetic */ int $row;
                            final /* synthetic */ int $columnFinal;

                            public final void itemStateChanged(ItemEvent it) {
                                KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0);
                                ItemEvent itemEvent = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"it");
                                kotlinCallableParameterTableModel.setValueAtWithoutUpdate(itemEvent.getItem(), this.$row, this.$columnFinal);
                                KotlinChangeSignatureDialog.access$updateSignature(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$row = n;
                                this.$columnFinal = n2;
                            }
                        });
                        component = comboBox;
                        editor2 = null;
                    } else {
                        if (!KotlinFunctionParameterTableModel.isReceiverColumn(columnInfo)) continue;
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(Intrinsics.areEqual((Object)KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0).getReceiver(), (Object)((KotlinParameterInfo)this.$item.parameter)));
                        checkBox.addItemListener(new ItemListener(this){
                            final /* synthetic */ getTableEditor.1 this$0;

                            public final void itemStateChanged(ItemEvent it) {
                                ItemEvent itemEvent = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)itemEvent, (String)"it");
                                KotlinParameterInfo newReceiver = itemEvent.getStateChange() == 1 ? (KotlinParameterInfo)this.this$0.$item.parameter : null;
                                KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0);
                                if (kotlinCallableParameterTableModel == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel");
                                }
                                ((KotlinFunctionParameterTableModel)kotlinCallableParameterTableModel).setReceiver(newReceiver);
                                KotlinChangeSignatureDialog.access$updateSignature(this.this$0.this$0);
                                getTableEditor.1.access$updateNameEditor(this.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        component = checkBox;
                        editor2 = null;
                    }
                    ColumnInfo columnInfo2 = columnInfo;
                    Intrinsics.checkExpressionValueIsNotNull((Object)columnInfo2, (String)"columnInfo");
                    JBLabel label2 = new JBLabel(columnInfo2.getName(), UIUtil.ComponentStyle.SMALL);
                    panel.add((Component)label2);
                    if (editor2 != null) {
                        editor2.addDocumentListener(new DocumentListener(this, columnFinal){
                            final /* synthetic */ getTableEditor.1 this$0;
                            final /* synthetic */ int $columnFinal;

                            public void documentChanged(@NotNull DocumentEvent e) {
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                this.this$0.fireDocumentChanged(e, this.$columnFinal);
                            }
                            {
                                this.this$0 = $outer;
                                this.$columnFinal = $captured_local_variable$1;
                            }
                        });
                        editor2.setPreferredWidth(table.getWidth() / KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0).getColumnCount());
                    }
                    this.components.add(component);
                    panel.add(component);
                    this.add(panel);
                    IJSwingUtilities.adjustComponentsOnMac((JLabel)((JLabel)label2), (JComponent)component);
                    ++column;
                }
            }

            @NotNull
            public JBTableRow getValue() {
                return new JBTableRow(this){
                    final /* synthetic */ getTableEditor.1 this$0;

                    @Nullable
                    public final Object getValueAt(int column) {
                        Object object;
                        ColumnInfo columnInfo = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0).getColumnInfos()[column];
                        if (KotlinPrimaryConstructorParameterTableModel.isValVarColumn(columnInfo)) {
                            E e = getTableEditor.1.access$getComponents$p(this.this$0).get(column);
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type javax.swing.JComboBox<*>");
                            }
                            object = ((JComboBox)e).getSelectedItem();
                        } else if (KotlinCallableParameterTableModel.isTypeColumn(columnInfo)) {
                            object = this.this$0.$item.typeCodeFragment;
                        } else if (KotlinCallableParameterTableModel.isNameColumn(columnInfo)) {
                            E e = getTableEditor.1.access$getComponents$p(this.this$0).get(column);
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.EditorTextField");
                            }
                            object = ((EditorTextField)e).getText();
                        } else {
                            object = KotlinCallableParameterTableModel.isDefaultValueColumn(columnInfo) ? this.this$0.$item.defaultValueCodeFragment : null;
                        }
                        return object;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }

            private final int getColumnWidth(int letters) {
                EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                Font font = editorColorsManager.getGlobalScheme().getFont(EditorFontType.PLAIN);
                Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"EditorColorsManager.getI\u2026ont(EditorFontType.PLAIN)");
                Font font2 = font;
                font2 = new Font(font2.getFontName(), font2.getStyle(), 12);
                return letters * Toolkit.getDefaultToolkit().getFontMetrics(font2).stringWidth("W");
            }

            /*
             * WARNING - void declaration
             */
            private final int getEditorIndex(int x) {
                int[] nArray;
                int x2 = x;
                if (this.isDefaultColumnEnabled()) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = 4;
                    nArray2[1] = KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0);
                    nArray2[2] = KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0);
                    nArray = nArray2;
                    nArray2[3] = KotlinChangeSignatureDialog.access$getDefaultValuesMaxLength(this.this$0);
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = 4;
                    nArray3[1] = KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0);
                    nArray = nArray3;
                    nArray3[2] = KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0);
                }
                int[] columnLetters = nArray;
                int columnIndex = 0;
                int n = KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 0 : 1;
                int n2 = columnLetters.length;
                while (n < n2) {
                    void i2;
                    int width = this.getColumnWidth(columnLetters[i2]);
                    if (x2 <= width) {
                        return columnIndex;
                    }
                    ++columnIndex;
                    x2 -= width;
                    ++i2;
                }
                return columnIndex - 1;
            }

            @NotNull
            public JComponent getPreferredFocusedComponent() {
                JComponent jComponent;
                MouseEvent me = this.getMouseEvent();
                int index2 = me != null ? this.getEditorIndex((int)me.getPoint().getX()) : (KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 1 : 0);
                JComponent jComponent2 = this.components.get(index2);
                Intrinsics.checkExpressionValueIsNotNull((Object)jComponent2, (String)"components[index]");
                JComponent component = jComponent2;
                if (component instanceof EditorTextField) {
                    JComponent jComponent3 = ((EditorTextField)component).getFocusTarget();
                    jComponent = jComponent3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jComponent3, (String)"component.focusTarget");
                } else {
                    jComponent = component;
                }
                return jComponent;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public JComponent[] getFocusableComponents() {
                int n = this.components.size();
                JComponent[] jComponentArray = new JComponent[n];
                for (int j = 0; j < n; ++j) {
                    Object object;
                    JComponent component;
                    void it;
                    int n2 = j;
                    int n3 = j;
                    JComponent[] jComponentArray2 = jComponentArray;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.components.get((int)it), (String)"components[it]");
                    JComponent jComponent = component;
                    if (!(jComponent instanceof EditorTextField)) {
                        jComponent = null;
                    }
                    if ((object = (EditorTextField)jComponent) == null || (object = object.getFocusTarget()) == null) {
                        object = component;
                    }
                    Object object2 = object;
                    jComponentArray2[n3] = object2;
                }
                return jComponentArray;
            }
            {
                this.this$0 = $outer;
                this.$item = $captured_local_variable$1;
                this.components = new ArrayList<E>();
                Object object = $captured_local_variable$1.parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"item.parameter");
                this.nameEditor = new EditorTextField(((KotlinParameterInfo)object).getName(), KotlinChangeSignatureDialog.access$getProject($outer), (FileType)$outer.getFileType());
            }

            public static final /* synthetic */ void access$updateNameEditor(getTableEditor.1 $this) {
                $this.updateNameEditor();
            }

            public static final /* synthetic */ ArrayList access$getComponents$p(getTableEditor.1 $this) {
                return $this.components;
            }
        };
    }

    @NotNull
    protected String calculateSignature() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        Visibility visibility2 = (Visibility)this.getVisibility();
        String string = this.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"methodName");
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myDefaultValueContext");
        KotlinChangeInfo changeInfo = KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, visibility2, string, psiElement2, true);
        return changeInfo.getNewSignature(this.getMethodDescriptor().getOriginalPrimaryCallable());
    }

    @NotNull
    protected ComboBoxVisibilityPanel<Visibility> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])new Visibility[]{Visibilities.INTERNAL, Visibilities.PRIVATE, Visibilities.PROTECTED, Visibilities.PUBLIC});
    }

    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    @Nullable
    protected String validateAndCommitData() {
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && Companion.getTypeInfo(this.myReturnTypeCodeFragment, true, false).getType() == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Return type '");
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            if (psiCodeFragment == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeFragment, (String)"myReturnTypeCodeFragment!!");
            if (Messages.showOkCancelDialog((Project)this.myProject, (String)stringBuilder.append(psiCodeFragment.getText()).append("' cannot be resolved.\nContinue?").toString(), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) != 0) {
                return "";
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            String string;
            if (Companion.getTypeInfo(item.typeCodeFragment, true, false).getType() != null) continue;
            if (Intrinsics.areEqual((Object)((KotlinParameterInfo)item.parameter), (Object)this.getParametersTableModel().getReceiver()) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("parameter '");
                Object object = item.parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"item.parameter");
                string = stringBuilder.append(((KotlinParameterInfo)object).getName()).append('\'').toString();
            } else {
                string = "receiver";
            }
            String paramText = string;
            StringBuilder stringBuilder = new StringBuilder().append("Type '");
            PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeFragment, (String)"item.typeCodeFragment");
            if (Messages.showOkCancelDialog((Project)this.myProject, (String)stringBuilder.append(psiCodeFragment.getText()).append("' for ").append(paramText).append(" cannot be resolved.\nContinue?").toString(), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getWarningIcon()) == 0) continue;
            return "";
        }
        return null;
    }

    protected void canRun() {
        JPanel jPanel2 = this.myNamePanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel2, (String)"myNamePanel");
        if (jPanel2.isVisible() && ((KotlinMethodDescriptor)this.myMethod).canChangeName() && !KtPsiUtilKt.isIdentifier(this.getMethodName())) {
            throw (Throwable)new ConfigurationException(KotlinRefactoringBundle.message("function.name.is.invalid", new Object[0]));
        }
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            if (!(psiCodeFragment instanceof KtTypeCodeFragment)) {
                psiCodeFragment = null;
            }
            KtTypeCodeFragment ktTypeCodeFragment = (KtTypeCodeFragment)psiCodeFragment;
            if (ktTypeCodeFragment != null) {
                KtElement ktElement = ktTypeCodeFragment;
                String string = KotlinRefactoringBundle.message("return.type.is.invalid", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinRefactoringBundle.\u2026\"return.type.is.invalid\")");
                KotlinRefactoringUtilKt.validateElement(ktElement, string);
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            Object object = item.parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"item.parameter");
            String parameterName2 = ((KotlinParameterInfo)object).getName();
            if (Intrinsics.areEqual((Object)((KotlinParameterInfo)item.parameter), (Object)this.getParametersTableModel().getReceiver()) ^ true && !KtPsiUtilKt.isIdentifier(parameterName2)) {
                throw (Throwable)new ConfigurationException(KotlinRefactoringBundle.message("parameter.name.is.invalid", parameterName2));
            }
            PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
            if (!(psiCodeFragment instanceof KtTypeCodeFragment)) {
                psiCodeFragment = null;
            }
            KtTypeCodeFragment ktTypeCodeFragment = (KtTypeCodeFragment)psiCodeFragment;
            if (ktTypeCodeFragment == null) continue;
            KtElement ktElement = ktTypeCodeFragment;
            Object[] objectArray = new Object[1];
            PsiCodeFragment psiCodeFragment2 = item.typeCodeFragment;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeFragment2, (String)"item.typeCodeFragment");
            objectArray[0] = psiCodeFragment2.getText();
            String string = KotlinRefactoringBundle.message("parameter.type.is.invalid", objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinRefactoringBundle.\u2026em.typeCodeFragment.text)");
            KotlinRefactoringUtilKt.validateElement(ktElement, string);
        }
    }

    @NotNull
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        Visibility visibility2 = (Visibility)this.getVisibility();
        String string = this.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"methodName");
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myDefaultValueContext");
        KotlinChangeInfo changeInfo = KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, visibility2, string, psiElement2, false);
        Set set2 = this.myMethodsToPropagateParameters;
        changeInfo.setPrimaryPropagationTargets(set2 != null ? (Collection)set2 : (Collection)CollectionsKt.emptyList());
        Project project = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
        String string2 = this.commandName;
        if (string2 == null) {
            String string3 = this.getTitle();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"title");
        }
        return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project, changeInfo, string2);
    }

    private final KotlinMethodDescriptor getMethodDescriptor() {
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor, (String)"myMethod");
        return (KotlinMethodDescriptor)methodDescriptor;
    }

    protected int getSelectedIdx() {
        Object v2;
        block1: {
            MethodDescriptor methodDescriptor = this.myMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor, (String)"myMethod");
            List list2 = ((KotlinMethodDescriptor)methodDescriptor).getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"myMethod.parameters");
            Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)list2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IndexedValue it = (IndexedValue)element$iv;
                boolean bl = false;
                if (!((KotlinParameterInfo)it.getValue()).isNewParameter()) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        IndexedValue indexedValue = v2;
        return indexedValue != null ? indexedValue.getIndex() : super.getSelectedIdx();
    }

    public KotlinChangeSignatureDialog(@NotNull Project project, @NotNull KotlinMethodDescriptor methodDescriptor, @NotNull PsiElement context2, @Nullable String commandName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)methodDescriptor, (String)"methodDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        super(project, (MethodDescriptor)methodDescriptor, false, context2);
        this.commandName = commandName;
    }

    public static final /* synthetic */ String access$getPresentationName(KotlinChangeSignatureDialog $this, ParameterTableModelItemBase item) {
        return $this.getPresentationName((ParameterTableModelItemBase<KotlinParameterInfo>)item);
    }

    public static final /* synthetic */ KotlinCallableParameterTableModel access$getParametersTableModel$p(KotlinChangeSignatureDialog $this) {
        return $this.getParametersTableModel();
    }

    public static final /* synthetic */ KotlinMethodDescriptor access$getMyMethod$p(KotlinChangeSignatureDialog $this) {
        return (KotlinMethodDescriptor)$this.myMethod;
    }

    public static final /* synthetic */ Project access$getProject(KotlinChangeSignatureDialog $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ void access$updateSignature(KotlinChangeSignatureDialog $this) {
        $this.updateSignature();
    }

    public static final /* synthetic */ int access$getParamNamesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getParamNamesMaxLength();
    }

    public static final /* synthetic */ int access$getTypesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getTypesMaxLength();
    }

    public static final /* synthetic */ int access$getDefaultValuesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getDefaultValuesMaxLength();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002JD\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bJ\u001c\u0010 \u001a\u00020!*\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog$Companion;", "", "()V", "createParametersInfoModel", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "defaultValueContext", "Lcom/intellij/psi/PsiElement;", "createRefactoringProcessorForSilentChangeSignature", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "commandName", "", "method", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "evaluateChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeInfo;", "parametersModel", "returnTypeCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "methodDescriptor", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "methodName", "forPreview", "", "getTypeCodeFragmentContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "startFrom", "getTypeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinTypeInfo;", "isCovariant", "idea"})
    public static final class Companion {
        private final KotlinCallableParameterTableModel createParametersInfoModel(KotlinMethodDescriptor descriptor2, PsiElement defaultValueContext) {
            KotlinCallableParameterTableModel kotlinCallableParameterTableModel;
            KtElement typeContext = this.getTypeCodeFragmentContext(descriptor2.getBaseDeclaration());
            switch (KotlinChangeSignatureDialog$Companion$WhenMappings.$EnumSwitchMapping$0[descriptor2.getKind().ordinal()]) {
                case 1: {
                    kotlinCallableParameterTableModel = new KotlinFunctionParameterTableModel(descriptor2, (PsiElement)typeContext, defaultValueContext);
                    break;
                }
                case 2: {
                    kotlinCallableParameterTableModel = new KotlinPrimaryConstructorParameterTableModel(descriptor2, (PsiElement)typeContext, defaultValueContext);
                    break;
                }
                case 3: {
                    kotlinCallableParameterTableModel = new KotlinSecondaryConstructorParameterTableModel(descriptor2, (PsiElement)typeContext, defaultValueContext);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return kotlinCallableParameterTableModel;
        }

        @NotNull
        public final KtElement getTypeCodeFragmentContext(@NotNull PsiElement startFrom) {
            Intrinsics.checkParameterIsNotNull((Object)startFrom, (String)"startFrom");
            return (KtElement)SequencesKt.first((Sequence)SequencesKt.mapNotNull(PsiUtilsKt.getParentsWithSelf(startFrom), (Function1)getTypeCodeFragmentContext.1.INSTANCE));
        }

        private final KtTypeCodeFragment createReturnTypeCodeFragment(Project project, KotlinMethodDescriptor method) {
            return new KtPsiFactory(project, false, 2, null).createTypeCodeFragment(KotlinTypeInfoKt.render(KotlinMethodDescriptorKt.getReturnTypeInfo(method)), (PsiElement)this.getTypeCodeFragmentContext(method.getBaseDeclaration()));
        }

        @NotNull
        public final BaseRefactoringProcessor createRefactoringProcessorForSilentChangeSignature(@NotNull Project project, @NotNull String commandName, @NotNull KotlinMethodDescriptor method, @NotNull PsiElement defaultValueContext) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)defaultValueContext, (String)"defaultValueContext");
            KotlinCallableParameterTableModel parameterTableModel = this.createParametersInfoModel(method, defaultValueContext);
            parameterTableModel.setParameterInfos(method.getParameters());
            PsiCodeFragment psiCodeFragment = (PsiCodeFragment)this.createReturnTypeCodeFragment(project, method);
            Visibility visibility2 = (Visibility)method.getVisibility();
            String string = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
            KotlinChangeInfo changeInfo = this.evaluateChangeInfo(parameterTableModel, psiCodeFragment, method, visibility2, string, defaultValueContext, false);
            return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project, changeInfo, commandName);
        }

        @NotNull
        public final KotlinTypeInfo getTypeInfo(@Nullable PsiCodeFragment $this$getTypeInfo, boolean isCovariant, boolean forPreview) {
            if (!($this$getTypeInfo instanceof KtTypeCodeFragment)) {
                return new KotlinTypeInfo(isCovariant, null, null, 6, null);
            }
            KtTypeReference typeRef = ((KtTypeCodeFragment)$this$getTypeInfo).getContentElement();
            Object object = typeRef;
            KotlinType type2 = object != null && (object = ResolutionUtils.analyze((KtElement)object, BodyResolveMode.PARTIAL)) != null ? (KotlinType)object.get(BindingContext.TYPE, typeRef) : null;
            return type2 != null && !KotlinTypeKt.isError(type2) ? new KotlinTypeInfo(isCovariant, type2, forPreview ? typeRef.getText() : null) : (typeRef != null ? new KotlinTypeInfo(isCovariant, null, typeRef.getText()) : new KotlinTypeInfo(isCovariant, null, null, 6, null));
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinChangeInfo evaluateChangeInfo(KotlinCallableParameterTableModel parametersModel, PsiCodeFragment returnTypeCodeFragment, KotlinMethodDescriptor methodDescriptor, Visibility visibility2, String methodName2, PsiElement defaultValueContext, boolean forPreview) {
            void $this$mapTo$iv$iv;
            List list2 = parametersModel.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"parametersModel.items");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                ParameterTableModelItemBase parameterTableModelItemBase = (ParameterTableModelItemBase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinParameterInfo parameterInfo = (KotlinParameterInfo)parameter.parameter;
                parameterInfo.setCurrentTypeInfo(Companion.getTypeInfo(parameter.typeCodeFragment, false, forPreview));
                PsiCodeFragment psiCodeFragment = parameter.defaultValueCodeFragment;
                if (psiCodeFragment == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpressionCodeFragment");
                }
                KtExpressionCodeFragment codeFragment = (KtExpressionCodeFragment)psiCodeFragment;
                KtExpression oldDefaultValue = parameterInfo.getDefaultValueForCall();
                if (Intrinsics.areEqual((Object)codeFragment.getText(), (Object)(oldDefaultValue != null ? oldDefaultValue.getText() : "")) ^ true) {
                    parameterInfo.setDefaultValueForCall(codeFragment.getContentElement());
                }
                KotlinParameterInfo kotlinParameterInfo = parameterInfo;
                collection.add(kotlinParameterInfo);
            }
            List parameters2 = (List)destination$iv$iv;
            KotlinMethodDescriptor kotlinMethodDescriptor = methodDescriptor.getOriginal();
            KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(returnTypeCodeFragment, true, forPreview);
            Visibility visibility3 = visibility2;
            if (visibility3 == null) {
                Visibility visibility4 = Visibilities.DEFAULT_VISIBILITY;
                visibility3 = visibility4;
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility4, (String)"Visibilities.DEFAULT_VISIBILITY");
            }
            return new KotlinChangeInfo(kotlinMethodDescriptor, methodName2, kotlinTypeInfo, visibility3, parameters2, parametersModel.getReceiver(), defaultValueContext, null, 128, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

