/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH$J\u0006\u0010!\u001a\u00020\u0018J,\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0010\n\u0002\u0010\u0010\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "callableDescriptor", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "callableDescriptor$annotations", "()V", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getCommandName", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkModifiable", "", "element", "Lcom/intellij/psi/PsiElement;", "forcePerformForSelectedFunctionOnly", "getClosestModifiableDescriptors", "", "performRefactoring", "", "descriptorsForChange", "run", "showSuperFunctionWarningDialog", "", "superCallables", "callableFromEditor", "options", "", "idea"})
public abstract class CallableRefactoring<T extends CallableDescriptor> {
    private final Logger LOG;
    @NotNull
    private final T callableDescriptor;
    private final CallableMemberDescriptor.Kind kind;
    @NotNull
    private final Project project;
    @NotNull
    private final String commandName;

    public static /* synthetic */ void callableDescriptor$annotations() {
    }

    @NotNull
    public final T getCallableDescriptor() {
        return this.callableDescriptor;
    }

    protected boolean forcePerformForSelectedFunctionOnly() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CallableDescriptor> getClosestModifiableDescriptors() {
        void $this$mapTo$iv$iv;
        Collection<CallableMemberDescriptor> collection;
        switch (CallableRefactoring$WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                collection = SetsKt.setOf(this.callableDescriptor);
                break;
            }
            case 2: 
            case 3: {
                T t = this.callableDescriptor;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                collection = DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)t);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected callable kind: " + (Object)((Object)this.kind));
            }
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CallableDescriptor callableDescriptor;
            void it;
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = ExpectActualUtilKt.liftToExpected((DeclarationDescriptor)it);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((callableDescriptor = (CallableDescriptor)declarationDescriptor) == null) {
                callableDescriptor = it;
            }
            CallableDescriptor callableDescriptor3 = callableDescriptor;
            collection2.add(callableDescriptor3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final int showSuperFunctionWarningDialog(Collection<? extends CallableDescriptor> superCallables, CallableDescriptor callableFromEditor, List<String> options2) {
        void $this$toTypedArray$iv;
        Function1 function1 = showSuperFunctionWarningDialog.superString.1.INSTANCE;
        CharSequence charSequence = null;
        int n = 0;
        Object object = ".\n\n";
        CharSequence charSequence2 = ",\n    ";
        CharSequence charSequence3 = "\n    ";
        String superString2 = CollectionsKt.joinToString$default((Iterable)superCallables, (CharSequence)charSequence2, (CharSequence)charSequence3, (CharSequence)object, (int)n, charSequence, (Function1)function1, (int)24, null);
        String string = KotlinBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT.render(callableFromEditor), superString2, "refactor");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\n  \u2026     \"refactor\"\n        )");
        String message2 = string;
        String string2 = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String title = string2;
        Icon icon = Messages.getQuestionIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"Messages.getQuestionIcon()");
        Icon icon2 = icon;
        object = options2;
        String string3 = title;
        String string4 = message2;
        boolean $i$f$toTypedArray = false;
        void v3 = $this$toTypedArray$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v3;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        return Messages.showDialog((String)string4, (String)string3, (String[])stringArray2, (int)0, (Icon)icon2);
    }

    protected final boolean checkModifiable(@NotNull PsiElement element3) {
        String unmodifiableFile;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (KotlinRefactoringUtilKt.canRefactor(element3)) {
            return true;
        }
        PsiFile psiFile = element3.getContainingFile();
        String string = psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getPresentableUrl() : (unmodifiableFile = null);
        if (unmodifiableFile != null) {
            String message2 = RefactoringBundle.message((String)"refactoring.cannot.be.performed") + "\n" + IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{unmodifiableFile});
            String string2 = CommonBundle.getErrorTitle();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Messages.showErrorDialog((Project)this.project, (String)message2, (String)string2);
        } else {
            this.LOG.error("Could not find file for Psi element: " + element3.getText());
        }
        return false;
    }

    protected abstract void performRefactoring(@NotNull Collection<? extends CallableDescriptor> var1);

    public final boolean run() {
        Object object;
        run.1 $fun$buttonPressed$1 = run.1.INSTANCE;
        run.2 $fun$performForWholeHierarchy$2 = run.2.INSTANCE;
        run.3 $fun$performForSelectedFunctionOnly$3 = run.3.INSTANCE;
        run.4 $fun$buildDialogOptions$4 = run.4.INSTANCE;
        if (this.kind == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            this.LOG.error("Change signature refactoring should not be called for synthesized member " + this.callableDescriptor);
            return false;
        }
        Collection<CallableDescriptor> closestModifiableDescriptors = this.getClosestModifiableDescriptors();
        if (this.forcePerformForSelectedFunctionOnly()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean bl = !closestModifiableDescriptors.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallableRefactoring$run$62 = false;
            String $i$a$-assert-CallableRefactoring$run$62 = "Should contain original declaration or some of its super declarations";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallableRefactoring$run$62));
        }
        T t = this.callableDescriptor;
        if (!(t instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((object = (CallableMemberDescriptor)t) == null || (object = DescriptorUtilsKt.getDeepestSuperDeclarations$default((CallableMemberDescriptor)object, false, 1, null)) == null) {
            object = CollectionsKt.listOf(this.callableDescriptor);
        }
        Object deepestSuperDeclarations = object;
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (application.isUnitTestMode()) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations);
            return true;
        }
        if (closestModifiableDescriptors.size() == 1 && CollectionsKt.subtract((Iterable)((Iterable)deepestSuperDeclarations), (Iterable)closestModifiableDescriptors).isEmpty()) {
            this.performRefactoring(closestModifiableDescriptors);
            return true;
        }
        boolean isSingleFunctionSelected = closestModifiableDescriptors.size() == 1;
        T selectedFunction = isSingleFunctionSelected ? (CallableDescriptor)CollectionsKt.first((Iterable)closestModifiableDescriptors) : this.callableDescriptor;
        List<String> optionsForDialog = $fun$buildDialogOptions$4.invoke(isSingleFunctionSelected);
        int code = this.showSuperFunctionWarningDialog((Collection<? extends CallableDescriptor>)((Collection<CallableDescriptor>)deepestSuperDeclarations), (CallableDescriptor)selectedFunction, optionsForDialog);
        if ($fun$performForWholeHierarchy$2.invoke(optionsForDialog, code)) {
            this.performRefactoring((Collection<CallableDescriptor>)deepestSuperDeclarations);
        } else if ($fun$performForSelectedFunctionOnly$3.invoke(optionsForDialog, code)) {
            this.performRefactoring(closestModifiableDescriptors);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    public CallableRefactoring(@NotNull Project project, @NotNull T callableDescriptor, @NotNull String commandName) {
        Object object;
        T t;
        CallableDescriptor callableDescriptor2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)commandName, (String)"commandName");
        this.project = project;
        this.commandName = commandName;
        Logger logger = Logger.getInstance(CallableRefactoring.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Calla\u2026eRefactoring::class.java)");
        this.LOG = logger;
        DeclarationDescriptor declarationDescriptor = ExpectActualUtilKt.liftToExpected((DeclarationDescriptor)callableDescriptor);
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if ((callableDescriptor2 = (CallableDescriptor)declarationDescriptor) == null) {
            callableDescriptor2 = this.callableDescriptor = callableDescriptor;
        }
        if (!((t = callableDescriptor) instanceof CallableMemberDescriptor)) {
            t = null;
        }
        if ((object = (CallableMemberDescriptor)t) == null || (object = object.getKind()) == null) {
            object = CallableMemberDescriptor.Kind.DECLARATION;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(callableDescriptor as? \u2026tor)?.kind ?: DECLARATION");
        this.kind = object;
    }
}

