/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.AddArrayOfTypeFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddToStringFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeToUseSpreadOperatorFix;
import org.jetbrains.kotlin.idea.quickfix.ConvertCollectionFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.LetImplementInterfaceFix;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.idea.quickfix.QuickFixFactoryForTypeMismatchError;
import org.jetbrains.kotlin.idea.quickfix.RoundNumberFix;
import org.jetbrains.kotlin.idea.quickfix.WrapWithArrayLiteralFix;
import org.jetbrains.kotlin.idea.quickfix.WrapWithCollectionLiteralCallFix;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFix;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reflectToRegularFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Companion", "idea"})
public final class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG;
    public static final Companion Companion;

    private final KotlinType reflectToRegularFunctionType(@NotNull KotlinType $this$reflectToRegularFunctionType) {
        Annotations annotations2 = $this$reflectToRegularFunctionType.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        boolean isTypeAnnotatedWithExtensionFunctionType = annotations2.findAnnotation(fqName2) != null;
        int parameterCount = isTypeAnnotatedWithExtensionFunctionType ? $this$reflectToRegularFunctionType.getArguments().size() - 2 : $this$reflectToRegularFunctionType.getArguments().size() - 1;
        Annotations annotations3 = $this$reflectToRegularFunctionType.getAnnotations();
        ClassDescriptor classDescriptor2 = TypeUtilsKt.getBuiltIns($this$reflectToRegularFunctionType).getFunction(parameterCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.getFunction(parameterCount)");
        return KotlinTypeFactory.simpleNotNullType(annotations3, classDescriptor2, $this$reflectToRegularFunctionType.getArguments());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KotlinType parameterVarargType;
        KotlinType valueArgumentType;
        boolean bl;
        Object object;
        KotlinType kotlinType2;
        KtIfExpression parentIf;
        Unit unit;
        KotlinType expressionType;
        KotlinType expectedType;
        PsiElement diagnosticElement;
        BindingContext context2;
        LinkedList<KotlinQuickFixAction> actions;
        block44: {
            block46: {
                block45: {
                    KtAnnotationEntry annotationEntry2;
                    KtFunction declaration2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    PsiElement psiElement2;
                    KtCallableDeclaration function2;
                    KotlinType nullableExpected;
                    Boolean bl2;
                    Object constantValue2;
                    AbstractDiagnostic diagnosticWithParameters;
                    void $this$analyzeWithContent$iv$iv;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    actions = new LinkedList<KotlinQuickFixAction>();
                    PsiFile psiFile = diagnostic.getPsiFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    KtDeclarationContainer $this$analyzeWithContent$iv = (KtFile)psiFile;
                    boolean $i$f$analyzeWithContent = false;
                    KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
                    ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)((Object)$this$analyzeWithContent$iv));
                    boolean $i$f$analyzeWithContent2 = false;
                    context2 = resolutionFacade.analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)$this$analyzeWithContent$iv$iv)).getBindingContext();
                    PsiElement psiElement3 = diagnostic.getPsiElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"diagnostic.psiElement");
                    diagnosticElement = psiElement3;
                    if (!(diagnosticElement instanceof KtExpression)) {
                        LOG.error("Unexpected element: " + diagnosticElement.getText());
                        return CollectionsKt.emptyList();
                    }
                    expectedType = null;
                    expressionType = null;
                    DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                    if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_MISMATCH)) {
                        Object d = Errors.TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_MISMATCH.cast(diagnostic)");
                        diagnosticWithParameters = (DiagnosticWithParameters2)d;
                        Object a = ((DiagnosticWithParameters2)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE)) {
                        Object d = Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic)");
                        diagnosticWithParameters = (DiagnosticWithParameters1)d;
                        Object a = ((DiagnosticWithParameters1)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = TypeUtilsKt.makeNullable(expectedType);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH)) {
                        Object d = Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_INFERENCE_EX\u2026MISMATCH.cast(diagnostic)");
                        diagnosticWithParameters = (DiagnosticWithParameters2)d;
                        Object a = ((DiagnosticWithParameters2)diagnosticWithParameters).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
                        Object d = Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.CONSTANT_EXPECTED\u2026MISMATCH.cast(diagnostic)");
                        diagnosticWithParameters = (DiagnosticWithParameters2)d;
                        Object b = ((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                        Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                        expectedType = (KotlinType)b;
                        expressionType = context2.getType((KtExpression)diagnosticElement);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED)) {
                        constantValue2 = (CompileTimeConstant)context2.get(BindingContext.COMPILE_TIME_VALUE, diagnosticElement);
                        if (!(constantValue2 instanceof IntegerValueTypeConstant)) return CollectionsKt.emptyList();
                        IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)constantValue2;
                        SimpleType simpleType2 = org.jetbrains.kotlin.types.TypeUtils.NO_EXPECTED_TYPE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
                        expectedType = integerValueTypeConstant.getType(simpleType2);
                        IntegerValueTypeConstant.Companion companion = IntegerValueTypeConstant.Companion;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        IntegerValueTypeConstant.Companion $this$with = companion;
                        boolean bl5 = false;
                        IntegerValueTypeConstant signedConstantValue = $this$with.convertToSignedConstant((IntegerValueTypeConstant)constantValue2, ResolutionUtils.findModuleDescriptor((KtElement)diagnosticElement));
                        SimpleType simpleType3 = org.jetbrains.kotlin.types.TypeUtils.NO_EXPECTED_TYPE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"NO_EXPECTED_TYPE");
                        expressionType = signedConstantValue.getType(simpleType3);
                    } else {
                        LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                        return CollectionsKt.emptyList();
                    }
                    if (expressionType == null) {
                        LOG.error("No type inferred: " + ((KtExpression)diagnosticElement).getText());
                        return CollectionsKt.emptyList();
                    }
                    if (TypeUtilsKt.isSignedOrUnsignedNumberType(expressionType) && TypeUtilsKt.isSignedOrUnsignedNumberType(expectedType)) {
                        void var7_11;
                        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = null;
                        if (diagnosticElement instanceof KtConstantExpression && !KotlinBuiltIns.isChar(expectedType)) {
                            WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix2 = new WrongPrimitiveLiteralFix((KtConstantExpression)diagnosticElement, expectedType);
                            actions.add(wrongPrimitiveLiteralFix2);
                        }
                        actions.add(new NumberConversionFix((KtExpression)diagnosticElement, expectedType, (IntentionAction)var7_11));
                        actions.add(new RoundNumberFix((KtExpression)diagnosticElement, expectedType, (IntentionAction)var7_11));
                    }
                    if (KotlinBuiltIns.isCharSequenceOrNullableCharSequence(expectedType) || KotlinBuiltIns.isStringOrNullableString(expectedType)) {
                        actions.add(new AddToStringFix((KtExpression)diagnosticElement, false));
                        if (expectedType.isMarkedNullable() && expressionType.isMarkedNullable()) {
                            actions.add(new AddToStringFix((KtExpression)diagnosticElement, true));
                        }
                    }
                    if (TypeUtilsKt.isInterface(expectedType)) {
                        KtClassOrObject ktClassOrObject;
                        PsiElement psiElement4;
                        PsiElement psiElement5;
                        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor != null) {
                            constantValue2 = classifierDescriptor;
                            boolean signedConstantValue = false;
                            boolean bl6 = false;
                            Object it = constantValue2;
                            boolean bl7 = false;
                            Object object2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                            psiElement5 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)object2);
                        } else {
                            psiElement5 = psiElement4 = null;
                        }
                        if (!(psiElement5 instanceof KtClassOrObject)) {
                            psiElement4 = null;
                        }
                        if ((ktClassOrObject = (KtClassOrObject)psiElement4) != null && Intrinsics.areEqual((Object)expectedType, (Object)org.jetbrains.kotlin.types.TypeUtils.makeNotNullable(expressionType)) ^ true) {
                            actions.add(new LetImplementInterfaceFix(ktClassOrObject, expectedType, expressionType));
                        }
                    }
                    actions.addAll((Collection)WrapWithCollectionLiteralCallFix.Companion.create(expectedType, expressionType, (KtExpression)diagnosticElement));
                    ConvertCollectionFix.CollectionType collectionType = ConvertCollectionFix.Companion.getConversionTypeOrNull(expressionType, expectedType);
                    if (collectionType != null) {
                        ConvertCollectionFix.CollectionType collectionType2 = collectionType;
                        boolean constantValue2 = false;
                        boolean signedConstantValue = false;
                        ConvertCollectionFix.CollectionType collectionType3 = collectionType2;
                        boolean bl8 = false;
                        bl2 = actions.add(new ConvertCollectionFix((KtExpression)diagnosticElement, collectionType3));
                    } else {
                        bl2 = null;
                    }
                    doCreateActions.2 var7_17 = doCreateActions.2.INSTANCE;
                    if (Intrinsics.areEqual(diagnostic.getFactory(), Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED) ^ true && !(diagnosticElement instanceof KtBinaryExpressionWithTypeRHS) && !(((KtExpression)diagnosticElement).getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
                        actions.add(new CastExpressionFix(var7_17.invoke((KtExpression)diagnosticElement), expectedType));
                    }
                    if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, nullableExpected = TypeUtilsKt.makeNullable(expectedType))) {
                        actions.add(new AddExclExclCallFix((PsiElement)var7_17.invoke((KtExpression)diagnosticElement)));
                    }
                    Function3 $fun$addChangeTypeFix$3 = new Function3<D, KotlinType, Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>>, Unit>(this, context2, actions){
                        final /* synthetic */ QuickFixFactoryForTypeMismatchError this$0;
                        final /* synthetic */ BindingContext $context;
                        final /* synthetic */ LinkedList $actions;

                        public final <D extends KtCallableDeclaration> void invoke(@NotNull D callable2, @NotNull KotlinType expressionType, @NotNull Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>> createFix2) {
                            Intrinsics.checkParameterIsNotNull(callable2, (String)"callable");
                            Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
                            Intrinsics.checkParameterIsNotNull(createFix2, (String)"createFix");
                            LexicalScope scope2 = ScopeUtils.getResolutionScope(callable2, this.$context, ResolutionUtils.getResolutionFacade(callable2));
                            KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                            ClassifierDescriptor classifierDescriptor = typeToInsert.getConstructor().getDeclarationDescriptor();
                            if ((classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.KFunction) {
                                this.$actions.add(createFix2.invoke(callable2, (Object)QuickFixFactoryForTypeMismatchError.access$reflectToRegularFunctionType(this.this$0, typeToInsert)));
                            }
                            this.$actions.add(createFix2.invoke(callable2, (Object)typeToInsert));
                        }
                        {
                            this.this$0 = quickFixFactoryForTypeMismatchError;
                            this.$context = bindingContext2;
                            this.$actions = linkedList;
                            super(3);
                        }
                    };
                    KtProperty property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtProperty.class);
                    if (property2 != null) {
                        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
                        KtExpression initializer2 = property2.getInitializer();
                        if (QuickFixUtil.canEvaluateTo(initializer2, (KtExpression)diagnosticElement) || ktPropertyAccessor != null && QuickFixUtil.canFunctionOrGetterReturnExpression(ktPropertyAccessor, (KtExpression)diagnosticElement)) {
                            $fun$addChangeTypeFix$3.invoke((KtCallableDeclaration)property2, expressionType, doCreateActions.4.INSTANCE);
                        }
                    }
                    KtCallableDeclaration ktCallableDeclaration = function2 = (psiElement2 = ((KtExpression)diagnosticElement).getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)psiElement2, context2) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtFunction.class, (boolean)true);
                    if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, (KtExpression)diagnosticElement)) {
                        $fun$addChangeTypeFix$3.invoke(function2, expressionType, doCreateActions.5.INSTANCE);
                    }
                    if (diagnosticElement instanceof KtOperationExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context2)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if (diagnosticElement instanceof KtCallExpression && (resolvedCall = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context2)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if ((annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtAnnotationEntry.class)) == null) break block44;
                    if (!KotlinBuiltIns.isArray(expectedType)) break block45;
                    KotlinType kotlinType3 = expectedType.getArguments().get(0).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"expectedType.arguments[0].type");
                    if (TypeUtilsKt.isSubtypeOf(expressionType, kotlinType3)) break block46;
                }
                if (!KotlinBuiltIns.isPrimitiveArray(expectedType)) break block44;
            }
            actions.add(new AddArrayOfTypeFix((KtExpression)diagnosticElement, expectedType));
            if (PlatformKt.getLanguageVersionSettings(diagnosticElement).supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
                actions.add(new WrapWithArrayLiteralFix((KtExpression)diagnosticElement));
            }
        }
        PsiElement $this$getStrictParentOfType$iv = diagnosticElement;
        boolean $i$f$getStrictParentOfType = false;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true);
        if (ktParameter != null) {
            $this$getStrictParentOfType$iv = ktParameter;
            $i$f$getStrictParentOfType = false;
            boolean bl9 = false;
            PsiElement it = $this$getStrictParentOfType$iv;
            boolean bl10 = false;
            if (Intrinsics.areEqual((Object)it.getDefaultValue(), (Object)diagnosticElement)) {
                actions.add(new ChangeParameterTypeFix((KtParameter)it, expressionType));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getParentResolvedCall((KtElement)diagnosticElement, context2, true);
        if (resolvedCall3 == null) return actions;
        KtIfExpression ktIfExpression = parentIf = QuickFixUtil.getParentIfForBranch((KtExpression)diagnosticElement);
        KtExpression argumentExpression2 = ktIfExpression != null ? (KtExpression)ktIfExpression : (KtExpression)diagnosticElement;
        Call call2 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call2, argumentExpression2);
        if (valueArgument == null) return actions;
        ValueParameterDescriptor correspondingParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall3, valueArgument);
        PsiElement psiElement6 = QuickFixUtil.safeGetDeclaration(correspondingParameterDescriptor);
        if (!(psiElement6 instanceof KtParameter)) {
            psiElement6 = null;
        }
        KtParameter correspondingParameter = (KtParameter)psiElement6;
        KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
        DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
        if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE) || Intrinsics.areEqual(diagnosticFactory, Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED)) {
            kotlinType2 = expressionType;
        } else {
            KtExpression ktExpression = expressionFromArgument;
            if (ktExpression != null) {
                object = ktExpression;
                bl = false;
                boolean bl11 = false;
                KtExpression it = object;
                boolean bl12 = false;
                kotlinType2 = context2.getType(it);
            } else {
                kotlinType2 = valueArgumentType = null;
            }
        }
        if (valueArgumentType == null) return actions;
        if (correspondingParameter != null) {
            KtCallableDeclaration callable2;
            KtCallableDeclaration ktCallableDeclaration = callable2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
            LexicalScope scope2 = ktCallableDeclaration != null ? ScopeUtils.getResolutionScope(ktCallableDeclaration, context2, ResolutionUtils.getResolutionFacade(callable2)) : null;
            KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(valueArgumentType, scope2, true);
            actions.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert));
        }
        ValueParameterDescriptor valueParameterDescriptor = correspondingParameterDescriptor;
        KotlinType kotlinType4 = parameterVarargType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        if (parameterVarargType == null && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()), (Object)new FqName("kotlin.collections.mapOf")) || !KotlinBuiltIns.isArray(valueArgumentType)) return actions;
        object = expressionType.getArguments();
        bl = false;
        if (!(!object.isEmpty()) || !Intrinsics.areEqual((Object)expressionType.getArguments().get(0).getType().getConstructor(), (Object)expectedType.getConstructor())) return actions;
        actions.add(new ChangeToUseSpreadOperatorFix((KtExpression)diagnosticElement));
        return actions;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Quick\u2026ismatchError::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ KotlinType access$reflectToRegularFunctionType(QuickFixFactoryForTypeMismatchError $this, KotlinType $this$access_u24reflectToRegularFunctionType) {
        return $this.reflectToRegularFunctionType($this$access_u24reflectToRegularFunctionType);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "idea"})
    public static final class Companion {
        private final KtFunction getFunctionDeclaration(ResolvedCall<?> resolvedCall2) {
            PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall2.getResultingDescriptor());
            if (result2 instanceof KtFunction) {
                return (KtFunction)result2;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

