/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.CreateLabelFix;
import org.jetbrains.kotlin.idea.quickfix.CreateLabelFix$Companion$getContainingLambdas$;
import org.jetbrains.kotlin.idea.quickfix.CreateLabelFix$Companion$getContainingLoops$;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpressionImpl;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001b\u001c\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0002H&J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\"\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u001e\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;", "expression", "(Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;)V", "chooserTitle", "", "getChooserTitle", "()Ljava/lang/String;", "doCreateLabel", "", "it", "Lorg/jetbrains/kotlin/psi/KtExpression;", "project", "Lcom/intellij/openapi/project/Project;", "getCandidateExpressions", "", "labelReferenceExpression", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "ForLambda", "ForLoop", "Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix$ForLoop;", "Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix$ForLambda;", "idea"})
public abstract class CreateLabelFix
extends KotlinQuickFixAction<KtLabelReferenceExpression> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Create label";
    }

    @NotNull
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder().append("Create label ");
        Object object = (KtLabelReferenceExpression)this.getElement();
        if (object == null || (object = ((KtSimpleNameExpressionImpl)object).getReferencedName()) == null) {
            object = "";
        }
        return stringBuilder.append((String)object).append('@').toString();
    }

    @NotNull
    public abstract String getChooserTitle();

    @NotNull
    public abstract List<KtExpression> getCandidateExpressions(@NotNull KtLabelReferenceExpression var1);

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private final void doCreateLabel(KtLabelReferenceExpression expression2, KtExpression it, Project project) {
        ApplicationUtilsKt.executeWriteCommand(project, this.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(it, project, expression2){
            final /* synthetic */ KtExpression $it;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtLabelReferenceExpression $expression;

            public final void invoke() {
                this.$it.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(new KtPsiFactory(this.$project, false, 2, null), this.$expression.getReferencedName() + "@ $0", new Object[]{this.$it}, false, 4, null));
            }
            {
                this.$it = ktExpression;
                this.$project = project;
                this.$expression = ktLabelReferenceExpression;
                super(0);
            }
        }));
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtLabelReferenceExpression ktLabelReferenceExpression = (KtLabelReferenceExpression)this.getElement();
        if (ktLabelReferenceExpression == null) {
            return;
        }
        KtLabelReferenceExpression expression2 = ktLabelReferenceExpression;
        if (editor2 == null) {
            return;
        }
        List<KtExpression> containers = this.getCandidateExpressions(expression2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.doCreateLabel(expression2, (KtExpression)CollectionsKt.last(containers), project);
            return;
        }
        KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, editor2, this.getChooserTitle(), true, invoke.1.INSTANCE, (Function1)new Function1<KtExpression, Unit>(this, expression2, project){
            final /* synthetic */ CreateLabelFix this$0;
            final /* synthetic */ KtLabelReferenceExpression $expression;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull KtExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CreateLabelFix.access$doCreateLabel(this.this$0, this.$expression, it, this.$project);
            }
            {
                this.this$0 = createLabelFix;
                this.$expression = ktLabelReferenceExpression;
                this.$project = project;
                super(1);
            }
        });
    }

    private CreateLabelFix(KtLabelReferenceExpression expression2) {
        super((PsiElement)expression2);
    }

    public /* synthetic */ CreateLabelFix(KtLabelReferenceExpression expression2, DefaultConstructorMarker $constructor_marker) {
        this(expression2);
    }

    public static final /* synthetic */ void access$doCreateLabel(CreateLabelFix $this, KtLabelReferenceExpression expression2, KtExpression it, Project project) {
        $this.doCreateLabel(expression2, it, project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix$ForLoop;", "Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix;", "expression", "Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;", "(Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;)V", "chooserTitle", "", "getChooserTitle", "()Ljava/lang/String;", "getCandidateExpressions", "", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "labelReferenceExpression", "idea"})
    public static final class ForLoop
    extends CreateLabelFix {
        @NotNull
        private final String chooserTitle = "Select loop statement to label";

        @Override
        @NotNull
        public String getChooserTitle() {
            return this.chooserTitle;
        }

        @NotNull
        public List<KtLoopExpression> getCandidateExpressions(@NotNull KtLabelReferenceExpression labelReferenceExpression) {
            Intrinsics.checkParameterIsNotNull((Object)labelReferenceExpression, (String)"labelReferenceExpression");
            return SequencesKt.toList((Sequence)Companion.getContainingLoops(labelReferenceExpression));
        }

        public ForLoop(@NotNull KtLabelReferenceExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            super(expression2, null);
            this.chooserTitle = "Select loop statement to label";
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix$ForLambda;", "Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix;", "expression", "Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;", "(Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;)V", "chooserTitle", "", "getChooserTitle", "()Ljava/lang/String;", "getCandidateExpressions", "", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "labelReferenceExpression", "idea"})
    public static final class ForLambda
    extends CreateLabelFix {
        @NotNull
        private final String chooserTitle = "Select lambda to label";

        @Override
        @NotNull
        public String getChooserTitle() {
            return this.chooserTitle;
        }

        @NotNull
        public List<KtLambdaExpression> getCandidateExpressions(@NotNull KtLabelReferenceExpression labelReferenceExpression) {
            Intrinsics.checkParameterIsNotNull((Object)labelReferenceExpression, (String)"labelReferenceExpression");
            return SequencesKt.toList((Sequence)Companion.getContainingLambdas(labelReferenceExpression));
        }

        public ForLambda(@NotNull KtLabelReferenceExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            super(expression2, null);
            this.chooserTitle = "Select lambda to label";
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\nH\u0002J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CreateLabelFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getContainingLambdas", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtLabelReferenceExpression;", "getContainingLoops", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private final Sequence<KtLoopExpression> getContainingLoops(@NotNull KtLabelReferenceExpression $this$getContainingLoops) {
            Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile(PsiUtilsKt.getParents((PsiElement)$this$getContainingLoops), (Function1)getContainingLoops.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$getContainingLoops$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            return sequence2;
        }

        private final Sequence<KtLambdaExpression> getContainingLambdas(@NotNull KtLabelReferenceExpression $this$getContainingLambdas) {
            Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile(PsiUtilsKt.getParents((PsiElement)$this$getContainingLambdas), (Function1)getContainingLambdas.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$getContainingLambdas$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            return sequence2;
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PsiElement psiElement2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement3 = diagnostic.getPsiElement();
            if (!(psiElement3 instanceof KtLabelReferenceExpression)) {
                psiElement3 = null;
            }
            KtLabelReferenceExpression ktLabelReferenceExpression = (KtLabelReferenceExpression)psiElement3;
            if (ktLabelReferenceExpression == null) {
                return null;
            }
            KtLabelReferenceExpression labelReferenceExpression = ktLabelReferenceExpression;
            PsiElement psiElement4 = labelReferenceExpression.getParent();
            if (!(psiElement4 instanceof KtContainerNode)) {
                psiElement4 = null;
            }
            KtContainerNode ktContainerNode = (KtContainerNode)psiElement4;
            Object object = psiElement2 = ktContainerNode != null ? ktContainerNode.getParent() : null;
            return psiElement2 instanceof KtBreakExpression || psiElement2 instanceof KtContinueExpression ? (IntentionAction)(SequencesKt.any(this.getContainingLoops(labelReferenceExpression)) ? new ForLoop(labelReferenceExpression) : null) : (psiElement2 instanceof KtReturnExpression ? (IntentionAction)(SequencesKt.any(this.getContainingLambdas(labelReferenceExpression)) ? new ForLambda(labelReferenceExpression) : null) : null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

