/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.BooleanMissingCase;
import org.jetbrains.kotlin.cfg.ClassMissingCase;
import org.jetbrains.kotlin.cfg.NullMissingCase;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenCheckerKt;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.ImportAllMembersIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddWhenRemainingBranchesFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "expression", "withImport", "", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Z)V", "getWithImport", "()Z", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Companion", "idea"})
public final class AddWhenRemainingBranchesFix
extends KotlinQuickFixAction<KtWhenExpression> {
    private final boolean withImport;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Add remaining branches" + (this.withImport ? " with * import" : "");
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Companion.isAvailable((KtWhenExpression)this.getElement());
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Companion.addRemainingBranches((KtWhenExpression)this.getElement(), this.withImport);
    }

    public final boolean getWithImport() {
        return this.withImport;
    }

    public AddWhenRemainingBranchesFix(@NotNull KtWhenExpression expression2, boolean withImport) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
        this.withImport = withImport;
    }

    public /* synthetic */ AddWhenRemainingBranchesFix(KtWhenExpression ktWhenExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(ktWhenExpression, bl);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\f\u0010\u0010\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddWhenRemainingBranchesFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "addRemainingBranches", "", "element", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "withImport", "", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "importAllEntries", "isAvailable", "hasEnumSubject", "idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        private final boolean hasEnumSubject(@NotNull KtWhenExpression $this$hasEnumSubject) {
            KtExpression ktExpression = $this$hasEnumSubject.getSubjectExpression();
            if (ktExpression == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"subjectExpression ?: return false");
            KtExpression subject = ktExpression;
            Object object = ResolutionUtils.analyze$default(subject, null, 1, null).getType(subject);
            if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"subject.analyze().getTyp\u2026escriptor ?: return false");
            Object descriptor2 = object;
            Object object2 = descriptor2;
            if (!(object2 instanceof ClassDescriptor)) {
                object2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)object2;
            return (classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.ENUM_CLASS;
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
            boolean $i$f$getNonStrictParentOfType = false;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtWhenExpression.class, (boolean)false);
            if (ktWhenExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtWhenExpression whenExpression2 = ktWhenExpression;
            List actions = CollectionsKt.mutableListOf((Object[])new AddWhenRemainingBranchesFix[]{new AddWhenRemainingBranchesFix(whenExpression2, false, 2, null)});
            if (this.hasEnumSubject(whenExpression2)) {
                Collection collection = actions;
                AddWhenRemainingBranchesFix addWhenRemainingBranchesFix = new AddWhenRemainingBranchesFix(whenExpression2, true);
                boolean bl = false;
                collection.add(addWhenRemainingBranchesFix);
            }
            return actions;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAvailable(@Nullable KtWhenExpression element3) {
            if (element3 == null) {
                return false;
            }
            if (element3.getCloseBrace() == null) return false;
            List<WhenMissingCase> list2 = WhenChecker.INSTANCE.getMissingCases(element3, ResolutionUtils.analyze$default(element3, null, 1, null));
            boolean bl = false;
            boolean bl2 = false;
            List<WhenMissingCase> $this$with = list2;
            boolean bl3 = false;
            Collection collection = $this$with;
            boolean bl4 = false;
            if (collection.isEmpty()) return false;
            boolean bl5 = true;
            if (!bl5) return false;
            if (WhenCheckerKt.getHasUnknown($this$with)) return false;
            return true;
        }

        public final void addRemainingBranches(@Nullable KtWhenExpression element3, boolean withImport) {
            Object v3;
            Object object;
            PsiElement whenCloseBrace;
            List<WhenMissingCase> missingCases;
            block12: {
                if (element3 == null) {
                    return;
                }
                missingCases = WhenChecker.INSTANCE.getMissingCases(element3, ResolutionUtils.analyze$default(element3, null, 1, null));
                PsiElement psiElement2 = element3.getCloseBrace();
                if (psiElement2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)"isAvailable should check if close brace exist"));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.closeBrace ?: th\u2026ck if close brace exist\")");
                whenCloseBrace = psiElement2;
                List<KtWhenEntry> list2 = element3.getEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.entries");
                Iterable iterable = list2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                object = iterable2.iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    KtWhenEntry it = (KtWhenEntry)t;
                    boolean bl3 = false;
                    KtWhenEntry ktWhenEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"it");
                    if (!ktWhenEntry.isElse()) continue;
                    v3 = t;
                    break block12;
                }
                v3 = null;
            }
            KtWhenEntry elseBranch = v3;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            PsiElement psiElement3 = whenCloseBrace.getPrevSibling();
            if (!(psiElement3 instanceof PsiWhiteSpace)) {
                psiElement3 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement3;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.replace(psiFactory.createNewLine());
            }
            for (WhenMissingCase whenMissingCase : missingCases) {
                String string;
                object = whenMissingCase;
                if (Intrinsics.areEqual((Object)object, (Object)UnknownMissingCase.INSTANCE) || Intrinsics.areEqual((Object)object, (Object)NullMissingCase.INSTANCE) || object instanceof BooleanMissingCase) {
                    string = whenMissingCase.getBranchConditionText();
                } else if (object instanceof ClassMissingCase) {
                    string = (((ClassMissingCase)whenMissingCase).getClassIsSingleton() ? "" : "is ") + UtilsKt.quoteIfNeeded(DescriptorUtilsKt.getFqNameSafe(((ClassMissingCase)whenMissingCase).getDescriptor())).asString();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String branchConditionText = string;
                KtWhenEntry entry = psiFactory.createWhenEntry(branchConditionText + " -> TODO()");
                if (elseBranch != null) {
                    element3.addBefore((PsiElement)entry, (PsiElement)elseBranch);
                    continue;
                }
                element3.addBefore((PsiElement)entry, whenCloseBrace);
            }
            ShortenReferences.process$default(ShortenReferences.DEFAULT, element3, null, 2, null);
            if (withImport) {
                this.importAllEntries(element3);
            }
        }

        public static /* synthetic */ void addRemainingBranches$default(Companion companion, KtWhenExpression ktWhenExpression, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.addRemainingBranches(ktWhenExpression, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final void importAllEntries(KtWhenExpression element3) {
            block5: {
                KtDotQualifiedExpression ktDotQualifiedExpression;
                ImportAllMembersIntention.Companion $this$with;
                block4: {
                    void $this$mapTo$iv$iv;
                    ImportAllMembersIntention.Companion companion = ImportAllMembersIntention.Companion;
                    boolean bl = false;
                    boolean bl2 = false;
                    $this$with = companion;
                    boolean bl3 = false;
                    List<KtWhenEntry> list2 = element3.getEntries();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.entries");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        void v1 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        Object[] objectArray = v1.getConditions();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.conditions");
                        List list3 = ArraysKt.toList((Object[])objectArray);
                        collection.add(list3);
                    }
                    Iterable $this$firstNotNullResult$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    boolean $i$f$firstNotNullResult = false;
                    for (Object element$iv : $this$firstNotNullResult$iv) {
                        KtDotQualifiedExpression result$iv;
                        KtWhenCondition it = (KtWhenCondition)element$iv;
                        boolean bl5 = false;
                        KtWhenCondition ktWhenCondition = it;
                        if (!(ktWhenCondition instanceof KtWhenConditionWithExpression)) {
                            ktWhenCondition = null;
                        }
                        KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)ktWhenCondition;
                        KtExpression ktExpression = ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null;
                        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                            ktExpression = null;
                        }
                        if ((result$iv = (KtDotQualifiedExpression)ktExpression) == null) continue;
                        ktDotQualifiedExpression = result$iv;
                        break block4;
                    }
                    ktDotQualifiedExpression = null;
                }
                if (ktDotQualifiedExpression == null) break block5;
                $this$with.importReceiverMembers(ktDotQualifiedExpression);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

