/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;

public class TargetPlatformDetector {
    public static final TargetPlatformDetector INSTANCE = new TargetPlatformDetector();
    private static final Logger LOG = Logger.getInstance(TargetPlatformDetector.class);

    private TargetPlatformDetector() {
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull KtFile file2) {
        Module moduleForFile;
        VirtualFile virtualFile2;
        KotlinScriptDefinition scriptDefinition;
        KtFile contextFile;
        TargetPlatform explicitPlatform;
        if (file2 == null) {
            TargetPlatformDetector.$$$reportNull$$$1(0);
        }
        if (file2 == null) {
            TargetPlatformDetector.$$$reportNull$$$0(0);
        }
        if ((explicitPlatform = PlatformKt.getForcedTargetPlatform(file2)) != null) {
            TargetPlatform targetPlatform = explicitPlatform;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(1);
            }
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$1(1);
            }
            return targetPlatform;
        }
        if (file2 instanceof KtCodeFragment && (contextFile = ((KtCodeFragment)file2).getContextContainingFile()) != null) {
            return TargetPlatformDetector.getPlatform(contextFile);
        }
        PsiElement context2 = KtPsiFactoryKt.getAnalysisContext(file2);
        if (context2 != null) {
            PsiFile contextFile2 = context2.getContainingFile();
            TargetPlatform targetPlatform = contextFile2 instanceof KtFile ? TargetPlatformDetector.getPlatform((KtFile)contextFile2) : JvmPlatform.INSTANCE;
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$0(2);
            }
            if (targetPlatform == null) {
                TargetPlatformDetector.$$$reportNull$$$1(2);
            }
            return targetPlatform;
        }
        if (file2.isScript() && (scriptDefinition = DefinitionsKt.scriptDefinition((PsiFile)file2)) != null) {
            String platformNameFromScriptDefinition = scriptDefinition.getPlatform();
            for (IdePlatform<IdePlatformKind<?>, CommonCompilerArguments> platform : IdePlatformKind.Companion.getAll_PLATFORMS()) {
                TargetPlatform compilerPlatform = platform.getKind().getCompilerPlatform();
                if (!compilerPlatform.getPlatformName().equals(platformNameFromScriptDefinition)) continue;
                TargetPlatform targetPlatform = compilerPlatform;
                if (targetPlatform == null) {
                    TargetPlatformDetector.$$$reportNull$$$0(3);
                }
                if (targetPlatform == null) {
                    TargetPlatformDetector.$$$reportNull$$$1(3);
                }
                return targetPlatform;
            }
        }
        if ((virtualFile2 = file2.getOriginalFile().getVirtualFile()) != null && (moduleForFile = ProjectFileIndex.SERVICE.getInstance((Project)file2.getProject()).getModuleForFile(virtualFile2)) != null) {
            return TargetPlatformDetector.getPlatform(moduleForFile);
        }
        TargetPlatform targetPlatform = DefaultIdeTargetPlatformKindProvider.Companion.getDefaultCompilerPlatform();
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(4);
        }
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$1(4);
        }
        return targetPlatform;
    }

    @NotNull
    public static TargetPlatform getPlatform(@NotNull Module module) {
        if (module == null) {
            TargetPlatformDetector.$$$reportNull$$$1(5);
        }
        if (module == null) {
            TargetPlatformDetector.$$$reportNull$$$0(5);
        }
        TargetPlatform targetPlatform = ProjectStructureUtil.getCachedPlatformForModule(module);
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$0(6);
        }
        if (targetPlatform == null) {
            TargetPlatformDetector.$$$reportNull$$$1(6);
        }
        return targetPlatform;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/project/TargetPlatformDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatform";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

