/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.configuration.KotlinMigrationProjectComponentKt;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.inspections.migration.CoroutinesObsoleteLibrariesKt;
import org.jetbrains.kotlin.idea.inspections.migration.DeprecatedForKotlinLibInfo;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/MavenCoroutinesDeprecationInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "Companion", "idea-maven"})
public final class MavenCoroutinesDeprecationInspection
extends DomElementsInspection<MavenDomProjectModel>
implements CleanupLocalInspectionTool,
MigrationFix {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkParameterIsNotNull((Object)migrationInfo, (String)"migrationInfo");
        return KotlinMigrationProjectComponentKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3);
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlFile, (String)"domFileElement.file");
        XmlFile file2 = xmlFile;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"domFileElement.module ?: return");
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProject, (String)"manager.findProject(module) ?: return");
        MavenProject mavenProject2 = mavenProject;
        PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (DeprecatedForKotlinLibInfo deprecatedLibInfo : CoroutinesObsoleteLibrariesKt.getDEPRECATED_COROUTINES_LIBRARIES_INFORMATION()) {
            String versionStr;
            if (!MavenCoroutinesDeprecationInspection.Companion.checkKotlinVersion(module2, deprecatedLibInfo.getSinceKotlinLanguageVersion())) {
                return;
            }
            MavenId libMavenId = new MavenId(deprecatedLibInfo.getLib().getGroupId(), deprecatedLibInfo.getLib().getName(), null);
            for (MavenDomDependency dependency : PomFile.findDependencies$default(pomFile2, libMavenId, null, 2, null)) {
                void $this$mapTo$iv$iv;
                List list2 = mavenProject2.findDependencies(deprecatedLibInfo.getLib().getGroupId(), deprecatedLibInfo.getLib().getName());
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"mavenProject.findDepende\u2026precatedLibInfo.lib.name)");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v6 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                    String string = v6.getVersion();
                    collection.add(string);
                }
                versionStr = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                if (versionStr == null) continue;
                MavenCoroutinesDeprecationInspection.Companion.reportDependency(dependency, versionStr, deprecatedLibInfo, holder);
            }
            MavenDomDependencyManagement mavenDomDependencyManagement = pomFile2.getDomModel().getDependencyManagement();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomDependencyManagement, (String)"pomFile.domModel.dependencyManagement");
            MavenDomDependencies mavenDomDependencies = mavenDomDependencyManagement.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomDependencies, (String)"pomFile.domModel.dependencyManagement.dependencies");
            for (MavenDomDependency dependency : PomFileKt.findDependencies$default(mavenDomDependencies, libMavenId, null, 2, null)) {
                GenericDomValue genericDomValue = dependency.getVersion();
                versionStr = genericDomValue != null ? genericDomValue.getStringValue() : null;
                if (versionStr == null) continue;
                MavenCoroutinesDeprecationInspection.Companion.reportDependency(dependency, versionStr, deprecatedLibInfo, holder);
            }
        }
    }

    public MavenCoroutinesDeprecationInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/MavenCoroutinesDeprecationInspection$Companion;", "", "()V", "checkKotlinVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "reportDependency", "", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "versionStr", "", "deprecatedLibInfo", "Lorg/jetbrains/kotlin/idea/inspections/migration/DeprecatedForKotlinLibInfo;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "idea-maven"})
    public static final class Companion {
        private final void reportDependency(MavenDomDependency dependency, String versionStr, DeprecatedForKotlinLibInfo deprecatedLibInfo, DomElementAnnotationHolder holder) {
            LocalQuickFix[] localQuickFixArray;
            String updatedVersionStr = deprecatedLibInfo.getVersionUpdater().updateVersion(versionStr);
            if (Intrinsics.areEqual((Object)updatedVersionStr, (Object)versionStr)) {
                return;
            }
            GenericDomValue genericDomValue = dependency.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)genericDomValue, (String)"dependency.version");
            XmlElement xmlElement = genericDomValue.getXmlElement();
            if (xmlElement == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement, (String)"dependency.version.xmlElement ?: return");
            XmlElement xmlElement2 = xmlElement;
            String string = xmlElement2.getText();
            if (string == null) {
                return;
            }
            String xmlText = string;
            if (StringsKt.contains$default((CharSequence)xmlText, (CharSequence)updatedVersionStr, (boolean)false, (int)2, null)) {
                return;
            }
            if (StringsKt.contains$default((CharSequence)xmlText, (CharSequence)versionStr, (boolean)false, (int)2, null)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new ReplaceStringInDocumentFix((PsiElement)xmlElement2, versionStr, updatedVersionStr);
            } else {
                localQuickFixArray = new LocalQuickFix[]{};
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.createProblem((DomElement)dependency.getVersion(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, deprecatedLibInfo.getMessage(), null, Arrays.copyOf(fixes, fixes.length));
        }

        private final boolean checkKotlinVersion(Module module, LanguageVersion languageVersion) {
            boolean bl;
            block3: {
                ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.getWholeModuleGroup(module);
                Iterable $this$any$iv = moduleGroup.getSourceRootModules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Module moduleInGroup = (Module)element$iv;
                        boolean bl2 = false;
                        if (!(PlatformKt.getLanguageVersionSettings(moduleInGroup).getLanguageVersion().compareTo((Enum)languageVersion) >= 0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

