/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.java;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.java.UnimplementedKotlinInterfaceMemberAnnotator;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/java/UnimplementedKotlinInterfaceMemberAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "findUnimplementedMethod", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "registerFixes", "errorAnnotation", "Lcom/intellij/lang/annotation/Annotation;", "report", "method", "idea-core"})
public final class UnimplementedKotlinInterfaceMemberAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            if (!(element3 instanceof PsiClass) || Intrinsics.areEqual((Object)((PsiClass)element3).getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE))) {
                return;
            }
            if (((PsiClass)element3).isInterface() || ((PsiClass)element3).hasModifierProperty("abstract")) {
                return;
            }
            if (ClassUtil.getAnyMethodToImplement((PsiClass)((PsiClass)element3)) != null) {
                return;
            }
            KtLightMethod ktLightMethod = this.findUnimplementedMethod((PsiClass)element3);
            if (ktLightMethod == null) break block3;
            KtLightMethod ktLightMethod2 = ktLightMethod;
            boolean bl = false;
            boolean bl2 = false;
            KtLightMethod it = ktLightMethod2;
            boolean bl3 = false;
            this.report(it, holder, (PsiClass)element3);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final KtLightMethod findUnimplementedMethod(PsiClass psiClass2) {
        Object v8;
        block9: {
            Object element$iv;
            boolean bl;
            PsiClass kotlinSuperClass2;
            Object object;
            Object v3;
            List signaturesFromKotlinInterfaces;
            int n;
            block8: {
                void $this$filterTo$iv$iv;
                Collection collection = psiClass2.getVisibleSignatures();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"psiClass.visibleSignatures");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    HierarchicalMethodSignature signature = (HierarchicalMethodSignature)element$iv$iv;
                    boolean bl2 = false;
                    HierarchicalMethodSignature hierarchicalMethodSignature = signature;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hierarchicalMethodSignature, (String)"signature");
                    PsiMethod psiMethod = hierarchicalMethodSignature.getMethod();
                    boolean bl3 = false;
                    n = 0;
                    PsiMethod it = psiMethod;
                    boolean bl4 = false;
                    boolean bl5 = it instanceof KtLightMethod && it.hasModifierProperty("default");
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection $this$ifEmpty$iv = (List)destination$iv$iv;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.isEmpty()) {
                    return null;
                }
                signaturesFromKotlinInterfaces = (List)$this$ifEmpty$iv;
                Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)psiClass2, (Function1)findUnimplementedMethod.kotlinSuperClass.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    PsiClass it = (PsiClass)element$iv2;
                    boolean bl6 = false;
                    if (!(it instanceof KtLightClassForSourceDeclaration)) continue;
                    v3 = element$iv2;
                    break block8;
                }
                v3 = null;
            }
            if ((object = (kotlinSuperClass2 = (PsiClass)v3)) == null || (object = object.getVisibleSignatures()) == null) {
                object = CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"kotlinSuperClass?.visibleSignatures ?: emptyList()");
            Object signaturesVisibleThroughKotlinSuperClass = object;
            Iterable $this$firstOrNull$iv = signaturesFromKotlinInterfaces;
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            do {
                block12: {
                    boolean bl7;
                    block10: {
                        PsiAnnotation[] psiAnnotationArray;
                        block13: {
                            block11: {
                                PsiAnnotation[] $this$none$iv;
                                if (!iterator2.hasNext()) break block11;
                                element$iv = iterator2.next();
                                HierarchicalMethodSignature it = (HierarchicalMethodSignature)element$iv;
                                boolean bl8 = false;
                                if (signaturesVisibleThroughKotlinSuperClass.contains(it)) break block12;
                                HierarchicalMethodSignature hierarchicalMethodSignature = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)hierarchicalMethodSignature, (String)"it");
                                PsiMethod psiMethod = hierarchicalMethodSignature.getMethod();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it.method");
                                PsiModifierList psiModifierList = psiMethod.getModifierList();
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"it.method.modifierList");
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList.getAnnotations(), (String)"it.method.modifierList.annotations");
                                boolean $i$f$none = false;
                                psiAnnotationArray = $this$none$iv;
                                n = psiAnnotationArray.length;
                                break block13;
                            }
                            v8 = null;
                            break block9;
                        }
                        for (int j = 0; j < n; ++j) {
                            PsiAnnotation element$iv3;
                            PsiAnnotation annotation2 = element$iv3 = psiAnnotationArray[j];
                            boolean bl9 = false;
                            PsiAnnotation psiAnnotation = annotation2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"annotation");
                            if (!Intrinsics.areEqual((Object)psiAnnotation.getQualifiedName(), (Object)JvmAnnotationUtilKt.getJVM_DEFAULT_FQ_NAME().asString())) continue;
                            bl7 = false;
                            break block10;
                        }
                        bl7 = true;
                    }
                    if (bl7) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v8 = element$iv;
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = v8;
        Object object = hierarchicalMethodSignature != null ? hierarchicalMethodSignature.getMethod() : null;
        if (!(object instanceof KtLightMethod)) {
            object = null;
        }
        return (KtLightMethod)object;
    }

    private final void report(KtLightMethod method, AnnotationHolder holder, PsiClass psiClass2) {
        Annotation errorAnnotation;
        String key = psiClass2 instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract";
        String message2 = JavaErrorMessages.message((String)key, (Object[])new Object[]{HighlightUtil.formatClass((PsiClass)psiClass2, (boolean)false), JavaHighlightUtil.formatMethod((PsiMethod)((PsiMethod)method)), HighlightUtil.formatClass((PsiClass)method.getContainingClass(), (boolean)false)});
        Annotation annotation2 = errorAnnotation = holder.createErrorAnnotation(HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)psiClass2), message2);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"errorAnnotation");
        this.registerFixes(annotation2, psiClass2);
    }

    private final void registerFixes(Annotation errorAnnotation, PsiClass psiClass2) {
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        errorAnnotation.registerFix((IntentionAction)quickFixFactory.createImplementMethodsFix(psiClass2));
        if (!(psiClass2 instanceof PsiAnonymousClass)) {
            PsiModifierList psiModifierList = psiClass2.getModifierList();
            if (!(psiModifierList != null ? psiModifierList.hasExplicitModifier("final") : false)) {
                errorAnnotation.registerFix((IntentionAction)quickFixFactory.createModifierListFix((PsiModifierListOwner)psiClass2, "abstract", true, false));
            }
        }
    }
}

