/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.SimplifyBooleanWithConstantsIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0015\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u001d\u0010\u0017\u001a\u00020\n*\u00020\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u000bH\u0002J\u000e\u0010\u001c\u001a\u00020\n*\u0004\u0018\u00010\u000bH\u0002J\f\u0010\u001d\u001a\u00020\u0002*\u00020\u0002H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SimplifyBooleanWithConstantsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "areThereExpressionsToBeSimplified", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isApplicableTo", "removeRedundantAssertion", "expression", "removeRedundantAssertion$idea", "simplifyExpression", "toSimplifiedBooleanBinaryExpressionWithConstantOperand", "constantOperand", "otherOperand", "operation", "Lcom/intellij/psi/tree/IElementType;", "toSimplifiedExpression", "canBeReducedToBooleanConstant", "constant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/Boolean;)Z", "canBeReducedToFalse", "canBeReducedToTrue", "hasBooleanType", "topBinary", "idea"})
public final class SimplifyBooleanWithConstantsIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.areThereExpressionsToBeSimplified(this.topBinary(element3));
    }

    private final KtBinaryExpression topBinary(@NotNull KtBinaryExpression $this$topBinary) {
        KtBinaryExpression ktBinaryExpression;
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf((PsiElement)$this$topBinary), (Function1)topBinary.1.INSTANCE));
        if (!(object instanceof KtBinaryExpression)) {
            object = null;
        }
        if ((ktBinaryExpression = (KtBinaryExpression)object) == null) {
            ktBinaryExpression = $this$topBinary;
        }
        return ktBinaryExpression;
    }

    private final boolean areThereExpressionsToBeSimplified(KtExpression element3) {
        if (element3 == null) {
            return false;
        }
        KtExpression ktExpression = element3;
        if (ktExpression instanceof KtParenthesizedExpression) {
            return this.areThereExpressionsToBeSimplified(((KtParenthesizedExpression)element3).getExpression());
        }
        if (ktExpression instanceof KtBinaryExpression) {
            IElementType iElementType = ((KtBinaryExpression)element3).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.operationToken");
            IElementType op = iElementType;
            if (Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EXCLEQ))) {
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getLeft()) && this.hasBooleanType(((KtBinaryExpression)element3).getRight())) {
                    return true;
                }
                if (this.areThereExpressionsToBeSimplified(((KtBinaryExpression)element3).getRight()) && this.hasBooleanType(((KtBinaryExpression)element3).getLeft())) {
                    return true;
                }
            }
        }
        return SimplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant$default(this, element3, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        KtExpression ktExpression;
        void $this$replaced$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtBinaryExpression topBinary2 = this.topBinary(element3);
        KtExpression simplified = this.toSimplifiedExpression(topBinary2);
        PsiElement psiElement2 = (PsiElement)topBinary2;
        PsiElement newElement$iv = (PsiElement)KtPsiUtil.safeDeparenthesize(simplified, true);
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
        PsiElement psiElement3 = result$iv;
        if (!(psiElement3 instanceof KtExpression)) {
            psiElement3 = null;
        }
        if ((ktExpression = (KtExpression)psiElement3) == null) {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"topBinary.replaced(KtPsi\u2026hesize(simplified, true))");
        KtExpression result2 = ktExpression;
        this.removeRedundantAssertion$idea(result2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void removeRedundantAssertion$idea(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)expression2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) return;
        KtCallExpression callExpression2 = ktCallExpression;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(callExpression2);
        FqName fqName2 = callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null;
        List<KtValueArgument> list2 = callExpression2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
        List<KtValueArgument> valueArguments2 = list2;
        FqName fqName3 = fqName2;
        if (!Intrinsics.areEqual((Object)(fqName3 != null ? fqName3.asString() : null), (Object)"kotlin.assert")) return;
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull(valueArguments2);
        if (!CommonUtilsKt.isTrueConstant(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null)) return;
        boolean bl = true;
        boolean isRedundant2 = bl;
        if (!isRedundant2) return;
        callExpression2.delete();
    }

    private final KtExpression toSimplifiedExpression(KtExpression expression2) {
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
        if (this.canBeReducedToTrue(expression2)) {
            return psiFactory.createExpression("true");
        }
        if (this.canBeReducedToFalse(expression2)) {
            return psiFactory.createExpression("false");
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            KtExpression expr2 = ((KtParenthesizedExpression)expression2).getExpression();
            if (expr2 != null) {
                KtExpression simplified = this.toSimplifiedExpression(expr2);
                return simplified instanceof KtBinaryExpression ? CreateByPatternKt.createExpressionByPattern$default(psiFactory, "($0)", new Object[]{simplified}, false, 4, null) : simplified;
            }
        } else if (expression2 instanceof KtBinaryExpression) {
            if (!this.areThereExpressionsToBeSimplified(expression2)) {
                return (KtExpression)PsiModificationUtilsKt.copied((PsiElement)expression2);
            }
            KtExpression left2 = ((KtBinaryExpression)expression2).getLeft();
            KtExpression right2 = ((KtBinaryExpression)expression2).getRight();
            IElementType iElementType = ((KtBinaryExpression)expression2).getOperationToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.operationToken");
            IElementType op = iElementType;
            if (left2 != null && right2 != null && (Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.ANDAND)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.OROR)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EXCLEQ)))) {
                KtExpression ktExpression;
                KtExpression simpleLeft = this.simplifyExpression(left2);
                KtExpression simpleRight = this.simplifyExpression(right2);
                if (this.canBeReducedToTrue(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleRight, op);
                } else if (this.canBeReducedToFalse(simpleLeft)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleRight, op);
                } else if (this.canBeReducedToTrue(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(true, simpleLeft, op);
                } else if (this.canBeReducedToFalse(simpleRight)) {
                    ktExpression = this.toSimplifiedBooleanBinaryExpressionWithConstantOperand(false, simpleLeft, op);
                } else {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)expression2).getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                    String opText = ktOperationReferenceExpression.getText();
                    ktExpression = CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 " + opText + " $1", new Object[]{simpleLeft, simpleRight}, false, 4, null);
                }
                return ktExpression;
            }
        }
        return (KtExpression)PsiModificationUtilsKt.copied((PsiElement)expression2);
    }

    private final KtExpression toSimplifiedBooleanBinaryExpressionWithConstantOperand(boolean constantOperand, KtExpression otherOperand, IElementType operation2) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)otherOperand, false, 2, null);
        IElementType iElementType = operation2;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            if (constantOperand) {
                return factory2.createExpression("true");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            if (!constantOperand) {
                return factory2.createExpression("false");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            KtExpression ktExpression = this.toSimplifiedExpression(otherOperand);
            boolean bl = false;
            boolean bl2 = false;
            KtExpression it = ktExpression;
            boolean bl3 = false;
            return constantOperand == Intrinsics.areEqual((Object)operation2, (Object)((Object)KtTokens.EQEQ)) ? it : CreateByPatternKt.createExpressionByPattern$default(factory2, "!$0", new Object[]{it}, false, 4, null);
        }
        return this.toSimplifiedExpression(otherOperand);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression simplifyExpression(KtExpression expression2) {
        KtExpression ktExpression;
        void $this$replaced$iv;
        PsiElement psiElement2 = (PsiElement)expression2;
        PsiElement newElement$iv = (PsiElement)this.toSimplifiedExpression(expression2);
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
        PsiElement psiElement3 = result$iv;
        if (!(psiElement3 instanceof KtExpression)) {
            psiElement3 = null;
        }
        if ((ktExpression = (KtExpression)psiElement3) == null) {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return ktExpression;
    }

    private final boolean hasBooleanType(@Nullable KtExpression $this$hasBooleanType) {
        Object object = $this$hasBooleanType;
        if (object == null || (object = CallUtilKt.getType((KtExpression)object, ResolutionUtils.analyze($this$hasBooleanType, BodyResolveMode.PARTIAL))) == null) {
            return false;
        }
        Object type2 = object;
        return KotlinBuiltIns.isBoolean((KotlinType)type2) && !FlexibleTypesKt.isFlexible((KotlinType)type2);
    }

    private final boolean canBeReducedToBooleanConstant(@NotNull KtExpression $this$canBeReducedToBooleanConstant, Boolean constant) {
        return CompileTimeConstantUtils.canBeReducedToBooleanConstant($this$canBeReducedToBooleanConstant, ResolutionUtils.analyze($this$canBeReducedToBooleanConstant, BodyResolveMode.PARTIAL), constant);
    }

    static /* synthetic */ boolean canBeReducedToBooleanConstant$default(SimplifyBooleanWithConstantsIntention simplifyBooleanWithConstantsIntention, KtExpression ktExpression, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return simplifyBooleanWithConstantsIntention.canBeReducedToBooleanConstant(ktExpression, bl);
    }

    private final boolean canBeReducedToTrue(@NotNull KtExpression $this$canBeReducedToTrue) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToTrue, true);
    }

    private final boolean canBeReducedToFalse(@NotNull KtExpression $this$canBeReducedToFalse) {
        return this.canBeReducedToBooleanConstant($this$canBeReducedToFalse, false);
    }

    public SimplifyBooleanWithConstantsIntention() {
        super(KtBinaryExpression.class, "Simplify boolean expression", null, 4, null);
    }
}

