/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class IntroduceBackingPropertyIntention
extends SelfTargetingIntention<KtProperty> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!Companion.canIntroduceBackingProperty(element3)) {
            return false;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null && psiElement2.containsOffset(caretOffset);
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Companion.introduceBackingProperty(element3);
    }

    public IntroduceBackingPropertyIntention() {
        super(KtProperty.class, "Introduce backing property", null, 4, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention$Companion;", "", "()V", "canIntroduceBackingProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "createBackingProperty", "", "createGetter", "element", "createSetter", "introduceBackingProperty", "replaceFieldReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "propertyName", "", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "idea"})
    public static final class Companion {
        public final boolean canIntroduceBackingProperty(@NotNull KtProperty property2) {
            boolean bl;
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                String string = property2.getName();
                if (string == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name ?: return false");
                String name2 = string;
                if (property2.hasModifier(KtTokens.CONST_KEYWORD)) {
                    return false;
                }
                if (ModifierListModifactorKt.hasJvmFieldAnnotation(property2)) {
                    return false;
                }
                BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade(property2).analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)property2)).getBindingContext();
                DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor2 == null) {
                    return false;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor2;
                if (Intrinsics.areEqual((Object)((Boolean)bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)false)) {
                    return false;
                }
                PsiElement $this$getStrictParentOfType$iv = property2;
                boolean $i$f$getStrictParentOfType = false;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
                if (ktClassOrObject == null) {
                    return false;
                }
                KtClassOrObject containingClass = ktClassOrObject;
                if (ExpectActualUtilKt.isExpectDeclaration(containingClass)) {
                    return false;
                }
                Iterable $this$none$iv = containingClass.getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)('_' + name2)))) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final void introduceBackingProperty(@NotNull KtProperty property2) {
            KtPropertyAccessor getter2;
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            this.createBackingProperty(property2);
            if (property2.getTypeReference() == null) {
                KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration(property2);
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(null, property2, type2);
            }
            if ((getter2 = property2.getGetter()) == null) {
                this.createGetter(property2);
            } else {
                KtElement ktElement = getter2;
                String string = property2.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                this.replaceFieldReferences(ktElement, string);
            }
            if (property2.isVar()) {
                KtPropertyAccessor setter2 = property2.getSetter();
                if (setter2 == null) {
                    this.createSetter(property2);
                } else {
                    KtElement ktElement = setter2;
                    String string = property2.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                    this.replaceFieldReferences(ktElement, string);
                }
            }
            property2.setInitializer(null);
        }

        private final void createGetter(KtProperty element3) {
            String body2 = "get() = _" + element3.getName();
            KtPropertyAccessor ktPropertyAccessor = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createProperty("val x " + body2).getGetter();
            if (ktPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"KtPsiFactory(element).cr\u2026y(\"val x $body\").getter!!");
            KtPropertyAccessor newGetter = ktPropertyAccessor;
            this.addAccessor(element3, newGetter);
        }

        private final void createSetter(KtProperty element3) {
            String body2 = "set(value) { _" + element3.getName() + " = value }";
            KtPropertyAccessor ktPropertyAccessor = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createProperty("val x " + body2).getSetter();
            if (ktPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"KtPsiFactory(element).cr\u2026y(\"val x $body\").setter!!");
            KtPropertyAccessor newSetter = ktPropertyAccessor;
            this.addAccessor(element3, newSetter);
        }

        private final void addAccessor(@NotNull KtProperty $this$addAccessor, KtPropertyAccessor newAccessor) {
            ASTNode semicolon2 = $this$addAccessor.getNode().findChildByType((IElementType)KtTokens.SEMICOLON);
            ASTNode aSTNode = semicolon2;
            $this$addAccessor.addBefore(newAccessor, (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
        }

        private final void createBackingProperty(KtProperty property2) {
            KtDeclaration backingProperty2 = CreateByPatternKt.buildDeclaration(KtPsiFactoryKt.KtPsiFactory$default(property2, false, 2, null), (Function1<? super BuilderByPattern<KtDeclaration>, Unit>)((Function1)new Function1<BuilderByPattern<KtDeclaration>, Unit>(property2){
                final /* synthetic */ KtProperty $property;

                public final void invoke(@NotNull BuilderByPattern<KtDeclaration> $this$buildDeclaration) {
                    Intrinsics.checkParameterIsNotNull($this$buildDeclaration, (String)"$receiver");
                    $this$buildDeclaration.appendFixedText("private ");
                    PsiElement psiElement2 = this.$property.getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"property.valOrVarKeyword");
                    String string = psiElement2.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.valOrVarKeyword.text");
                    $this$buildDeclaration.appendFixedText(string);
                    $this$buildDeclaration.appendFixedText(" _" + this.$property.getName());
                    if (this.$property.getTypeReference() != null) {
                        $this$buildDeclaration.appendFixedText(": ");
                        $this$buildDeclaration.appendTypeReference(this.$property.getTypeReference());
                    }
                    if (this.$property.getInitializer() != null) {
                        $this$buildDeclaration.appendFixedText(" = ");
                        $this$buildDeclaration.appendExpression(this.$property.getInitializer());
                    }
                }
                {
                    this.$property = ktProperty;
                    super(1);
                }
            }));
            property2.getParent().addBefore((PsiElement)backingProperty2, (PsiElement)property2);
        }

        private final void replaceFieldReferences(KtElement element3, String propertyName) {
            element3.acceptChildren(new KtTreeVisitorVoid(element3, propertyName){
                final /* synthetic */ KtElement $element;
                final /* synthetic */ String $propertyName;

                public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                    D target;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(expression2, null, 1, null);
                    Object object = target = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                    if (target instanceof SyntheticFieldDescriptor) {
                        expression2.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)this.$element, false, 2, null).createSimpleName('_' + this.$propertyName));
                    }
                }

                public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                    Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                }
                {
                    this.$element = $captured_local_variable$0;
                    this.$propertyName = $captured_local_variable$1;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

