/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.intentions.ConvertParameterToReceiverIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertParameterToReceiverIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "parameterIndex", "", "isApplicableTo", "", "caretOffset", "startInWriteAction", "idea"})
public final class ConvertParameterToReceiverIntention
extends SelfTargetingIntention<KtParameter> {
    @Override
    public boolean isApplicableTo(@NotNull KtParameter element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.nameIdentifier ?: return false");
        PsiElement identifier2 = psiElement2;
        if (!identifier2.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (element3.isVarArg()) {
            return false;
        }
        PsiElement $this$getStrictParentOfType$iv = element3;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function2 = ktNamedFunction;
        return Intrinsics.areEqual((Object)function2.getValueParameterList(), (Object)element3.getParent()) && function2.getReceiverTypeReference() == null;
    }

    private final KotlinChangeSignatureConfiguration configureChangeSignature(int parameterIndex2) {
        return new KotlinChangeSignatureConfiguration(parameterIndex2){
            final /* synthetic */ int $parameterIndex;

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this, originalDescriptor){
                    final /* synthetic */ configureChangeSignature.1 this$0;
                    final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;

                    public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        it.setReceiver((KotlinParameterInfo)this.$originalDescriptor.getParameters().get(this.this$0.$parameterIndex));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$originalDescriptor = kotlinMethodDescriptor;
                        super(1);
                    }
                }));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                return true;
            }
            {
                this.$parameterIndex = $captured_local_variable$0;
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtParameter element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = element3;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction function2 = ktNamedFunction;
        int parameterIndex2 = function2.getValueParameters().indexOf(element3);
        DeclarationDescriptor declarationDescriptor = KotlinRefactoringUtilKt.resolveToExpectedDescriptorIfPossible(function2);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        KotlinChangeSignatureKt.runChangeSignature(project, descriptor2, this.configureChangeSignature(parameterIndex2), element3, this.getText());
    }

    public ConvertParameterToReceiverIntention() {
        super(KtParameter.class, "Convert parameter to receiver", null, 4, null);
    }
}

