/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertLateinitPropertyToNullableIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertLateinitPropertyToNullableIntention
extends SelfTargetingIntention<KtProperty> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!element3.hasModifier(KtTokens.LATEINIT_KEYWORD)) return false;
        if (!element3.isVar()) return false;
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if ((ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType) return false;
        if (element3.getInitializer() != null) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        KotlinType kotlinType2 = (KotlinType)ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference2);
        if (kotlinType2 == null || (kotlinType2 = TypeUtilsKt.makeNullable(kotlinType2)) == null) {
            return;
        }
        KotlinType nullableType = kotlinType2;
        element3.removeModifier(KtTokens.LATEINIT_KEYWORD);
        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)element3, nullableType, false, 2, null);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null);
        KtKeywordToken ktKeywordToken = KtTokens.NULL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.NULL_KEYWORD");
        String string = ktKeywordToken.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KtTokens.NULL_KEYWORD.value");
        element3.setInitializer(ktPsiFactory.createExpression(string));
    }

    public ConvertLateinitPropertyToNullableIntention() {
        super(KtProperty.class, "Convert to nullable var", null, 4, null);
    }
}

