/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.inspections.coroutines.AbstractIsResultInspection;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J#\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0012J6\u0010\r\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/DirectUseOfResultTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/coroutines/AbstractIsResultInspection;", "()V", "analyzeFunctionWithAllowedSuffix", "", "name", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toReport", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "hasCorrespondingNonCatchingFunction", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "nameWithoutCatching", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;Ljava/lang/String;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "valueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "extensionReceiverType", "idea"})
public final class DirectUseOfResultTypeInspection
extends AbstractIsResultInspection {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasCorrespondingNonCatchingFunction(@NotNull MemberScope $this$hasCorrespondingNonCatchingFunction, String nameWithoutCatching, List<? extends ValueParameterDescriptor> valueParameters2, KotlinType returnType2, KotlinType extensionReceiverType) {
        boolean bl;
        Name name2 = Name.identifier(nameWithoutCatching);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(nameWithoutCatching)");
        Collection<? extends SimpleFunctionDescriptor> nonCatchingFunctions = $this$hasCorrespondingNonCatchingFunction.getContributedFunctions(name2, NoLookupLocation.FROM_IDE);
        Iterable $this$any$iv = nonCatchingFunctions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            SimpleFunctionDescriptor nonCatchingFun = (SimpleFunctionDescriptor)element$iv;
            boolean bl2 = false;
            if (nonCatchingFun.getValueParameters().size() == valueParameters2.size() && Intrinsics.areEqual((Object)nonCatchingFun.getReturnType(), (Object)returnType2)) {
                ReceiverParameterDescriptor receiverParameterDescriptor = nonCatchingFun.getExtensionReceiverParameter();
                if (Intrinsics.areEqual((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null), (Object)extensionReceiverType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Boolean hasCorrespondingNonCatchingFunction(@NotNull FunctionDescriptor $this$hasCorrespondingNonCatchingFunction, KotlinType returnType2, String nameWithoutCatching) {
        MemberScope memberScope2;
        DeclarationDescriptor containingDescriptor;
        DeclarationDescriptor declarationDescriptor = $this$hasCorrespondingNonCatchingFunction.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
        DeclarationDescriptor declarationDescriptor2 = containingDescriptor = declarationDescriptor;
        if (declarationDescriptor2 instanceof ClassDescriptor) {
            memberScope2 = ((ClassDescriptor)containingDescriptor).getUnsubstitutedMemberScope();
        } else if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            memberScope2 = ((PackageFragmentDescriptor)containingDescriptor).getMemberScope();
        } else {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"when (containingDescript\u2026 -> return null\n        }");
        MemberScope scope2 = memberScope2;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull(returnType2.getArguments());
        KotlinType returnTypeArgument = typeProjection != null ? typeProjection.getType() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$hasCorrespondingNonCatchingFunction.getExtensionReceiverParameter();
        KotlinType extensionReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        List<ValueParameterDescriptor> list2 = $this$hasCorrespondingNonCatchingFunction.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
        if (this.hasCorrespondingNonCatchingFunction(scope2, nameWithoutCatching, list2, returnTypeArgument, extensionReceiverType)) {
            return true;
        }
        if (extensionReceiverType != null) {
            ClassDescriptor extensionClassDescriptor;
            ClassifierDescriptor classifierDescriptor = extensionReceiverType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((extensionClassDescriptor = (ClassDescriptor)classifierDescriptor) != null) {
                MemberScope memberScope3 = extensionClassDescriptor.getUnsubstitutedMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)memberScope3, (String)"extensionClassDescriptor.unsubstitutedMemberScope");
                MemberScope extensionClassScope = memberScope3;
                List<ValueParameterDescriptor> list3 = $this$hasCorrespondingNonCatchingFunction.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valueParameters");
                if (this.hasCorrespondingNonCatchingFunction(extensionClassScope, nameWithoutCatching, list3, returnTypeArgument, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void analyzeFunctionWithAllowedSuffix(@NotNull String name2, @NotNull FunctionDescriptor descriptor2, @NotNull PsiElement toReport, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)toReport, (String)"toReport");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.returnType ?: return");
        KotlinType returnType2 = kotlinType2;
        String nameWithoutCatching = StringsKt.substringBeforeLast$default((String)name2, (String)"Catching", null, (int)2, null);
        if (Intrinsics.areEqual((Object)this.hasCorrespondingNonCatchingFunction(descriptor2, returnType2, nameWithoutCatching), (Object)false)) {
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull(returnType2.getArguments());
            KotlinType returnTypeArgument = typeProjection != null ? typeProjection.getType() : null;
            Object object = returnTypeArgument;
            if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
                object = "T";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"returnTypeArgument?.cons\u2026?.name?.asString() ?: \"T\"");
            Object typeName = object;
            holder.registerProblem(toReport, "Function '" + name2 + "' returning 'Result<" + (String)typeName + ">' without the corresponding " + "function '" + nameWithoutCatching + "' returning '" + (String)typeName + '\'', ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    public DirectUseOfResultTypeInspection() {
        super("Result", "kotlin.Result", "Catching", SetsKt.setOf((Object[])new String[]{"success", "failure", "runCatching"}), "getOrThrow", false, null, 96, null);
    }
}

