/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.PsiDocComment;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspection;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspectionKt;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIJavaVisitor;
import org.jetbrains.kotlin.idea.inspections.api.ProblemsCache;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIJavaVisitor;", "Lcom/intellij/psi/JavaElementVisitor;", "myHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "problemsCache", "Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;)V", "exitOnNonCompiled", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "visitClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "visitDocComment", "comment", "Lcom/intellij/psi/javadoc/PsiDocComment;", "visitImportList", "list", "Lcom/intellij/psi/PsiImportList;", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "visitNewExpression", "expression", "Lcom/intellij/psi/PsiNewExpression;", "visitReferenceElement", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "visitReferenceExpression", "Lcom/intellij/psi/PsiReferenceExpression;", "idea-jvm"})
public final class IncompatibleAPIJavaVisitor
extends JavaElementVisitor {
    private final ProblemsHolder myHolder;
    private final ProblemsCache problemsCache;

    public void visitDocComment(@NotNull PsiDocComment comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
    }

    public void visitImportList(@Nullable PsiImportList list2) {
    }

    public void visitClass(@NotNull PsiClass aClass2) {
        Intrinsics.checkParameterIsNotNull((Object)aClass2, (String)"aClass");
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference2) {
        boolean isInsideImport2;
        block7: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
            PsiElement psiElement2 = reference2.getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"reference.element");
            Sequence $this$any$iv = SequencesKt.takeWhile(PsiUtilsKt.getParents(psiElement2), (Function1)visitReferenceElement.isInsideImport.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiImportStatement)) continue;
                bl = true;
                break block7;
            }
            bl = isInsideImport2 = false;
        }
        if (isInsideImport2) {
            return;
        }
        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)reference2.getElement()) == null) {
            return;
        }
        super.visitReferenceElement(reference2);
        String name2 = reference2.getReferenceName();
        if (name2 == null || !this.problemsCache.containsWord(name2)) {
            return;
        }
        PsiElement psiElement3 = reference2.resolve();
        if (!(psiElement3 instanceof PsiMember)) {
            psiElement3 = null;
        }
        PsiMember psiMember = (PsiMember)psiElement3;
        if (psiMember == null) {
            return;
        }
        PsiMember psiMember2 = psiMember;
        IncompatibleAPIInspection.Problem problem = IncompatibleAPIInspectionKt.findProblem((PsiElement)psiMember2, this.problemsCache);
        if (problem == null) {
            return;
        }
        IncompatibleAPIInspection.Problem problem2 = problem;
        IncompatibleAPIInspectionKt.registerProblemForReference((PsiReference)reference2, this.myHolder, problem2);
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression2) {
        String name2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)expression2)) == null) {
            return;
        }
        super.visitNewExpression(expression2);
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = expression2.getClassReference();
        String string = name2 = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceName() : null;
        if (name2 == null || !this.problemsCache.containsWord(name2)) {
            return;
        }
        PsiMethod constructor2 = expression2.resolveConstructor();
        if (this.exitOnNonCompiled((PsiElement)constructor2)) {
            return;
        }
        IncompatibleAPIInspection.Problem problem = IncompatibleAPIInspectionKt.findProblem((PsiElement)constructor2, this.problemsCache);
        if (problem != null) {
            IncompatibleAPIInspectionKt.registerProblemForReference((PsiReference)expression2.getClassReference(), this.myHolder, problem);
        }
    }

    public void visitMethod(@NotNull PsiMethod method) {
        PsiMethod[] methods2;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)method)) == null) {
            return;
        }
        super.visitMethod(method);
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        if (!this.problemsCache.containsWord(string)) {
            return;
        }
        if ((!method.isConstructor() ? AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)method), (String[])new String[]{"java.lang.Override"}) : null) == null) {
            return;
        }
        PsiMethod[] psiMethodArray = method.findSuperMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"method.findSuperMethods()");
        for (PsiMethod superMethod : methods2 = psiMethodArray) {
            if (this.exitOnNonCompiled((PsiElement)superMethod)) {
                return;
            }
            IncompatibleAPIInspection.Problem problem = IncompatibleAPIInspectionKt.findProblem((PsiElement)superMethod, this.problemsCache);
            if (problem == null) continue;
            IncompatibleAPIInspectionKt.registerProblemForElement((PsiElement)method.getNameIdentifier(), this.myHolder, problem);
            return;
        }
    }

    private final boolean exitOnNonCompiled(PsiElement psiElement2) {
        if (psiElement2 != null && !(psiElement2 instanceof PsiCompiledElement)) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isInternal()) {
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isUnitTestMode()) {
                    return true;
                }
            }
        }
        return false;
    }

    public IncompatibleAPIJavaVisitor(@NotNull ProblemsHolder myHolder, @NotNull ProblemsCache problemsCache) {
        Intrinsics.checkParameterIsNotNull((Object)myHolder, (String)"myHolder");
        Intrinsics.checkParameterIsNotNull((Object)problemsCache, (String)"problemsCache");
        this.myHolder = myHolder;
        this.problemsCache = problemsCache;
    }
}

