/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.SuspiciousCollectionReassignmentInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceWithOrdinaryAssignmentIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeToMutableCollectionFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\f\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "targetOperations", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ChangeTypeToMutableFix", "JoinWithInitializerFix", "ReplaceWithAssignmentFix", "ReplaceWithFilterFix", "idea"})
public final class SuspiciousCollectionReassignmentInspection
extends AbstractKotlinInspection {
    private final List<KtSingleValueToken> targetOperations = CollectionsKt.listOf((Object[])new KtSingleValueToken[]{KtTokens.PLUSEQ, KtTokens.MINUSEQ});

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.binaryExpressionVisitor((Function1<? super KtBinaryExpression, Unit>)((Function1)new Function1<KtBinaryExpression, Unit>(this, holder){
            final /* synthetic */ SuspiciousCollectionReassignmentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtBinaryExpression binaryExpression) {
                LocalQuickFix[] localQuickFixArray;
                void $this$toTypedArray$iv;
                String string;
                boolean $i$f$takeWhile22;
                String $this$takeWhile$iv;
                List fixes;
                block26: {
                    int n;
                    boolean bl;
                    boolean $i$f$any;
                    Annotated leftDefaultType;
                    KotlinType leftType;
                    BindingContext context2;
                    KtProperty property2;
                    KtSingleValueToken operationToken;
                    block25: {
                        Intrinsics.checkParameterIsNotNull((Object)binaryExpression, (String)"binaryExpression");
                        if (binaryExpression.getRight() == null) {
                            return;
                        }
                        IElementType iElementType = binaryExpression.getOperationToken();
                        if (!(iElementType instanceof KtSingleValueToken)) {
                            iElementType = null;
                        }
                        KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
                        if (ktSingleValueToken == null) {
                            return;
                        }
                        operationToken = ktSingleValueToken;
                        if (!SuspiciousCollectionReassignmentInspection.access$getTargetOperations$p(this.this$0).contains((Object)((Object)operationToken))) {
                            return;
                        }
                        KtExpression ktExpression = binaryExpression.getLeft();
                        if (ktExpression == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"binaryExpression.left ?: return");
                        KtExpression left2 = ktExpression;
                        KtReference ktReference = ReferenceUtilKt.getMainReference(left2);
                        Object object = ktReference != null ? ktReference.resolve() : null;
                        if (!(object instanceof KtProperty)) {
                            object = null;
                        }
                        KtProperty ktProperty = (KtProperty)object;
                        if (ktProperty == null) {
                            return;
                        }
                        property2 = ktProperty;
                        if (!property2.isVar()) {
                            return;
                        }
                        context2 = ResolutionUtils.analyze$default(binaryExpression, null, 1, null);
                        KotlinType kotlinType2 = CallUtilKt.getType(left2, context2);
                        if (kotlinType2 == null) {
                            return;
                        }
                        leftType = kotlinType2;
                        Annotated annotated = leftType.getConstructor().getDeclarationDescriptor();
                        if (annotated == null || (annotated = annotated.getDefaultType()) == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"leftType.constructor.dec\u2026or?.defaultType ?: return");
                        leftDefaultType = annotated;
                        if (!SuspiciousCollectionReassignmentInspectionKt.isReadOnlyCollectionOrMap(leftType, PlatformKt.getBuiltIns(binaryExpression))) {
                            return;
                        }
                        Iterable $this$any$iv = context2.getDiagnostics().forElement((PsiElement)binaryExpression);
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Diagnostic it = (Diagnostic)element$iv;
                                n = 0;
                                if (!(it.getSeverity() == Severity.ERROR)) continue;
                                bl = true;
                                break block25;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    $i$f$any = false;
                    fixes = new ArrayList<E>();
                    if (ChangeTypeToMutableFix.Companion.isApplicable(property2)) {
                        fixes.add(new ChangeTypeToMutableFix(leftType));
                    }
                    if (ReplaceWithFilterFix.Companion.isApplicable(binaryExpression, (SimpleType)leftDefaultType, context2)) {
                        fixes.add(new ReplaceWithFilterFix());
                    }
                    if (ReplaceWithAssignmentFix.Companion.isApplicable(binaryExpression, property2, context2)) {
                        fixes.add(new ReplaceWithAssignmentFix());
                    } else if (JoinWithInitializerFix.Companion.isApplicable(binaryExpression, property2)) {
                        fixes.add(new JoinWithInitializerFix(operationToken));
                    } else {
                        fixes.add(new IntentionWrapper((IntentionAction)new ReplaceWithOrdinaryAssignmentIntention(), (PsiFile)binaryExpression.getContainingKtFile()));
                    }
                    $this$takeWhile$iv = ((SimpleType)leftDefaultType).toString();
                    $i$f$takeWhile22 = false;
                    int it = 0;
                    n = $this$takeWhile$iv.length();
                    while (it < n) {
                        void index$iv;
                        char it2 = $this$takeWhile$iv.charAt((int)index$iv);
                        boolean bl2 = false;
                        if (!(it2 != '<')) {
                            String string2 = $this$takeWhile$iv;
                            int n2 = 0;
                            boolean bl3 = false;
                            String string3 = string2.substring(n2, (int)index$iv);
                            string = string3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            break block26;
                        }
                        ++index$iv;
                    }
                    string = $this$takeWhile$iv;
                }
                $this$takeWhile$iv = string;
                $i$f$takeWhile22 = false;
                String string4 = $this$takeWhile$iv;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                String typeText = string5;
                KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"binaryExpression.operationReference");
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                Collection $i$f$takeWhile22 = fixes;
                ProblemHighlightType problemHighlightType2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String string6 = '\'' + operationReference.getText() + "' create new " + typeText + " under the hood";
                PsiElement psiElement2 = (PsiElement)operationReference;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, string6, problemHighlightType2, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.this$0 = suspiciousCollectionReassignmentInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ List access$getTargetOperations$p(SuspiciousCollectionReassignmentInspection $this) {
        return $this.targetOperations;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ChangeTypeToMutableFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "idea"})
    private static final class ChangeTypeToMutableFix
    implements LocalQuickFix {
        private final KotlinType type;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getName() {
            return "Change type to mutable";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                    psiElement2 = null;
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
                if (ktOperationReferenceExpression == null) {
                    return;
                }
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                PsiElement psiElement3 = operationReference.getParent();
                if (!(psiElement3 instanceof KtBinaryExpression)) {
                    psiElement3 = null;
                }
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
                if (ktBinaryExpression == null) {
                    return;
                }
                KtBinaryExpression binaryExpression = ktBinaryExpression;
                KtExpression ktExpression = binaryExpression.getLeft();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"binaryExpression.left ?: return");
                KtExpression left2 = ktExpression;
                KtReference ktReference = ReferenceUtilKt.getMainReference(left2);
                Object object = ktReference != null ? ktReference.resolve() : null;
                if (!(object instanceof KtProperty)) {
                    object = null;
                }
                KtProperty ktProperty = (KtProperty)object;
                if (ktProperty == null) {
                    return;
                }
                KtProperty property2 = ktProperty;
                ChangeToMutableCollectionFix.Companion.applyFix(property2, this.type);
                property2.getValOrVarKeyword().replace(KtPsiFactoryKt.KtPsiFactory$default(property2, false, 2, null).createValKeyword());
                Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)binaryExpression);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block7;
                editor2.moveToOffset(PsiUtilsKt.getEndOffset(property2));
            }
        }

        public ChangeTypeToMutableFix(@NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.type = type2;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ChangeTypeToMutableFix$Companion;", "", "()V", "isApplicable", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "idea"})
        public static final class Companion {
            public final boolean isApplicable(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                return ChangeToMutableCollectionFix.Companion.isApplicable(property2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithFilterFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "idea"})
    private static final class ReplaceWithFilterFix
    implements LocalQuickFix {
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getName() {
            return "Replace with filter";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                psiElement2 = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            PsiElement psiElement3 = operationReference.getParent();
            if (!(psiElement3 instanceof KtBinaryExpression)) {
                psiElement3 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression binaryExpression = ktBinaryExpression;
            KtExpression ktExpression = binaryExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"binaryExpression.left ?: return");
            KtExpression left2 = ktExpression;
            KtExpression ktExpression2 = binaryExpression.getRight();
            if (ktExpression2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"binaryExpression.right ?: return");
            KtExpression right2 = ktExpression2;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)operationReference, false, 2, null);
            KtSingleValueToken ktSingleValueToken = KtTokens.EQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EQ");
            String string = ktSingleValueToken.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KtTokens.EQ.value");
            operationReference.replace((PsiElement)psiFactory.createOperationName(string));
            right2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0.filter { it !in $1 }", new Object[]{left2, right2}, false, 4, null));
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithFilterFix$Companion;", "", "()V", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "leftType", "Lorg/jetbrains/kotlin/types/SimpleType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea"})
        public static final class Companion {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull SimpleType leftType, @NotNull BindingContext context2) {
                Intrinsics.checkParameterIsNotNull((Object)binaryExpression, (String)"binaryExpression");
                Intrinsics.checkParameterIsNotNull((Object)leftType, (String)"leftType");
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                if (Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)((Object)KtTokens.MINUSEQ)) ^ true) {
                    return false;
                }
                ClassDescriptor classDescriptor2 = PlatformKt.getBuiltIns(binaryExpression).getMap();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"binaryExpression.builtIns.map");
                if (Intrinsics.areEqual((Object)leftType, (Object)classDescriptor2.getDefaultType())) {
                    return false;
                }
                KtExpression ktExpression = binaryExpression.getRight();
                Object object = ktExpression;
                if (ktExpression == null) return false;
                KotlinType kotlinType2 = CallUtilKt.getType((KtExpression)object, context2);
                object = kotlinType2;
                if (kotlinType2 == null) return false;
                ClassDescriptor classDescriptor3 = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)object);
                object = classDescriptor3;
                if (classDescriptor3 == null) return false;
                ClassDescriptor classDescriptor4 = PlatformKt.getBuiltIns(binaryExpression).getIterable();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"binaryExpression.builtIns.iterable");
                if (!DescriptorUtilsKt.isSubclassOf((ClassDescriptor)object, classDescriptor4)) return false;
                return true;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "idea"})
    private static final class ReplaceWithAssignmentFix
    implements LocalQuickFix {
        @NotNull
        private static final List<String> emptyCollectionFactoryMethods;
        public static final Companion Companion;

        @NotNull
        public String getName() {
            return "Replace with assignment (original is empty)";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                psiElement2 = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)operationReference, false, 2, null);
            KtSingleValueToken ktSingleValueToken = KtTokens.EQ;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"KtTokens.EQ");
            String string = ktSingleValueToken.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KtTokens.EQ.value");
            operationReference.replace((PsiElement)psiFactory.createOperationName(string));
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            Companion = new Companion(null);
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])new String[]{"emptyList", "emptySet", "emptyMap", "listOf", "setOf", "mapOf"});
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = "kotlin.collections." + (String)it;
                collection.add(string2);
            }
            emptyCollectionFactoryMethods = (List)var3_3;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix$Companion;", "", "()V", "emptyCollectionFactoryMethods", "", "", "getEmptyCollectionFactoryMethods", "()Ljava/util/List;", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea"})
        public static final class Companion {
            @NotNull
            public final List<String> getEmptyCollectionFactoryMethods() {
                return emptyCollectionFactoryMethods;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull KtProperty property2, @NotNull BindingContext context2) {
                boolean bl;
                block10: {
                    String fqName2;
                    Intrinsics.checkParameterIsNotNull((Object)binaryExpression, (String)"binaryExpression");
                    Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                    Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                    if (Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)((Object)KtTokens.PLUSEQ)) ^ true) {
                        return false;
                    }
                    if (!property2.isLocal()) {
                        return false;
                    }
                    KtExpression ktExpression = property2.getInitializer();
                    if (!(ktExpression instanceof KtCallExpression)) {
                        ktExpression = null;
                    }
                    KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
                    if (ktCallExpression == null) {
                        return false;
                    }
                    KtCallExpression initializer2 = ktCallExpression;
                    List<KtValueArgument> list2 = initializer2.getValueArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"initializer.valueArguments");
                    Collection collection = list2;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) {
                        return false;
                    }
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(initializer2, context2);
                    CallableDescriptor initializerResultingDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                    Object object = initializerResultingDescriptor;
                    String string = object != null && (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object)) != null ? ((FqName)object).asString() : (fqName2 = null);
                    if (!CollectionsKt.contains((Iterable)this.getEmptyCollectionFactoryMethods(), (Object)fqName2)) {
                        return false;
                    }
                    Object object2 = binaryExpression.getRight();
                    if (object2 == null || (object2 = CallUtilKt.getType((KtExpression)object2, context2)) == null || (object2 = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)object2)) == null) {
                        return false;
                    }
                    Object rightClassDescriptor = object2;
                    Annotated annotated = initializerResultingDescriptor;
                    if (annotated == null || (annotated = annotated.getReturnType()) == null || (annotated = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)annotated)) == null) {
                        return false;
                    }
                    Annotated initializerClassDescriptor = annotated;
                    if (!DescriptorUtilsKt.isSubclassOf((ClassDescriptor)rightClassDescriptor, (ClassDescriptor)initializerClassDescriptor)) {
                        return false;
                    }
                    Sequence $this$any$iv = SequencesKt.filter(PsiUtilsKt.siblings((PsiElement)binaryExpression, false, false), (Function1)((Function1)new Function1<PsiElement, Boolean>(property2){
                        final /* synthetic */ KtProperty $property;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)this.$property) ^ true;
                        }
                        {
                            this.$property = ktProperty;
                            super(1);
                        }
                    }));
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        void result$iv$iv$iv;
                        void $this$anyDescendantOfType$iv;
                        PsiElement sibling = (PsiElement)element$iv;
                        boolean bl3 = false;
                        PsiElement psiElement2 = sibling;
                        Function1 predicate$iv = (Function1)new Function1<KtSimpleNameExpression, Boolean>(property2){
                            final /* synthetic */ KtProperty $property$inlined;
                            {
                                this.$property$inlined = ktProperty;
                                super(1);
                            }

                            public final boolean invoke(@NotNull KtSimpleNameExpression it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)ReferenceUtilKt.getMainReference(it).resolve(), (Object)this.$property$inlined);
                            }
                        };
                        boolean $i$f$anyDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                        boolean $i$f$findDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = null;
                        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $captured_local_variable$0;
                                this.$result = $captured_local_variable$1;
                            }

                            public void visitElement(@NotNull PsiElement element3) {
                                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                if (element3 instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                    this.$result.element = element3;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element3;
                                boolean bl = false;
                                super.visitElement(element3);
                            }
                        });
                        boolean bl4 = (PsiElement)result$iv$iv$iv.element != null;
                        if (!bl4) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                return !bl;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "op", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "(Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "idea"})
    private static final class JoinWithInitializerFix
    implements LocalQuickFix {
        private final KtSingleValueToken op;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getName() {
            return "Join with initializer";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block13: {
                KtExpression ktExpression;
                void $this$replaced$iv;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                    psiElement2 = null;
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
                if (ktOperationReferenceExpression == null) {
                    return;
                }
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                PsiElement psiElement3 = operationReference.getParent();
                if (!(psiElement3 instanceof KtBinaryExpression)) {
                    psiElement3 = null;
                }
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
                if (ktBinaryExpression == null) {
                    return;
                }
                KtBinaryExpression binaryExpression = ktBinaryExpression;
                KtExpression ktExpression2 = binaryExpression.getLeft();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"binaryExpression.left ?: return");
                KtExpression left2 = ktExpression2;
                KtExpression ktExpression3 = binaryExpression.getRight();
                if (ktExpression3 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"binaryExpression.right ?: return");
                KtExpression right2 = ktExpression3;
                KtReference ktReference = ReferenceUtilKt.getMainReference(left2);
                Object object = ktReference != null ? ktReference.resolve() : null;
                if (!(object instanceof KtProperty)) {
                    object = null;
                }
                KtProperty ktProperty = (KtProperty)object;
                if (ktProperty == null) {
                    return;
                }
                KtProperty property2 = ktProperty;
                KtExpression ktExpression4 = property2.getInitializer();
                if (ktExpression4 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"property.initializer ?: return");
                KtExpression initializer2 = ktExpression4;
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)operationReference, false, 2, null);
                KtSingleValueToken newOp = Intrinsics.areEqual((Object)((Object)this.op), (Object)((Object)KtTokens.PLUSEQ)) ? KtTokens.PLUS : KtTokens.MINUS;
                PsiElement psiElement4 = (PsiElement)initializer2;
                Object[] objectArray = new Object[3];
                objectArray[0] = initializer2;
                KtSingleValueToken ktSingleValueToken = newOp;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"newOp");
                String string = ktSingleValueToken.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newOp.value");
                objectArray[1] = string;
                objectArray[2] = right2;
                PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 $1 $2", objectArray, false, 4, null);
                boolean $i$f$replaced = false;
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                PsiElement psiElement5 = result$iv;
                if (!(psiElement5 instanceof KtExpression)) {
                    psiElement5 = null;
                }
                if ((ktExpression = (KtExpression)psiElement5) == null) {
                    PsiElement psiElement6 = result$iv;
                    if (psiElement6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    ktExpression = ((KtParenthesizedExpression)psiElement6).getExpression();
                    if (ktExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                }
                KtExpression replaced2 = ktExpression;
                binaryExpression.delete();
                Editor editor2 = IntentionBasedInspectionKt.findExistingEditor(property2);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block13;
                editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)replaced2));
            }
        }

        public JoinWithInitializerFix(@NotNull KtSingleValueToken op) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)op), (String)"op");
            this.op = op;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix$Companion;", "", "()V", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "idea"})
        public static final class Companion {
            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)binaryExpression, (String)"binaryExpression");
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                if (!property2.isLocal() || property2.getInitializer() == null) {
                    return false;
                }
                return Intrinsics.areEqual((Object)PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)binaryExpression, false, 1, null), (Object)property2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

