/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRequireNotNullCallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "functionName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
final class RemoveRequireNotNullCallFix
implements LocalQuickFix {
    private final String functionName;

    @NotNull
    public String getName() {
        return "Remove '" + this.functionName + "' call";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression target;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        List<KtValueArgument> list2 = callExpression2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
        KtElement ktElement = (KtValueArgument)CollectionsKt.firstOrNull(list2);
        if (ktElement == null || (ktElement = ktElement.getArgumentExpression()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"callExpression.valueArgu\u2026entExpression() ?: return");
        KtElement argument2 = ktElement;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
        KtExpression ktExpression = target = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression2;
        if (BindingContextUtilsKt.isUsedAsExpression(callExpression2, ResolutionUtils.analyze(callExpression2, BodyResolveMode.PARTIAL))) {
            target.replace((PsiElement)argument2);
        } else {
            target.delete();
        }
    }

    public RemoveRequireNotNullCallFix(@NotNull String functionName2) {
        Intrinsics.checkParameterIsNotNull((Object)functionName2, (String)"functionName");
        this.functionName = functionName2;
    }
}

