/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix$applyFix$;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
public final class RemoveRedundantQualifierNameQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return "Remove redundant qualifier name";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        String $this$getLastParentOfTypeInRowWithSelf$iv;
        int $i$f$getLastParentOfTypeInRowWithSelf;
        IntRange intRange;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file2 = (KtFile)psiFile;
        PsiElement element3 = descriptor2.getPsiElement();
        if (element3 instanceof KtUserType) {
            intRange = new IntRange(PsiUtilsKt.getStartOffset(element3), PsiUtilsKt.getEndOffset(element3));
        } else if (element3 instanceof KtDotQualifiedExpression) {
            KtDotQualifiedExpression ktDotQualifiedExpression;
            KtElement ktElement;
            PsiElement psiElement3 = element3;
            int n = PsiUtilsKt.getStartOffset(element3);
            $i$f$getLastParentOfTypeInRowWithSelf = 0;
            Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getLastParentOfTypeInRowWithSelf$iv), (Function1)applyFix$$inlined$getLastParentOfTypeInRowWithSelf$1.INSTANCE));
            if (!(object instanceof KtDotQualifiedExpression)) {
                object = null;
            }
            if ((ktElement = (ktDotQualifiedExpression = (KtDotQualifiedExpression)object)) == null || (ktElement = KtPsiUtilKt.getQualifiedElementSelector(ktElement)) == null) {
                return;
            }
            int n2 = PsiUtilsKt.getEndOffset((PsiElement)ktElement);
            int n3 = n;
            intRange = new IntRange(n3, n2);
        } else {
            intRange = IntRange.Companion.getEMPTY();
        }
        IntRange range = intRange;
        String string = file2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        $this$getLastParentOfTypeInRowWithSelf$iv = string;
        $i$f$getLastParentOfTypeInRowWithSelf = range.getStart();
        int n = range.getEndInclusive();
        boolean bl = false;
        String string2 = $this$getLastParentOfTypeInRowWithSelf$iv;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring($i$f$getLastParentOfTypeInRowWithSelf, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substring = string3;
        Regex regex = Regex.Companion.fromLiteral(substring);
        String string4 = file2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"file.text");
        KtImportList ktImportList = file2.getImportList();
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)regex.findAll((CharSequence)string4, ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)ktImportList) : 0)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl2 = false;
            ShortenReferences.DEFAULT.process(file2, it.getRange().getStart(), it.getRange().getEndInclusive() + 1);
        }
    }
}

