/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.LiftReturnOrAssignmentInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "LiftAssignmentOutFix", "LiftReturnOutFix", "idea"})
public final class LiftReturnOrAssignmentInspection
extends AbstractKotlinInspection {
    private static final int LINES_LIMIT = 15;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ LiftReturnOrAssignmentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            /*
             * WARNING - void declaration
             */
            private final void visitIfOrWhenOrTry(KtExpression expression2, PsiElement keyword) {
                int assignmentNumber;
                List<KtReturnExpression> foldableReturns;
                if (IfThenUtilsKt.lineCount(expression2) > 15) {
                    return;
                }
                if (IfThenUtilsKt.isElseIf(expression2)) {
                    return;
                }
                List<KtReturnExpression> list2 = foldableReturns = BranchedFoldingUtils.INSTANCE.getFoldableReturns$idea(expression2);
                if (list2 != null) {
                    Collection collection = list2;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        void result$iv$iv$iv;
                        void $this$anyDescendantOfType$iv;
                        PsiElement psiElement2 = (PsiElement)expression2;
                        Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(foldableReturns){
                            final /* synthetic */ List $foldableReturns;

                            public final boolean invoke(@NotNull KtReturnExpression it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return !this.$foldableReturns.contains(it);
                            }
                            {
                                this.$foldableReturns = list2;
                                super(1);
                            }
                        };
                        boolean $i$f$anyDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                        boolean $i$f$findDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = null;
                        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $captured_local_variable$0;
                                this.$result = $captured_local_variable$1;
                            }

                            public void visitElement(@NotNull PsiElement element3) {
                                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                if (element3 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                    this.$result.element = element3;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element3;
                                boolean bl = false;
                                super.visitElement(element3);
                            }
                        });
                        boolean hasOtherReturns2 = (PsiElement)result$iv$iv$iv.element != null;
                        boolean isSerious = !hasOtherReturns2 && foldableReturns.size() > 1;
                        String string = keyword.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyword.text");
                        buildVisitor.1.registerProblem$default(this, expression2, keyword, isSerious, new LiftReturnOutFix(string), null, null, 48, null);
                        Iterable $this$forEach$iv = foldableReturns;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            KtReturnExpression it = (KtReturnExpression)element$iv;
                            boolean bl2 = false;
                            String string2 = keyword.getText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"keyword.text");
                            this.registerProblem(expression2, keyword, isSerious, new LiftReturnOutFix(string2), (PsiElement)it, ProblemHighlightType.INFORMATION);
                        }
                        return;
                    }
                }
                if ((assignmentNumber = BranchedFoldingUtils.INSTANCE.getFoldableAssignmentNumber$idea(expression2)) > 0) {
                    boolean isSerious = assignmentNumber > 1;
                    String string = keyword.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyword.text");
                    buildVisitor.1.registerProblem$default(this, expression2, keyword, isSerious, new LiftAssignmentOutFix(string), null, null, 48, null);
                }
            }

            private final void registerProblem(KtExpression expression2, PsiElement keyword, boolean isSerious, LocalQuickFix fix, PsiElement highlightElement, ProblemHighlightType highlightType) {
                String subject = fix instanceof LiftReturnOutFix ? "Return" : "Assignment";
                String verb = isSerious ? "should" : "can";
                TextRange textRange = highlightElement.getTextRange();
                this.this$0.registerProblemWithoutOfflineInformation(this.$holder, (PsiElement)expression2, subject + ' ' + verb + " be lifted out of '" + keyword.getText() + '\'', this.$isOnTheFly, highlightType, textRange != null ? textRange.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)expression2)) : null, fix);
            }

            static /* synthetic */ void registerProblem$default(buildVisitor.1 var0, KtExpression ktExpression, PsiElement psiElement2, boolean bl, LocalQuickFix localQuickFix, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    psiElement3 = psiElement2;
                }
                if ((n & 0x20) != 0) {
                    problemHighlightType2 = bl ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                }
                var0.registerProblem(ktExpression, psiElement2, bl, localQuickFix, psiElement3, problemHighlightType2);
            }

            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                KtExpression ktExpression = expression2;
                PsiElement psiElement2 = expression2.getIfKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.ifKeyword");
                this.visitIfOrWhenOrTry(ktExpression, psiElement2);
            }

            public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitWhenExpression(expression2);
                KtExpression ktExpression = expression2;
                PsiElement psiElement2 = expression2.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.whenKeyword");
                this.visitIfOrWhenOrTry(ktExpression, psiElement2);
            }

            public void visitTryExpression(@NotNull KtTryExpression expression2) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    super.visitTryExpression(expression2);
                    PsiElement psiElement2 = expression2.getTryKeyword();
                    if (psiElement2 == null) break block0;
                    PsiElement psiElement3 = psiElement2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement3;
                    boolean bl3 = false;
                    KtExpression ktExpression = expression2;
                    PsiElement psiElement4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
                    this.visitIfOrWhenOrTry(ktExpression, psiElement4);
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
                this.$isOnTheFly = $captured_local_variable$2;
            }
        };
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftReturnOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class LiftReturnOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return "Lift return out of '" + this.keyword + '\'';
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                KtExpression replaced2 = BranchedFoldingUtils.INSTANCE.foldToReturn((KtExpression)psiElement2);
                Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)replaced2);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block1;
                editor2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)replaced2));
            }
        }

        public LiftReturnOutFix(@NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftAssignmentOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class LiftAssignmentOutFix
    implements LocalQuickFix {
        private final String keyword;

        @NotNull
        public String getName() {
            return "Lift assignment out of '" + this.keyword + '\'';
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            BranchedFoldingUtils.INSTANCE.foldToAssignment((KtExpression)psiElement2);
        }

        public LiftAssignmentOutFix(@NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Companion;", "", "()V", "LINES_LIMIT", "", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

