/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeActionKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.DeleteEqualsAndHashCodeFix;
import org.jetbrains.kotlin.idea.inspections.EqualsOrHashCodeInspection$WhenMappings;
import org.jetbrains.kotlin.idea.inspections.GenerateEqualsOrHashCodeFix;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/EqualsOrHashCodeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class EqualsOrHashCodeInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.classOrObjectVisitor((Function1<? super KtClassOrObject, Unit>)((Function1)new Function1<KtClassOrObject, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtClassOrObject classOrObject) {
                boolean hasHashCode;
                Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                PsiElement psiElement2 = classOrObject.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"classOrObject.nameIdentifier ?: return");
                PsiElement nameIdentifier = psiElement2;
                ClassDescriptor classDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(classOrObject, null, 1, null);
                if (classDescriptor2 == null) {
                    return;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2;
                boolean hasEquals = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredEquals(classDescriptor3, false) != null;
                boolean bl = hasHashCode = KotlinGenerateEqualsAndHashcodeActionKt.findDeclaredHashCode(classDescriptor3, false) != null;
                if (!hasEquals && !hasHashCode) {
                    return;
                }
                switch (EqualsOrHashCodeInspection$WhenMappings.$EnumSwitchMapping$0[classDescriptor3.getKind().ordinal()]) {
                    case 1: {
                        Collection collection = classOrObject.getSuperTypeListEntries();
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            return;
                        }
                        this.$holder.registerProblem(nameIdentifier, "equals()/hashCode() in object declaration", new LocalQuickFix[]{DeleteEqualsAndHashCodeFix.INSTANCE});
                        break;
                    }
                    case 2: {
                        if (hasEquals && hasHashCode) {
                            return;
                        }
                        String description2 = InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{hasEquals ? "<code>equals()</code>" : "<code>hashCode()</code>", hasEquals ? "<code>hashCode()</code>" : "<code>equals()</code>"});
                        this.$holder.registerProblem(nameIdentifier, description2, new LocalQuickFix[]{hasEquals ? (GenerateEqualsOrHashCodeFix)GenerateEqualsOrHashCodeFix.HashCode.INSTANCE : (GenerateEqualsOrHashCodeFix)GenerateEqualsOrHashCodeFix.Equals.INSTANCE});
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

