/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportWrapper;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingUtil;", "", "()V", "shouldHighlight", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "shouldHighlightErrors", "shouldHighlightScript", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-core"})
public final class KotlinHighlightingUtil {
    public static final KotlinHighlightingUtil INSTANCE;

    public final boolean shouldHighlight(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile2 = (KtFile)psiFile;
        if (ktFile2 == null) {
            return false;
        }
        KtFile ktFile3 = ktFile2;
        if (ktFile3 instanceof KtCodeFragment && ((KtCodeFragment)ktFile3).getContext() != null) {
            return true;
        }
        VirtualFile virtualFile2 = ktFile3.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile.virtualFile");
        if (OutsidersPsiFileSupportWrapper.INSTANCE.isOutsiderFile(virtualFile2)) {
            Project project = ktFile3.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ktFile.project");
            VirtualFile virtualFile3 = ktFile3.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"ktFile.virtualFile");
            VirtualFile virtualFile4 = OutsidersPsiFileSupportUtils.INSTANCE.getOutsiderFileOrigin(project, virtualFile3);
            if (virtualFile4 == null) {
                return false;
            }
            VirtualFile origin = virtualFile4;
            PsiFile psiFile2 = PsiManager.getInstance((Project)ktFile3.getProject()).findFile(origin);
            if (psiFile2 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"PsiManager.getInstance(k\u2026e(origin) ?: return false");
            PsiFile psiFileOrigin = psiFile2;
            return this.shouldHighlight((PsiElement)psiFileOrigin);
        }
        if (ktFile3.isScript()) {
            return this.shouldHighlightScript(ktFile3);
        }
        return ProjectRootsUtil.isInProjectOrLibraryContent((PsiElement)ktFile3) && !(GetModuleInfoKt.getModuleInfo((PsiElement)ktFile3) instanceof NotUnderContentRootModuleInfo);
    }

    public final boolean shouldHighlightErrors(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile2 = (KtFile)psiFile;
        if (ktFile2 == null) {
            return false;
        }
        KtFile ktFile3 = ktFile2;
        if (ktFile3.isCompiled()) {
            return false;
        }
        if (ktFile3 instanceof KtCodeFragment && ((KtCodeFragment)ktFile3).getContext() != null) {
            return true;
        }
        if (ktFile3.isScript()) {
            return this.shouldHighlightScript(ktFile3);
        }
        return ProjectRootsUtil.isInProjectSource$default((PsiElement)ktFile3, false, 2, null);
    }

    private final boolean shouldHighlightScript(KtFile ktFile2) {
        if (CidrUtil.isRunningInCidrIde()) {
            return false;
        }
        if (!ScriptDependenciesUpdater.Companion.areDependenciesCached(ktFile2)) {
            return false;
        }
        List list2 = (List)ktFile2.getVirtualFile().getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        if (list2 != null) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScriptReport it = (ScriptReport)element$iv;
                        boolean bl2 = false;
                        if (!(it.getSeverity() == ScriptReport.Severity.FATAL)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        Project project = ktFile2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ktFile.project");
        if (!ScriptDefinitionsManager.Companion.getInstance(project).isReady()) {
            return false;
        }
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile2, true);
    }

    private KotlinHighlightingUtil() {
    }

    static {
        KotlinHighlightingUtil kotlinHighlightingUtil;
        INSTANCE = kotlinHighlightingUtil = new KotlinHighlightingUtil();
    }
}

