/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.xml.util.XmlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;

public class ChooseModulePanel {
    private JPanel contentPane;
    private JRadioButton allModulesWithKtRadioButton;
    private JRadioButton singleModuleRadioButton;
    private JComboBox singleModuleComboBox;
    private HyperlinkLabel allModulesWithKtNames;
    private JRadioButton allModulesRadioButton;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> modules;
    @NotNull
    private final List<Module> modulesWithKtFiles;

    public ChooseModulePanel(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator, Collection<Module> excludeModules) {
        if (project == null) {
            ChooseModulePanel.$$$reportNull$$$0(0);
        }
        if (configurator == null) {
            ChooseModulePanel.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.$$$setupUI$$$();
        this.modules = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(project, configurator);
        this.modulesWithKtFiles = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModulesWithKotlinFiles(project, configurator);
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
        for (Module module : this.modules) {
            comboBoxModel.addElement(module.getName());
        }
        if (this.modulesWithKtFiles.isEmpty()) {
            this.allModulesWithKtRadioButton.setVisible(false);
            this.allModulesWithKtNames.setVisible(false);
        }
        this.singleModuleComboBox.setModel(comboBoxModel);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModulePanel.this.updateComponents();
            }
        };
        this.singleModuleRadioButton.addActionListener(listener2);
        this.allModulesWithKtRadioButton.addActionListener(listener2);
        this.allModulesRadioButton.addActionListener(listener2);
        if (this.modulesWithKtFiles.size() > 2) {
            this.allModulesWithKtNames.setHtmlText("<html>" + XmlUtil.escape((String)this.modulesWithKtFiles.get(0).getName()) + ", " + XmlUtil.escape((String)this.modulesWithKtFiles.get(1).getName()) + " and <a href=\"#\">" + (this.modulesWithKtFiles.size() - 2) + " other modules</a>");
            this.allModulesWithKtNames.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Module>("Modules with Kotlin Files", ChooseModulePanel.this.modulesWithKtFiles){

                        @NotNull
                        public String getTextFor(Module value2) {
                            String string = value2.getName();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel$2$1", "getTextFor"));
                        }
                    }).showUnderneathOf((Component)ChooseModulePanel.this.allModulesWithKtNames);
                }
            });
        } else {
            this.allModulesWithKtNames.setText(StringUtil.join(this.modulesWithKtFiles, (Function)new Function<Module, String>(){

                public String fun(Module module) {
                    return module.getName();
                }
            }, (String)", "));
        }
        ButtonGroup modulesGroup = new ButtonGroup();
        modulesGroup.add(this.allModulesRadioButton);
        modulesGroup.add(this.allModulesWithKtRadioButton);
        modulesGroup.add(this.singleModuleRadioButton);
        if (this.allModulesWithKtRadioButton.isVisible()) {
            this.allModulesWithKtRadioButton.setSelected(true);
        } else {
            this.allModulesRadioButton.setSelected(true);
        }
        this.updateComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    private void updateComponents() {
        this.singleModuleComboBox.setEnabled(this.singleModuleRadioButton.isSelected());
    }

    public List<Module> getModulesToConfigure() {
        if (this.allModulesRadioButton.isSelected()) {
            return this.modules;
        }
        if (this.allModulesWithKtRadioButton.isSelected()) {
            return this.modulesWithKtFiles;
        }
        String selectedItem = (String)this.singleModuleComboBox.getSelectedItem();
        if (selectedItem == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ModuleManager.getInstance((Project)this.project).findModuleByName(selectedItem));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configurator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        HyperlinkLabel hyperlinkLabel;
        JComboBox jComboBox;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.singleModuleRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Single module:");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.singleModuleComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.allModulesWithKtNames = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setEnabled(true);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(-1, 100)));
        this.allModulesWithKtRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("All modules containing Kotlin files: ");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.allModulesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("All modules");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

