/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "", "()V", "getIndent", "Lcom/intellij/formatting/Indent;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Companion", "ConstIndentStrategy", "PositionStrategy", "formatter"})
public abstract class NodeIndentStrategy {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract Indent getIndent(@NotNull ASTNode var1, @NotNull CodeStyleSettings var2);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$ConstIndentStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/formatting/Indent;)V", "getIndent", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "formatter"})
    public static final class ConstIndentStrategy
    extends NodeIndentStrategy {
        private final Indent indent;

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node, @NotNull CodeStyleSettings settings2) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
            return this.indent;
        }

        public ConstIndentStrategy(@NotNull Indent indent2) {
            Intrinsics.checkParameterIsNotNull((Object)indent2, (String)"indent");
            this.indent = indent2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0000J\u001a\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ'\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00072\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\rH\u0016J'\u0010#\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00072\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001fJ'\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010'\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u000eJ\b\u0010)\u001a\u00020\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ'\u0010\u0011\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0019\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "debugInfo", "", "(Ljava/lang/String;)V", "forElement", "Ljava/util/ArrayList;", "Lcom/intellij/psi/tree/IElementType;", "forElementCallback", "Lkotlin/Function1;", "Lcom/intellij/lang/ASTNode;", "", "indentCallback", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "Lcom/intellij/formatting/Indent;", "notForElement", "notIn", "within", "withinCallback", "fillTypes", "", "resultCollection", "", "singleType", "otherTypes", "", "(Ljava/util/List;Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)V", "forAny", "callback", "forType", "elementType", "(Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/psi/tree/IElementType;)Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "getIndent", "node", "settings", "notForType", "notWithin", "parentType", "orParentTypes", "set", "indent", "toString", "parents", "Lcom/intellij/psi/tree/TokenSet;", "withinAny", "formatter"})
    public static final class PositionStrategy
    extends NodeIndentStrategy {
        private Function1<? super CodeStyleSettings, ? extends Indent> indentCallback;
        private final ArrayList<IElementType> within;
        private Function1<? super ASTNode, Boolean> withinCallback;
        private final ArrayList<IElementType> notIn;
        private final ArrayList<IElementType> forElement;
        private final ArrayList<IElementType> notForElement;
        private Function1<? super ASTNode, Boolean> forElementCallback;
        private final String debugInfo;

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("PositionStrategy ");
            String string = this.debugInfo;
            if (string == null) {
                string = "No debug info";
            }
            return stringBuilder.append((Object)string).toString();
        }

        @NotNull
        public final PositionStrategy set(@NotNull Indent indent2) {
            Intrinsics.checkParameterIsNotNull((Object)indent2, (String)"indent");
            this.indentCallback = (Function1)new Function1<CodeStyleSettings, Indent>(indent2){
                final /* synthetic */ Indent $indent;

                @NotNull
                public final Indent invoke(@NotNull CodeStyleSettings it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$indent;
                }
                {
                    this.$indent = indent2;
                    super(1);
                }
            };
            return this;
        }

        @NotNull
        public final PositionStrategy set(@NotNull Function1<? super CodeStyleSettings, ? extends Indent> indentCallback2) {
            Intrinsics.checkParameterIsNotNull(indentCallback2, (String)"indentCallback");
            this.indentCallback = indentCallback2;
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull TokenSet parents2) {
            IElementType[] types;
            Intrinsics.checkParameterIsNotNull((Object)parents2, (String)"parents");
            IElementType[] iElementTypeArray = parents2.getTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"parents.types");
            IElementType[] iElementTypeArray2 = types = iElementTypeArray;
            boolean bl = false;
            if (iElementTypeArray2.length == 0) {
                throw (Throwable)new IllegalArgumentException("Empty token set is unexpected");
            }
            List list2 = this.within;
            IElementType iElementType = types[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"types[0]");
            IElementType[] iElementTypeArray3 = Arrays.copyOfRange(types, 1, types.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray3, (String)"Arrays.copyOfRange(types, 1, types.size)");
            this.fillTypes(list2, iElementType, iElementTypeArray3);
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)parentType, (String)"parentType");
            Intrinsics.checkParameterIsNotNull((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.within, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy within(@NotNull Function1<? super ASTNode, Boolean> callback2) {
            Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
            this.withinCallback = callback2;
            return this;
        }

        @NotNull
        public final PositionStrategy notWithin(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)parentType, (String)"parentType");
            Intrinsics.checkParameterIsNotNull((Object)orParentTypes, (String)"orParentTypes");
            this.fillTypes((List<IElementType>)this.notIn, parentType, orParentTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy withinAny() {
            this.within.clear();
            this.notIn.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.forElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy notForType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)otherTypes, (String)"otherTypes");
            this.fillTypes((List<IElementType>)this.notForElement, elementType, otherTypes);
            return this;
        }

        @NotNull
        public final PositionStrategy forAny() {
            this.forElement.clear();
            this.notForElement.clear();
            return this;
        }

        @NotNull
        public final PositionStrategy forElement(@NotNull Function1<? super ASTNode, Boolean> callback2) {
            Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
            this.forElementCallback = callback2;
            return this;
        }

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node, @NotNull CodeStyleSettings settings2) {
            ASTNode parent2;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
            if (!this.forElement.isEmpty() && !this.forElement.contains(node.getElementType())) {
                return null;
            }
            if (this.notForElement.contains(node.getElementType())) {
                return null;
            }
            Function1<? super ASTNode, Boolean> function1 = this.forElementCallback;
            if (function1 != null) {
                if (!((Boolean)function1.invoke((Object)node)).booleanValue()) {
                    return null;
                }
            }
            if ((parent2 = node.getTreeParent()) != null) {
                if (!this.within.isEmpty() && !this.within.contains(parent2.getElementType())) {
                    return null;
                }
                if (this.notIn.contains(parent2.getElementType())) {
                    return null;
                }
                Function1<? super ASTNode, Boolean> function12 = this.withinCallback;
                if (function12 != null) {
                    if (!((Boolean)function12.invoke((Object)parent2)).booleanValue()) {
                        return null;
                    }
                }
            } else if (!this.within.isEmpty()) {
                return null;
            }
            return (Indent)this.indentCallback.invoke((Object)settings2);
        }

        private final void fillTypes(List<IElementType> resultCollection, IElementType singleType, IElementType[] otherTypes) {
            resultCollection.clear();
            resultCollection.add(singleType);
            Collections.addAll((Collection)resultCollection, Arrays.copyOf(otherTypes, otherTypes.length));
        }

        public PositionStrategy(@Nullable String debugInfo2) {
            this.debugInfo = debugInfo2;
            this.indentCallback = indentCallback.1.INSTANCE;
            this.within = new ArrayList();
            this.notIn = new ArrayList();
            this.forElement = new ArrayList();
            this.notForElement = new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$Companion;", "", "()V", "constIndent", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "indent", "Lcom/intellij/formatting/Indent;", "strategy", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "debugInfo", "", "formatter"})
    public static final class Companion {
        @NotNull
        public final NodeIndentStrategy constIndent(@NotNull Indent indent2) {
            Intrinsics.checkParameterIsNotNull((Object)indent2, (String)"indent");
            return new ConstIndentStrategy(indent2);
        }

        @NotNull
        public final PositionStrategy strategy(@Nullable String debugInfo2) {
            return new PositionStrategy(debugInfo2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

