/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtil;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingRulesKt;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a7\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u001b\u0010\u0017\u001a\u0017\u0012\b\u0012\u00060\u0019R\u00020\u0013\u0012\u0004\u0012\u00020\u00120\u0018\u00a2\u0006\u0002\b\u001a\u001a7\u0010\u001b\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u001b\u0010\u0017\u001a\u0017\u0012\b\u0012\u00060\u0019R\u00020\u0013\u0012\u0004\u0012\u00020\u00120\u0018\u00a2\u0006\u0002\b\u001a\u001a\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u0013*\u00060\u0019R\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u001f"}, d2={"EXTEND_COLON_ELEMENTS", "Lcom/intellij/psi/tree/TokenSet;", "getEXTEND_COLON_ELEMENTS", "()Lcom/intellij/psi/tree/TokenSet;", "MODIFIERS_LIST_ENTRIES", "getMODIFIERS_LIST_ENTRIES", "createSpacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "builderUtil", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilderUtil;", "excludeLambdasAndObjects", "", "Lcom/intellij/openapi/util/TextRange;", "parent", "Lcom/intellij/formatting/ASTBlock;", "afterInside", "", "Lcom/intellij/formatting/SpacingBuilder;", "element", "Lcom/intellij/psi/tree/IElementType;", "tokenSet", "spacingFun", "Lkotlin/Function1;", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "Lkotlin/ExtensionFunctionType;", "beforeInside", "spacesNoLineBreak", "spaces", "", "formatter"})
public final class KotlinSpacingRulesKt {
    @NotNull
    private static final TokenSet MODIFIERS_LIST_ENTRIES;
    @NotNull
    private static final TokenSet EXTEND_COLON_ELEMENTS;

    @NotNull
    public static final TokenSet getMODIFIERS_LIST_ENTRIES() {
        return MODIFIERS_LIST_ENTRIES;
    }

    @NotNull
    public static final TokenSet getEXTEND_COLON_ELEMENTS() {
        return EXTEND_COLON_ELEMENTS;
    }

    public static final void beforeInside(@NotNull SpacingBuilder $this$beforeInside, @NotNull IElementType element3, @NotNull TokenSet tokenSet, @NotNull Function1<? super SpacingBuilder.RuleBuilder, Unit> spacingFun) {
        Intrinsics.checkParameterIsNotNull((Object)$this$beforeInside, (String)"$this$beforeInside");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)tokenSet, (String)"tokenSet");
        Intrinsics.checkParameterIsNotNull(spacingFun, (String)"spacingFun");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"tokenSet.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int j = 0; j < n; ++j) {
            IElementType element$iv;
            IElementType inType = element$iv = iElementTypeArray2[j];
            boolean bl = false;
            SpacingBuilder.RuleBuilder ruleBuilder = $this$beforeInside.beforeInside(element3, inType);
            Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder, (String)"beforeInside(element, inType)");
            spacingFun.invoke((Object)ruleBuilder);
        }
    }

    public static final void afterInside(@NotNull SpacingBuilder $this$afterInside, @NotNull IElementType element3, @NotNull TokenSet tokenSet, @NotNull Function1<? super SpacingBuilder.RuleBuilder, Unit> spacingFun) {
        Intrinsics.checkParameterIsNotNull((Object)$this$afterInside, (String)"$this$afterInside");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)tokenSet, (String)"tokenSet");
        Intrinsics.checkParameterIsNotNull(spacingFun, (String)"spacingFun");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"tokenSet.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int j = 0; j < n; ++j) {
            IElementType element$iv;
            IElementType inType = element$iv = iElementTypeArray2[j];
            boolean bl = false;
            SpacingBuilder.RuleBuilder ruleBuilder = $this$afterInside.afterInside(element3, inType);
            Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder, (String)"afterInside(element, inType)");
            spacingFun.invoke((Object)ruleBuilder);
        }
    }

    @Nullable
    public static final SpacingBuilder spacesNoLineBreak(@NotNull SpacingBuilder.RuleBuilder $this$spacesNoLineBreak, int spaces) {
        Intrinsics.checkParameterIsNotNull((Object)$this$spacesNoLineBreak, (String)"$this$spacesNoLineBreak");
        return $this$spacesNoLineBreak.spacing(spaces, spaces, 0, false, 0);
    }

    @NotNull
    public static final KotlinSpacingBuilder createSpacingBuilder(@NotNull CodeStyleSettings settings2, @NotNull KotlinSpacingBuilderUtil builderUtil) {
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)builderUtil, (String)"builderUtil");
        KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(settings2);
        KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2);
        return KotlinSpacingBuilderKt.rules(kotlinCommonSettings, builderUtil, (Function1<? super KotlinSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder, Unit>(kotlinCommonSettings, settings2, builderUtil, kotlinCustomSettings){
            final /* synthetic */ KotlinCommonCodeStyleSettings $kotlinCommonSettings;
            final /* synthetic */ CodeStyleSettings $settings;
            final /* synthetic */ KotlinSpacingBuilderUtil $builderUtil;
            final /* synthetic */ KotlinCodeStyleSettings $kotlinCustomSettings;

            public final void invoke(@NotNull KotlinSpacingBuilder $this$rules) {
                Intrinsics.checkParameterIsNotNull((Object)$this$rules, (String)"$receiver");
                TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.SECONDARY_CONSTRUCTOR, KtNodeTypes.CLASS_INITIALIZER});
                Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(PROPERTY\u2026UCTOR, CLASS_INITIALIZER)");
                TokenSet DECLARATIONS = tokenSet;
                $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)createSpacingBuilder.1.INSTANCE));
                $this$rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder.CustomSpacingBuilder, Unit>(this, $this$rules, DECLARATIONS){
                    final /* synthetic */ createSpacingBuilder.1 this$0;
                    final /* synthetic */ KotlinSpacingBuilder $this_rules;
                    final /* synthetic */ TokenSet $DECLARATIONS;

                    public final void invoke(@NotNull KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$custom, (String)"$receiver");
                        Function1<Integer, Spacing> $fun$commentSpacing$1 = new Function1<Integer, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @NotNull
                            public final Spacing invoke(int minSpaces) {
                                if (this.this$0.this$0.$kotlinCommonSettings.KEEP_FIRST_COLUMN_COMMENT) {
                                    Spacing spacing2 = Spacing.createKeepingFirstColumnSpacing((int)minSpaces, (int)Integer.MAX_VALUE, (boolean)this.this$0.this$0.$settings.KEEP_LINE_BREAKS, (int)this.this$0.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)spacing2, (String)"Spacing.createKeepingFir\u2026ODE\n                    )");
                                    return spacing2;
                                }
                                Spacing spacing3 = Spacing.createSpacing((int)minSpaces, (int)Integer.MAX_VALUE, (int)0, (boolean)this.this$0.this$0.$settings.KEEP_LINE_BREAKS, (int)this.this$0.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                                Intrinsics.checkExpressionValueIsNotNull((Object)spacing3, (String)"Spacing.createSpacing(\n \u2026IN_CODE\n                )");
                                return spacing3;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        };
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtTokens.EOL_COMMENT, KtTokens.EOL_COMMENT, null, null, null, 56, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                ASTNode nodeBeforeRight = FormatterUtilKt.requireNode(right2).getTreePrev();
                                return nodeBeforeRight instanceof PsiWhiteSpace && !nodeBeforeRight.textContains('\n') ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 1, false, 0, 26, null) : null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtTokens.BLOCK_COMMENT, null, null, null, 59, null).spacing($fun$commentSpacing$1.invoke(0));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtTokens.EOL_COMMENT, null, null, null, 59, null).spacing($fun$commentSpacing$1.invoke(1));
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CLASS, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.OBJECT_DECLARATION, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.FUN, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.PROPERTY, KtNodeTypes.FUN, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.PROPERTY, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.SECONDARY_CONSTRUCTOR, KtNodeTypes.SECONDARY_CONSTRUCTOR, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.TYPEALIAS, KtNodeTypes.TYPEALIAS, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.emptyLinesIfLineBreakInLeft$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.FUN, KtNodeTypes.CLASS, null, null, null, 57, null), 1, 0, 0, 6, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.ENUM_ENTRY, null, null, null, 57, null).emptyLinesIfLineBreakInLeft(0, 0, 1);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, KtTokens.SEMICOLON, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                ASTNode aSTNode = FormatterUtilKt.requireNode(parent2).getTreeParent();
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"parent.requireNode().treeParent");
                                PsiElement psiElement2 = aSTNode.getPsi();
                                if (!(psiElement2 instanceof KtClass)) {
                                    psiElement2 = null;
                                }
                                KtClass ktClass2 = (KtClass)psiElement2;
                                if (ktClass2 == null) {
                                    return null;
                                }
                                KtClass klass2 = ktClass2;
                                return klass2.isEnum() && this.this$0.$DECLARATIONS.contains(FormatterUtilKt.requireNode(right2).getElementType()) ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 2, false, this.this$0.this$0.$settings.KEEP_BLANK_LINES_IN_DECLARATIONS, 10, null) : null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock left2, @NotNull ASTBlock right2) {
                                Spacing spacing2;
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                if (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right2).getElementType(), (Object)((Object)KtTokens.RBRACE))) {
                                    return KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 0, false, 0, 30, null);
                                }
                                PsiElement psiElement2 = FormatterUtilKt.requireNode(parent2).getPsi();
                                if (psiElement2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassBody");
                                }
                                KtClassBody classBody = (KtClassBody)psiElement2;
                                PsiElement psiElement3 = classBody.getParent();
                                if (!(psiElement3 instanceof KtClassOrObject)) {
                                    psiElement3 = null;
                                }
                                KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement3;
                                if (ktClassOrObject == null) {
                                    return null;
                                }
                                KtClassOrObject parentPsi = ktClassOrObject;
                                if (this.this$0.this$0.$kotlinCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER == 0 || KtPsiUtilKt.isObjectLiteral(parentPsi)) {
                                    spacing2 = null;
                                } else {
                                    int minLineFeeds = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right2).getElementType(), (Object)KtNodeTypes.FUN) || Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(right2).getElementType(), (Object)KtNodeTypes.PROPERTY) ? 1 : 0;
                                    KotlinSpacingBuilderUtil kotlinSpacingBuilderUtil = this.this$0.this$0.$builderUtil;
                                    boolean bl = this.this$0.this$0.$settings.KEEP_LINE_BREAKS;
                                    int n = this.this$0.this$0.$settings.KEEP_BLANK_LINES_IN_DECLARATIONS;
                                    TextRange textRange = parentPsi.getTextRange();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"parentPsi.textRange");
                                    int n2 = textRange.getStartOffset();
                                    PsiElement psiElement4 = FormatterUtilKt.requireNode(left2).getPsi();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"left.requireNode().psi");
                                    TextRange textRange2 = psiElement4.getTextRange();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"left.requireNode().psi.textRange");
                                    TextRange textRange3 = new TextRange(n2, textRange2.getStartOffset());
                                    DependentSpacingRule dependentSpacingRule = new DependentSpacingRule(DependentSpacingRule.Trigger.HAS_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, this.this$0.this$0.$kotlinCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER + 1);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dependentSpacingRule, (String)"DependentSpacingRule(Dep\u2026                        )");
                                    spacing2 = kotlinSpacingBuilderUtil.createLineFeedDependentSpacing(1, 1, minLineFeeds, bl, n, textRange3, dependentSpacingRule);
                                }
                                return spacing2;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        Function3 parameterWithDocCommentRule2 = (Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                ASTNode aSTNode = FormatterUtilKt.requireNode(right2).getFirstChildNode();
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"right.requireNode().firstChildNode");
                                return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.DOC_COMMENT) ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 1, true, this.this$0.this$0.$settings.KEEP_BLANK_LINES_IN_DECLARATIONS, 2, null) : null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        };
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_PARAMETER_LIST, null, KtNodeTypes.VALUE_PARAMETER, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)parameterWithDocCommentRule2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.PROPERTY, null, KtNodeTypes.PROPERTY_ACCESSOR, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)createSpacingBuilder.5.INSTANCE));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_ARGUMENT_LIST, KtTokens.LPAR, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            /*
                             * Enabled aggressive block sorting
                             */
                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock $noName_1, @NotNull ASTBlock $noName_2) {
                                Spacing spacing2;
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                if (this.this$0.this$0.$kotlinCommonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE) {
                                    PsiElement psiElement2 = FormatterUtilKt.requireNode(parent2).getPsi();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.requireNode().psi");
                                    if (KotlinCommonBlockKt.needWrapArgumentList(psiElement2)) {
                                        spacing2 = Spacing.createDependentLFSpacing((int)0, (int)0, (List)KotlinSpacingRulesKt.access$excludeLambdasAndObjects(parent2), (boolean)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE);
                                        return spacing2;
                                    }
                                }
                                spacing2 = KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 0, false, 0, 30, null);
                                return spacing2;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.VALUE_ARGUMENT_LIST, null, KtTokens.RPAR, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock left2, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                return this.this$0.this$0.$kotlinCommonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE ? Spacing.createDependentLFSpacing((int)0, (int)0, (List)KotlinSpacingRulesKt.access$excludeLambdasAndObjects(parent2), (boolean)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE) : (Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(left2).getElementType(), (Object)((Object)KtTokens.COMMA)) ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 1, 0, 0, false, 0, 30, null) : KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 0, false, 0, 30, null));
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.CONDITION, KtTokens.RPAR, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.2 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock left2, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                return this.this$0.this$0.$kotlinCustomSettings.IF_RPAREN_ON_NEW_LINE ? Spacing.createDependentLFSpacing((int)0, (int)0, (List)KotlinSpacingRulesKt.access$excludeLambdasAndObjects(left2), (boolean)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_LINE_BREAKS, (int)this.this$0.$this_rules.getCommonCodeStyleSettings().KEEP_BLANK_LINES_IN_CODE) : KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 0, false, 0, 30, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_rules = kotlinSpacingBuilder;
                        this.$DECLARATIONS = tokenSet;
                        super(1);
                    }
                }));
                $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder.BasicSpacingBuilder, Unit>(this, $this$rules, DECLARATIONS){
                    final /* synthetic */ createSpacingBuilder.1 this$0;
                    final /* synthetic */ KotlinSpacingBuilder $this_rules;
                    final /* synthetic */ TokenSet $DECLARATIONS;

                    public final void invoke(@NotNull KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$simple, (String)"$receiver");
                        $this$simple.before(KtTokens.DOC_COMMENT).lineBreakInCode();
                        $this$simple.between(KtNodeTypes.PROPERTY, KtNodeTypes.PROPERTY).lineBreakInCode();
                        $this$simple.between(KtNodeTypes.CLASS, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.FUN, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.PROPERTY, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.OBJECT_DECLARATION, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.SECONDARY_CONSTRUCTOR, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.CLASS_INITIALIZER, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.TYPEALIAS, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.ENUM_ENTRY, this.$DECLARATIONS).blankLines(1);
                        $this$simple.between(KtNodeTypes.ENUM_ENTRY, KtTokens.SEMICOLON).spaces(0);
                        $this$simple.beforeInside(KtNodeTypes.FUN, TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY})).lineBreakInCode();
                        $this$simple.beforeInside(KtNodeTypes.SECONDARY_CONSTRUCTOR, TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY})).lineBreakInCode();
                        $this$simple.beforeInside(KtNodeTypes.CLASS, TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY})).lineBreakInCode();
                        $this$simple.beforeInside(KtNodeTypes.OBJECT_DECLARATION, TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BODY, KtNodeTypes.CLASS_BODY})).lineBreakInCode();
                        $this$simple.beforeInside(KtNodeTypes.PROPERTY, KtNodeTypes.WHEN).spaces(0);
                        $this$simple.before(KtNodeTypes.PROPERTY).lineBreakInCode();
                        $this$simple.after(KtTokens.DOC_COMMENT).lineBreakInCode();
                        $this$simple.before(KtTokens.COMMA).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_COMMA);
                        $this$simple.after(KtTokens.COMMA).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AFTER_COMMA);
                        int spacesAroundAssignment = this.this$0.$kotlinCommonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
                        SpacingBuilder.RuleBuilder ruleBuilder = $this$simple.beforeInside(KtTokens.EQ, KtNodeTypes.PROPERTY);
                        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder, (String)"beforeInside(EQ, PROPERTY)");
                        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder, spacesAroundAssignment);
                        $this$simple.beforeInside(KtTokens.EQ, KtNodeTypes.FUN).spacing(spacesAroundAssignment, spacesAroundAssignment, 0, false, 0);
                        $this$simple.around(TokenSet.create((IElementType[])new IElementType[]{KtTokens.EQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.PERCEQ})).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
                        $this$simple.around(TokenSet.create((IElementType[])new IElementType[]{KtTokens.ANDAND, KtTokens.OROR})).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_LOGICAL_OPERATORS);
                        $this$simple.around(TokenSet.create((IElementType[])new IElementType[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ})).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_EQUALITY_OPERATORS);
                        $this$simple.aroundInside(TokenSet.create((IElementType[])new IElementType[]{KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ}), KtNodeTypes.BINARY_EXPRESSION).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_RELATIONAL_OPERATORS);
                        $this$simple.aroundInside(TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUS, KtTokens.MINUS}), KtNodeTypes.BINARY_EXPRESSION).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_ADDITIVE_OPERATORS);
                        $this$simple.aroundInside(TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC}), KtNodeTypes.BINARY_EXPRESSION).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
                        $this$simple.around(TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.MINUS, KtTokens.PLUS, KtTokens.EXCL})).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_AROUND_UNARY_OPERATOR);
                        $this$simple.before(KtTokens.ELVIS).spaces(1);
                        SpacingBuilder.RuleBuilder ruleBuilder2 = $this$simple.after(KtTokens.ELVIS);
                        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder2, (String)"after(ELVIS)");
                        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder2, 1);
                        $this$simple.around(KtTokens.RANGE).spaceIf(this.this$0.$kotlinCustomSettings.SPACE_AROUND_RANGE);
                        $this$simple.after(KtNodeTypes.MODIFIER_LIST).spaces(1);
                        $this$simple.beforeInside(KtTokens.IDENTIFIER, KtNodeTypes.CLASS).spaces(1);
                        $this$simple.beforeInside(KtTokens.IDENTIFIER, KtNodeTypes.OBJECT_DECLARATION).spaces(1);
                        $this$simple.after(KtTokens.VAL_KEYWORD).spaces(1);
                        $this$simple.after(KtTokens.VAR_KEYWORD).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_REFERENCE, KtTokens.DOT, KtNodeTypes.PROPERTY).spacing(0, 0, 0, false, 0);
                        $this$simple.betweenInside(KtTokens.DOT, KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY).spacing(0, 0, 0, false, 0);
                        $this$simple.betweenInside(KtTokens.RETURN_KEYWORD, KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.RETURN).spaces(0);
                        $this$simple.afterInside(KtTokens.RETURN_KEYWORD, KtNodeTypes.RETURN).spaces(1);
                        $this$simple.afterInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.RETURN).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, KtTokens.EOL_COMMENT, KtNodeTypes.LABELED_EXPRESSION).spacing(0, Integer.MAX_VALUE, 0, true, this.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, KtTokens.BLOCK_COMMENT, KtNodeTypes.LABELED_EXPRESSION).spacing(0, Integer.MAX_VALUE, 0, true, this.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                        $this$simple.betweenInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.LABELED_EXPRESSION).spaces(0);
                        $this$simple.afterInside(KtNodeTypes.LABEL_QUALIFIER, KtNodeTypes.LABELED_EXPRESSION).spaces(1);
                        $this$simple.betweenInside(KtTokens.FUN_KEYWORD, KtNodeTypes.VALUE_PARAMETER_LIST, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
                        $this$simple.after(KtTokens.FUN_KEYWORD).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, KtNodeTypes.TYPE_REFERENCE, KtNodeTypes.FUN).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_PARAMETER_LIST, KtTokens.IDENTIFIER, KtNodeTypes.FUN).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_REFERENCE, KtTokens.DOT, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
                        $this$simple.betweenInside(KtTokens.DOT, KtTokens.IDENTIFIER, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
                        $this$simple.afterInside(KtTokens.IDENTIFIER, KtNodeTypes.FUN).spacing(0, 0, 0, false, 0);
                        $this$simple.aroundInside(KtTokens.DOT, KtNodeTypes.USER_TYPE).spaces(0);
                        $this$simple.around(KtTokens.AS_KEYWORD).spaces(1);
                        $this$simple.around(KtTokens.IS_KEYWORD).spaces(1);
                        $this$simple.around(KtTokens.NOT_IS).spaces(1);
                        $this$simple.around(KtTokens.IN_KEYWORD).spaces(1);
                        $this$simple.around(KtTokens.NOT_IN).spaces(1);
                        $this$simple.aroundInside(KtTokens.IDENTIFIER, KtNodeTypes.BINARY_EXPRESSION).spaces(1);
                        $this$simple.after(KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE).spacing(0, 0, 0, false, 0);
                        this.$this_rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder.CustomSpacingBuilder, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.3 this$0;

                            public final void invoke(@NotNull KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$custom, (String)"$receiver");
                                KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtNodeTypes.PRIMARY_CONSTRUCTOR, null, null, null, 59, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                                    final /* synthetic */ createSpacingBuilder.1 this$0;

                                    @NotNull
                                    public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock r) {
                                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
                                        ASTNode aSTNode = FormatterUtilKt.requireNode(r).findLeafElementAt(0);
                                        int spacesCount = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.LPAR)) ^ true ? 1 : 0;
                                        return KotlinSpacingBuilder.createSpacing$default(this.this$0.this$0.$this_rules, spacesCount, 0, 0, true, 0, 2, null);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(3);
                                    }
                                }));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        $this$simple.afterInside(KtTokens.CONSTRUCTOR_KEYWORD, KtNodeTypes.PRIMARY_CONSTRUCTOR).spaces(0);
                        $this$simple.betweenInside(KtTokens.IDENTIFIER, KtNodeTypes.TYPE_PARAMETER_LIST, KtNodeTypes.CLASS).spaces(0);
                        $this$simple.beforeInside(KtTokens.DOT, KtNodeTypes.DOT_QUALIFIED_EXPRESSION).spaces(0);
                        SpacingBuilder.RuleBuilder ruleBuilder3 = $this$simple.afterInside(KtTokens.DOT, KtNodeTypes.DOT_QUALIFIED_EXPRESSION);
                        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder3, (String)"afterInside(DOT, DOT_QUALIFIED_EXPRESSION)");
                        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder3, 0);
                        $this$simple.beforeInside(KtTokens.SAFE_ACCESS, KtNodeTypes.SAFE_ACCESS_EXPRESSION).spaces(0);
                        SpacingBuilder.RuleBuilder ruleBuilder4 = $this$simple.afterInside(KtTokens.SAFE_ACCESS, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
                        Intrinsics.checkExpressionValueIsNotNull((Object)ruleBuilder4, (String)"afterInside(SAFE_ACCESS, SAFE_ACCESS_EXPRESSION)");
                        KotlinSpacingRulesKt.spacesNoLineBreak(ruleBuilder4, 0);
                        $this$simple.between(KotlinSpacingRulesKt.getMODIFIERS_LIST_ENTRIES(), KotlinSpacingRulesKt.getMODIFIERS_LIST_ENTRIES()).spaces(1);
                        $this$simple.after(KtTokens.LBRACKET).spaces(0);
                        $this$simple.before(KtTokens.RBRACKET).spaces(0);
                        $this$simple.afterInside(KtTokens.LPAR, KtNodeTypes.VALUE_PARAMETER_LIST).spaces(0, this.this$0.$kotlinCommonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
                        $this$simple.beforeInside(KtTokens.RPAR, KtNodeTypes.VALUE_PARAMETER_LIST).spaces(0, this.this$0.$kotlinCommonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
                        $this$simple.afterInside(KtTokens.LT, KtNodeTypes.TYPE_PARAMETER_LIST).spaces(0);
                        $this$simple.beforeInside(KtTokens.GT, KtNodeTypes.TYPE_PARAMETER_LIST).spaces(0);
                        $this$simple.afterInside(KtTokens.LT, KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
                        $this$simple.beforeInside(KtTokens.GT, KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
                        $this$simple.before(KtNodeTypes.TYPE_ARGUMENT_LIST).spaces(0);
                        $this$simple.after(KtTokens.LPAR).spaces(0);
                        $this$simple.before(KtTokens.RPAR).spaces(0);
                        $this$simple.betweenInside(KtTokens.FOR_KEYWORD, KtTokens.LPAR, KtNodeTypes.FOR).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_FOR_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.IF_KEYWORD, KtTokens.LPAR, KtNodeTypes.IF).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_IF_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.WHILE_KEYWORD, KtTokens.LPAR, KtNodeTypes.WHILE).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_WHILE_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.WHILE_KEYWORD, KtTokens.LPAR, KtNodeTypes.DO_WHILE).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_WHILE_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.WHEN_KEYWORD, KtTokens.LPAR, KtNodeTypes.WHEN).spaceIf(this.this$0.$kotlinCustomSettings.SPACE_BEFORE_WHEN_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.CATCH_KEYWORD, KtNodeTypes.VALUE_PARAMETER_LIST, KtNodeTypes.CATCH).spaceIf(this.this$0.$kotlinCommonSettings.SPACE_BEFORE_CATCH_PARENTHESES);
                        $this$simple.betweenInside(KtTokens.LPAR, KtNodeTypes.VALUE_PARAMETER, KtNodeTypes.FOR).spaces(0);
                        $this$simple.betweenInside(KtTokens.LPAR, KtNodeTypes.DESTRUCTURING_DECLARATION, KtNodeTypes.FOR).spaces(0);
                        $this$simple.betweenInside(KtNodeTypes.LOOP_RANGE, KtTokens.RPAR, KtNodeTypes.FOR).spaces(0);
                        $this$simple.after(KtTokens.LONG_TEMPLATE_ENTRY_START).spaces(0);
                        $this$simple.before(KtTokens.LONG_TEMPLATE_ENTRY_END).spaces(0);
                        $this$simple.afterInside(KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATED_EXPRESSION).spaces(1);
                        $this$simple.before(KtTokens.SEMICOLON).spaces(0);
                        $this$simple.beforeInside(KtNodeTypes.INITIALIZER_LIST, KtNodeTypes.ENUM_ENTRY).spaces(0);
                        $this$simple.beforeInside(KtTokens.QUEST, KtNodeTypes.NULLABLE_TYPE).spaces(0);
                        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.VALUE_PARAMETER, KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY, KtNodeTypes.FUNCTION_LITERAL});
                        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(PROPERTY\u2026_ENTRY, FUNCTION_LITERAL)");
                        TokenSet TYPE_COLON_ELEMENTS = tokenSet;
                        SpacingBuilder spacingBuilder = $this$simple;
                        KtSingleValueToken ktSingleValueToken = KtTokens.COLON;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COLON");
                        KotlinSpacingRulesKt.beforeInside(spacingBuilder, ktSingleValueToken, TYPE_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)new Function1<SpacingBuilder.RuleBuilder, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.3 this$0;

                            public final void invoke(@NotNull SpacingBuilder.RuleBuilder $this$beforeInside) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$beforeInside, (String)"$receiver");
                                $this$beforeInside.spaceIf(this.this$0.this$0.$kotlinCustomSettings.SPACE_BEFORE_TYPE_COLON);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        SpacingBuilder spacingBuilder2 = $this$simple;
                        KtSingleValueToken ktSingleValueToken2 = KtTokens.COLON;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"COLON");
                        KotlinSpacingRulesKt.afterInside(spacingBuilder2, ktSingleValueToken2, TYPE_COLON_ELEMENTS, (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)new Function1<SpacingBuilder.RuleBuilder, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.3 this$0;

                            public final void invoke(@NotNull SpacingBuilder.RuleBuilder $this$afterInside) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$afterInside, (String)"$receiver");
                                $this$afterInside.spaceIf(this.this$0.this$0.$kotlinCustomSettings.SPACE_AFTER_TYPE_COLON);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        SpacingBuilder spacingBuilder3 = $this$simple;
                        KtSingleValueToken ktSingleValueToken3 = KtTokens.COLON;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"COLON");
                        KotlinSpacingRulesKt.afterInside(spacingBuilder3, ktSingleValueToken3, KotlinSpacingRulesKt.getEXTEND_COLON_ELEMENTS(), (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)new Function1<SpacingBuilder.RuleBuilder, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.3 this$0;

                            public final void invoke(@NotNull SpacingBuilder.RuleBuilder $this$afterInside) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$afterInside, (String)"$receiver");
                                $this$afterInside.spaceIf(this.this$0.this$0.$kotlinCustomSettings.SPACE_AFTER_EXTEND_COLON);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        $this$simple.beforeInside(KtTokens.ARROW, KtNodeTypes.FUNCTION_LITERAL).spaceIf(this.this$0.$kotlinCustomSettings.SPACE_BEFORE_LAMBDA_ARROW);
                        $this$simple.aroundInside(KtTokens.ARROW, KtNodeTypes.FUNCTION_TYPE).spaceIf(this.this$0.$kotlinCustomSettings.SPACE_AROUND_FUNCTION_TYPE_ARROW);
                        $this$simple.before(KtNodeTypes.VALUE_ARGUMENT_LIST).spaces(0);
                        $this$simple.between(KtNodeTypes.VALUE_ARGUMENT_LIST, KtNodeTypes.LAMBDA_ARGUMENT).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.LAMBDA_ARGUMENT, KtNodeTypes.CALL_EXPRESSION).spaces(1);
                        $this$simple.betweenInside(KtNodeTypes.TYPE_ARGUMENT_LIST, KtNodeTypes.LAMBDA_ARGUMENT, KtNodeTypes.CALL_EXPRESSION).spaces(1);
                        $this$simple.around(KtTokens.COLONCOLON).spaces(0);
                        $this$simple.around(KtTokens.BY_KEYWORD).spaces(1);
                        $this$simple.betweenInside(KtTokens.IDENTIFIER, KtNodeTypes.PROPERTY_DELEGATE, KtNodeTypes.PROPERTY).spaces(1);
                        $this$simple.before(KtNodeTypes.INDICES).spaces(0);
                        $this$simple.before(KtTokens.WHERE_KEYWORD).spaces(1);
                        $this$simple.afterInside(KtTokens.GET_KEYWORD, KtNodeTypes.PROPERTY_ACCESSOR).spaces(0);
                        $this$simple.afterInside(KtTokens.SET_KEYWORD, KtNodeTypes.PROPERTY_ACCESSOR).spaces(0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_rules = kotlinSpacingBuilder;
                        this.$DECLARATIONS = tokenSet;
                        super(1);
                    }
                }));
                $this$rules.custom((Function1<? super KotlinSpacingBuilder.CustomSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder.CustomSpacingBuilder, Unit>(this, $this$rules){
                    final /* synthetic */ createSpacingBuilder.1 this$0;
                    final /* synthetic */ KotlinSpacingBuilder $this_rules;

                    public final void invoke(@NotNull KotlinSpacingBuilder.CustomSpacingBuilder $this$custom) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$custom, (String)"$receiver");
                        Function5<KotlinSpacingBuilder.CustomSpacingBuilder, Boolean, IElementType, IElementType, Function2<? super ASTNode, ? super ASTNode, ? extends Boolean>, Unit> $fun$ruleForKeywordOnNewLine$1 = new Function5<KotlinSpacingBuilder.CustomSpacingBuilder, Boolean, IElementType, IElementType, Function2<? super ASTNode, ? super ASTNode, ? extends Boolean>, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            public final void invoke(@NotNull KotlinSpacingBuilder.CustomSpacingBuilder $this$ruleForKeywordOnNewLine, boolean shouldBeOnNewLine, @NotNull IElementType keyword, @NotNull IElementType parent2, @NotNull Function2<? super ASTNode, ? super ASTNode, Boolean> afterBlockFilter) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$ruleForKeywordOnNewLine, (String)"$this$ruleForKeywordOnNewLine");
                                Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull(afterBlockFilter, (String)"afterBlockFilter");
                                if (shouldBeOnNewLine) {
                                    KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$ruleForKeywordOnNewLine, parent2, null, keyword, null, null, null, 58, null).lineBreakIfLineBreakInParent(1, false);
                                } else {
                                    KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$ruleForKeywordOnNewLine, parent2, null, keyword, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this, afterBlockFilter){
                                        final /* synthetic */ createSpacingBuilder.1 this$0;
                                        final /* synthetic */ Function2 $afterBlockFilter;

                                        /*
                                         * Unable to fully structure code
                                         * Could not resolve type clashes
                                         */
                                        @NotNull
                                        public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right) {
                                            Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                            Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
                                            previousLeaf = this.this$0.this$0.this$0.$builderUtil.getPreviousNonWhitespaceLeaf(FormatterUtilKt.requireNode(right));
                                            if (previousLeaf == null || !Intrinsics.areEqual((Object)previousLeaf.getElementType(), (Object)KtTokens.RBRACE)) ** GOTO lbl-1000
                                            v0 = previousLeaf.getTreeParent();
                                            if (Intrinsics.areEqual((Object)(v0 != null ? v0.getElementType() : null), (Object)KtNodeTypes.BLOCK)) {
                                                v1 = previousLeaf.getTreeParent();
                                                if (v1 == null) {
                                                    Intrinsics.throwNpe();
                                                }
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v1 = null;
                                            }
                                            if ((leftBlock = v1) == null) ** GOTO lbl-1000
                                            v2 = right.getNode();
                                            v3 /* !! */  = v2 != null ? v2.getTreeParent() : null;
                                            if (v3 /* !! */  == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            if (((Boolean)this.$afterBlockFilter.invoke((Object)v3 /* !! */ , leftBlock)).booleanValue()) {
                                                v4 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v4 = false;
                                            }
                                            removeLineBreaks = v4;
                                            return KotlinSpacingBuilder.createSpacing$default(this.this$0.this$0.$this_rules, 1, 0, 0, removeLineBreaks == false, 0, 2, null);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$afterBlockFilter = function2;
                                            super(3);
                                        }
                                    }));
                                }
                            }

                            public static /* synthetic */ void invoke$default(createSpacingBuilder.1 var0, KotlinSpacingBuilder.CustomSpacingBuilder customSpacingBuilder, boolean bl, IElementType iElementType, IElementType iElementType2, Function2 function2, int n, Object object) {
                                if ((n & 8) != 0) {
                                    function2 = createSpacingBuilder.1.INSTANCE;
                                }
                                var0.invoke(customSpacingBuilder, bl, iElementType, iElementType2, (Function2<? super ASTNode, ? super ASTNode, Boolean>)function2);
                            }
                            {
                                this.this$0 = var1_1;
                                super(5);
                            }
                        };
                        boolean bl = this.this$0.$kotlinCommonSettings.ELSE_ON_NEW_LINE;
                        KtKeywordToken ktKeywordToken = KtTokens.ELSE_KEYWORD;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"ELSE_KEYWORD");
                        IElementType iElementType = ktKeywordToken;
                        IElementType iElementType2 = KtNodeTypes.IF;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"IF");
                        $fun$ruleForKeywordOnNewLine$1.invoke($this$custom, bl, iElementType, iElementType2, (Function2<? super ASTNode, ? super ASTNode, Boolean>)((Function2)createSpacingBuilder.2.INSTANCE));
                        boolean bl2 = this.this$0.$kotlinCommonSettings.WHILE_ON_NEW_LINE;
                        KtKeywordToken ktKeywordToken2 = KtTokens.WHILE_KEYWORD;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken2), (String)"WHILE_KEYWORD");
                        IElementType iElementType3 = ktKeywordToken2;
                        IElementType iElementType4 = KtNodeTypes.DO_WHILE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType4, (String)"DO_WHILE");
                        $fun$ruleForKeywordOnNewLine$1.invoke($this$custom, bl2, iElementType3, iElementType4, (Function2<? super ASTNode, ? super ASTNode, Boolean>)((Function2)createSpacingBuilder.3.INSTANCE));
                        boolean bl3 = this.this$0.$kotlinCommonSettings.CATCH_ON_NEW_LINE;
                        IElementType iElementType5 = KtNodeTypes.CATCH;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType5, (String)"CATCH");
                        IElementType iElementType6 = KtNodeTypes.TRY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType6, (String)"TRY");
                        createSpacingBuilder.1.invoke$default($fun$ruleForKeywordOnNewLine$1, $this$custom, bl3, iElementType5, iElementType6, null, 8, null);
                        boolean bl4 = this.this$0.$kotlinCommonSettings.FINALLY_ON_NEW_LINE;
                        IElementType iElementType7 = KtNodeTypes.FINALLY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType7, (String)"FINALLY");
                        IElementType iElementType8 = KtNodeTypes.TRY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType8, (String)"TRY");
                        createSpacingBuilder.1.invoke$default($fun$ruleForKeywordOnNewLine$1, $this$custom, bl4, iElementType7, iElementType8, null, 8, null);
                        Function2<ASTNode, IElementType, Spacing> $fun$spacingForLeftBrace$4 = new Function2<ASTNode, IElementType, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            @Nullable
                            public final Spacing invoke(@Nullable ASTNode block, @NotNull IElementType blockType) {
                                ASTNode leftBrace;
                                Intrinsics.checkParameterIsNotNull((Object)blockType, (String)"blockType");
                                if (block != null && Intrinsics.areEqual((Object)block.getElementType(), (Object)blockType) && (leftBrace = block.findChildByType((IElementType)KtTokens.LBRACE)) != null) {
                                    ASTNode previousLeaf = this.this$0.this$0.$builderUtil.getPreviousNonWhitespaceLeaf(leftBrace);
                                    boolean isAfterEolComment = previousLeaf != null && Intrinsics.areEqual((Object)previousLeaf.getElementType(), (Object)((Object)KtTokens.EOL_COMMENT));
                                    boolean keepLineBreaks = this.this$0.this$0.$kotlinCustomSettings.LBRACE_ON_NEXT_LINE || isAfterEolComment;
                                    int minimumLF = this.this$0.this$0.$kotlinCustomSettings.LBRACE_ON_NEXT_LINE ? 1 : 0;
                                    return KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 1, 0, minimumLF, keepLineBreaks, 0, 2, null);
                                }
                                return KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 1, 0, 0, false, 0, 30, null);
                            }

                            public static /* synthetic */ Spacing invoke$default(createSpacingBuilder.4 var0, ASTNode aSTNode, IElementType iElementType, int n, Object object) {
                                if ((n & 2) != 0) {
                                    IElementType iElementType2 = KtNodeTypes.BLOCK;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"BLOCK");
                                    iElementType = iElementType2;
                                }
                                return var0.invoke(aSTNode, iElementType);
                            }
                            {
                                this.this$0 = var1_1;
                                super(2);
                            }
                        };
                        Function1<IElementType, Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>> $fun$leftBraceRule$5 = new Function1<IElementType, Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>>($fun$spacingForLeftBrace$4){
                            final /* synthetic */ createSpacingBuilder.4 $spacingForLeftBrace$4;

                            @NotNull
                            public final Function3<ASTBlock, ASTBlock, ASTBlock, Spacing> invoke(@NotNull IElementType blockType) {
                                Intrinsics.checkParameterIsNotNull((Object)blockType, (String)"blockType");
                                return (Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this, blockType){
                                    final /* synthetic */ createSpacingBuilder.5 this$0;
                                    final /* synthetic */ IElementType $blockType;

                                    @Nullable
                                    public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                        Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                        return this.this$0.$spacingForLeftBrace$4.invoke(right2.getNode(), this.$blockType);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$blockType = iElementType;
                                        super(3);
                                    }
                                };
                            }

                            public static /* synthetic */ Function3 invoke$default(createSpacingBuilder.5 var0, IElementType iElementType, int n, Object object) {
                                if ((n & 1) != 0) {
                                    IElementType iElementType2 = KtNodeTypes.BLOCK;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"BLOCK");
                                    iElementType = iElementType2;
                                }
                                return var0.invoke(iElementType);
                            }
                            {
                                this.$spacingForLeftBrace$4 = var1_1;
                                super(1);
                            }
                        };
                        Function3 leftBraceRuleIfBlockIsWrapped2 = (Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>($fun$spacingForLeftBrace$4){
                            final /* synthetic */ createSpacingBuilder.4 $spacingForLeftBrace$4;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                return createSpacingBuilder.4.invoke$default(this.$spacingForLeftBrace$4, FormatterUtilKt.requireNode(right2).getFirstChildNode(), null, 2, null);
                            }
                            {
                                this.$spacingForLeftBrace$4 = var1_1;
                                super(3);
                            }
                        };
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtTokens.SEMICOLON, null, null, null, null, 61, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock left2, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                ASTNode nodeAfterLeft = FormatterUtilKt.requireNode(left2).getTreeNext();
                                return nodeAfterLeft instanceof PsiWhiteSpace && !nodeAfterLeft.textContains('\n') ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 1, 0, 0, false, 0, 30, null) : null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.IF, null, KtNodeTypes.THEN, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.IF, null, KtNodeTypes.ELSE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FOR, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHILE, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.DO_WHILE, null, KtNodeTypes.BODY, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)leftBraceRuleIfBlockIsWrapped2);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.TRY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CATCH, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FINALLY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUN, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.SECONDARY_CONSTRUCTOR, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_INITIALIZER, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.PROPERTY_ACCESSOR, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder customSpacingBuilder = KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, null, KtNodeTypes.CLASS_BODY, null, null, null, 59, null);
                        IElementType iElementType9 = KtNodeTypes.CLASS_BODY;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType9, (String)"CLASS_BODY");
                        customSpacingBuilder.customRule($fun$leftBraceRule$5.invoke(iElementType9));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtNodeTypes.WHEN_ENTRY, KtNodeTypes.WHEN_ENTRY, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            @NotNull
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock left2, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                PsiElement psiElement2 = FormatterUtilKt.requireNode(left2).getPsi();
                                if (psiElement2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
                                }
                                KtWhenEntry leftEntry = (KtWhenEntry)psiElement2;
                                PsiElement psiElement3 = FormatterUtilKt.requireNode(right2).getPsi();
                                if (psiElement3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
                                }
                                KtWhenEntry rightEntry = (KtWhenEntry)psiElement3;
                                int blankLines = leftEntry.getExpression() instanceof KtBlockExpression || rightEntry.getExpression() instanceof KtBlockExpression ? KtCodeStyleSettingsKt.getKotlinCustomSettings((CodeStyleSettings)this.this$0.this$0.$settings).BLANK_LINES_AROUND_BLOCK_WHEN_BRANCHES : 0;
                                return KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, blankLines + 1, false, 0, 26, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHEN_ENTRY, null, KtNodeTypes.BLOCK, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)createSpacingBuilder.5.invoke$default($fun$leftBraceRule$5, null, 1, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.WHEN, null, KtTokens.LBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>($fun$spacingForLeftBrace$4){
                            final /* synthetic */ createSpacingBuilder.4 $spacingForLeftBrace$4;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock $noName_1, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                ASTNode aSTNode = FormatterUtilKt.requireNode(parent2);
                                IElementType iElementType = KtNodeTypes.WHEN;
                                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"WHEN");
                                return this.$spacingForLeftBrace$4.invoke(aSTNode, iElementType);
                            }
                            {
                                this.$spacingForLeftBrace$4 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, KtTokens.LBRACE, KtNodeTypes.WHEN_ENTRY, null, null, null, 57, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            @NotNull
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                return KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, 0, 0, 1, false, 0, 26, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        int spacesInSimpleFunction = this.this$0.$kotlinCustomSettings.INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD ? 1 : 0;
                        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, KtTokens.LBRACE, KtNodeTypes.BLOCK, null, null, null, 56, null), spacesInSimpleFunction, false, 2, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, KtTokens.ARROW, KtNodeTypes.BLOCK, null, null, null, 56, null), 1, false, 2, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, KtTokens.LBRACE, KtTokens.RBRACE, null, null, null, 56, null).spacing(KotlinSpacingBuilder.createSpacing$default(this.$this_rules, 0, 1, 0, false, 0, 28, null));
                        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, null, KtTokens.RBRACE, null, null, null, 58, null), spacesInSimpleFunction, false, 2, null);
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.FUNCTION_LITERAL, KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this, spacesInSimpleFunction){
                            final /* synthetic */ createSpacingBuilder.4 this$0;
                            final /* synthetic */ int $spacesInSimpleFunction;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock $noName_1, @NotNull ASTBlock right2) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)right2, (String)"right");
                                ASTNode rightNode = FormatterUtilKt.requireNode(right2);
                                IElementType iElementType = rightNode.getElementType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"rightNode.elementType");
                                IElementType rightType = iElementType;
                                return Intrinsics.areEqual((Object)rightType, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) ? KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, this.$spacesInSimpleFunction, 0, 0, false, 0, 22, null) : KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, this.$spacesInSimpleFunction, 0, 0, false, 0, 30, null);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$spacesInSimpleFunction = n;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, null, KtTokens.RBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock $noName_1, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                CommonCodeStyleSettings commonCodeStyleSettings = this.this$0.this$0.$kotlinCommonSettings;
                                TextRange textRange = parent2.getTextRange();
                                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"parent.textRange");
                                return KotlinSpacingBuilderKt.createSpaceBeforeRBrace(commonCodeStyleSettings, 1, textRange);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.BLOCK, null, KtTokens.RBRACE, null, null, null, 58, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this, spacesInSimpleFunction){
                            final /* synthetic */ createSpacingBuilder.4 this$0;
                            final /* synthetic */ int $spacesInSimpleFunction;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock block, @NotNull ASTBlock left2, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                ASTNode aSTNode = FormatterUtilKt.requireNode(block).getTreeParent();
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"block.requireNode().treeParent");
                                PsiElement psiElement2 = aSTNode.getPsi();
                                boolean empty = Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(left2).getElementType(), (Object)((Object)KtTokens.LBRACE));
                                PsiElement psiElement3 = psiElement2;
                                if (psiElement3 instanceof KtFunction) {
                                    if (((KtFunction)psiElement2).getName() != null && !empty) {
                                        return null;
                                    }
                                } else if (psiElement3 instanceof KtPropertyAccessor) {
                                    if (!empty) {
                                        return null;
                                    }
                                } else {
                                    return null;
                                }
                                int spaces = empty ? 0 : this.$spacesInSimpleFunction;
                                return KotlinSpacingBuilderKt.createSpaceBeforeRBrace(this.this$0.this$0.$kotlinCommonSettings, spaces, PsiUtilsKt.getTextRangeWithoutComments(psiElement2));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$spacesInSimpleFunction = n;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.BLOCK, KtTokens.LBRACE, null, null, null, null, 60, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this, spacesInSimpleFunction){
                            final /* synthetic */ createSpacingBuilder.4 this$0;
                            final /* synthetic */ int $spacesInSimpleFunction;

                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock parent2, @NotNull ASTBlock $noName_1, @NotNull ASTBlock $noName_2) {
                                Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                ASTNode aSTNode = FormatterUtilKt.requireNode(parent2).getTreeParent();
                                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"parent.requireNode().treeParent");
                                PsiElement psiElement2 = aSTNode.getPsi();
                                PsiElement psiElement3 = psiElement2;
                                if (!(psiElement3 instanceof KtFunction)) {
                                    psiElement3 = null;
                                }
                                KtFunction ktFunction = (KtFunction)psiElement3;
                                if (ktFunction == null) {
                                    return null;
                                }
                                KtFunction funNode = ktFunction;
                                if (funNode.getName() != null) {
                                    return null;
                                }
                                return Spacing.createDependentLFSpacing((int)this.$spacesInSimpleFunction, (int)this.$spacesInSimpleFunction, (TextRange)PsiUtilsKt.getTextRangeWithoutComments(funNode), (boolean)this.this$0.this$0.$kotlinCommonSettings.KEEP_LINE_BREAKS, (int)this.this$0.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$spacesInSimpleFunction = n;
                                super(3);
                            }
                        }));
                        TokenSet tokenSet = null;
                        TokenSet tokenSet2 = null;
                        IElementType iElementType10 = KtTokens.COLON;
                        IElementType iElementType11 = KtNodeTypes.PRIMARY_CONSTRUCTOR;
                        TokenSet tokenSet3 = KotlinSpacingRulesKt.getEXTEND_COLON_ELEMENTS();
                        KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, null, iElementType11, iElementType10, tokenSet3, tokenSet2, tokenSet, 49, null).customRule((Function3<? super ASTBlock, ? super ASTBlock, ? super ASTBlock, ? extends Spacing>)((Function3)new Function3<ASTBlock, ASTBlock, ASTBlock, Spacing>(this){
                            final /* synthetic */ createSpacingBuilder.4 this$0;

                            /*
                             * Enabled aggressive block sorting
                             */
                            @Nullable
                            public final Spacing invoke(@NotNull ASTBlock $noName_0, @NotNull ASTBlock left2, @NotNull ASTBlock $noName_2) {
                                Spacing spacing2;
                                PsiElement rightParenthesis;
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Intrinsics.checkParameterIsNotNull((Object)left2, (String)"left");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 2>");
                                PsiElement psiElement2 = FormatterUtilKt.requireNode(left2).getPsi();
                                if (psiElement2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
                                }
                                KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)psiElement2;
                                KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                                PsiElement psiElement3 = rightParenthesis = ktParameterList != null ? ktParameterList.getRightParenthesis() : null;
                                PsiElement prevSibling2 = psiElement3 != null ? psiElement3.getPrevSibling() : null;
                                int spaces = this.this$0.this$0.$kotlinCustomSettings.SPACE_BEFORE_EXTEND_COLON ? 1 : 0;
                                PsiElement psiElement4 = prevSibling2;
                                if (!(psiElement4 instanceof PsiWhiteSpace)) {
                                    psiElement4 = null;
                                }
                                PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement4;
                                if (!(psiWhiteSpace != null && psiWhiteSpace.textContains('\n') || this.this$0.this$0.$kotlinCommonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE)) {
                                    spacing2 = KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, spaces, 0, 0, false, 0, 30, null);
                                    return spacing2;
                                }
                                spacing2 = KotlinSpacingBuilder.createSpacing$default(this.this$0.$this_rules, spaces, 0, 0, false, 0, 22, null);
                                return spacing2;
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        }));
                        KotlinSpacingBuilder.CustomSpacingBuilder.lineBreakIfLineBreakInParent$default(KotlinSpacingBuilder.CustomSpacingBuilder.inPosition$default($this$custom, KtNodeTypes.CLASS_BODY, KtTokens.LBRACE, KtNodeTypes.ENUM_ENTRY, null, null, null, 56, null), 1, false, 2, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_rules = kotlinSpacingBuilder;
                        super(1);
                    }
                }));
                $this$rules.simple((Function1<? super KotlinSpacingBuilder.BasicSpacingBuilder, Unit>)((Function1)new Function1<KotlinSpacingBuilder.BasicSpacingBuilder, Unit>(this){
                    final /* synthetic */ createSpacingBuilder.1 this$0;

                    public final void invoke(@NotNull KotlinSpacingBuilder.BasicSpacingBuilder $this$simple) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$simple, (String)"$receiver");
                        $this$simple.afterInside(KtTokens.LBRACE, KtNodeTypes.BLOCK).lineBreakInCode();
                        $this$simple.beforeInside(KtTokens.RBRACE, KtNodeTypes.BLOCK).spacing(1, 0, 1, this.this$0.$kotlinCommonSettings.KEEP_LINE_BREAKS, this.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                        $this$simple.between(KtTokens.LBRACE, KtNodeTypes.ENUM_ENTRY).spacing(1, 0, 0, true, this.this$0.$kotlinCommonSettings.KEEP_BLANK_LINES_IN_CODE);
                        $this$simple.beforeInside(KtTokens.RBRACE, KtNodeTypes.WHEN).lineBreakInCode();
                        $this$simple.between(KtTokens.RPAR, KtNodeTypes.BODY).spaces(1);
                        $this$simple.aroundInside(KtTokens.ARROW, KtNodeTypes.WHEN_ENTRY).spaceIf(this.this$0.$kotlinCustomSettings.SPACE_AROUND_WHEN_ARROW);
                        SpacingBuilder spacingBuilder = $this$simple;
                        KtSingleValueToken ktSingleValueToken = KtTokens.COLON;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COLON");
                        KotlinSpacingRulesKt.beforeInside(spacingBuilder, ktSingleValueToken, KotlinSpacingRulesKt.getEXTEND_COLON_ELEMENTS(), (Function1<? super SpacingBuilder.RuleBuilder, Unit>)((Function1)new Function1<SpacingBuilder.RuleBuilder, Unit>(this){
                            final /* synthetic */ createSpacingBuilder.5 this$0;

                            public final void invoke(@NotNull SpacingBuilder.RuleBuilder $this$beforeInside) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$beforeInside, (String)"$receiver");
                                $this$beforeInside.spaceIf(this.this$0.this$0.$kotlinCustomSettings.SPACE_BEFORE_EXTEND_COLON);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        $this$simple.after(KtTokens.EOL_COMMENT).lineBreakInCode();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$kotlinCommonSettings = kotlinCommonCodeStyleSettings;
                this.$settings = codeStyleSettings;
                this.$builderUtil = kotlinSpacingBuilderUtil;
                this.$kotlinCustomSettings = kotlinCodeStyleSettings;
                super(1);
            }
        }));
    }

    private static final List<TextRange> excludeLambdasAndObjects(ASTBlock parent2) {
        boolean bl = false;
        List rangesToExclude = new ArrayList();
        FormatterUtilKt.requireNode(parent2).getPsi().accept((PsiElementVisitor)new KtTreeVisitorVoid(rangesToExclude){
            final /* synthetic */ List $rangesToExclude;

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
                super.visitLambdaExpression(lambdaExpression2);
                TextRange textRange = lambdaExpression2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"lambdaExpression.textRange");
                this.$rangesToExclude.add(textRange);
            }

            public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitObjectLiteralExpression(expression2);
                TextRange textRange = expression2.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expression.textRange");
                this.$rangesToExclude.add(textRange);
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                super.visitNamedFunction(function2);
                if (function2.getName() == null) {
                    TextRange textRange = function2.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"function.textRange");
                    this.$rangesToExclude.add(textRange);
                }
            }
            {
                this.$rangesToExclude = $captured_local_variable$0;
            }
        });
        Iterable iterable = TextRangeUtil.excludeRanges((TextRange)parent2.getTextRange(), (List)rangesToExclude);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"TextRangeUtil.excludeRan\u2026xtRange, rangesToExclude)");
        return CollectionsKt.toList((Iterable)iterable);
    }

    static {
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATION}), KtTokens.MODIFIER_KEYWORDS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.orSet(TokenSet.\u2026TION), MODIFIER_KEYWORDS)");
        MODIFIERS_LIST_ENTRIES = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.TYPE_CONSTRAINT, KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION, KtNodeTypes.TYPE_PARAMETER, KtNodeTypes.ENUM_ENTRY, KtNodeTypes.SECONDARY_CONSTRUCTOR});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(TYPE_CON\u2026Y, SECONDARY_CONSTRUCTOR)");
        EXTEND_COLON_ELEMENTS = tokenSet2;
    }

    public static final /* synthetic */ List access$excludeLambdasAndObjects(ASTBlock parent2) {
        return KotlinSpacingRulesKt.excludeLambdasAndObjects(parent2);
    }
}

