/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.impl.HyperlinkInfoFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.filters.InlineFunctionHyperLinkInfo;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/Filter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "exceptionFilter", "Lcom/intellij/execution/filters/ExceptionFilter;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "defaultResult", "createHyperlinks", "Lorg/jetbrains/kotlin/idea/filters/InlineFunctionHyperLinkInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parseNativeStackTraceLine", "rawLine", "patchResult", "result", "Companion", "idea-jvm"})
public final class KotlinExceptionFilter
implements Filter {
    private final ExceptionFilter exceptionFilter;
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN;
    private static final Pattern LINE_COLUMN_PATTERN;
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return (Filter.Result)ApplicationUtilsKt.runReadAction((Function0)new Function0<Filter.Result>(this, line, entireLength){
            final /* synthetic */ KotlinExceptionFilter this$0;
            final /* synthetic */ String $line;
            final /* synthetic */ int $entireLength;

            @Nullable
            public final Filter.Result invoke() {
                Filter.Result result2 = KotlinExceptionFilter.access$getExceptionFilter$p(this.this$0).applyFilter(this.$line, this.$entireLength);
                return result2 == null ? KotlinExceptionFilter.access$parseNativeStackTraceLine(this.this$0, this.$line, this.$entireLength) : KotlinExceptionFilter.access$patchResult(this.this$0, result2, this.$line);
            }
            {
                this.this$0 = kotlinExceptionFilter;
                this.$line = string;
                this.$entireLength = n;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        Collection<Filter.ResultItem> collection;
        void $this$mapTo$iv$iv;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line, result2);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        List list2 = result2.getResultItems();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"result.resultItems");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Filter.ResultItem resultItem2 = new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes());
            collection.add(resultItem2);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new Filter.Result(list3);
    }

    /*
     * WARNING - void declaration
     */
    private final HyperlinkInfo createHyperlinkInfo(String line, Filter.Result defaultResult) {
        String fileName;
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"searchScope.project ?: return null");
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String string = fileName = stackTraceElement2.getFileName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(string)) {
            return null;
        }
        String fullyQualifiedName = stackTraceElement2.getClassName();
        int lineNumber = stackTraceElement2.getLineNumber() - 1;
        String string2 = fullyQualifiedName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fullyQualifiedName");
        String internalName = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(internalName)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile file2 = DebuggerUtils.findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils.INSTANCE, project2, this.searchScope, jvmClassName2, fileName, null, 16, null);
        if (file2 == null) {
            void $this$mapNotNullTo$iv;
            List list2 = defaultResult.getResultItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"defaultResult.resultItems");
            Iterable iterable = list2;
            PsiFile[] destination$iv = (PsiFile[])new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string3;
                FileHyperlinkInfo fileHyperlinkInfo;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                Filter.ResultItem it = (Filter.ResultItem)element$iv;
                boolean bl2 = false;
                Filter.ResultItem resultItem = it;
                if (!(resultItem instanceof FileHyperlinkInfo)) {
                    resultItem = null;
                }
                if (((fileHyperlinkInfo = (FileHyperlinkInfo)resultItem) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getDescriptor()) != null && (fileHyperlinkInfo = fileHyperlinkInfo.getFile()) != null ? fileHyperlinkInfo.getName() : null) == null) continue;
                string3 = string3;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv = string3;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            HashSet defaultLinkFileNames = (HashSet)destination$iv;
            if (!defaultLinkFileNames.contains(fileName)) {
                void $this$mapNotNullTo$iv2;
                PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)project2, (String)fileName, (GlobalSearchScope)this.searchScope);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026t, fileName, searchScope)");
                destination$iv = psiFileArray;
                Collection destination$iv2 = new HashSet();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv2 = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach2 = false;
                void var18_23 = $this$forEach$iv$iv2;
                int n = ((void)var18_23).length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile virtualFile2;
                    void element$iv$iv;
                    void element$iv = element$iv$iv = var18_23[j];
                    boolean bl = false;
                    void it = element$iv;
                    boolean bl6 = false;
                    void v9 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                    if ((!v9.isValid() ? null : it.getVirtualFile()) == null) continue;
                    virtualFile2 = virtualFile2;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    VirtualFile it$iv = virtualFile2;
                    boolean bl9 = false;
                    destination$iv2.add(it$iv);
                }
                HashSet filesByName = (HashSet)destination$iv2;
                Collection collection = filesByName;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return filesByName.size() > 1 ? HyperlinkInfoFactoryImpl.getInstance().createMultipleFilesHyperlinkInfo(CollectionsKt.toList((Iterable)filesByName), lineNumber, project2) : (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, (VirtualFile)CollectionsKt.first((Iterable)filesByName), lineNumber);
                }
            }
            return null;
        }
        VirtualFile virtualFile3 = file2.getVirtualFile();
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile virtualFile4 = virtualFile3;
        InlineFunctionHyperLinkInfo hyperlinkInfoForInline = this.createHyperlinks(jvmClassName2, virtualFile4, lineNumber + 1, project2);
        if (hyperlinkInfoForInline != null) {
            return (HyperlinkInfo)hyperlinkInfoForInline;
        }
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile4, lineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final InlineFunctionHyperLinkInfo createHyperlinks(JvmClassName jvmName, VirtualFile file2, int line, Project project) {
        void inlineFunctionBodyFile;
        if (!NoStrataPositionManagerHelperKt.isInlineFunctionLineNumber(file2, line, project)) {
            return null;
        }
        BytecodeDebugInfo bytecodeDebugInfo = NoStrataPositionManagerHelperKt.readBytecodeInfo(project, jvmName, file2);
        if (bytecodeDebugInfo == null) {
            return null;
        }
        BytecodeDebugInfo debugInfo2 = bytecodeDebugInfo;
        SmapData smapData = debugInfo2.getSmapData();
        if (smapData == null) {
            return null;
        }
        SmapData smapData2 = smapData;
        boolean bl = false;
        ArrayList<InlineFunctionHyperLinkInfo.InlineInfo> inlineInfos = new ArrayList<InlineFunctionHyperLinkInfo.InlineInfo>();
        Pair<KtFile, Integer> pair2 = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.EXECUTED_LINE, this.searchScope);
        if (pair2 == null) {
            return null;
        }
        Pair<KtFile, Integer> pair3 = pair2;
        KtFile ktFile2 = (KtFile)pair3.component1();
        int inlineFunctionBodyLine = ((Number)pair3.component2()).intValue();
        VirtualFile virtualFile2 = inlineFunctionBodyFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"inlineFunctionBodyFile.virtualFile");
        inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.InlineFunctionBodyInfo(virtualFile2, inlineFunctionBodyLine));
        Pair<KtFile, Integer> inlineFunCallInfo = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.CALL_LINE, this.searchScope);
        if (inlineFunCallInfo != null) {
            void callSiteFile;
            Pair<KtFile, Integer> pair4 = inlineFunCallInfo;
            KtFile ktFile3 = (KtFile)pair4.component1();
            int callSiteLine = ((Number)pair4.component2()).intValue();
            VirtualFile virtualFile3 = callSiteFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"callSiteFile.virtualFile");
            inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.CallSiteInfo(virtualFile3, callSiteLine));
        }
        return new InlineFunctionHyperLinkInfo(project, (List<? extends InlineFunctionHyperLinkInfo.InlineInfo>)inlineInfos);
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result parseNativeStackTraceLine(String rawLine, int entireLength) {
        void lineNumber;
        String atPrefix = "at ";
        String ktExtension = ".kt:";
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"searchScope.project ?: return null");
        Project project2 = project;
        String string = rawLine;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String line = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)line, (String)atPrefix, (boolean)false, (int)2, null) && !StringsKt.endsWith$default((CharSequence)line, (char)')', (boolean)false, (int)2, null)) {
            return null;
        }
        int fileNameBegin = StringsKt.lastIndexOf$default((CharSequence)line, (char)'(', (int)0, (boolean)false, (int)6, null) + 1;
        if (fileNameBegin < 1) {
            return null;
        }
        int fileNameEnd = StringsKt.indexOf$default((CharSequence)line, (String)ktExtension, (int)fileNameBegin, (boolean)false, (int)4, null) + ktExtension.length() - 1;
        if (fileNameEnd < ktExtension.length() - 1) {
            return null;
        }
        String string3 = line;
        Companion companion = Companion;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(fileNameBegin, fileNameEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string6 = string5;
        VirtualFile virtualFile2 = companion.findFile(string6);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        String string7 = line;
        int n = fileNameEnd + 1;
        int n2 = StringsKt.getLastIndex((CharSequence)line);
        companion = Companion;
        boolean bl3 = false;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string6 = string9;
        Pair pair2 = companion.parsLineColumn(string6);
        int n3 = ((Number)pair2.component1()).intValue();
        int columnNumber = ((Number)pair2.component2()).intValue();
        int offset2 = entireLength - rawLine.length() + StringsKt.indexOf$default((CharSequence)rawLine, (String)atPrefix, (int)0, (boolean)false, (int)6, null);
        int highlightEndOffset = offset2 + (lineNumber > 0 ? StringsKt.getLastIndex((CharSequence)line) : fileNameEnd);
        OpenFileHyperlinkInfo hyperLinkInfo = new OpenFileHyperlinkInfo(project2, virtualFile3, (int)lineNumber, columnNumber);
        return new Filter.Result(offset2 + fileNameBegin, highlightEndOffset, (HyperlinkInfo)hyperLinkInfo);
    }

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        this.searchScope = searchScope2;
        this.exceptionFilter = new ExceptionFilter(this.searchScope);
    }

    static {
        Companion = new Companion(null);
        STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
        LINE_COLUMN_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    }

    public static final /* synthetic */ ExceptionFilter access$getExceptionFilter$p(KotlinExceptionFilter $this) {
        return $this.exceptionFilter;
    }

    public static final /* synthetic */ Filter.Result access$parseNativeStackTraceLine(KotlinExceptionFilter $this, String rawLine, int entireLength) {
        return $this.parseNativeStackTraceLine(rawLine, entireLength);
    }

    public static final /* synthetic */ Filter.Result access$patchResult(KotlinExceptionFilter $this, Filter.Result result2, String line) {
        return $this.patchResult(result2, line);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter$Companion;", "", "()V", "LINE_COLUMN_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "STACK_TRACE_ELEMENT_PATTERN", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "parsLineColumn", "Lkotlin/Pair;", "", "locationLine", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "idea-jvm"})
    public static final class Companion {
        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = STACK_TRACE_ELEMENT_PATTERN.matcher(line);
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName2 = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumber = matcher2.group(4);
                return new StackTraceElement(declaringClass, methodName2, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private final VirtualFile findFile(String fileName) {
            if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
                return null;
            }
            String string = FileUtil.toSystemIndependentName((String)fileName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndependentName(fileName)");
            String vfsFileName = string;
            return LocalFileSystem.getInstance().findFileByPath(vfsFileName);
        }

        private final Pair<Integer, Integer> parsLineColumn(String locationLine) {
            Matcher matcher2 = LINE_COLUMN_PATTERN.matcher(locationLine);
            if (matcher2.matches()) {
                int line = Integer.parseInt(matcher2.group(1));
                int column = Integer.parseInt(matcher2.group(2));
                return new Pair((Object)line, (Object)column);
            }
            return new Pair((Object)0, (Object)0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

