/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinValueArgumentListFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinValueArgumentListFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor2, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtValueArgumentList) || ((KtValueArgumentList)element3).getRightParenthesis() != null) {
            return;
        }
        PsiElement psiElement2 = ((KtValueArgumentList)element3).getLeftParenthesis();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.leftParenthesis ?: return");
        PsiElement lPar = psiElement2;
        List<KtValueArgument> list2 = ((KtValueArgumentList)element3).getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.arguments");
        KtValueArgument lastArgument = (KtValueArgument)CollectionsKt.lastOrNull(list2);
        if (lastArgument != null && PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)lastArgument))) {
            PsiElement psiElement3 = PsiUtilsKt.getPrevSiblingIgnoringWhitespace$default((PsiElement)lastArgument, false, 1, null);
            if (psiElement3 == null) {
                psiElement3 = lPar;
            }
            PsiElement prev2 = psiElement3;
            int offset2 = PsiUtilsKt.getEndOffset(prev2);
            if (Intrinsics.areEqual((Object)prev2, (Object)lPar)) {
                editor2.getDocument().insertString(offset2, (CharSequence)")");
                editor2.getCaretModel().moveToOffset(offset2);
            } else {
                editor2.getDocument().insertString(offset2, (CharSequence)" )");
                editor2.getCaretModel().moveToOffset(offset2 + 1);
            }
        } else {
            int offset3 = PsiUtilsKt.getEndOffset(element3);
            editor2.getDocument().insertString(offset3, (CharSequence)")");
            editor2.getCaretModel().moveToOffset(offset3 + 1);
        }
    }
}

