/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinBasicStepMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isInvoke", "", "targetMethodName", "", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "(Lcom/intellij/psi/SmartPsiElementPointer;ZLjava/lang/String;Lcom/intellij/util/Range;)V", "getCallingExpressionLines", "getMethodName", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "idea-jvm"})
public final class KotlinBasicStepMethodFilter
implements NamedMethodFilter {
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;
    private final boolean isInvoke;
    private final String targetMethodName;
    private final Range<Integer> myCallingExpressionLines;

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @NotNull
    public String getMethodName() {
        return this.targetMethodName;
    }

    /*
     * WARNING - void declaration
     */
    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        boolean bl;
        block10: {
            void currentDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            Method method = location2.method();
            if (Intrinsics.areEqual((Object)this.targetMethodName, (Object)method.name()) ^ true) {
                return false;
            }
            CompoundPositionManager compoundPositionManager = process2.getPositionManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)compoundPositionManager, (String)"process.positionManager");
            CompoundPositionManager positionManager = compoundPositionManager;
            Pair pair2 = (Pair)ApplicationUtilsKt.runReadAction((Function0)new Function0<Pair<? extends DeclarationDescriptor, ? extends KtDeclaration>>(positionManager, location2, method){
                final /* synthetic */ CompoundPositionManager $positionManager;
                final /* synthetic */ Location $location;
                final /* synthetic */ Method $method;

                @NotNull
                public final Pair<DeclarationDescriptor, KtDeclaration> invoke() {
                    Pair pair2;
                    KtDeclaration declaration2;
                    PsiElement elementAt;
                    SourcePosition sourcePosition = this.$positionManager.getSourcePosition(this.$location);
                    PsiElement psiElement2 = elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
                    KtDeclaration ktDeclaration = declaration2 = psiElement2 != null ? (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate(psiElement2, false, new Class[]{KtDeclaration.class}, locationMatches.declaration.1.INSTANCE) : null;
                    if (declaration2 instanceof KtClass && Intrinsics.areEqual((Object)this.$method.name(), (Object)"<init>")) {
                        ClassDescriptor classDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)declaration2, null, 1, null);
                        pair2 = TuplesKt.to((Object)(classDescriptor2 != null ? classDescriptor2.getUnsubstitutedPrimaryConstructor() : null), (Object)declaration2);
                    } else {
                        KtDeclaration ktDeclaration2 = declaration2;
                        pair2 = TuplesKt.to((Object)(ktDeclaration2 != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktDeclaration2, null, 1, null) : null), (Object)declaration2);
                    }
                    return pair2;
                }
                {
                    this.$positionManager = compoundPositionManager;
                    this.$location = location2;
                    this.$method = method;
                    super(0);
                }
            });
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)pair2.component1();
            KtDeclaration currentDeclaration = (KtDeclaration)pair2.component2();
            if (currentDescriptor == null || currentDeclaration == null) {
                return false;
            }
            if (!(currentDescriptor instanceof CallableMemberDescriptor)) {
                return false;
            }
            if (((CallableMemberDescriptor)currentDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                return false;
            }
            if (this.isInvoke) {
                return true;
            }
            Object object = this.declarationPtr;
            if (object == null || (object = (KtDeclaration)object.getElement()) == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull(object, (String)"declarationPtr?.element\n\u2026           ?: return true");
            Object declaration2 = object;
            if (currentDeclaration.isEquivalentTo((PsiElement)declaration2)) {
                return true;
            }
            Set<CallableDescriptor> set2 = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)currentDescriptor);
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"DescriptorUtils.getAllOv\u2026iptors(currentDescriptor)");
            Iterable $this$any$iv = set2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor baseOfCurrent = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Project project = currentDeclaration.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"currentDeclaration.project");
                    CallableMemberDescriptor callableMemberDescriptor = baseOfCurrent;
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"baseOfCurrent");
                    PsiElement currentBaseDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, callableMemberDescriptor);
                    if (!declaration2.isEquivalentTo(currentBaseDeclaration)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    public KotlinBasicStepMethodFilter(@Nullable SmartPsiElementPointer<KtDeclaration> declarationPtr, boolean isInvoke, @NotNull String targetMethodName, @NotNull Range<Integer> myCallingExpressionLines) {
        Intrinsics.checkParameterIsNotNull((Object)targetMethodName, (String)"targetMethodName");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.declarationPtr = declarationPtr;
        this.isInvoke = isInvoke;
        this.targetMethodName = targetMethodName;
        this.myCallingExpressionLines = myCallingExpressionLines;
        boolean bl = this.declarationPtr != null || this.isInvoke;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

