/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.InterpreterUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.ValuesOrder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/FilterTraceInterpreter;", "Lcom/intellij/debugger/streams/trace/CallTraceInterpreter;", "predicateValueToAccept", "", "(Z)V", "extractPredicateValues", "", "", "filteringMap", "Lcom/sun/jdi/Value;", "resolve", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "call", "Lcom/intellij/debugger/streams/wrapper/StreamCall;", "value", "resolveValuesAfter", "Lcom/intellij/debugger/streams/trace/TraceElement;", "before", "resolveValuesBefore", "map", "idea-jvm"})
public final class FilterTraceInterpreter
implements CallTraceInterpreter {
    private final boolean predicateValueToAccept;

    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value2) {
        Value filteringMap;
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        if (!(value2 instanceof ArrayReference)) {
            throw (Throwable)new UnexpectedValueTypeException("array reference excepted, but actual: " + value2.type().name());
        }
        Value value3 = ((ArrayReference)value2).getValue(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)value3, (String)"value.getValue(0)");
        Map<Integer, TraceElement> before = this.resolveValuesBefore(value3);
        Value value4 = filteringMap = ((ArrayReference)value2).getValue(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)value4, (String)"filteringMap");
        Map<Integer, TraceElement> after = this.resolveValuesAfter(before, value4);
        return new ValuesOrder(call2, before, after);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, TraceElement> resolveValuesBefore(Value map2) {
        void keys2;
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(map2);
        ArrayReference arrayReference = mapRepresentation.component1();
        ArrayReference objects = mapRepresentation.component2();
        int n = 0;
        List result2 = new ArrayList();
        n = 0;
        int n2 = keys2.length();
        while (n < n2) {
            void i2;
            Value time = keys2.getValue((int)i2);
            Value value2 = objects.getValue((int)i2);
            if (!(time instanceof IntegerValue)) {
                throw (Throwable)new UnexpectedValueTypeException("time should be represented by integer value");
            }
            result2.add(new TraceElementImpl(((IntegerValue)time).value(), value2));
            ++i2;
        }
        return InterpreterUtil.INSTANCE.createIndexByTime(result2);
    }

    private final Map<Integer, TraceElement> resolveValuesAfter(Map<Integer, ? extends TraceElement> before, Value filteringMap) {
        Map<Integer, Boolean> predicateValues = this.extractPredicateValues(filteringMap);
        boolean bl = false;
        LinkedHashMap result2 = new LinkedHashMap();
        Map<Integer, ? extends TraceElement> map2 = before;
        boolean bl2 = false;
        Iterator<Map.Entry<Integer, ? extends TraceElement>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, ? extends TraceElement> entry;
            Map.Entry<Integer, ? extends TraceElement> entry2 = entry = iterator2.next();
            boolean bl3 = false;
            int beforeTime = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl3 = false;
            TraceElement element3 = entry2.getValue();
            Boolean predicateValue = predicateValues.get(beforeTime);
            if (!Intrinsics.areEqual((Object)predicateValue, (Object)this.predicateValueToAccept)) continue;
            ((Map)result2).put(beforeTime + 1, new TraceElementImpl(beforeTime + 1, element3.getValue()));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Boolean> extractPredicateValues(Value filteringMap) {
        void keys2;
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(filteringMap);
        ArrayReference arrayReference = mapRepresentation.component1();
        ArrayReference values = mapRepresentation.component2();
        int n = 0;
        Map result2 = new LinkedHashMap();
        n = 0;
        int n2 = keys2.length();
        while (n < n2) {
            void i2;
            Value time = keys2.getValue((int)i2);
            Value value2 = values.getValue((int)i2);
            if (!(time instanceof IntegerValue)) {
                throw (Throwable)new UnexpectedValueTypeException("time should be represented by integer value");
            }
            if (!(value2 instanceof BooleanValue)) {
                throw (Throwable)new UnexpectedValueTypeException("predicate value should be represented by boolean value");
            }
            result2.put(((IntegerValue)time).value(), ((BooleanValue)value2).value());
            ++i2;
        }
        return result2;
    }

    public FilterTraceInterpreter(boolean predicateValueToAccept) {
        this.predicateValueToAccept = predicateValueToAccept;
    }
}

