/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.collections;

import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.QualifierExpression;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.impl.StreamChainImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.collections.KotlinCollectionsTypeExtractor;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.impl.KotlinChainTransformerImpl;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/CollectionChainTransformer;", "Lcom/intellij/debugger/streams/psi/ChainTransformer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "transformer", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainTransformerImpl;", "isArray", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "transform", "Lcom/intellij/debugger/streams/wrapper/StreamChain;", "chainCalls", "", "context", "Lcom/intellij/psi/PsiElement;", "WrappedQualifier", "idea-jvm"})
public final class CollectionChainTransformer
implements ChainTransformer<KtCallExpression> {
    private final KotlinChainTransformerImpl transformer = new KotlinChainTransformerImpl(new KotlinCollectionsTypeExtractor());

    @NotNull
    public StreamChain transform(@NotNull List<? extends KtCallExpression> chainCalls, @NotNull PsiElement context2) {
        Intrinsics.checkParameterIsNotNull(chainCalls, (String)"chainCalls");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        StreamChain chain = this.transformer.transform(chainCalls, context2);
        if (this.isArray(KotlinPsiUtilKt.resolveType((KtExpression)CollectionsKt.first(chainCalls)))) {
            QualifierExpression qualifierExpression = chain.getQualifierExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifierExpression, (String)"chain.qualifierExpression");
            WrappedQualifier qualifier2 = new WrappedQualifier(qualifierExpression);
            return (StreamChain)new StreamChainImpl((QualifierExpression)qualifier2, chain.getIntermediateCalls(), chain.getTerminationCall(), chain.getContext());
        }
        return chain;
    }

    private final boolean isArray(@NotNull KotlinType $this$isArray) {
        return KotlinBuiltIns.isArray($this$isArray) || KotlinBuiltIns.isPrimitiveArray($this$isArray);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\f\u001a\u00020\rH\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/CollectionChainTransformer$WrappedQualifier;", "Lcom/intellij/debugger/streams/wrapper/QualifierExpression;", "qualifierExpression", "(Lcom/intellij/debugger/streams/wrapper/QualifierExpression;)V", "text", "", "getText", "()Ljava/lang/String;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getTypeAfter", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "idea-jvm"})
    private static final class WrappedQualifier
    implements QualifierExpression {
        private final QualifierExpression qualifierExpression;

        @NotNull
        public String getText() {
            return this.qualifierExpression.getText() + ".asIterable()";
        }

        public WrappedQualifier(@NotNull QualifierExpression qualifierExpression) {
            Intrinsics.checkParameterIsNotNull((Object)qualifierExpression, (String)"qualifierExpression");
            this.qualifierExpression = qualifierExpression;
        }

        @NotNull
        public TextRange getTextRange() {
            return this.qualifierExpression.getTextRange();
        }

        @NotNull
        public GenericType getTypeAfter() {
            return this.qualifierExpression.getTypeAfter();
        }
    }
}

