/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder$WhenMappings;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 C2\u00020\u0001:\u0004CDEFB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020,H\u0002J4\u0010-\u001a\u0004\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002000/H\u0002J(\u0010-\u001a\u0004\u0018\u00010\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u000202H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u000204H\u0002J\"\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\u0010\u00107\u001a\u0002002\u0006\u0010#\u001a\u00020$H\u0002J\b\u00108\u001a\u000200H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;*\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010:\u001a\b\u0012\u0004\u0012\u00020<0;*\b\u0012\u0004\u0012\u00020=0\u00182\u0006\u0010>\u001a\u00020\u001cH\u0002J\u0016\u0010?\u001a\u000200*\u00020\u00112\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u0016\u0010B\u001a\u0004\u0018\u00010\n*\u00020<2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;)V", "evaluatorValueConverter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "find", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "parameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "findCapturedVariable", "kind", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "parentFactory", "Lkotlin/Function0;", "Lcom/sun/jdi/Value;", "parent", "findCapturedVariableInReceiver", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "findCoroutineContext", "findCoroutineContextForContinuation", "Lcom/sun/jdi/ObjectReference;", "continuation", "findCoroutineContextForLambda", "method", "Lcom/sun/jdi/Method;", "findCoroutineContextForMethod", "findDebugLabel", "name", "", "findDispatchThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "findExtensionThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "findFieldVariable", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "findLocalFunction", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "findLocalVariable", "namePredicate", "Lkotlin/Function1;", "", "findOrdinary", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "findUnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "getUnwrapDelegate", "valueFactory", "isCapturedReceiverFieldName", "isInsideDefaultImpls", "thisObject", "namedEntitySequence", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "Lcom/sun/jdi/Field;", "owner", "typeMatches", "actualType", "Lcom/sun/jdi/Type;", "unwrapAndCheck", "Companion", "NamedEntity", "Result", "VariableKind", "idea-jvm"})
public final class VariableFinder {
    private final StackFrameProxyImpl frameProxy;
    private final EvaluatorValueConverter evaluatorValueConverter;
    private final ExecutionContext context;
    private static final boolean USE_UNSAFE_FALLBACK = true;
    @NotNull
    private static final Type CONTINUATION_TYPE;
    @NotNull
    private static final List<String> SUSPEND_LAMBDA_CLASSES;
    @NotNull
    private static final Regex inlinedThisRegex;
    public static final Companion Companion;

    @Nullable
    public final Result find(@NotNull CodeFragmentParameter parameter, @NotNull Type asmType) {
        Result result2;
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
        switch (VariableFinder$WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                result2 = this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, false));
                break;
            }
            case 2: {
                result2 = this.findOrdinary(new VariableKind.Ordinary(parameter.getName(), asmType, true));
                break;
            }
            case 3: {
                ObjectReference objectReference = this.thisObject();
                if (objectReference != null) {
                    ObjectReference objectReference2 = objectReference;
                    boolean bl = false;
                    boolean bl2 = false;
                    ObjectReference it = objectReference2;
                    boolean bl3 = false;
                    result2 = new Result(it);
                    break;
                }
                result2 = null;
                break;
            }
            case 4: {
                result2 = this.findExtensionThis(new VariableKind.ExtensionThis(parameter.getName(), asmType));
                break;
            }
            case 5: {
                result2 = this.findLocalFunction(new VariableKind.LocalFunction(parameter.getName(), asmType));
                break;
            }
            case 6: {
                result2 = this.findDispatchThis(new VariableKind.OuterClassThis(asmType));
                break;
            }
            case 7: {
                result2 = this.findCoroutineContext();
                break;
            }
            case 8: {
                result2 = this.findFieldVariable(new VariableKind.FieldVar(parameter.getName(), asmType));
                break;
            }
            case 9: {
                result2 = this.findDebugLabel(parameter.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result2;
    }

    private final Result findOrdinary(VariableKind.Ordinary kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName());
        if (result2 != null) {
            Result result3 = result2;
            boolean bl = false;
            boolean bl2 = false;
            Result it = result3;
            boolean bl3 = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result result5 = result4;
            boolean bl = false;
            boolean bl4 = false;
            Result it = result5;
            boolean bl5 = false;
            return it;
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable((VariableKind)kind2, containingThis);
    }

    private final Result findFieldVariable(VariableKind.FieldVar kind2) {
        ObjectReference thisObject = this.thisObject();
        if (thisObject != null) {
            Field field2 = thisObject.referenceType().fieldByName(kind2.getFieldName());
            if (field2 == null) {
                return null;
            }
            Field field3 = field2;
            return new Result(thisObject.getValue(field3));
        }
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return null;
        }
        Comparable<Location> containingType = comparable;
        Field field4 = containingType.fieldByName(kind2.getFieldName());
        if (field4 == null) {
            return null;
        }
        Field field5 = field4;
        return new Result(containingType.getValue(field5));
    }

    private final Result findLocalFunction(VariableKind.LocalFunction kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        String newConventionName = "$fun$" + kind2.getName();
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, newConventionName);
        if (result2 != null) {
            Result result3 = result2;
            boolean bl = false;
            boolean bl2 = false;
            Result it = result3;
            boolean bl3 = false;
            return it;
        }
        Result result4 = this.findLocalVariable(variables, (VariableKind)kind2, kind2.getName() + "$");
        if (result4 != null) {
            Result result5 = result4;
            boolean bl = false;
            boolean bl4 = false;
            Result it = result5;
            boolean bl5 = false;
            return it;
        }
        Result result6 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result6 != null) {
            Result result7 = result6;
            boolean bl = false;
            boolean bl6 = false;
            Result it = result7;
            boolean bl7 = false;
            return it;
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable((VariableKind)kind2, containingThis);
    }

    private final Result findExtensionThis(VariableKind.ExtensionThis kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Function1 namePredicate2 = (Function1)new Function1<String, Boolean>(kind2){
            final /* synthetic */ VariableKind.ExtensionThis $kind;

            public final boolean invoke(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)this.$kind.getParameterName()) || StringsKt.startsWith$default((String)name2, (String)(this.$kind.getParameterName() + '$'), (boolean)false, (int)2, null);
            }
            {
                this.$kind = extensionThis;
                super(1);
            }
        };
        Result result2 = this.findLocalVariable(variables, (VariableKind)kind2, (Function1<? super String, Boolean>)namePredicate2);
        if (result2 != null) {
            Result result3 = result2;
            boolean bl = false;
            boolean bl2 = false;
            Result it = result3;
            boolean bl3 = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result4 != null) {
            Result result5 = result4;
            boolean bl = false;
            boolean bl4 = false;
            Result it = result5;
            boolean bl5 = false;
            return it;
        }
        ObjectReference containingThis = this.thisObject();
        if (containingThis != null) {
            Result result6 = this.findCapturedVariable((VariableKind)kind2, containingThis);
            if (result6 != null) {
                Result result7 = result6;
                boolean bl = false;
                boolean bl6 = false;
                Result it = result7;
                boolean bl7 = false;
                return it;
            }
        }
        Result result8 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()));
        if (result8 != null) {
            Result result9 = result8;
            boolean bl = false;
            boolean bl8 = false;
            Result it = result9;
            boolean bl9 = false;
            return it;
        }
        return null;
    }

    private final Result findDispatchThis(VariableKind.OuterClassThis kind2) {
        int inlineDepth;
        List<LocalVariableProxyImpl> variables;
        ObjectReference containingThis = this.thisObject();
        if (containingThis != null) {
            Result result2 = this.findCapturedVariable((VariableKind)kind2, containingThis);
            if (result2 != null) {
                Result result3 = result2;
                boolean bl = false;
                boolean bl2 = false;
                Result it = result3;
                boolean bl3 = false;
                return it;
            }
        }
        if (this.isInsideDefaultImpls()) {
            variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
            Result result4 = this.findLocalVariable(variables, (VariableKind)kind2, "$this");
            if (result4 != null) {
                Result result5 = result4;
                boolean bl = false;
                boolean bl4 = false;
                Result it = result5;
                boolean bl5 = false;
                return it;
            }
        }
        if ((inlineDepth = Companion.getInlineDepth(variables = SafeUtilKt.safeVisibleVariables(this.frameProxy))) > 0) {
            Result result6 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, inlineDepth, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ int $inlineDepth;
                final /* synthetic */ VariableKind.OuterClassThis $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    CharSequence charSequence = it.getName();
                    Regex regex = VariableFinder.Companion.getInlinedThisRegex();
                    boolean bl = false;
                    return regex.matches(charSequence) && VariableFinder.Companion.getInlineDepth(it.getName()) == this.$inlineDepth && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$inlineDepth = n;
                    this.$kind = outerClassThis;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind.OuterClassThis $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = outerClassThis;
                    super(1);
                }
            })));
            if (result6 != null) {
                Result result7 = result6;
                boolean bl = false;
                boolean bl6 = false;
                Result it = result7;
                boolean bl7 = false;
                return it;
            }
        }
        Result result8 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()));
        if (result8 != null) {
            Result result9 = result8;
            boolean bl = false;
            boolean bl8 = false;
            Result it = result9;
            boolean bl9 = false;
            return it;
        }
        return null;
    }

    private final Result findDebugLabel(String name2) {
        Map<? extends Value, ValueMarkup> markupMap;
        Map<? extends Value, ValueMarkup> map2 = markupMap = DebugLabelPropertyDescriptorProvider.Companion.getMarkupMap(this.context.getDebugProcess());
        boolean bl = false;
        Iterator<Map.Entry<? extends Value, ValueMarkup>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<? extends Value, ValueMarkup> entry;
            Map.Entry<? extends Value, ValueMarkup> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            Value value2 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ValueMarkup markup = entry2.getValue();
            if (!Intrinsics.areEqual((Object)markup.getText(), (Object)name2)) continue;
            return new Result(value2);
        }
        return null;
    }

    private final Result findUnlabeledThis(VariableKind.UnlabeledThis kind2) {
        List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findCapturedVariableInReceiver(variables, kind2);
        if (result2 != null) {
            Result result3 = result2;
            boolean bl = false;
            boolean bl2 = false;
            Result it = result3;
            boolean bl3 = false;
            return it;
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable((VariableKind)kind2, containingThis);
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, String name2) {
        return this.findLocalVariable(variables, kind2, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(name2){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        }));
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2, Function1<? super String, Boolean> namePredicate2) {
        int inlineDepth = Companion.getInlineDepth(variables);
        if (inlineDepth > 0) {
            Function1 inlineAwareNamePredicate2 = (Function1)new Function1<String, Boolean>(namePredicate2){
                final /* synthetic */ Function1 $namePredicate;

                public final boolean invoke(@NotNull String name2) {
                    int endIndex;
                    Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                    int depth2 = 0;
                    int suffixLen = "$iv".length();
                    for (endIndex = name2.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
                        String string = name2;
                        int n = endIndex - suffixLen;
                        boolean bl = false;
                        String string2 = string.substring(n, endIndex);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        if (Intrinsics.areEqual((Object)string2, (Object)"$iv") ^ true) break;
                        ++depth2;
                    }
                    return (Boolean)this.$namePredicate.invoke((Object)StringsKt.take((String)name2, (int)endIndex));
                }
                {
                    this.$namePredicate = function1;
                    super(1);
                }
            };
            Result result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, inlineDepth, inlineAwareNamePredicate2, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ int $inlineDepth;
                final /* synthetic */ Function1 $inlineAwareNamePredicate;
                final /* synthetic */ VariableKind $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return (Boolean)this.$inlineAwareNamePredicate.invoke((Object)it.getName()) != false && VariableFinder.Companion.getInlineDepth(it.getName()) == this.$inlineDepth && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$inlineDepth = n;
                    this.$inlineAwareNamePredicate = function1;
                    this.$kind = variableKind;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result2 != null) {
                Result result3 = result2;
                boolean bl = false;
                boolean bl2 = false;
                Result it = result3;
                boolean bl3 = false;
                return it;
            }
        }
        Result result4 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, namePredicate2, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ Function1 $namePredicate;
            final /* synthetic */ VariableKind $kind;

            public final boolean invoke(@NotNull NamedEntity it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)this.$namePredicate.invoke((Object)it.getName()) != false && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
            }
            {
                this.this$0 = variableFinder;
                this.$namePredicate = function1;
                this.$kind = variableKind;
                super(1);
            }
        })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
            }
            {
                this.this$0 = variableFinder;
                this.$kind = variableKind;
                super(1);
            }
        })));
        if (result4 != null) {
            Result result5 = result4;
            boolean bl = false;
            boolean bl4 = false;
            Result it = result5;
            boolean bl5 = false;
            return it;
        }
        return null;
    }

    private final boolean isInsideDefaultImpls() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = comparable.declaringType()) == null) {
            return false;
        }
        Comparable<Location> declaringType = comparable;
        String string = declaringType.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"declaringType.name()");
        return StringsKt.endsWith$default((String)string, (String)"$DefaultImpls", (boolean)false, (int)2, null);
    }

    private final Result findCoroutineContext() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = SafeUtilKt.safeMethod(comparable)) == null) {
            return null;
        }
        Comparable<Location> method = comparable;
        ObjectReference objectReference = this.findCoroutineContextForLambda((Method)method);
        if (objectReference == null) {
            objectReference = this.findCoroutineContextForMethod((Method)method);
        }
        if (objectReference == null) {
            return null;
        }
        ObjectReference result2 = objectReference;
        return new Result(result2);
    }

    private final ObjectReference findCoroutineContextForLambda(Method method) {
        boolean bl;
        ObjectReference thisObject;
        block6: {
            if (Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") ^ true || Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;") ^ true) {
                return null;
            }
            ObjectReference objectReference = this.thisObject();
            if (objectReference == null) {
                return null;
            }
            thisObject = objectReference;
            ReferenceType thisType = thisObject.referenceType();
            Iterable $this$none$iv = SUSPEND_LAMBDA_CLASSES;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    ReferenceType referenceType = thisType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"thisType");
                    if (!DebuggerUtilKt.isSubtype((com.sun.jdi.Type)referenceType, it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.findCoroutineContextForContinuation(thisObject);
    }

    private final ObjectReference findCoroutineContextForMethod(Method method) {
        String string = method.signature();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.signature()");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)(CONTINUATION_TYPE.getDescriptor() + ")"), (boolean)false, (int)2, null)) {
            return null;
        }
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$continuation");
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = this.frameProxy.getValue(continuationVariable);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuation = objectReference;
        return this.findCoroutineContextForContinuation(continuation);
    }

    private final ObjectReference findCoroutineContextForContinuation(ObjectReference continuation) {
        Object object;
        block9: {
            block8: {
                Object v2;
                block7: {
                    ReferenceType referenceType = continuation.referenceType();
                    if (!(referenceType instanceof ClassType)) {
                        referenceType = null;
                    }
                    if ((object = (ClassType)referenceType) == null || (object = object.allInterfaces()) == null) break block8;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)Continuation.class.getName())) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                if ((object = (InterfaceType)v2) != null) break block9;
            }
            return null;
        }
        Object continuationType = object;
        List<Method> list2 = continuationType.methodsByName("getContext", "()Lkotlin/coroutines/CoroutineContext;");
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"continuationType\n       \u2026tines/CoroutineContext;\")");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        Value value2 = this.context.invokeMethod(continuation, getContextMethod, (List<? extends Value>)CollectionsKt.emptyList());
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        return (ObjectReference)value2;
    }

    private final Result findCapturedVariableInReceiver(List<? extends LocalVariableProxyImpl> variables, VariableKind kind2) {
        findCapturedVariableInReceiver.1 $fun$isReceiverOrPassedThis$1 = findCapturedVariableInReceiver.1.INSTANCE;
        if (kind2 instanceof VariableKind.ExtensionThis) {
            Result result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result2 != null) {
                Result result3 = result2;
                boolean bl = false;
                boolean bl2 = false;
                Result it = result3;
                boolean bl3 = false;
                return it;
            }
        }
        return (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables), (Function1)findCapturedVariableInReceiver.5.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
            {
                this.this$0 = variableFinder;
                this.$kind = variableKind;
                super(1);
            }
        })));
    }

    private final Result findCapturedVariable(VariableKind kind2, Function0<? extends Value> parentFactory) {
        Value parent2 = this.getUnwrapDelegate(kind2, parentFactory);
        return this.findCapturedVariable(kind2, parent2);
    }

    private final Result findCapturedVariable(VariableKind kind2, Value parent2) {
        Object object;
        boolean acceptsParentValue;
        boolean bl = acceptsParentValue = kind2 instanceof VariableKind.UnlabeledThis || kind2 instanceof VariableKind.OuterClassThis;
        if (parent2 != null && acceptsParentValue && this.typeMatches(kind2, parent2.type())) {
            return new Result(parent2);
        }
        Value value2 = parent2;
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        if ((object = (ObjectReference)value2) == null || (object = object.referenceType()) == null || (object = object.fields()) == null) {
            return null;
        }
        Object fields2 = object;
        if (!(kind2 instanceof VariableKind.OuterClassThis)) {
            Result result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result2 != null) {
                Result result3 = result2;
                boolean bl2 = false;
                boolean bl3 = false;
                Result it = result3;
                boolean bl4 = false;
                return it;
            }
            Result result4 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this){
                final /* synthetic */ VariableFinder this$0;

                public final boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$isCapturedReceiverFieldName(this.this$0, it.getName());
                }
                {
                    this.this$0 = variableFinder;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
                }
                {
                    this.this$0 = variableFinder;
                    this.$kind = variableKind;
                    super(1);
                }
            })));
            if (result4 != null) {
                Result result5 = result4;
                boolean bl5 = false;
                boolean bl6 = false;
                Result it = result5;
                boolean bl7 = false;
                return it;
            }
        }
        Result result6 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence((List<? extends Field>)fields2, (ObjectReference)parent2), (Function1)findCapturedVariable.7.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
            {
                this.this$0 = variableFinder;
                this.$kind = variableKind;
                super(1);
            }
        })));
        if (result6 != null) {
            Result result7 = result6;
            boolean bl8 = false;
            boolean bl9 = false;
            Result it = result7;
            boolean bl10 = false;
            return it;
        }
        return null;
    }

    private final Value getUnwrapDelegate(VariableKind kind2, Function0<? extends Value> valueFactory2) {
        Value rawValue = (Value)valueFactory2.invoke();
        if (!(kind2 instanceof VariableKind.Ordinary) || !((VariableKind.Ordinary)kind2).isDelegated()) {
            return rawValue;
        }
        Value value2 = rawValue;
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return rawValue;
        }
        ObjectReference delegateValue = objectReference;
        List<Method> list2 = delegateValue.referenceType().methodsByName("getValue", "()Ljava/lang/Object;");
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"delegateValue.referenceT\u2026, \"()Ljava/lang/Object;\")");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return rawValue;
        }
        Method getValueMethod = method;
        return this.context.invokeMethod(delegateValue, getValueMethod, (List<? extends Value>)CollectionsKt.emptyList());
    }

    private final boolean isCapturedReceiverFieldName(String name2) {
        String string = AsmUtil.getCapturedFieldName("this_");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCapturedFieldName(AsmUtil.LABELED_THIS_FIELD)");
        return StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"receiver$0");
    }

    private final boolean typeMatches(@NotNull VariableKind $this$typeMatches, com.sun.jdi.Type actualType) {
        if ($this$typeMatches instanceof VariableKind.Ordinary && ((VariableKind.Ordinary)$this$typeMatches).isDelegated()) {
            return true;
        }
        return this.evaluatorValueConverter.typeMatches($this$typeMatches.getAsmType(), actualType);
    }

    private final Result unwrapAndCheck(@NotNull NamedEntity $this$unwrapAndCheck, VariableKind kind2) {
        return this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, $this$unwrapAndCheck.getValue()), kind2.getAsmType());
    }

    private final Sequence<NamedEntity> namedEntitySequence(@NotNull List<? extends Field> $this$namedEntitySequence, ObjectReference owner) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<Field, NamedEntity>(owner){
            final /* synthetic */ ObjectReference $owner;

            @NotNull
            public final NamedEntity invoke(@NotNull Field it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, this.$owner);
            }
            {
                this.$owner = objectReference;
                super(1);
            }
        }));
    }

    private final Sequence<NamedEntity> namedEntitySequence(@NotNull List<? extends LocalVariableProxyImpl> $this$namedEntitySequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<LocalVariableProxyImpl, NamedEntity>(this){
            final /* synthetic */ VariableFinder this$0;

            @NotNull
            public final NamedEntity invoke(@NotNull LocalVariableProxyImpl it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, VariableFinder.access$getFrameProxy$p(this.this$0));
            }
            {
                this.this$0 = variableFinder;
                super(1);
            }
        }));
    }

    private final ObjectReference thisObject() {
        ObjectReference thisObjectFromEvaluation;
        Value value2 = this.context.getEvaluationContext().computeThisObject();
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        if ((thisObjectFromEvaluation = (ObjectReference)value2) != null) {
            return thisObjectFromEvaluation;
        }
        return this.frameProxy.thisObject();
    }

    public VariableFinder(@NotNull ExecutionContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.frameProxy = this.context.getFrameProxy();
        this.evaluatorValueConverter = new EvaluatorValueConverter(this.context);
    }

    static {
        Companion = new Companion(null);
        Type type2 = Type.getType(Continuation.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"AsmType.getType(Continuation::class.java)");
        CONTINUATION_TYPE = type2;
        SUSPEND_LAMBDA_CLASSES = CollectionsKt.listOf((Object[])new String[]{"kotlin.coroutines.jvm.internal.SuspendLambda", "kotlin.coroutines.jvm.internal.RestrictedSuspendLambda"});
        inlinedThisRegex = VariableFinder.Companion.getLocalVariableNameRegexInlineAware("this_");
    }

    public static final /* synthetic */ boolean access$typeMatches(VariableFinder $this, VariableKind $this$access_u24typeMatches, com.sun.jdi.Type actualType) {
        return $this.typeMatches($this$access_u24typeMatches, actualType);
    }

    public static final /* synthetic */ Result access$unwrapAndCheck(VariableFinder $this, NamedEntity $this$access_u24unwrapAndCheck, VariableKind kind2) {
        return $this.unwrapAndCheck($this$access_u24unwrapAndCheck, kind2);
    }

    public static final /* synthetic */ Result access$findCapturedVariable(VariableFinder $this, VariableKind kind2, Function0 parentFactory) {
        return $this.findCapturedVariable(kind2, (Function0<? extends Value>)parentFactory);
    }

    public static final /* synthetic */ boolean access$isCapturedReceiverFieldName(VariableFinder $this, String name2) {
        return $this.isCapturedReceiverFieldName(name2);
    }

    public static final /* synthetic */ StackFrameProxyImpl access$getFrameProxy$p(VariableFinder $this) {
        return $this.frameProxy;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0006\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "capturedNameMatches", "", "name", "", "ExtensionThis", "FieldVar", "LocalFunction", "Ordinary", "OuterClassThis", "UnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "idea-jvm"})
    public static abstract class VariableKind {
        @NotNull
        private final Type asmType;

        public abstract boolean capturedNameMatches(@NotNull String var1);

        @NotNull
        public final Type getAsmType() {
            return this.asmType;
        }

        private VariableKind(Type asmType) {
            this.asmType = asmType;
        }

        public /* synthetic */ VariableKind(Type asmType, DefaultConstructorMarker $constructor_marker) {
            this(asmType);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isDelegated", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Z)V", "capturedNameRegex", "Lkotlin/text/Regex;", "()Z", "getName", "()Ljava/lang/String;", "capturedNameMatches", "idea-jvm"})
        public static final class Ordinary
        extends VariableKind {
            private final Regex capturedNameRegex;
            @NotNull
            private final String name;
            private final boolean isDelegated;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean isDelegated() {
                return this.isDelegated;
            }

            public Ordinary(@NotNull String name2, @NotNull Type asmType, boolean isDelegated) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
                this.isDelegated = isDelegated;
                String string = AsmUtil.getCapturedFieldName(this.name);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCapturedFieldName(this.name)");
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(string);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getName", "()Ljava/lang/String;", "capturedNameMatches", "", "idea-jvm"})
        public static final class LocalFunction
        extends VariableKind {
            @NotNull
            private final String name;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)("$" + name2));
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public LocalFunction(@NotNull String name2, @NotNull Type asmType) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "idea-jvm"})
        public static final class UnlabeledThis
        extends VariableKind {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)name2, (Object)"receiver$0")) return true;
                String string = AsmUtil.getCapturedFieldName("this_");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCapturedFieldName(AsmUtil.LABELED_THIS_FIELD)");
                if (!StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null)) return false;
                return true;
            }

            public UnlabeledThis(@NotNull Type asmType) {
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "idea-jvm"})
        public static final class OuterClassThis
        extends VariableKind {
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return false;
            }

            public OuterClassThis(@NotNull Type asmType) {
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "fieldName", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldName", "()Ljava/lang/String;", "capturedNameMatches", "", "name", "idea-jvm"})
        public static final class FieldVar
        extends VariableKind {
            @NotNull
            private final String fieldName;

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return false;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            public FieldVar(@NotNull String fieldName, @NotNull Type asmType) {
                Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.fieldName = fieldName;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "label", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameRegex", "Lkotlin/text/Regex;", "fieldName", "getFieldName", "()Ljava/lang/String;", "getLabel", "parameterName", "getParameterName", "capturedNameMatches", "", "name", "idea-jvm"})
        public static final class ExtensionThis
        extends VariableKind {
            @NotNull
            private final String parameterName;
            @NotNull
            private final String fieldName;
            private final Regex capturedNameRegex;
            @NotNull
            private final String label;

            @NotNull
            public final String getParameterName() {
                return this.parameterName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public ExtensionThis(@NotNull String label2, @NotNull Type asmType) {
                Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
                Intrinsics.checkParameterIsNotNull((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.label = label2;
                String string = AsmUtil.getLabeledThisName(this.label, "$this$", "$receiver");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getLabeledThisName(label\u2026.RECEIVER_PARAMETER_NAME)");
                this.parameterName = string;
                String string2 = AsmUtil.getLabeledThisName(this.label, AsmUtil.getCapturedFieldName("this_"), "receiver$0");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getLabeledThisName(label\u2026.CAPTURED_RECEIVER_FIELD)");
                this.fieldName = string2;
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(this.fieldName);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "", "value", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/Value;)V", "getValue", "()Lcom/sun/jdi/Value;", "idea-jvm"})
    public static final class Result {
        @Nullable
        private final Value value;

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public Result(@Nullable Value value2) {
            this.value = value2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "", "name", "", "type", "Lcom/sun/jdi/Type;", "value", "Lkotlin/Function0;", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lcom/sun/jdi/Type;Lkotlin/jvm/functions/Function0;)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/sun/jdi/Type;", "getValue", "()Lkotlin/jvm/functions/Function0;", "Companion", "idea-jvm"})
    private static final class NamedEntity {
        @NotNull
        private final String name;
        @Nullable
        private final com.sun.jdi.Type type;
        @NotNull
        private final Function0<Value> value;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final com.sun.jdi.Type getType() {
            return this.type;
        }

        @NotNull
        public final Function0<Value> getValue() {
            return this.value;
        }

        public NamedEntity(@NotNull String name2, @Nullable com.sun.jdi.Type type2, @NotNull Function0<? extends Value> value2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull(value2, (String)"value");
            this.name = name2;
            this.type = type2;
            this.value = value2;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity$Companion;", "", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "variable", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "field", "Lcom/sun/jdi/Field;", "owner", "Lcom/sun/jdi/ObjectReference;", "idea-jvm"})
        public static final class Companion {
            @NotNull
            public final NamedEntity of(@NotNull Field field2, @NotNull ObjectReference owner) {
                Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
                Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
                String string = field2.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name()");
                return new NamedEntity(string, SafeUtilKt.safeType(field2), (Function0<? extends Value>)((Function0)new Function0<Value>(owner, field2){
                    final /* synthetic */ ObjectReference $owner;
                    final /* synthetic */ Field $field;

                    public final Value invoke() {
                        return this.$owner.getValue(this.$field);
                    }
                    {
                        this.$owner = objectReference;
                        this.$field = field2;
                        super(0);
                    }
                }));
            }

            @NotNull
            public final NamedEntity of(@NotNull LocalVariableProxyImpl variable2, @NotNull StackFrameProxyImpl frameProxy) {
                Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
                Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
                String string = variable2.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name()");
                return new NamedEntity(string, SafeUtilKt.safeType(variable2), (Function0<? extends Value>)((Function0)new Function0<Value>(frameProxy, variable2){
                    final /* synthetic */ StackFrameProxyImpl $frameProxy;
                    final /* synthetic */ LocalVariableProxyImpl $variable;

                    public final Value invoke() {
                        return this.$frameProxy.getValue(this.$variable);
                    }
                    {
                        this.$frameProxy = stackFrameProxyImpl;
                        this.$variable = localVariableProxyImpl;
                        super(0);
                    }
                }));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\bJ\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001a\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Companion;", "", "()V", "CONTINUATION_TYPE", "Lorg/jetbrains/org/objectweb/asm/Type;", "getCONTINUATION_TYPE", "()Lorg/jetbrains/org/objectweb/asm/Type;", "SUSPEND_LAMBDA_CLASSES", "", "", "getSUSPEND_LAMBDA_CLASSES", "()Ljava/util/List;", "USE_UNSAFE_FALLBACK", "", "inlinedThisRegex", "Lkotlin/text/Regex;", "getInlinedThisRegex", "()Lkotlin/text/Regex;", "getCapturedVariableNameRegex", "capturedName", "getInlineDepth", "", "variableName", "variables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "getLocalVariableNameRegexInlineAware", "name", "variableNotFound", "Ljava/lang/Exception;", "Lkotlin/Exception;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "message", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final Type getCONTINUATION_TYPE() {
            return CONTINUATION_TYPE;
        }

        @NotNull
        public final List<String> getSUSPEND_LAMBDA_CLASSES() {
            return SUSPEND_LAMBDA_CLASSES;
        }

        @NotNull
        public final Exception variableNotFound(@NotNull ExecutionContext context2, @NotNull String message2) {
            JvmClassName jvmClassName;
            boolean bl;
            Object object;
            GlobalSearchScope scope2;
            Location location2;
            block7: {
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                    StackFrameProxyImpl frameProxy = context2.getFrameProxy();
                    location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                    GlobalSearchScope globalSearchScope = context2.getDebugProcess().getSearchScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"context.debugProcess.searchScope");
                    scope2 = globalSearchScope;
                    object = location2;
                    if (object == null) break block6;
                    Location location3 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Location $this$run = location3;
                    bl = false;
                    object = "Location: " + $this$run.sourceName() + ':' + $this$run.lineNumber();
                    if (object != null) break block7;
                }
                object = "No location available";
            }
            Object locationText = object;
            Location location4 = location2;
            String sourceName = location4 != null ? location4.sourceName() : null;
            Object object2 = location2;
            if (object2 != null && (object2 = object2.declaringType()) != null && (object2 = object2.name()) != null && (object2 = StringsKt.replace$default((String)object2, (char)'.', (char)'/', (boolean)false, (int)4, null)) != null) {
                Object object3 = object2;
                boolean $this$run = false;
                bl = false;
                Object it = object3;
                boolean bl4 = false;
                jvmClassName = JvmClassName.byInternalName((String)it);
            } else {
                jvmClassName = null;
            }
            JvmClassName declaringTypeName = jvmClassName;
            KtFile sourceFile = sourceName != null && declaringTypeName != null ? DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(context2.getProject(), scope2, declaringTypeName, sourceName, location2) : null;
            String sourceFileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(sourceFile){
                final /* synthetic */ KtFile $sourceFile;

                @Nullable
                public final String invoke() {
                    KtFile ktFile2 = this.$sourceFile;
                    return ktFile2 != null ? ktFile2.getText() : null;
                }
                {
                    this.$sourceFile = ktFile2;
                    super(0);
                }
            });
            if (sourceName != null && sourceFileText2 != null) {
                Attachment attachments2 = AttachmentUtilsKt.mergeAttachments(new Attachment(sourceName, sourceFileText2), new Attachment("location.txt", (String)locationText));
                KotlinEvaluatorBuilderKt.getLOG().error(message2, new Attachment[]{attachments2});
            }
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)message2);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026valuateException(message)");
            return (Exception)((Object)evaluateException);
        }

        @NotNull
        public final Regex getInlinedThisRegex() {
            return inlinedThisRegex;
        }

        private final Regex getCapturedVariableNameRegex(String capturedName) {
            String escapedName = Regex.Companion.escape(capturedName);
            String escapedSuffix = Regex.Companion.escape("$inlined");
            return new Regex('^' + escapedName + "(?:" + escapedSuffix + ")?$");
        }

        private final Regex getLocalVariableNameRegexInlineAware(String name2) {
            String escapedName = Regex.Companion.escape(name2);
            String escapedSuffix = Regex.Companion.escape("$iv");
            return new Regex('^' + escapedName + "(?:" + escapedSuffix + ")*$");
        }

        /*
         * WARNING - void declaration
         */
        public final int getInlineDepth(@NotNull List<? extends LocalVariableProxyImpl> variables) {
            int n;
            Object v1;
            LocalVariableProxyImpl it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
            Iterable $this$filter$iv = variables;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LocalVariableProxyImpl)element$iv$iv;
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List inlineFunVariables = (List)destination$iv$iv;
            if (inlineFunVariables.isEmpty()) {
                return 0;
            }
            Iterable $this$maxBy$iv = inlineFunVariables;
            boolean $i$f$maxBy = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    LocalVariableProxyImpl it2 = (LocalVariableProxyImpl)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = it2.getVariable();
                    do {
                        Object e$iv = iterator$iv.next();
                        it = (LocalVariableProxyImpl)e$iv;
                        $i$a$-maxBy-VariableFinder$Companion$getInlineDepth$closestInlineFun$1 = false;
                        Comparable v$iv = it.getVariable();
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            LocalVariable closestInlineFun = ((LocalVariableProxyImpl)v1).getVariable();
            Iterable $this$count$iv = variables;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    LocalVariableProxyImpl it3 = (LocalVariableProxyImpl)element$iv;
                    boolean bl = false;
                    String string = it3.name();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                    if (!(StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null) && it3.getVariable().compareTo(closestInlineFun) > 0)) continue;
                    int n2 = ++count$iv;
                    boolean bl2 = false;
                    if (n2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int inlineLambdaDepth = n;
            int n3 = 0;
            int n4 = inlineFunVariables.size() - inlineLambdaDepth;
            boolean bl = false;
            return Math.max(n3, n4);
        }

        public final int getInlineDepth(@NotNull String variableName) {
            Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
            int depth2 = 0;
            int suffixLen = "$iv".length();
            for (int endIndex = variableName.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
                String string = variableName;
                int n = endIndex - suffixLen;
                boolean bl = false;
                String string2 = string.substring(n, endIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (Intrinsics.areEqual((Object)string2, (Object)"$iv") ^ true) break;
                ++depth2;
            }
            return depth2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

