/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AbstractAndroidClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AndroidOClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "()V", "isApplicable", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "resolveClassLoaderClass", "Lcom/sun/jdi/ClassType;", "idea-jvm"})
public final class AndroidOClassLoadingAdapter
extends AbstractAndroidClassLoadingAdapter {
    @Override
    public boolean isApplicable(@NotNull ExecutionContext context2, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
        boolean bl = false;
        boolean bl2 = false;
        ClassLoadingAdapter.Companion.ClassInfoForEvaluator $this$with = info2;
        boolean bl3 = false;
        return $this$with.isCompilingEvaluatorPreferred() && NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)context2.getDebugProcess());
    }

    private final ClassType resolveClassLoaderClass(ExecutionContext context2) {
        ClassType classType;
        try {
            ClassLoaderReference classLoader = context2.getClassLoader();
            ReferenceType referenceType = this.tryLoadClass(context2, "dalvik.system.InMemoryDexClassLoader", classLoader);
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            classType = (ClassType)referenceType;
        }
        catch (EvaluateException e) {
            classType = null;
        }
        return classType;
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext context2, @NotNull Collection<ClassToLoad> classes2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        ClassType classType = this.resolveClassLoaderClass(context2);
        if (classType == null) {
            String string = "InMemoryDexClassLoader class not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassType inMemoryClassLoaderClass = classType;
        Method method = inMemoryClassLoaderClass.concreteMethodByName("<init>", "(Ljava/nio/ByteBuffer;Ljava/lang/ClassLoader;)V");
        if (method == null) {
            String string = "Constructor method not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Method constructorMethod = method;
        byte[] byArray = this.dex(context2, classes2);
        if (byArray == null) {
            String string = "Can't dex classes";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] dexBytes = byArray;
        ArrayReference dexBytesMirror = this.mirrorOfByteArray(dexBytes, context2);
        ObjectReference dexByteBuffer = this.wrapToByteBuffer(dexBytesMirror, context2);
        ClassLoaderReference classLoader = context2.getClassLoader();
        List args = CollectionsKt.listOf((Object[])new ObjectReference[]{dexByteBuffer, classLoader});
        ObjectReference objectReference = context2.newInstance(inMemoryClassLoaderClass, constructorMethod, args);
        if (objectReference == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassLoaderReference");
        }
        ClassLoaderReference newClassLoader = (ClassLoaderReference)objectReference;
        context2.keepReference(newClassLoader);
        return newClassLoader;
    }
}

