/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.j2k.JavaToKotlinConverterFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\"\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010 \u001a\u00020!2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createFakeFileWithJavaContextElement", "Lorg/jetbrains/kotlin/psi/KtFile;", "funWithLocalVariables", "", "javaContext", "createPresentationCodeFragment", "fixImportIfNeeded", "import", "getDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getFrameInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "contextElement", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "initImports", "imports", "isContextAccepted", "", "supplyDebugInformation", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "Companion", "FrameInfo", "idea-jvm"})
public final class KotlinCodeFragmentFactory
extends CodeFragmentFactory {
    private static final Logger LOG;
    @NotNull
    private static final Key<DebuggerContextImpl> DEBUG_CONTEXT_FOR_TESTS;
    @NotNull
    private static final Key<KotlinDebuggerEvaluator.EvaluationType> EVALUATION_TYPE;
    @NotNull
    public static final String FAKE_JAVA_CONTEXT_FUNCTION_NAME = "_java_locals_debug_fun_";
    @NotNull
    public static final String FAKE_JAVA_THIS_NAME = "$this$_java_locals_debug_fun_";
    public static final Companion Companion;

    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project) {
        FunctionReference functionReference2;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement contextElement = Companion.getContextElement(context2);
        CodeFragmentKind codeFragmentKind = item.getKind();
        if (codeFragmentKind == null) {
            String string = "Code fragment kind should be set";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        switch (KotlinCodeFragmentFactory$WhenMappings.$EnumSwitchMapping$0[codeFragmentKind.ordinal()]) {
            case 1: {
                functionReference2 = createCodeFragment.constructor.1.INSTANCE;
                break;
            }
            case 2: {
                functionReference2 = createCodeFragment.constructor.2.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FunctionReference constructor2 = functionReference2;
        Function5 function5 = constructor2;
        String string = item.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.text");
        KtCodeFragment codeFragment = (KtCodeFragment)function5.invoke((Object)project, (Object)"fragment.kt", (Object)string, (Object)this.initImports(item.getImports()), (Object)contextElement);
        this.supplyDebugInformation(item, codeFragment, context2);
        codeFragment.putCopyableUserData(KtCodeFragment.Companion.getRUNTIME_TYPE_EVALUATOR(), new Function1<KtExpression, KotlinType>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinType invoke(@NotNull KtExpression expression2) {
                KotlinType kotlinType2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
                DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
                DebuggerContextImpl debuggerContext = debuggerContextImpl;
                DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                    kotlinType2 = null;
                } else {
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    AtomicReference<V> nameRef = new AtomicReference<V>();
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    if (progressIndicator == null) {
                        Intrinsics.throwNpe();
                    }
                    KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(nameRef, semaphore, expression2, debuggerContext, null, expression2, debuggerContext, progressIndicator){
                        final /* synthetic */ AtomicReference $nameRef;
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ KtExpression $expression;
                        final /* synthetic */ DebuggerContextImpl $debuggerContext;

                        protected void typeCalculationFinished(@Nullable KotlinType type2) {
                            this.$nameRef.set(type2);
                            this.$semaphore.up();
                        }
                        {
                            this.$nameRef = $captured_local_variable$0;
                            this.$semaphore = $captured_local_variable$1;
                            this.$expression = $captured_local_variable$2;
                            this.$debuggerContext = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                        }
                    };
                    DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
                    if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                        debugProcessImpl.invoke((DebuggerCommandImpl)worker2);
                    }
                    int n = 0;
                    int n2 = 50;
                    while (n <= n2) {
                        void i2;
                        ProgressManager.checkCanceled();
                        if (semaphore.waitFor(20L)) break;
                        ++i2;
                    }
                    kotlinType2 = (KotlinType)nameRef.get();
                }
                return kotlinType2;
            }
            {
                this.$project = project;
                super(1);
            }
        });
        if (contextElement != null && !(contextElement instanceof KtElement)) {
            codeFragment.putCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE(), new Function0<KtElement>(this, contextElement, project){
                final /* synthetic */ KotlinCodeFragmentFactory this$0;
                final /* synthetic */ PsiElement $contextElement;
                final /* synthetic */ Project $project;

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public final KtElement invoke() {
                    block11: {
                        block10: {
                            emptyFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, "", this.$contextElement);
                            v0 = DebuggerManagerEx.getInstanceEx((Project)this.$project);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"DebuggerManagerEx.getInstanceEx(project)");
                            v1 = v0.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"DebuggerManagerEx.getInstanceEx(project).context");
                            debuggerContext = v1;
                            debuggerSession = debuggerContext.getDebuggerSession();
                            if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                                v2 = ApplicationManager.getApplication();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ApplicationManager.getApplication()");
                                if (!v2.isUnitTestMode()) {
                                    KotlinCodeFragmentFactory.access$getLOG$cp().warn("Couldn't create fake context element for java file, debugger isn't paused on breakpoint");
                                    return emptyFile;
                                }
                            }
                            if ((frameDescriptor = KotlinCodeFragmentFactory.access$getFrameInfo(this.this$0, this.$contextElement, debuggerContext)) == null) {
                                v3 = debuggerContext.getSourcePosition();
                                KotlinCodeFragmentFactory.access$getLOG$cp().warn("Couldn't get info about 'this' and local variables for " + ((v4 = debuggerContext.getSourcePosition()) != null && (v4 = v4.getFile()) != null ? v4.getName() : null) + ':' + (v3 != null ? Integer.valueOf(v3.getLine()) : null));
                                return emptyFile;
                            }
                            v5 = frameDescriptor.getThisObject();
                            if (v5 == null) ** GOTO lbl-1000
                            var6_5 = v5;
                            var7_6 = false;
                            var8_9 = false;
                            it = var6_5;
                            $i$a$-let-KotlinCodeFragmentFactory$createCodeFragment$2$receiverTypeReference$1 = false;
                            v6 = it.type().name();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.type().name()");
                            v5 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$createKotlinProperty(KotlinCodeFragmentFactory.Companion, this.$project, "$this$_java_locals_debug_fun_", v6, it);
                            if (v5 != null) {
                                v7 = v5.getTypeReference();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v7 = null;
                            }
                            if ((v8 = (receiverTypeReference = v7)) == null) break block10;
                            var7_7 = v8;
                            var8_9 = false;
                            it = false;
                            it = var7_7;
                            $i$a$-let-KotlinCodeFragmentFactory$createCodeFragment$2$receiverTypeText$1 = false;
                            v8 = it.getText() + '.';
                            if (v8 != null) break block11;
                        }
                        v8 = "";
                    }
                    receiverTypeText = v8;
                    var8_10 = frameDescriptor.getVisibleVariables().entrySet();
                    var19_22 = KotlinCodeFragmentFactory.Companion;
                    $i$f$associate = false;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    $i$a$-let-KotlinCodeFragmentFactory$createCodeFragment$2$receiverTypeText$1 = $this$associate$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        var16_27 = destination$iv$iv;
                        it = (Map.Entry)element$iv$iv;
                        $i$a$-associate-KotlinCodeFragmentFactory$createCodeFragment$2$kotlinVariablesText$1 = false;
                        var17_28 = TuplesKt.to((Object)((LocalVariable)it.getKey()).name(), it.getValue());
                        var18_29 = false;
                        var16_27.put(var17_28.getFirst(), var17_28.getSecond());
                    }
                    var20_30 = destination$iv$iv;
                    kotlinVariablesText = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$kotlinVariablesAsText(var19_22, var20_30, this.$project);
                    fakeFunctionText = "fun " + receiverTypeText + "_java_locals_debug_fun_() {\n" + kotlinVariablesText + "\n}";
                    fakeFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, fakeFunctionText, this.$contextElement);
                    v9 = CollectionsKt.firstOrNull(fakeFile.getDeclarations());
                    if (!(v9 instanceof KtFunction)) {
                        v9 = null;
                    }
                    v10 = fakeContext = (v11 = (fakeFunction = (KtFunction)v9)) != null && (v11 = v11.getBodyBlockExpression()) != null && (v11 = v11.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)v11) : null;
                    return v10 != null ? (KtElement)v10 : (KtElement)emptyFile;
                }
                {
                    this.this$0 = kotlinCodeFragmentFactory;
                    this.$contextElement = psiElement2;
                    this.$project = project;
                    super(0);
                }
            });
        }
        return codeFragment;
    }

    private final void supplyDebugInformation(TextWithImports item, KtCodeFragment codeFragment, PsiElement context2) {
        XDebuggerEvaluator evaluator2;
        Project project = codeFragment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"codeFragment.project");
        Project project2 = project;
        DebugProcessImpl debugProcessImpl = this.getDebugProcess(project2, context2);
        if (debugProcessImpl == null) {
            return;
        }
        DebugProcessImpl debugProcess = debugProcessImpl;
        new DebugLabelPropertyDescriptorProvider(codeFragment, debugProcess).supplyDebugLabels();
        DebuggerSession debuggerSession = debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerSession, (String)"debugProcess.session");
        XDebugSession xDebugSession = debuggerSession.getXDebugSession();
        XDebuggerEvaluator xDebuggerEvaluator = xDebugSession != null && (xDebugSession = xDebugSession.getCurrentStackFrame()) != null ? xDebugSession.getEvaluator() : (evaluator2 = null);
        if (evaluator2 instanceof KotlinDebuggerEvaluator) {
            codeFragment.putUserData(EVALUATION_TYPE, (Object)((KotlinDebuggerEvaluator)evaluator2).getType(item));
        }
    }

    private final DebugProcessImpl getDebugProcess(Project project, PsiElement context2) {
        DebugProcessImpl debugProcessImpl;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            PsiElement psiElement2 = context2;
            debugProcessImpl = psiElement2 != null && (psiElement2 = (DebuggerContextImpl)psiElement2.getCopyableUserData(DEBUG_CONTEXT_FOR_TESTS)) != null ? psiElement2.getDebugProcess() : null;
        } else {
            DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
            DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
            debugProcessImpl = debuggerContextImpl.getDebugProcess();
        }
        return debugProcessImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final FrameInfo getFrameInfo(PsiElement contextElement, DebuggerContextImpl debuggerContext) {
        void frameInfo;
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl worker2 = new DebuggerCommandImpl(contextElement, debuggerContext, (Ref.ObjectRef)frameInfo, semaphore){
            final /* synthetic */ PsiElement $contextElement;
            final /* synthetic */ DebuggerContextImpl $debuggerContext;
            final /* synthetic */ Ref.ObjectRef $frameInfo;
            final /* synthetic */ Semaphore $semaphore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void action() {
                try {
                    Map map2;
                    StackFrame frame;
                    StackFrame stackFrame;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        PsiElement psiElement2 = this.$contextElement;
                        stackFrame = psiElement2 != null && (psiElement2 = (DebuggerContextImpl)psiElement2.getCopyableUserData(KotlinCodeFragmentFactory.Companion.getDEBUG_CONTEXT_FOR_TESTS())) != null && (psiElement2 = psiElement2.getFrameProxy()) != null ? psiElement2.getStackFrame() : null;
                    } else {
                        StackFrameProxyImpl stackFrameProxyImpl = this.$debuggerContext.getFrameProxy();
                        stackFrame = frame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
                    }
                    if (frame != null) {
                        Map<LocalVariable, Value> values;
                        Map<LocalVariable, Value> map3 = values = frame.getValues(frame.visibleVariables());
                        Intrinsics.checkExpressionValueIsNotNull(map3, (String)"values");
                        Map<LocalVariable, Value> $this$filterValues$iv = map3;
                        boolean $i$f$filterValues = false;
                        LinkedHashMap<LocalVariable, Value> result$iv = new LinkedHashMap<LocalVariable, Value>();
                        Map<LocalVariable, Value> map4 = $this$filterValues$iv;
                        boolean bl = false;
                        for (Map.Entry<LocalVariable, Value> entry$iv : map4.entrySet()) {
                            Value it = entry$iv.getValue();
                            boolean bl2 = false;
                            if (!(it != null)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        map2 = result$iv;
                    } else {
                        map2 = MapsKt.emptyMap();
                    }
                    Map visibleVariables = map2;
                    StackFrame stackFrame2 = frame;
                    this.$frameInfo.element = new FrameInfo(stackFrame2 != null ? stackFrame2.thisObject() : null, visibleVariables);
                }
                catch (AbsentInformationException absentInformationException) {
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                }
                finally {
                    this.$semaphore.up();
                }
            }
            {
                this.$contextElement = $captured_local_variable$0;
                this.$debuggerContext = $captured_local_variable$1;
                this.$frameInfo = $captured_local_variable$2;
                this.$semaphore = $captured_local_variable$3;
            }
        };
        DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
        if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
            debugProcessImpl.invoke(worker2);
        }
        int n = 0;
        int n2 = 50;
        while (n <= n2 && !semaphore.waitFor(20L)) {
            void i2;
            ++i2;
        }
        return (FrameInfo)frameInfo.element;
    }

    /*
     * WARNING - void declaration
     */
    private final String initImports(String imports2) {
        if (imports2 != null) {
            CharSequence charSequence = imports2;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)imports2, (String[])new String[]{KtCodeFragment.Companion.getIMPORT_SEPARATOR()}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (this.fixImportIfNeeded(it) == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it$iv$iv = string;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)KtCodeFragment.Companion.getIMPORT_SEPARATOR(), null, null, (int)0, null, null, (int)62, null);
            }
        }
        return null;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"[]");
            KotlinCodeFragmentFactory kotlinCodeFragmentFactory = this;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            return kotlinCodeFragmentFactory.fixImportIfNeeded(string4);
        }
        if (Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string) ^ true) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaCodeFragment kotlinCodeFragment = this.createCodeFragment(item, context2, project);
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)kotlinCodeFragment)) && kotlinCodeFragment instanceof KtExpressionCodeFragment) {
            KtImportList e2;
            PsiExpression psiExpression;
            try {
                psiExpression = PsiElementFactory.SERVICE.getInstance((Project)project).createExpressionFromText(item.getText(), context2);
            }
            catch (IncorrectOperationException e2) {
                psiExpression = null;
            }
            PsiExpression javaExpression = psiExpression;
            try {
                Object object;
                KtImportList ktImportList = ((KtExpressionCodeFragment)kotlinCodeFragment).importsAsImportList();
                if (ktImportList != null) {
                    e2 = ktImportList;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtImportList it = e2;
                    boolean bl3 = false;
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)it.getText());
                    if (!(psiFile instanceof PsiJavaFile)) {
                        psiFile = null;
                    }
                    PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                    object = psiJavaFile != null ? psiJavaFile.getImportList() : null;
                } else {
                    object = null;
                }
                e2 = object;
            }
            catch (IncorrectOperationException e3) {
                e2 = null;
            }
            KtImportList importList = e2;
            if (javaExpression != null && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)javaExpression))) {
                void convertedFragment;
                e2 = new Ref.ObjectRef();
                ((Ref.ObjectRef)e2).element = null;
                ApplicationUtilsKt.executeWriteCommand(project, "Convert java expression to kotlin in Evaluate Expression", (Function0<Unit>)((Function0)new Function0<Unit>(javaExpression, (PsiImportList)importList, (Ref.ObjectRef)convertedFragment, project, kotlinCodeFragment){
                    final /* synthetic */ PsiExpression $javaExpression;
                    final /* synthetic */ PsiImportList $importList;
                    final /* synthetic */ Ref.ObjectRef $convertedFragment;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JavaCodeFragment $kotlinCodeFragment;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        try {
                            String newImports;
                            void elementResults;
                            Result result2 = KotlinRefactoringUtilKt.convertToKotlin((PsiElement)this.$javaExpression);
                            if (result2 == null) {
                                return;
                            }
                            Result result3 = result2;
                            List<ElementResult> list2 = result3.component1();
                            ConverterContext conversionContext = result3.component3();
                            ElementResult elementResult = (ElementResult)CollectionsKt.singleOrNull((List)elementResults);
                            String newText2 = elementResult != null ? elementResult.getText() : null;
                            PsiImportList psiImportList = this.$importList;
                            String string = newImports = psiImportList != null ? KotlinRefactoringUtilKt.j2kText((PsiElement)psiImportList) : null;
                            if (newText2 != null) {
                                String string2 = ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"kotlinCodeFragment.name");
                                this.$convertedFragment.element = new KtExpressionCodeFragment(this.$project, string2, newText2, newImports, ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getContext());
                                AfterConversionPass afterConversionPass = new AfterConversionPass(this.$project, JavaToKotlinConverterFactory.INSTANCE.createPostProcessor(false));
                                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)this.$convertedFragment.element;
                                if (ktExpressionCodeFragment == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterConversionPass.run(ktExpressionCodeFragment, conversionContext, null);
                            }
                        }
                        catch (Throwable e) {
                            KotlinCodeFragmentFactory.access$getLOG$cp().error("Couldn't convert expression:\n`" + this.$javaExpression.getText() + '`', e);
                        }
                    }
                    {
                        this.$javaExpression = psiExpression;
                        this.$importList = psiImportList;
                        this.$convertedFragment = objectRef;
                        this.$project = project;
                        this.$kotlinCodeFragment = javaCodeFragment;
                        super(0);
                    }
                }));
                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)convertedFragment.element;
                return ktExpressionCodeFragment != null ? (JavaCodeFragment)ktExpressionCodeFragment : kotlinCodeFragment;
            }
        }
        return kotlinCodeFragment;
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this, contextElement){
            final /* synthetic */ KotlinCodeFragmentFactory this$0;
            final /* synthetic */ PsiElement $contextElement;

            public final boolean invoke() {
                boolean bl;
                if (this.$contextElement instanceof PsiCodeBlock) {
                    PsiElement psiElement2 = ((PsiCodeBlock)this.$contextElement).getContext();
                    bl = this.this$0.isContextAccepted((PsiElement)(psiElement2 != null ? psiElement2.getContext() : null));
                } else if (this.$contextElement == null) {
                    bl = false;
                } else {
                    Language language = this.$contextElement.getLanguage();
                    KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
                    if (Intrinsics.areEqual((Object)language, (Object)kotlinFileType.getLanguage())) {
                        bl = true;
                    } else {
                        Language language2 = this.$contextElement.getLanguage();
                        JavaFileType javaFileType = JavaFileType.INSTANCE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaFileType, (String)"JavaFileType.INSTANCE");
                        if (Intrinsics.areEqual((Object)language2, (Object)javaFileType.getLanguage())) {
                            Project project = this.$contextElement.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"contextElement.project");
                            GlobalSearchScope globalSearchScope = this.$contextElement.getResolveScope();
                            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"contextElement.resolveScope");
                            bl = KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
                        } else {
                            bl = false;
                        }
                    }
                }
                return bl;
            }
            {
                this.this$0 = kotlinCodeFragmentFactory;
                this.$contextElement = psiElement2;
                super(0);
            }
        });
    }

    @NotNull
    public KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    public KotlinEvaluatorBuilder getEvaluatorBuilder() {
        return KotlinEvaluatorBuilder.INSTANCE;
    }

    private final KtFile createFakeFileWithJavaContextElement(String funWithLocalVariables, PsiElement javaContext) {
        PsiJavaFile psiJavaFile;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        PsiFile psiFile = javaContext.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            psiFile = null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        StringBuilder sb = new StringBuilder();
        Object object2 = javaFile;
        if (object2 != null && (object2 = object2.getPackageName()) != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            Object object3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
            object2 = !StringsKt.isBlank((CharSequence)((CharSequence)object3)) ? object : null;
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                StringBuilder stringBuilder = sb.append("package ");
                Object object4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"it");
                stringBuilder.append(KtPsiUtilKt.quoteIfNeeded((String)object4)).append("\n");
            }
        }
        if ((psiJavaFile = javaFile) != null && (psiJavaFile = psiJavaFile.getImportList()) != null) {
            object = psiJavaFile;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl5 = false;
            Object object5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
            sb.append(object5.getText()).append("\n");
        }
        sb.append(funWithLocalVariables);
        Project project = javaContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"javaContext.project");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return ktPsiFactory.createAnalyzableFile("fakeFileForJavaContextInDebugger.kt", string, javaContext);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(this::class.java)");
        LOG = logger;
        Key key = Key.create((String)"DEBUG_CONTEXT_FOR_TESTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"DEBUG_CONTEXT_FOR_TESTS\")");
        DEBUG_CONTEXT_FOR_TESTS = key;
        Key key2 = Key.create((String)"DEBUG_EVALUATION_TYPE");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_EVALUATION_TYPE\")");
        EVALUATION_TYPE = key2;
    }

    public static final /* synthetic */ KtFile access$createFakeFileWithJavaContextElement(KotlinCodeFragmentFactory $this, String funWithLocalVariables, PsiElement javaContext) {
        return $this.createFakeFileWithJavaContextElement(funWithLocalVariables, javaContext);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ FrameInfo access$getFrameInfo(KotlinCodeFragmentFactory $this, PsiElement contextElement, DebuggerContextImpl debuggerContext) {
        return $this.getFrameInfo(contextElement, debuggerContext);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "", "thisObject", "Lcom/sun/jdi/Value;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getThisObject", "()Lcom/sun/jdi/Value;", "getVisibleVariables", "()Ljava/util/Map;", "idea-jvm"})
    private static final class FrameInfo {
        @Nullable
        private final Value thisObject;
        @NotNull
        private final Map<LocalVariable, Value> visibleVariables;

        @Nullable
        public final Value getThisObject() {
            return this.thisObject;
        }

        @NotNull
        public final Map<LocalVariable, Value> getVisibleVariables() {
            return this.visibleVariables;
        }

        public FrameInfo(@Nullable Value thisObject, @NotNull Map<LocalVariable, ? extends Value> visibleVariables) {
            Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
            this.thisObject = thisObject;
            this.visibleVariables = visibleVariables;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J \u0010\u001b\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$Companion;", "", "()V", "DEBUG_CONTEXT_FOR_TESTS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDEBUG_CONTEXT_FOR_TESTS", "()Lcom/intellij/openapi/util/Key;", "EVALUATION_TYPE", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerEvaluator$EvaluationType;", "getEVALUATION_TYPE", "FAKE_JAVA_CONTEXT_FUNCTION_NAME", "", "FAKE_JAVA_THIS_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "project", "Lcom/intellij/openapi/project/Project;", "variableName", "variableTypeName", "value", "Lcom/sun/jdi/Value;", "getContextElement", "Lcom/intellij/psi/PsiElement;", "elementAt", "kotlinVariablesAsText", "", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final Key<DebuggerContextImpl> getDEBUG_CONTEXT_FOR_TESTS() {
            return DEBUG_CONTEXT_FOR_TESTS;
        }

        @NotNull
        public final Key<KotlinDebuggerEvaluator.EvaluationType> getEVALUATION_TYPE() {
            return EVALUATION_TYPE;
        }

        @Nullable
        public final PsiElement getContextElement(@Nullable PsiElement elementAt) {
            int n;
            if (elementAt == null) {
                return null;
            }
            if (elementAt instanceof PsiCodeBlock) {
                PsiElement psiElement2 = ((PsiCodeBlock)elementAt).getContext();
                return this.getContextElement((PsiElement)(psiElement2 != null ? psiElement2.getContext() : null));
            }
            if (elementAt instanceof KtLightClass) {
                return this.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
            }
            PsiFile containingFile = elementAt.getContainingFile();
            if (containingFile instanceof PsiJavaFile) {
                return elementAt;
            }
            if (!(containingFile instanceof KtFile)) {
                return null;
            }
            if (elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) {
                PsiElement psiElement3 = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                n = psiElement3 != null ? psiElement3.getTextOffset() : elementAt.getTextOffset();
            } else {
                n = elementAt.getTextOffset();
            }
            int lineStartOffset = n;
            getContextElement.1 $fun$takeIfAcceptedAsCodeFragmentContext$1 = getContextElement.1.INSTANCE;
            KtElement ktElement = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)lineStartOffset, KtExpression.class, (boolean)false);
            if (ktElement != null && (ktElement = $fun$takeIfAcceptedAsCodeFragmentContext$1.invoke(ktElement)) != null) {
                KtElement ktElement2 = ktElement;
                boolean bl = false;
                boolean bl2 = false;
                KtElement it = ktElement2;
                boolean bl3 = false;
                return (PsiElement)CodeInsightUtils.getTopmostElementAtOffset((PsiElement)it, lineStartOffset, KtExpression.class);
            }
            KtElement ktElement3 = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
            if (ktElement3 != null && (ktElement3 = $fun$takeIfAcceptedAsCodeFragmentContext$1.invoke(ktElement3)) != null) {
                KtElement ktElement4 = ktElement3;
                boolean bl = false;
                boolean bl4 = false;
                KtElement it = ktElement4;
                boolean bl5 = false;
                return (PsiElement)it;
            }
            return (PsiElement)containingFile;
        }

        private final String kotlinVariablesAsText(@NotNull Map<String, ? extends Value> $this$kotlinVariablesAsText, Project project) {
            StringBuilder sb = new StringBuilder();
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)project);
            Iterator<Map.Entry<String, ? extends Value>> iterator2 = $this$kotlinVariablesAsText.entrySet().iterator();
            while (iterator2.hasNext()) {
                KtProperty kotlinProperty;
                Map.Entry<String, ? extends Value> entry;
                Map.Entry<String, ? extends Value> entry2 = entry = iterator2.next();
                boolean bl = false;
                String variableName = entry2.getKey();
                entry2 = entry;
                bl = false;
                Value variableValue = entry2.getValue();
                if (!psiNameHelper.isIdentifier(variableName)) continue;
                Object object = variableValue.type();
                if (object == null || (object = object.name()) == null) {
                    continue;
                }
                Object variableTypeName = object;
                if (this.createKotlinProperty(project, variableName, (String)variableTypeName, variableValue) == null) {
                    continue;
                }
                sb.append(kotlinProperty.getText() + '\n');
            }
            sb.append("val _debug_context_val = 1\n");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final KtProperty createKotlinProperty(Project project, String variableName, String variableTypeName, Value value2) {
            KtProperty ktField;
            block2: {
                KtElementImplStub ktElementImplStub;
                Type type2 = JdiValuesKt.asValue(value2).getAsmType();
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                ClassDescriptor actualClassDescriptor = KotlinEvaluatorBuilderKt.getClassDescriptor$default(type2, globalSearchScope, false, null, 6, null);
                if (actualClassDescriptor != null && actualClassDescriptor.getDefaultType().getArguments().isEmpty()) {
                    SimpleType simpleType2 = actualClassDescriptor.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"actualClassDescriptor.defaultType");
                    String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(TypeUtilsKt.makeNullable(simpleType2));
                    return new KtPsiFactory(project, false, 2, null).createProperty(KtPsiUtilKt.quoteIfNeeded(variableName), renderedType, false);
                }
                Function1<String, String> $fun$addArraySuffix$1 = new Function1<String, String>(value2){
                    final /* synthetic */ Value $value;

                    @NotNull
                    public final String invoke(@NotNull String $this$addArraySuffix) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$addArraySuffix, (String)"$this$addArraySuffix");
                        return this.$value instanceof ArrayReference ? $this$addArraySuffix + "[]" : $this$addArraySuffix;
                    }
                    {
                        this.$value = value2;
                        super(1);
                    }
                };
                String className2 = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)variableTypeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType psiClassType = PsiType.getTypeByName((String)className2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"PsiType.getTypeByName(cl\u2026hScope.allScope(project))");
                PsiClassType classType = psiClassType;
                String type3 = $fun$addArraySuffix$1.invoke(!(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className2);
                PsiField psiField = PsiElementFactory.SERVICE.getInstance((Project)project).createField(variableName, (PsiType)PsiType.getTypeByName((String)type3, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
                Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"PsiElementFactory.SERVIC\u2026Scope.allScope(project)))");
                PsiField field2 = psiField;
                KtNamedDeclaration ktNamedDeclaration = KotlinRefactoringUtilKt.j2k((PsiMember)field2);
                if (!(ktNamedDeclaration instanceof KtProperty)) {
                    ktNamedDeclaration = null;
                }
                if ((ktElementImplStub = (ktField = (KtProperty)ktNamedDeclaration)) == null || (ktElementImplStub = ((KtModifierListOwnerStub)ktElementImplStub).getModifierList()) == null) break block2;
                ktElementImplStub.delete();
            }
            return ktField;
        }

        private Companion() {
        }

        public static final /* synthetic */ KtProperty access$createKotlinProperty(Companion $this, Project project, String variableName, String variableTypeName, Value value2) {
            return $this.createKotlinProperty(project, variableName, variableTypeName, value2);
        }

        public static final /* synthetic */ String access$kotlinVariablesAsText(Companion $this, Map $this$access_u24kotlinVariablesAsText, Project project) {
            return $this.kotlinVariablesAsText($this$access_u24kotlinVariablesAsText, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

