/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.frame.XNamedValue;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.KotlinCoroutinesAsyncStackTraceProviderBase;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\rH\u0002J\u0014\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\rH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinCoroutinesAsyncStackTraceProvider;", "Lorg/jetbrains/kotlin/idea/debugger/KotlinCoroutinesAsyncStackTraceProviderBase;", "()V", "getAsyncStackTrace", "", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "stackFrame", "Lcom/intellij/debugger/engine/JavaStackFrame;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "collectFrames", "Lorg/jetbrains/kotlin/idea/debugger/KotlinCoroutinesAsyncStackTraceProvider$AsyncStackTraceContext;", "continuation", "Lcom/sun/jdi/ObjectReference;", "collectFramesRecursively", "", "consumer", "", "findClassSafe", "Lcom/sun/jdi/ClassType;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "className", "", "getAsyncStackTraceForSuspendFunction", "getAsyncStackTraceForSuspendLambda", "getLocation", "Lcom/sun/jdi/Location;", "getSpilledVariables", "Lcom/intellij/xdebugger/frame/XNamedValue;", "AsyncStackTraceContext", "Companion", "idea-jvm"})
public final class KotlinCoroutinesAsyncStackTraceProvider
implements KotlinCoroutinesAsyncStackTraceProviderBase {
    @NotNull
    public static final String DEBUG_METADATA_KT = "kotlin.coroutines.jvm.internal.DebugMetadataKt";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public List<StackFrameItem> getAsyncStackTrace(@NotNull JavaStackFrame stackFrame, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkParameterIsNotNull((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        StackFrameProxyImpl stackFrameProxyImpl = stackFrame.getStackFrameProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameProxyImpl, (String)"stackFrame.stackFrameProxy");
        return this.getAsyncStackTrace(stackFrameProxyImpl, suspendContext);
    }

    @Nullable
    public final List<StackFrameItem> getAsyncStackTrace(@NotNull StackFrameProxyImpl frameProxy, @NotNull SuspendContextImpl suspendContext) {
        Method method;
        block8: {
            block7: {
                Location location2;
                Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
                Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
                Location location3 = location2 = frameProxy.location();
                Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
                if (!DebuggerUtilKt.isInKotlinSources(location3)) {
                    return null;
                }
                Method method2 = SafeUtilKt.safeMethod(location2);
                if (method2 == null) {
                    return null;
                }
                method = method2;
                ThreadReferenceProxyImpl threadReferenceProxyImpl = frameProxy.threadProxy();
                Intrinsics.checkExpressionValueIsNotNull((Object)threadReferenceProxyImpl, (String)"frameProxy.threadProxy()");
                ThreadReference threadReference = threadReferenceProxyImpl.getThreadReference();
                if (threadReference == null || !threadReference.isSuspended()) break block7;
                DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
                Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
                if (DebuggerUtilKt.getCanRunEvaluation(debugProcessImpl)) break block8;
            }
            return null;
        }
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, frameProxy);
        ExecutionContext context2 = new ExecutionContext(evaluationContext, frameProxy);
        ClassType classType = this.findClassSafe(context2, DEBUG_METADATA_KT);
        if (classType == null) {
            return null;
        }
        ClassType debugMetadataKtType = classType;
        AsyncStackTraceContext asyncContext = new AsyncStackTraceContext(context2, method, debugMetadataKtType);
        List<StackFrameItem> list2 = this.getAsyncStackTraceForSuspendLambda(asyncContext);
        if (list2 == null) {
            list2 = this.getAsyncStackTraceForSuspendFunction(asyncContext);
        }
        return list2;
    }

    private final List<StackFrameItem> getAsyncStackTraceForSuspendLambda(@NotNull AsyncStackTraceContext $this$getAsyncStackTraceForSuspendLambda) {
        boolean bl;
        ObjectReference thisObject;
        block6: {
            if (Intrinsics.areEqual((Object)$this$getAsyncStackTraceForSuspendLambda.getMethod().name(), (Object)"invokeSuspend") ^ true || Intrinsics.areEqual((Object)$this$getAsyncStackTraceForSuspendLambda.getMethod().signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;") ^ true) {
                return null;
            }
            ObjectReference objectReference = $this$getAsyncStackTraceForSuspendLambda.getContext().getFrameProxy().thisObject();
            if (objectReference == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)objectReference, (String)"context.frameProxy.thisObject() ?: return null");
            thisObject = objectReference;
            ReferenceType thisType = thisObject.referenceType();
            Iterable $this$none$iv = VariableFinder.Companion.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    ReferenceType referenceType = thisType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"thisType");
                    if (!DebuggerUtilKt.isSubtype((Type)referenceType, it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.collectFrames($this$getAsyncStackTraceForSuspendLambda, thisObject);
    }

    private final List<StackFrameItem> getAsyncStackTraceForSuspendFunction(@NotNull AsyncStackTraceContext $this$getAsyncStackTraceForSuspendFunction) {
        String string = $this$getAsyncStackTraceForSuspendFunction.getMethod().signature();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.signature()");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null)) {
            return null;
        }
        StackFrameProxyImpl frameProxy = $this$getAsyncStackTraceForSuspendFunction.getContext().getFrameProxy();
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(frameProxy, "$continuation");
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = frameProxy.getValue(continuationVariable);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuation = objectReference;
        return this.collectFrames($this$getAsyncStackTraceForSuspendFunction, continuation);
    }

    private final List<StackFrameItem> collectFrames(@NotNull AsyncStackTraceContext $this$collectFrames, ObjectReference continuation) {
        boolean bl = false;
        List frames2 = new ArrayList();
        this.collectFramesRecursively($this$collectFrames, continuation, frames2);
        return frames2;
    }

    private final void collectFramesRecursively(@NotNull AsyncStackTraceContext $this$collectFramesRecursively, ObjectReference continuation, List<StackFrameItem> consumer2) {
        List spilledVariables;
        ReferenceType referenceType = continuation.referenceType();
        if (!(referenceType instanceof ClassType)) {
            referenceType = null;
        }
        ClassType classType = (ClassType)referenceType;
        if (classType == null) {
            return;
        }
        ClassType continuationType = classType;
        ClassType classType2 = Companion.findBaseContinuationSuperSupertype(continuationType);
        if (classType2 == null) {
            return;
        }
        ClassType baseContinuationSupertype = classType2;
        Location location2 = this.getLocation($this$collectFramesRecursively, continuation);
        List list2 = this.getSpilledVariables($this$collectFramesRecursively, continuation);
        if (list2 == null) {
            list2 = spilledVariables = CollectionsKt.emptyList();
        }
        if (location2 != null) {
            Collection collection = consumer2;
            StackFrameItem stackFrameItem = new StackFrameItem(location2, spilledVariables);
            boolean bl = false;
            collection.add(stackFrameItem);
        }
        Field field2 = baseContinuationSupertype.fieldByName("completion");
        if (field2 == null) {
            return;
        }
        Field completionField = field2;
        Value value2 = continuation.getValue(completionField);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return;
        }
        ObjectReference completion = objectReference;
        this.collectFramesRecursively($this$collectFramesRecursively, completion, consumer2);
    }

    private final Location getLocation(@NotNull AsyncStackTraceContext $this$getLocation, ObjectReference continuation) {
        Comparable<IntegerValue> comparable;
        Object methodName2;
        Object className2;
        block14: {
            block13: {
                Object object;
                Object object2;
                List<Method> list2 = $this$getLocation.getDebugMetadataKtType().methodsByName("getStackTraceElement", "(Lkotlin/coroutines/jvm/internal/BaseContinuationImpl;)Ljava/lang/StackTraceElement;");
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"debugMetadataKtType.meth\u2026kTraceElement;\"\n        )");
                Method method = (Method)CollectionsKt.firstOrNull(list2);
                if (method == null) {
                    return null;
                }
                Method getStackTraceElementMethod = method;
                List args = CollectionsKt.listOf((Object)continuation);
                Value value2 = $this$getLocation.getContext().invokeMethod($this$getLocation.getDebugMetadataKtType(), getStackTraceElementMethod, (List<? extends Value>)args);
                if (!(value2 instanceof ObjectReference)) {
                    value2 = null;
                }
                ObjectReference objectReference = (ObjectReference)value2;
                if (objectReference == null) {
                    return null;
                }
                ObjectReference stackTraceElement = objectReference;
                ReferenceType referenceType = stackTraceElement.referenceType();
                boolean bl = false;
                boolean bl2 = false;
                ReferenceType it = referenceType;
                boolean $i$a$-takeIf-KotlinCoroutinesAsyncStackTraceProvider$getLocation$stackTraceElementType$22 = false;
                ReferenceType referenceType2 = Intrinsics.areEqual((Object)it.name(), (Object)StackTraceElement.class.getName()) ? referenceType : null;
                if (referenceType2 == null) {
                    return null;
                }
                ReferenceType stackTraceElementType = referenceType2;
                Function2<String, String, Value> $fun$getValue$1 = new Function2<String, String, Value>($this$getLocation, stackTraceElementType, stackTraceElement){
                    final /* synthetic */ AsyncStackTraceContext $this_getLocation;
                    final /* synthetic */ ReferenceType $stackTraceElementType;
                    final /* synthetic */ ObjectReference $stackTraceElement;

                    @Nullable
                    public final Value invoke(@NotNull String name2, @NotNull String desc2) {
                        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)desc2, (String)"desc");
                        List<Method> list2 = this.$stackTraceElementType.methodsByName(name2, desc2);
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"stackTraceElementType.methodsByName(name, desc)");
                        Method method = (Method)CollectionsKt.single(list2);
                        ExecutionContext executionContext = this.$this_getLocation.getContext();
                        Method method2 = method;
                        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                        return executionContext.invokeMethod(this.$stackTraceElement, method2, (List<? extends Value>)CollectionsKt.emptyList());
                    }
                    {
                        this.$this_getLocation = asyncStackTraceContext;
                        this.$stackTraceElementType = referenceType;
                        this.$stackTraceElement = objectReference;
                        super(2);
                    }
                };
                Value value3 = $fun$getValue$1.invoke("getClassName", "()Ljava/lang/String;");
                if (!(value3 instanceof StringReference)) {
                    value3 = null;
                }
                if ((object2 = (StringReference)value3) == null || (object2 = object2.value()) == null) {
                    return null;
                }
                className2 = object2;
                Value value4 = $fun$getValue$1.invoke("getMethodName", "()Ljava/lang/String;");
                if (!(value4 instanceof StringReference)) {
                    value4 = null;
                }
                if ((object = (StringReference)value4) == null || (object = object.value()) == null) {
                    return null;
                }
                methodName2 = object;
                Value value5 = $fun$getValue$1.invoke("getLineNumber", "()I");
                if (!(value5 instanceof IntegerValue)) {
                    value5 = null;
                }
                if ((comparable = (IntegerValue)value5) == null) break block13;
                Integer $i$a$-takeIf-KotlinCoroutinesAsyncStackTraceProvider$getLocation$stackTraceElementType$22 = comparable.value();
                boolean bl3 = false;
                boolean bl4 = false;
                int it2 = ((Number)$i$a$-takeIf-KotlinCoroutinesAsyncStackTraceProvider$getLocation$stackTraceElementType$22).intValue();
                boolean bl5 = false;
                comparable = it2 >= 0 ? $i$a$-takeIf-KotlinCoroutinesAsyncStackTraceProvider$getLocation$stackTraceElementType$22 : null;
                if (comparable != null) break block14;
            }
            return null;
        }
        int lineNumber = (Integer)comparable;
        ClassType classType = this.findClassSafe($this$getLocation.getContext(), (String)className2);
        if (classType == null) {
            return null;
        }
        ClassType locationClass = classType;
        return (Location)new GeneratedLocation($this$getLocation.getContext().getDebugProcess(), (ReferenceType)locationClass, (String)methodName2, lineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final List<XNamedValue> getSpilledVariables(@NotNull AsyncStackTraceContext $this$getSpilledVariables, ObjectReference continuation) {
        List<Method> list2 = $this$getSpilledVariables.getDebugMetadataKtType().methodsByName("getSpilledVariableFieldMapping", "(Lkotlin/coroutines/jvm/internal/BaseContinuationImpl;)[Ljava/lang/String;");
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"debugMetadataKtType.meth\u2026a/lang/String;\"\n        )");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return null;
        }
        Method getSpilledVariableFieldMappingMethod = method;
        List args = CollectionsKt.listOf((Object)continuation);
        Value value2 = $this$getSpilledVariables.getContext().invokeMethod($this$getSpilledVariables.getDebugMetadataKtType(), getSpilledVariableFieldMappingMethod, (List<? extends Value>)args);
        if (!(value2 instanceof ArrayReference)) {
            value2 = null;
        }
        ArrayReference arrayReference = (ArrayReference)value2;
        if (arrayReference == null) {
            return null;
        }
        ArrayReference rawSpilledVariables = arrayReference;
        int length = rawSpilledVariables.length() / 2;
        ArrayList spilledVariables = new ArrayList(length);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            Object object;
            void index2;
            Value value3 = rawSpilledVariables.getValue(2 * index2);
            if (!(value3 instanceof StringReference)) {
                value3 = null;
            }
            if ((object = (StringReference)value3) == null || (object = object.value()) == null) {
            } else {
                Object object2;
                Object fieldName = object;
                Value value4 = rawSpilledVariables.getValue(2 * index2 + 1);
                if (!(value4 instanceof StringReference)) {
                    value4 = null;
                }
                if ((object2 = (StringReference)value4) == null || (object2 = object2.value()) == null) {
                } else {
                    Object variableName = object2;
                    if (continuation.referenceType().fieldByName((String)fieldName) == null) {
                    } else {
                        Field field2;
                        ValueDescriptorImpl valueDescriptor2 = new ValueDescriptorImpl($this$getSpilledVariables, (String)variableName, continuation, field2, $this$getSpilledVariables.getContext().getProject()){
                            final /* synthetic */ AsyncStackTraceContext $this_getSpilledVariables;
                            final /* synthetic */ String $variableName;
                            final /* synthetic */ ObjectReference $continuation;
                            final /* synthetic */ Field $field;

                            @NotNull
                            public String calcValueName() {
                                return this.$variableName;
                            }

                            public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
                                return this.$continuation.getValue(this.$field);
                            }

                            @NotNull
                            public Void getDescriptorEvaluation(@Nullable DebuggerContext context2) {
                                throw (Throwable)new EvaluateException("Spilled variable evaluation is not supported");
                            }
                            {
                                this.$this_getSpilledVariables = $receiver;
                                this.$variableName = $captured_local_variable$1;
                                this.$continuation = $captured_local_variable$2;
                                this.$field = $captured_local_variable$3;
                                super($super_call_param$4);
                            }
                        };
                        Collection collection = spilledVariables;
                        ValueDescriptorImpl valueDescriptorImpl = valueDescriptor2;
                        EvaluationContextImpl evaluationContextImpl = $this$getSpilledVariables.getContext().getEvaluationContext();
                        JavaDebugProcess javaDebugProcess = $this$getSpilledVariables.getContext().getDebugProcess().getXdebugProcess();
                        if (javaDebugProcess == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaDebugProcess, (String)"context.debugProcess.xdebugProcess!!");
                        JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)valueDescriptorImpl, (EvaluationContextImpl)evaluationContextImpl, (NodeManagerImpl)javaDebugProcess.getNodeManager(), (boolean)false);
                        boolean bl = false;
                        collection.add(javaValue);
                    }
                }
            }
            ++index2;
        }
        return spilledVariables;
    }

    private final ClassType findClassSafe(@NotNull ExecutionContext $this$findClassSafe, String className2) {
        ClassType classType;
        try {
            ReferenceType referenceType = ExecutionContext.findClass$default($this$findClassSafe, className2, null, 2, null);
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            classType = (ClassType)referenceType;
        }
        catch (Throwable e) {
            classType = null;
        }
        return classType;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinCoroutinesAsyncStackTraceProvider$AsyncStackTraceContext;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "method", "Lcom/sun/jdi/Method;", "debugMetadataKtType", "Lcom/sun/jdi/ClassType;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lcom/sun/jdi/Method;Lcom/sun/jdi/ClassType;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "getDebugMetadataKtType", "()Lcom/sun/jdi/ClassType;", "getMethod", "()Lcom/sun/jdi/Method;", "idea-jvm"})
    private static final class AsyncStackTraceContext {
        @NotNull
        private final ExecutionContext context;
        @NotNull
        private final Method method;
        @NotNull
        private final ClassType debugMetadataKtType;

        @NotNull
        public final ExecutionContext getContext() {
            return this.context;
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        @NotNull
        public final ClassType getDebugMetadataKtType() {
            return this.debugMetadataKtType;
        }

        public AsyncStackTraceContext(@NotNull ExecutionContext context2, @NotNull Method method, @NotNull ClassType debugMetadataKtType) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)debugMetadataKtType, (String)"debugMetadataKtType");
            this.context = context2;
            this.method = method;
            this.debugMetadataKtType = debugMetadataKtType;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinCoroutinesAsyncStackTraceProvider$Companion;", "", "()V", "DEBUG_METADATA_KT", "", "findBaseContinuationSuperSupertype", "Lcom/sun/jdi/ClassType;", "type", "idea-jvm"})
    private static final class Companion {
        @Nullable
        public final ClassType findBaseContinuationSuperSupertype(@NotNull ClassType type2) {
            while (true) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                if (Intrinsics.areEqual((Object)type2.name(), (Object)"kotlin.coroutines.jvm.internal.BaseContinuationImpl")) {
                    return type2;
                }
                if (type2.superclass() != null) continue;
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

