/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileTypeFactory;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.MockStackFrame;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\u001a(\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0017\u001a\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u0015\u0010&\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010'\u001a\n\u0010(\u001a\u00020\u0004*\u00020)\u001a1\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,*\u00020\u00052\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H+0.\u00a2\u0006\u0002\u0010/\u001a\n\u00100\u001a\u00020\u0004*\u00020\u001c\u001a\u0012\u00101\u001a\u00020\u0004*\u0002022\u0006\u00103\u001a\u00020\u0001\u001a\u0012\u00101\u001a\u00020\u0004*\u0002022\u0006\u00104\u001a\u000205\u001a\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020807*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u00069"}, d2={"DO_RESUME_SIGNATURE", "", "INVOKE_SUSPEND_SIGNATURE", "canRunEvaluation", "", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/impl/DebuggerContextImpl;)Z", "findCallByEndToken", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "element", "Lcom/intellij/psi/PsiElement;", "findElementAtLine", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "functionNameByArgument", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "functionNameByLocalVariable", "name", "isInSuspendMethod", "location", "Lcom/sun/jdi/Location;", "isInsideInlineArgument", "inlineArgument", "debugProcess", "bindingContext", "isLastLineLocationInMethod", "isOnSuspendReturnOrReenter", "isOneLineMethod", "lambdaOrdinalByArgument", "lambdaOrdinalByLocalVariable", "suspendFunctionFirstLineLocation", "(Lcom/sun/jdi/Location;)Ljava/lang/Integer;", "containsKotlinStrata", "Lcom/sun/jdi/ReferenceType;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isInKotlinSources", "isSubtype", "Lcom/sun/jdi/Type;", "className", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "idea-jvm"})
public final class DebuggerUtilKt {
    private static final String DO_RESUME_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/lang/Object;";
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        String string;
        ReferenceType declaringType;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)$this$isInKotlinSources, (String)"$this$isInKotlinSources");
                ReferenceType referenceType = declaringType = $this$isInKotlinSources.declaringType();
                Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"declaringType");
                string = SafeUtilKt.safeSourceName(referenceType);
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block4;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                string = string4;
                if (string4 != null) break block5;
            }
            string = "";
        }
        String fileExtension = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactory.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactory.KOTLIN_EXTENSIONS, (Object)fileExtension) || DebuggerUtilKt.containsKotlinStrata(declaringType);
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkParameterIsNotNull((Object)$this$containsKotlinStrata, (String)"$this$containsKotlinStrata");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isInsideInlineArgument(@NotNull KtFunction inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess, @NotNull BindingContext bindingContext2) {
        boolean bl;
        block7: {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)inlineArgument, (String)"inlineArgument");
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            List<LocalVariable> visibleVariables = DebuggerUtilKt.visibleVariables(location2, debugProcess);
            Iterable $this$filter$iv = visibleVariables;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LocalVariable it = (LocalVariable)element$iv$iv;
                boolean bl2 = false;
                String string = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                if (!StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List markerLocalVariables = (List)destination$iv$iv;
            BindingContext context2 = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(inlineArgument).getBindingContext();
            int lambdaOrdinal2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)new Function0<Integer>(inlineArgument, context2){
                final /* synthetic */ KtFunction $inlineArgument;
                final /* synthetic */ BindingContext $context;

                public final int invoke() {
                    return DebuggerUtilKt.access$lambdaOrdinalByArgument(this.$inlineArgument, this.$context);
                }
                {
                    this.$inlineArgument = ktFunction;
                    this.$context = bindingContext2;
                    super(0);
                }
            })).intValue();
            String functionName2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(inlineArgument, context2){
                final /* synthetic */ KtFunction $inlineArgument;
                final /* synthetic */ BindingContext $context;

                @NotNull
                public final String invoke() {
                    return DebuggerUtilKt.access$functionNameByArgument(this.$inlineArgument, this.$context);
                }
                {
                    this.$inlineArgument = ktFunction;
                    this.$context = bindingContext2;
                    super(0);
                }
            });
            Iterable $this$map$iv = markerLocalVariables;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LocalVariable localVariable = (LocalVariable)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                String string = it.name();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name()");
                String string2 = StringsKt.drop((String)string, (int)"$i$a$".length());
                collection.add(string2);
            }
            Iterable $this$any$iv = (List)destination$iv$iv2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    String variableName = (String)element$iv;
                    boolean bl5 = false;
                    if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                        Type type2 = CodegenBinding.asmTypeForAnonymousClass(bindingContext2, inlineArgument);
                        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"asmTypeForAnonymousClass\u2026gContext, inlineArgument)");
                        String string = type2.getInternalName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmTypeForAnonymousClass\u2026            .internalName");
                        String lambdaClassName = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
                        bl4 = Intrinsics.areEqual((Object)variableName, (Object)('-' + functionName2 + '-' + lambdaClassName));
                    } else {
                        bl4 = DebuggerUtilKt.lambdaOrdinalByLocalVariable(variableName) == lambdaOrdinal2 && Intrinsics.areEqual((Object)DebuggerUtilKt.functionNameByLocalVariable(variableName), (Object)functionName2);
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isInsideInlineArgument$default(KtFunction ktFunction, Location location2, DebugProcessImpl debugProcessImpl, BindingContext bindingContext2, int n, Object object) {
        if ((n & 8) != 0) {
            bindingContext2 = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(ktFunction).getBindingContext();
        }
        return DebuggerUtilKt.isInsideInlineArgument(ktFunction, location2, debugProcessImpl, bindingContext2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f2) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)$this$invokeInManagerThread, (String)"$this$invokeInManagerThread");
        Intrinsics.checkParameterIsNotNull(f2, (String)"f");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl command2 = new DebuggerCommandImpl($this$invokeInManagerThread, (Ref.ObjectRef)result2, f2){
            final /* synthetic */ DebugProcessImpl $this_invokeInManagerThread;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $f;

            protected void action() {
                this.$result.element = ApplicationUtilsKt.runReadAction((Function0)new Function0<T>(this){
                    final /* synthetic */ invokeInManagerThread.command.1 this$0;

                    @Nullable
                    public final T invoke() {
                        Function1 function1 = this.this$0.$f;
                        DebuggerContextImpl debuggerContextImpl = this.this$0.$this_invokeInManagerThread.getDebuggerContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                        return (T)function1.invoke((Object)debuggerContextImpl);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$this_invokeInManagerThread = $receiver;
                this.$result = $captured_local_variable$1;
                this.$f = $captured_local_variable$2;
            }
        };
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            $this$invokeInManagerThread.getManagerThread().invoke(command2);
        } else {
            $this$invokeInManagerThread.getManagerThread().invokeAndWait(command2);
        }
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt, BindingContext context2) {
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(context2, elementAt);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"CodegenBinding.asmTypeFo\u2026Class(context, elementAt)");
        Type type3 = type2;
        String string = type3.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.className");
        String string2 = StringsKt.substringAfterLast$default((String)string, (String)"$", null, (int)2, null);
        boolean bl = false;
        return Integer.parseInt(string2);
    }

    private static final String functionNameByArgument(KtFunction elementAt, BindingContext context2) {
        ValueParameterDescriptor inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor(elementAt, context2);
        Object object = inlineArgumentDescriptor;
        if (object == null || (object = object.getContainingDeclaration()) == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private static final List<LocalVariable> visibleVariables(@NotNull Location $this$visibleVariables, DebugProcessImpl debugProcess) {
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"debugProcess.virtualMachineProxy");
        VirtualMachine virtualMachine = virtualMachineProxyImpl.getVirtualMachine();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"debugProcess.virtualMachineProxy.virtualMachine");
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            return Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isInSuspendMethod(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        String signature = method.signature();
        for (Type continuationAsmType : CoroutineCodegenUtilKt.continuationAsmTypes()) {
            String string = signature;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"signature");
            CharSequence charSequence = string;
            String string2 = continuationAsmType.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"continuationAsmType.toString()");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) && (!Intrinsics.areEqual((Object)method.name(), (Object)"doResume") || !Intrinsics.areEqual((Object)signature, (Object)DO_RESUME_SIGNATURE)) && (!Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") || !Intrinsics.areEqual((Object)signature, (Object)INVOKE_SUSPEND_SIGNATURE))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final Integer suspendFunctionFirstLineLocation(@NotNull Location location2) {
        Integer lineNumber;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        if (!DebuggerUtilKt.isInSuspendMethod(location2)) {
            return null;
        }
        Location location3 = location2.method().location();
        Integer n = lineNumber = location3 != null ? Integer.valueOf(location3.lineNumber()) : null;
        if (n != null && n == -1) {
            return null;
        }
        return lineNumber;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Integer n = DebuggerUtilKt.suspendFunctionFirstLineLocation(location2);
        if (n == null) {
            return false;
        }
        int suspendStartLineNumber = n;
        return suspendStartLineNumber == location2.lineNumber();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isLastLineLocationInMethod(@NotNull Location location2) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"location.method()");
        Iterable $this$map$iv = SafeUtilKt.safeAllLineLocations(method);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Location location3 = (Location)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.lineNumber();
            collection.add(n);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it != -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List knownLines = (List)destination$iv$iv;
        if (knownLines.isEmpty()) {
            return false;
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)knownLines);
        int n2 = location2.lineNumber();
        return n != null && n == n2;
    }

    public static final boolean isOneLineMethod(@NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"location.method()");
        List<Location> allLineLocations = SafeUtilKt.safeAllLineLocations(method);
        Location location3 = (Location)CollectionsKt.firstOrNull(allLineLocations);
        Integer firstLine2 = location3 != null ? Integer.valueOf(location3.lineNumber()) : null;
        Location location4 = (Location)CollectionsKt.lastOrNull(allLineLocations);
        Integer lastLine = location4 != null ? Integer.valueOf(location4.lineNumber()) : null;
        return firstLine2 != null && Intrinsics.areEqual((Object)firstLine2, (Object)lastLine);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file2, int line) {
        void offset2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Integer n = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file2, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = KotlinRefactoringUtilKt.getLineEndOffset((PsiFile)file2, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        PsiElement topMostElement = null;
        PsiElement elementAt = null;
        int n3 = lineStartOffset;
        int n4 = lineEndOffset;
        while (!(n3 >= n4 || (elementAt = file2.findElementAt((int)offset2)) != null && (topMostElement = CodeInsightUtils.getTopmostElementAtOffset(elementAt, (int)offset2)) instanceof KtElement)) {
            ++offset2;
        }
        return topMostElement;
    }

    @Nullable
    public static final KtCallExpression findCallByEndToken(@NotNull PsiElement element3) {
        KtCallExpression ktCallExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3 instanceof KtElement) {
            return null;
        }
        ASTNode aSTNode = element3.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.RPAR))) {
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtValueArgumentList)) {
                psiElement2 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
            Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object instanceof KtCallExpression)) {
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.RBRACE))) {
            PsiElement braceParent;
            PsiElement psiElement3 = CodeInsightUtils.getTopParentWithEndOffset(element3, KtCallExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"CodeInsightUtils.getTopP\u2026llExpression::class.java)");
            PsiElement psiElement4 = braceParent = psiElement3;
            if (psiElement4 instanceof KtCallExpression) {
                ktCallExpression = (KtCallExpression)braceParent;
            } else if (psiElement4 instanceof KtLambdaArgument) {
                PsiElement psiElement5 = ((KtLambdaArgument)braceParent).getParent();
                if (!(psiElement5 instanceof KtCallExpression)) {
                    psiElement5 = null;
                }
                ktCallExpression = (KtCallExpression)psiElement5;
            } else if (psiElement4 instanceof KtValueArgument) {
                PsiElement psiElement6 = ((KtValueArgument)braceParent).getParent();
                if (!(psiElement6 instanceof KtValueArgumentList)) {
                    psiElement6 = null;
                }
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement6;
                Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
                if (!(object instanceof KtCallExpression)) {
                    object = null;
                }
                ktCallExpression = (KtCallExpression)object;
            } else {
                ktCallExpression = null;
            }
        } else {
            ktCallExpression = null;
        }
        return ktCallExpression;
    }

    public static final boolean isSubtype(@NotNull com.sun.jdi.Type $this$isSubtype, @NotNull String className2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSubtype, (String)"$this$isSubtype");
        Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
        Type type2 = Type.getObjectType((String)className2);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"AsmType.getObjectType(className)");
        return DebuggerUtilKt.isSubtype($this$isSubtype, type2);
    }

    public static final boolean isSubtype(@NotNull com.sun.jdi.Type $this$isSubtype, @NotNull Type type2) {
        boolean bl;
        String superTypeName;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isSubtype, (String)"$this$isSubtype");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (Intrinsics.areEqual((Object)$this$isSubtype.signature(), (Object)type2.getDescriptor())) {
                return true;
            }
            if (type2.getSort() != 10 || !($this$isSubtype instanceof ClassType)) {
                return false;
            }
            superTypeName = type2.getClassName();
            List<InterfaceType> list2 = ((ClassType)$this$isSubtype).allInterfaces();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allInterfaces()");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InterfaceType it = (InterfaceType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)superTypeName)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        for (ClassType superClass = ((ClassType)$this$isSubtype).superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!Intrinsics.areEqual((Object)superClass.name(), (Object)superTypeName)) continue;
            return true;
        }
        return false;
    }

    public static final boolean getCanRunEvaluation(@NotNull DebuggerContextImpl $this$canRunEvaluation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canRunEvaluation, (String)"$this$canRunEvaluation");
        DebugProcessImpl debugProcessImpl = $this$canRunEvaluation.getDebugProcess();
        return debugProcessImpl != null ? DebuggerUtilKt.getCanRunEvaluation(debugProcessImpl) : false;
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canRunEvaluation, (String)"$this$canRunEvaluation");
        SuspendManager suspendManager = $this$canRunEvaluation.getSuspendManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendManager, (String)"suspendManager");
        return suspendManager.getPausedContext() != null;
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(KtFunction elementAt, BindingContext context2) {
        return DebuggerUtilKt.lambdaOrdinalByArgument(elementAt, context2);
    }

    public static final /* synthetic */ String access$functionNameByArgument(KtFunction elementAt, BindingContext context2) {
        return DebuggerUtilKt.functionNameByArgument(elementAt, context2);
    }
}

