/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUMap;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesFileAttributeKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.ScriptNewDependenciesNotificationKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptContentLoader;
import org.jetbrains.kotlin.scripting.resolve.ScriptContentLoaderKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H&J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H$J\b\u0010%\u001a\u00020\u0016H\u0016J \u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0004J \u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0004J\b\u0010+\u001a\u00020\u0016H$J\b\u0010,\u001a\u00020\u0016H\u0004J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "contentLoader", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader;", "getContentLoader", "()Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader;", "fileModificationStamps", "Lcom/intellij/util/containers/SLRUMap;", "", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "reporter", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptReportSink;", "shouldNotifyRootsChanged", "", "getShouldNotifyRootsChanged", "()Z", "setShouldNotifyRootsChanged", "(Z)V", "attachReportsIfChanged", "", "result", "Lkotlin/script/experimental/dependencies/DependenciesResolver$ResolveResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDef", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "isApplicable", "loadDependencies", "notifyRootsChanged", "processResult", "saveDependencies", "saveToCache", "dependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "shouldShowNotification", "submitMakeRootsChange", "updateDependencies", "idea-core"})
public abstract class ScriptDependenciesLoader {
    private final SLRUMap<String, Long> fileModificationStamps;
    private boolean shouldNotifyRootsChanged;
    @NotNull
    private final ScriptContentLoader contentLoader;
    @NotNull
    private final ScriptDependenciesCache cache;
    private final ScriptReportSink reporter;
    @NotNull
    private final Project project;

    public final void updateDependencies(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Long l = (Long)this.fileModificationStamps.get((Object)file2.getPath());
        long l2 = file2.getModificationStamp();
        if (l == null || l != l2) {
            this.fileModificationStamps.put((Object)file2.getPath(), (Object)file2.getModificationStamp());
            this.loadDependencies(file2);
        }
    }

    public abstract boolean isApplicable(@NotNull VirtualFile var1);

    protected abstract void loadDependencies(@NotNull VirtualFile var1);

    protected abstract boolean shouldShowNotification();

    protected final boolean getShouldNotifyRootsChanged() {
        return this.shouldNotifyRootsChanged;
    }

    protected final void setShouldNotifyRootsChanged(boolean bl) {
        this.shouldNotifyRootsChanged = bl;
    }

    @NotNull
    protected final ScriptContentLoader getContentLoader() {
        return this.contentLoader;
    }

    @NotNull
    protected final ScriptDependenciesCache getCache() {
        return this.cache;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void processResult(@NotNull DependenciesResolver.ResolveResult result2, @NotNull VirtualFile file2, @NotNull KotlinScriptDefinition scriptDef) {
        ScriptDependencies newDependencies;
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)scriptDef, (String)"scriptDef");
        if (this.cache.get(file2) == null) {
            this.saveDependencies(result2, file2, scriptDef);
            this.attachReportsIfChanged(result2, file2, scriptDef);
            return;
        }
        ScriptDependencies scriptDependencies2 = result2.getDependencies();
        Object object = newDependencies = scriptDependencies2 != null ? ScriptContentLoaderKt.adjustByDefinition((ScriptDependencies)scriptDependencies2, (KotlinScriptDefinition)scriptDef) : null;
        if (!(Intrinsics.areEqual((Object)this.cache.get(file2), (Object)newDependencies) ^ true)) {
            this.attachReportsIfChanged(result2, file2, scriptDef);
            if (!this.shouldShowNotification()) return;
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(file2, this.project);
            return;
        }
        if (this.shouldShowNotification()) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                ScriptNewDependenciesNotificationKt.addScriptDependenciesNotificationPanel(file2, result2, this.project, (Function1<? super DependenciesResolver.ResolveResult, Unit>)((Function1)new Function1<DependenciesResolver.ResolveResult, Unit>(this, file2, scriptDef){
                    final /* synthetic */ ScriptDependenciesLoader this$0;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ KotlinScriptDefinition $scriptDef;

                    public final void invoke(@NotNull DependenciesResolver.ResolveResult it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        ScriptDependenciesLoader.access$saveDependencies(this.this$0, it, this.$file, this.$scriptDef);
                        ScriptDependenciesLoader.access$attachReportsIfChanged(this.this$0, it, this.$file, this.$scriptDef);
                        this.this$0.submitMakeRootsChange();
                    }
                    {
                        this.this$0 = scriptDependenciesLoader;
                        this.$file = virtualFile2;
                        this.$scriptDef = kotlinScriptDefinition;
                        super(1);
                    }
                }));
                return;
            }
        }
        this.saveDependencies(result2, file2, scriptDef);
        this.attachReportsIfChanged(result2, file2, scriptDef);
    }

    private final void attachReportsIfChanged(DependenciesResolver.ResolveResult result2, VirtualFile file2, KotlinScriptDefinition scriptDef) {
        List list2;
        List list3 = result2.getReports();
        List list4 = (List)file2.getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list3;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        List list5 = list2 = !collection.isEmpty() ? list3 : null;
        if (Intrinsics.areEqual((Object)list4, (Object)list2) ^ true) {
            this.reporter.attachReports(file2, result2.getReports());
        }
    }

    private final void saveDependencies(DependenciesResolver.ResolveResult result2, VirtualFile file2, KotlinScriptDefinition scriptDef) {
        ScriptDependencies scriptDependencies2;
        if (this.shouldShowNotification()) {
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(file2, this.project);
        }
        if ((scriptDependencies2 = result2.getDependencies()) == null || (scriptDependencies2 = ScriptContentLoaderKt.adjustByDefinition((ScriptDependencies)scriptDependencies2, (KotlinScriptDefinition)scriptDef)) == null) {
            return;
        }
        ScriptDependencies dependencies2 = scriptDependencies2;
        this.saveToCache(file2, dependencies2);
    }

    protected final void saveToCache(@NotNull VirtualFile file2, @NotNull ScriptDependencies dependencies2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dependencies2, (String)"dependencies");
        boolean rootsChanged = this.cache.hasNotCachedRoots(dependencies2);
        if (this.cache.save(file2, dependencies2)) {
            ScriptDependenciesFileAttributeKt.setScriptDependencies(file2, dependencies2);
        }
        if (rootsChanged) {
            this.shouldNotifyRootsChanged = true;
        }
    }

    public boolean notifyRootsChanged() {
        return this.submitMakeRootsChange();
    }

    protected final boolean submitMakeRootsChange() {
        if (!this.shouldNotifyRootsChanged) {
            return false;
        }
        Runnable doNotifyRootsChanged2 = new Runnable(this){
            final /* synthetic */ ScriptDependenciesLoader this$0;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ submitMakeRootsChange.doNotifyRootsChanged.1 this$0;

                    public final void invoke() {
                        if (this.this$0.this$0.getProject().isDisposed()) {
                            return;
                        }
                        this.this$0.this$0.setShouldNotifyRootsChanged(false);
                        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)this.this$0.this$0.getProject());
                        if (projectRootManagerEx != null) {
                            projectRootManagerEx.makeRootsChange(EmptyRunnable.getInstance(), false, true);
                        }
                        ScriptDependenciesModificationTracker.Companion.getInstance(this.this$0.this$0.getProject()).incModificationCount();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = scriptDependenciesLoader;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            TransactionGuard.submitTransaction((Disposable)((Disposable)this.project), (Runnable)doNotifyRootsChanged2);
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.project, doNotifyRootsChanged2);
        }
        return true;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public ScriptDependenciesLoader(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.fileModificationStamps = new SLRUMap(50, 50);
        this.contentLoader = new ScriptContentLoader(this.project);
        Object object = ServiceManager.getService((Project)this.project, ScriptDependenciesCache.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026denciesCache::class.java)");
        this.cache = (ScriptDependenciesCache)object;
        Object object2 = ServiceManager.getService((Project)this.project, ScriptReportSink.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ServiceManager.getServic\u2026ptReportSink::class.java)");
        this.reporter = (ScriptReportSink)object2;
    }

    public static final /* synthetic */ void access$saveDependencies(ScriptDependenciesLoader $this, DependenciesResolver.ResolveResult result2, VirtualFile file2, KotlinScriptDefinition scriptDef) {
        $this.saveDependencies(result2, file2, scriptDef);
    }

    public static final /* synthetic */ void access$attachReportsIfChanged(ScriptDependenciesLoader $this, DependenciesResolver.ResolveResult result2, VirtualFile file2, KotlinScriptDefinition scriptDef) {
        $this.attachReportsIfChanged(result2, file2, scriptDef);
    }
}

