/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.AsyncDependenciesResolver;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesFileAttributeKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdaterKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.AsyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.FromFileAttributeScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.OutsiderFileDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.SyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.LegacyResolverWrapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;)V", "loaders", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader;", "Lkotlin/collections/ArrayList;", "scriptChangesListenerDelay", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "areDependenciesCached", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentDependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "isAsyncDependencyResolver", "scriptDef", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "listenForChangesInScripts", "", "makeRootsChangeIfNeeded", "shouldStartUpdate", "updateDependencies", "updateDependenciesIfNeeded", "files", "", "Companion", "idea-core"})
public final class ScriptDependenciesUpdater {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelay = 1400;
    private final ArrayList<ScriptDependenciesLoader> loaders;
    private final Project project;
    private final ScriptDependenciesCache cache;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ScriptDependencies getCurrentDependencies(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ScriptDependencies scriptDependencies2 = this.cache.get(file2);
        if (scriptDependencies2 != null) {
            ScriptDependencies scriptDependencies3 = scriptDependencies2;
            boolean bl = false;
            boolean bl2 = false;
            ScriptDependencies it = scriptDependencies3;
            boolean bl3 = false;
            return it;
        }
        this.updateDependencies(file2);
        this.makeRootsChangeIfNeeded();
        ScriptDependencies scriptDependencies4 = this.cache.get(file2);
        if (scriptDependencies4 == null) {
            scriptDependencies4 = ScriptDependencies.Companion.getEmpty();
        }
        return scriptDependencies4;
    }

    public final boolean updateDependenciesIfNeeded(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        if (!ScriptDefinitionsManager.Companion.getInstance(this.project).isReady()) {
            return false;
        }
        boolean wasDependenciesUpdateStarted = false;
        for (VirtualFile virtualFile2 : files2) {
            if (this.areDependenciesCached(virtualFile2)) continue;
            wasDependenciesUpdateStarted = true;
            this.updateDependencies(virtualFile2);
        }
        if (wasDependenciesUpdateStarted) {
            this.makeRootsChangeIfNeeded();
        }
        return wasDependenciesUpdateStarted;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDependencies(VirtualFile file2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.loaders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScriptDependenciesLoader it = (ScriptDependenciesLoader)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(file2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDependenciesLoader it = (ScriptDependenciesLoader)element$iv;
            boolean bl = false;
            it.updateDependencies(file2);
        }
    }

    private final void makeRootsChangeIfNeeded() {
        Iterable $this$firstOrNull$iv = this.loaders;
        boolean $i$f$firstOrNull = false;
        for (Object element$iv : $this$firstOrNull$iv) {
            ScriptDependenciesLoader it = (ScriptDependenciesLoader)element$iv;
            boolean bl = false;
            if (!it.notifyRootsChanged()) continue;
            break;
        }
    }

    private final void listenForChangesInScripts() {
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile3;
                    boolean bl3 = false;
                    VirtualFile virtualFile4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"it");
                    this.runScriptDependenciesUpdateIfNeeded(virtualFile4);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file2) {
                if (!ScriptDependenciesUpdater.access$shouldStartUpdate(this.this$0, file2)) {
                    return;
                }
                ScriptDependenciesUpdater.access$updateDependencies(this.this$0, file2);
                ScriptDependenciesUpdater.access$makeRootsChangeIfNeeded(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                Document document;
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        Document document2 = event.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"event.document");
                        document = document2;
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block6;
                        VirtualFile virtualFile2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl3 = false;
                        VirtualFile virtualFile3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                        object = virtualFile3.isInLocalFileSystem() ? virtualFile2 : null;
                        if (object != null) break block7;
                    }
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"FileDocumentManager.getI\u2026calFileSystem } ?: return");
                VirtualFile file2 = object;
                if (!file2.isValid()) {
                    ScriptDependenciesUpdater.access$getCache$p(this.this$0).delete(file2);
                    return;
                }
                if (!ScriptDependenciesUpdater.access$shouldStartUpdate(this.this$0, file2)) {
                    return;
                }
                if (ScriptDependenciesUpdater.access$getCache$p(this.this$0).get(file2) == null) {
                    return;
                }
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).cancelAllRequests();
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).addRequest(new Runnable(this, document, file2){
                    final /* synthetic */ listenForChangesInScripts.2 this$0;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ VirtualFile $file;

                    public final void run() {
                        FileDocumentManager.getInstance().saveDocument(this.$document);
                        ScriptDependenciesUpdater.access$updateDependencies(this.this$0.this$0, this.$file);
                        ScriptDependenciesUpdater.access$makeRootsChangeIfNeeded(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$document = document;
                        this.$file = virtualFile2;
                    }
                }, ScriptDependenciesUpdater.access$getScriptChangesListenerDelay$p(this.this$0), true);
            }
            {
                this.this$0 = $outer;
            }
        }, (Disposable)this.project.getMessageBus().connect());
    }

    private final boolean shouldStartUpdate(VirtualFile file2) {
        PsiFile psiFile;
        if (this.project.isDisposed() || !file2.isValid() || Intrinsics.areEqual((Object)file2.getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
            if (Intrinsics.areEqual((Object)ScriptDependenciesUpdaterKt.isScriptDependenciesUpdaterDisabled(application2), (Object)true)) {
                return false;
            }
        }
        if (!((psiFile = PsiManager.getInstance((Project)this.project).findFile(file2)) instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile2 = (KtFile)psiFile;
        if (ktFile2 == null) {
            return false;
        }
        KtFile ktFile3 = ktFile2;
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile3, true);
    }

    private final boolean areDependenciesCached(VirtualFile file2) {
        return this.cache.get(file2) != null || ScriptDependenciesFileAttributeKt.getScriptDependencies(file2) != null;
    }

    public final boolean isAsyncDependencyResolver(@NotNull KotlinScriptDefinition scriptDef) {
        Intrinsics.checkParameterIsNotNull((Object)scriptDef, (String)"scriptDef");
        DependenciesResolver dependencyResolver = scriptDef.getDependencyResolver();
        return dependencyResolver instanceof AsyncDependenciesResolver || dependencyResolver instanceof LegacyResolverWrapper;
    }

    public ScriptDependenciesUpdater(@NotNull Project project, @NotNull ScriptDependenciesCache cache2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)cache2, (String)"cache");
        this.project = project;
        this.cache = cache2;
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
        this.scriptChangesListenerDelay = 1400;
        this.loaders = CollectionsKt.arrayListOf((Object[])new ScriptDependenciesLoader[]{new FromFileAttributeScriptDependenciesLoader(this.project), new OutsiderFileDependenciesLoader(this.project), new AsyncScriptDependenciesLoader(this.project), new SyncScriptDependenciesLoader(this.project)});
        this.listenForChangesInScripts();
    }

    public static final /* synthetic */ boolean access$shouldStartUpdate(ScriptDependenciesUpdater $this, VirtualFile file2) {
        return $this.shouldStartUpdate(file2);
    }

    public static final /* synthetic */ void access$updateDependencies(ScriptDependenciesUpdater $this, VirtualFile file2) {
        $this.updateDependencies(file2);
    }

    public static final /* synthetic */ void access$makeRootsChangeIfNeeded(ScriptDependenciesUpdater $this) {
        $this.makeRootsChangeIfNeeded();
    }

    public static final /* synthetic */ ScriptDependenciesCache access$getCache$p(ScriptDependenciesUpdater $this) {
        return $this.cache;
    }

    public static final /* synthetic */ Alarm access$getScriptsQueue$p(ScriptDependenciesUpdater $this) {
        return $this.scriptsQueue;
    }

    public static final /* synthetic */ int access$getScriptChangesListenerDelay$p(ScriptDependenciesUpdater $this) {
        return $this.scriptChangesListenerDelay;
    }

    @JvmStatic
    @NotNull
    public static final ScriptDependenciesUpdater getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater$Companion;", "", "()V", "areDependenciesCached", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "isAsyncDependencyResolver", "idea-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ScriptDependenciesUpdater getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ScriptDependenciesUpdater.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026nciesUpdater::class.java)");
            return (ScriptDependenciesUpdater)object;
        }

        public final boolean areDependenciesCached(@NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            ScriptDependenciesUpdater scriptDependenciesUpdater = this.getInstance(project);
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            return scriptDependenciesUpdater.areDependenciesCached(virtualFile2);
        }

        public final boolean isAsyncDependencyResolver(@NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            KotlinScriptDefinition kotlinScriptDefinition = DefinitionsKt.findScriptDefinition((VirtualFile)virtualFile2, (Project)project);
            if (kotlinScriptDefinition == null) {
                return false;
            }
            KotlinScriptDefinition scriptDefinition = kotlinScriptDefinition;
            Project project2 = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            return this.getInstance(project2).isAsyncDependencyResolver(scriptDefinition);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

