/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.SettingsScriptBuilder;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\fJ\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\fJ\u001a\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\b\b\u0002\u0010\u001b\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/SettingsScriptBuilder;", "", "scriptFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "(Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addIncludedModules", "", "modules", "", "", "addMavenCentralPluginRepository", "addPluginRepository", "repository", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "addPluginRepositoryExpression", "expression", "addResolutionStrategy", "pluginId", "appendExpressionToBlockIfAbsent", "offset", "", "build", "findBlockBody", "blockName", "startFrom", "getOrAppendInnerBlockBody", "getOrCreatePluginManagementBody", "getOrPrependTopLevelBlockBody", "idea-gradle"})
public final class SettingsScriptBuilder {
    private final StringBuilder builder;

    private final int findBlockBody(String blockName, int startFrom) {
        int blockOffset = this.builder.indexOf(blockName, startFrom);
        if (blockOffset < 0) {
            return -1;
        }
        return StringsKt.indexOf$default((CharSequence)this.builder, (char)'{', (int)(blockOffset + 1), (boolean)false, (int)4, null) + 1;
    }

    static /* synthetic */ int findBlockBody$default(SettingsScriptBuilder settingsScriptBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return settingsScriptBuilder.findBlockBody(string, n);
    }

    private final int getOrPrependTopLevelBlockBody(String blockName) {
        int blockBody = SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
        if (blockBody >= 0) {
            return blockBody;
        }
        this.builder.insert(0, blockName + " {}\n");
        return SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
    }

    private final int getOrAppendInnerBlockBody(String blockName, int offset2) {
        int repositoriesBody = this.findBlockBody(blockName, offset2);
        if (repositoriesBody >= 0) {
            return repositoriesBody;
        }
        this.builder.insert(offset2, '\n' + blockName + " {}\n");
        return this.findBlockBody(blockName, offset2);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendExpressionToBlockIfAbsent(String expression2, int offset2) {
        int braceCount = 1;
        int blockEnd = offset2;
        int n = offset2;
        int n2 = StringsKt.getLastIndex((CharSequence)this.builder);
        if (n <= n2) {
            while (true) {
                void i2;
                switch (this.builder.charAt((int)i2)) {
                    case '{': {
                        ++braceCount;
                        break;
                    }
                    case '}': {
                        --braceCount;
                    }
                }
                if (braceCount == 0) {
                    blockEnd = i2;
                    break;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        String string = this.builder.substring(offset2, blockEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.substring(offset, blockEnd)");
        String string2 = expression2;
        CharSequence charSequence = string;
        n2 = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string4, (boolean)false, (int)2, null)) {
            this.builder.insert(blockEnd, '\n' + expression2 + '\n');
        }
    }

    private final int getOrCreatePluginManagementBody() {
        return this.getOrPrependTopLevelBlockBody("pluginManagement");
    }

    private final void addPluginRepositoryExpression(String expression2) {
        int repositoriesBody = this.getOrAppendInnerBlockBody("repositories", this.getOrCreatePluginManagementBody());
        this.appendExpressionToBlockIfAbsent(expression2, repositoriesBody);
    }

    public final void addMavenCentralPluginRepository() {
        this.addPluginRepositoryExpression("mavenCentral()");
    }

    public final void addPluginRepository(@NotNull RepositoryDescription repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.addPluginRepositoryExpression(ConfigureKotlinInProjectUtilsKt.toGroovyRepositorySnippet(repository));
    }

    public final void addResolutionStrategy(@NotNull String pluginId) {
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        int resolutionStrategyBody = this.getOrAppendInnerBlockBody("resolutionStrategy", this.getOrCreatePluginManagementBody());
        int eachPluginBody = this.getOrAppendInnerBlockBody("eachPlugin", resolutionStrategyBody);
        this.appendExpressionToBlockIfAbsent(StringsKt.trimIndent((String)("\n                if (requested.id.id == \"" + pluginId + "\") {\n                    useModule(\"org.jetbrains.kotlin:kotlin-gradle-plugin:${requested.version}\")\n                }\n            ")), eachPluginBody);
    }

    public final void addIncludedModules(@NotNull List<String> modules) {
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        this.builder.append(CollectionsKt.joinToString$default((Iterable)modules, null, (CharSequence)"include ", (CharSequence)"\n", (int)0, null, (Function1)addIncludedModules.1.INSTANCE, (int)25, null));
    }

    @NotNull
    public final String build() {
        String string = this.builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public SettingsScriptBuilder(@NotNull GroovyFile scriptFile) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        this.builder = new StringBuilder(scriptFile.getText());
    }
}

