/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.KotlinCompilation;
import org.jetbrains.kotlin.gradle.KotlinModule;
import org.jetbrains.kotlin.gradle.KotlinPlatform;
import org.jetbrains.kotlin.gradle.KotlinSourceSet;
import org.jetbrains.kotlin.idea.configuration.DataNodeUtilsKt;
import org.jetbrains.kotlin.idea.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPDataNodesKt;
import org.jetbrains.kotlin.idea.configuration.KotlinSourceSetDataService;
import org.jetbrains.kotlin.idea.configuration.KotlinSourceSetDataService$assignTestScope$;
import org.jetbrains.kotlin.idea.configuration.KotlinSourceSetInfo;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindTooling;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00020\u00020\nH\u0016J6\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSourceSetDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "Ljava/lang/Void;", "()V", "assignTestScope", "", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "idea-gradle"})
public final class KotlinSourceSetDataService
extends AbstractProjectDataService<GradleSourceSetData, Void> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key key = GradleSourceSetData.KEY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"GradleSourceSetData.KEY");
        return key;
    }

    public void postProcess(@NotNull Collection<DataNode<GradleSourceSetData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<GradleSourceSetData> nodeToImport : toImport) {
            ModifiableRootModel rootModel;
            KotlinSourceSetInfo kotlinSourceSet;
            Module ideModule;
            DataNode mainModuleData;
            if (ExternalSystemApiUtil.findParent(nodeToImport, (Key)ProjectKeys.MODULE) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)mainModuleData, (String)"ExternalSystemApiUtil.fi\u2026            ) ?: continue");
            Object object = nodeToImport.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nodeToImport.data");
            GradleSourceSetData sourceSetData = (GradleSourceSetData)object;
            if (KotlinMPPDataNodesKt.getKotlinSourceSet(nodeToImport) == null) {
                continue;
            }
            if (modelsProvider.findIdeModule((ModuleData)sourceSetData) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ideModule, (String)"modelsProvider.findIdeMo\u2026ourceSetData) ?: continue");
            KotlinPlatform platform = kotlinSourceSet.getPlatform();
            Intrinsics.checkExpressionValueIsNotNull((Object)modelsProvider.getModifiableRootModel(ideModule), (String)"modelsProvider.getModifiableRootModel(ideModule)");
            if (platform != KotlinPlatform.JVM && platform != KotlinPlatform.ANDROID) {
                ProjectRootUtilsKt.migrateNonJvmSourceFolders(rootModel);
            }
            if (Companion.configureFacet((ModuleData)sourceSetData, kotlinSourceSet, (DataNode<ModuleData>)mainModuleData, ideModule, modelsProvider) != null) {
                KotlinFacet kotlinFacet;
                boolean bl = false;
                boolean bl2 = false;
                KotlinFacet facet = kotlinFacet;
                boolean bl3 = false;
                Iterable $this$forEach$iv = GradleProjectImportHandler.Companion.getInstances(project);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GradleProjectImportHandler it = (GradleProjectImportHandler)element$iv;
                    boolean bl4 = false;
                    it.importBySourceSet(facet, nodeToImport);
                }
            }
            if (!kotlinSourceSet.isTestModule()) continue;
            this.assignTestScope(rootModel);
        }
    }

    private final void assignTestScope(ModifiableRootModel rootModel) {
        Object[] objectArray = rootModel.getOrderEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootModel\n            .orderEntries");
        Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])objectArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)assignTestScope$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence2, (Function1)assignTestScope.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExportableOrderEntry it = (ExportableOrderEntry)element$iv;
            boolean bl = false;
            it.setScope(DependencyScope.TEST);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSourceSetDataService$Companion;", "", "()V", "kind", "Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "Lorg/jetbrains/kotlin/gradle/KotlinModule;", "getKind", "(Lorg/jetbrains/kotlin/gradle/KotlinModule;)Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "configureFacet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "moduleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/idea/configuration/KotlinSourceSetInfo;", "mainModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "ideModule", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "idea-gradle"})
    public static final class Companion {
        private final KotlinModuleKind getKind(@NotNull KotlinModule $this$kind) {
            KotlinModule kotlinModule = $this$kind;
            return kotlinModule instanceof KotlinCompilation ? KotlinModuleKind.COMPILATION_AND_SOURCE_SET_HOLDER : (kotlinModule instanceof KotlinSourceSet ? KotlinModuleKind.SOURCE_SET_HOLDER : KotlinModuleKind.DEFAULT);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KotlinFacet configureFacet(@NotNull ModuleData moduleData, @NotNull KotlinSourceSetInfo kotlinSourceSet, @NotNull DataNode<ModuleData> mainModuleNode, @NotNull Module ideModule, @NotNull IdeModifiableModelsProvider modelsProvider) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            String string;
            IdePlatform platform;
            IdePlatform idePlatform;
            IdePlatformKind<?> platformKind;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)moduleData, (String)"moduleData");
            Intrinsics.checkParameterIsNotNull((Object)kotlinSourceSet, (String)"kotlinSourceSet");
            Intrinsics.checkParameterIsNotNull(mainModuleNode, (String)"mainModuleNode");
            Intrinsics.checkParameterIsNotNull((Object)ideModule, (String)"ideModule");
            Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
            Key key = BuildScriptClasspathData.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BuildScriptClasspathData.KEY");
            NodeWithData nodeWithData = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(mainModuleNode, key));
            if (nodeWithData != null && (nodeWithData = (BuildScriptClasspathData)nodeWithData.getData()) != null) {
                NodeWithData nodeWithData2 = nodeWithData;
                boolean bl = false;
                boolean bl2 = false;
                NodeWithData it = nodeWithData2;
                boolean bl3 = false;
                string2 = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)it);
            } else {
                string2 = null;
            }
            String compilerVersion = string2;
            IdePlatformKind<?> idePlatformKind = platformKind = IdePlatformKindTooling.Companion.getTooling(kotlinSourceSet.getPlatform()).getKind();
            if (idePlatformKind instanceof JvmIdePlatformKind) {
                JvmTarget jvmTarget;
                String string3 = moduleData.getTargetCompatibility();
                if (string3 == null) {
                    string3 = "";
                }
                if ((jvmTarget = JvmTarget.Companion.fromString(string3)) == null) {
                    jvmTarget = JvmTarget.DEFAULT;
                }
                JvmTarget target = jvmTarget;
                idePlatform = new JvmIdePlatformKind.Platform(target);
            } else {
                idePlatform = platform = platformKind.getDefaultPlatform();
            }
            if ((string = KotlinGradleProjectResolverExtensionKt.getCoroutines(mainModuleNode)) == null) {
                Project project = ideModule.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ideModule.project");
                string = KotlinGradleSourceSetDataServiceKt.findKotlinCoroutinesProperty(project);
            }
            LanguageFeature.State coroutinesProperty = CoroutineSupport.INSTANCE.byCompilerArgument(string);
            KotlinFacet kotlinFacet = FacetUtilsKt.getOrCreateFacet$default(ideModule, modelsProvider, false, null, false, 12, null);
            FacetUtilsKt.configureFacet(kotlinFacet, compilerVersion, coroutinesProperty, platform, modelsProvider);
            CommonCompilerArguments compilerArguments2 = kotlinSourceSet.getCompilerArguments();
            CommonCompilerArguments defaultCompilerArguments = kotlinSourceSet.getDefaultCompilerArguments();
            if (compilerArguments2 != null) {
                FacetUtilsKt.applyCompilerArgumentsToFacet(compilerArguments2, defaultCompilerArguments, kotlinFacet, modelsProvider);
            }
            KotlinGradleSourceSetDataServiceKt.adjustClasspath(kotlinFacet, kotlinSourceSet.getDependencyClasspath());
            FacetUtilsKt.noVersionAutoAdvance(kotlinFacet);
            KotlinFacetSettings kotlinFacetSettings = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings();
            boolean bl = false;
            boolean bl4 = false;
            KotlinFacetSettings $this$with = kotlinFacetSettings;
            boolean bl5 = false;
            $this$with.setKind(Companion.getKind(kotlinSourceSet.getKotlinModule()));
            $this$with.setTestModule(kotlinSourceSet.isTestModule());
            $this$with.setExternalProjectId(kotlinSourceSet.getGradleModuleId());
            Iterable iterable = kotlinSourceSet.getSourceSetIdsByName().values();
            KotlinFacetSettings kotlinFacetSettings2 = $this$with;
            boolean $i$f$mapNotNull = false;
            void var21_24 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string4;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl6 = false;
                String sourceSetId = (String)element$iv$iv;
                boolean bl7 = false;
                if (DataNodeUtilsKt.findChildModuleById(mainModuleNode, sourceSetId) == null) {
                    string4 = null;
                } else {
                    DataNode<? extends ModuleData> node;
                    Object object = node.getData();
                    if (!(object instanceof ModuleData)) {
                        object = null;
                    }
                    if ((ModuleData)object == null) {
                        string4 = null;
                    } else {
                        ModuleData data;
                        Module module = modelsProvider.findIdeModule(data);
                        string4 = module != null ? module.getName() : null;
                    }
                }
                if (string4 == null) continue;
                String string5 = string4;
                boolean bl8 = false;
                boolean bl9 = false;
                String it$iv$iv = string5;
                boolean bl10 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            kotlinFacetSettings2.setSourceSetNames(list2);
            if (kotlinSourceSet.isTestModule()) {
                CommonCompilerArguments commonCompilerArguments = kotlinSourceSet.getCompilerArguments();
                if (!(commonCompilerArguments instanceof K2JSCompilerArguments)) {
                    commonCompilerArguments = null;
                }
                K2JSCompilerArguments k2JSCompilerArguments = (K2JSCompilerArguments)commonCompilerArguments;
                $this$with.setTestOutputPath(k2JSCompilerArguments != null ? k2JSCompilerArguments.getOutputFile() : null);
                $this$with.setProductionOutputPath(null);
            } else {
                CommonCompilerArguments commonCompilerArguments = kotlinSourceSet.getCompilerArguments();
                if (!(commonCompilerArguments instanceof K2JSCompilerArguments)) {
                    commonCompilerArguments = null;
                }
                K2JSCompilerArguments k2JSCompilerArguments = (K2JSCompilerArguments)commonCompilerArguments;
                $this$with.setProductionOutputPath(k2JSCompilerArguments != null ? k2JSCompilerArguments.getOutputFile() : null);
                $this$with.setTestOutputPath(null);
            }
            return kotlinFacet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

