/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\f\u0010\u001c\u001a\u00020\u0016*\u00020\u001dH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleWebMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "commonName", "", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jsSourceName", "getJsSourceName", "jsTargetName", "jsTestName", "getJsTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "buildMultiPlatformPart", "createProjectSkeleton", "", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "setupAdditionalDependencies", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "idea-gradle"})
public final class KotlinGradleWebMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "jvm";
    private String jsTargetName = "js";

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getJsSourceName() {
        return this.jsTargetName + "Main";
    }

    private final String getJsTestName() {
        return this.jsTargetName + "Test";
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.web";
    }

    @NotNull
    public String getPresentableName() {
        return "JS Client and JVM Server | Gradle";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform Gradle project allowing reuse of the same Kotlin code between JS Client and JVM Server";
    }

    @Override
    protected void setupAdditionalDependencies(@NotNull BuildScriptDataBuilder $this$setupAdditionalDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setupAdditionalDependencies, (String)"$this$setupAdditionalDependencies");
        $this$setupAdditionalDependencies.addBuildscriptRepositoriesDefinition("jcenter()");
        $this$setupAdditionalDependencies.addRepositoriesDefinition("maven { url \"https://dl.bintray.com/kotlin/ktor\" }");
        $this$setupAdditionalDependencies.addRepositoriesDefinition("jcenter()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProjectSkeleton(@NotNull VirtualFile rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile2 = rootDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"rootDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile2;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter jvmMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmSourceName(), this.jvmTargetName, null, null, 12, null);
        BufferedWriter jvmTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmTestName(), null, null, "SampleTestsJVM.kt", 6, null);
        BufferedWriter jsMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJsSourceName(), this.jsTargetName, null, null, 12, null);
        BufferedWriter jsTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJsTestName(), null, null, "SampleTestsJS.kt", 6, null);
        VirtualFile virtualFile3 = src.findChild(this.getJvmSourceName());
        if (virtualFile3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"src.findChild(jvmSourceName)!!");
        VirtualFile jvmRoot = virtualFile3;
        VirtualFile virtualFile4 = jvmRoot.createChildDirectory((Object)this, "resources");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"jvmRoot.createChildDirectory(this, \"resources\")");
        VirtualFile jvmResources = virtualFile4;
        VirtualFile virtualFile5 = jvmResources.createChildData((Object)this, "logback.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"jvmResources.createChildData(this, \"logback.xml\")");
        BufferedWriter logBack = this.bufferedWriter(virtualFile5);
        try {
            commonMain.write("package sample\n\nexpect class Sample() {\n    fun checkMe(): Int\n}\n\nexpect object Platform {\n    val name: String\n}\n\nfun hello(): String = \"Hello from ${Platform.name}\"");
            jvmMain.write(StringsKt.trimIndent((String)("\n                package sample\n\n                import io.ktor.application.*\n                import io.ktor.html.*\n                import io.ktor.http.content.*\n                import io.ktor.routing.*\n                import io.ktor.server.engine.*\n                import io.ktor.server.netty.*\n                import kotlinx.html.*\n                import java.io.*\n\n                actual class Sample {\n                    actual fun checkMe() = 42\n                }\n\n                actual object Platform {\n                    actual val name: String = \"JVM\"\n                }\n\n                fun main() {\n                    embeddedServer(Netty, port = 8080, host = \"127.0.0.1\") {\n                        routing {\n                            get(\"/\") {\n                                call.respondHtml {\n                                    head {\n                                        title(\"Hello from Ktor!\")\n                                    }\n                                    body {\n                                        +\"${hello()} from Ktor. Check me value: ${Sample().checkMe()}\"\n                                        div {\n                                            id = \"js-response\"\n                                            +\"Loading...\"\n                                        }\n                                        script(src = \"/static/" + this.getName() + ".js\") {}\n                                    }\n                                }\n                            }\n                            static(\"/static\") {\n                                resource(\"" + this.getName() + ".js\")\n                            }\n                        }\n                    }.start(wait = true)\n                }\n            ")));
            logBack.write("<configuration>\n    <appender name=\"STDOUT\" class=\"ch.qos.logback.core.ConsoleAppender\">\n        <encoder>\n            <pattern>%d{YYYY-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n</pattern>\n        </encoder>\n    </appender>\n\n    <root level=\"INFO\">\n        <appender-ref ref=\"STDOUT\"/>\n    </root>\n</configuration>");
            jsMain.write("package sample\n\nimport kotlin.browser.*\n\nactual class Sample {\n    actual fun checkMe() = 12\n}\n\nactual object Platform {\n    actual val name: String = \"JS\"\n}\n\n\n@Suppress(\"unused\")\n@JsName(\"helloWorld\")\nfun helloWorld(salutation: String) {\n    val message = \"$salutation from Kotlin.JS ${hello()}, check me value: ${Sample().checkMe()}\"\n    document.getElementById(\"js-response\")?.textContent = message\n}\n\nfun main() {\n    document.addEventListener(\"DOMContentLoaded\", {\n        helloWorld(\"Hi!\")\n    })\n}                ");
            commonTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTests {\n    @Test\n    fun testMe() {\n        assertTrue(Sample().checkMe() > 0)\n    }\n}");
            jvmTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsJVM {\n    @Test\n    fun testHello() {\n        assertTrue(\"JVM\" in hello())\n    }\n}");
            jsTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsJS {\n    @Test\n    fun testHello() {\n        assertTrue(\"JS\" in hello())\n    }\n}");
        }
        catch (Throwable throwable) {
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, jsMain, jsTest, logBack});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                boolean bl = false;
                p1.close();
            }
            throw throwable;
        }
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, jsMain, jsTest, logBack});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            boolean bl = false;
            p1.close();
        }
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        return StringsKt.trimIndent((String)("\n            def ktor_version = '1.1.3'\n            def logback_version = '1.2.3'\n\n            kotlin {\n                jvm()\n                js {\n                    browser {\n                    }\n                }\n                sourceSets {\n                    " + this.getCommonSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib-common')\n                        }\n                    }\n                    " + this.getCommonTestName() + " {\n                        dependencies {\n                            implementation kotlin('test-common')\n                            implementation kotlin('test-annotations-common')\n                        }\n                    }\n                    " + this.getJvmSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib-jdk8')\n                            implementation \"io.ktor:ktor-server-netty:$ktor_version\"\n                            implementation \"io.ktor:ktor-html-builder:$ktor_version\"\n                            implementation \"ch.qos.logback:logback-classic:$logback_version\"\n                        }\n                    }\n                    " + this.getJvmTestName() + " {\n                        dependencies {\n                            implementation kotlin('test')\n                            implementation kotlin('test-junit')\n                        }\n                    }\n                    " + this.getJsSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib-js')\n                        }\n                    }\n                    " + this.getJsTestName() + " {\n                        dependencies {\n                            implementation kotlin('test-js')\n                        }\n                    }\n                }\n            }\n\n            jvmJar {\n                dependsOn(jsBrowserWebpack)\n                from(new File(jsBrowserWebpack.entry.name, jsBrowserWebpack.outputPath))\n            }\n            \n            task run(type: JavaExec, dependsOn: [jvmJar]) {\n                group = \"application\"\n                main = \"sample.SampleJvmKt\"\n                classpath(configurations.jvmRuntimeClasspath, jvmJar)\n                args = []\n            }\n        "));
    }

    public KotlinGradleWebMultiplatformModuleBuilder() {
        super(false, 1, null);
    }
}

