/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BooleanFunction;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.KotlinGradleModel;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilder;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilderKt;
import org.jetbrains.kotlin.gradle.KotlinMPPGradleModel;
import org.jetbrains.kotlin.gradle.KotlinTarget;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPGradleProjectResolverKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacadeKt;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002J4\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0002J.\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\tH\u0002Jh\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2 \u0010\"\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0$\u0018\u00010#2&\u0010&\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\n\u0012\u0004\u0012\u00020'0$\u0018\u00010#H\u0002J\u0016\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*0)H\u0016J\u0016\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*0)H\u0016J,\u0010-\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0016J\b\u0010.\u001a\u00020/H\u0002J0\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0 *\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0002JD\u00101\u001a4\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012(\u0012&\u0012\f\u0012\n 2*\u0004\u0018\u00010\u001e0\u001e 2*\u0012\u0012\f\u0012\n 2*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\n0\n0#*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\"\u0010\b\u001a\u0004\u0018\u00010\t*\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleProjectResolverExtension;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isAndroidProjectKey", "Lcom/intellij/openapi/util/Key;", "()Lcom/intellij/openapi/util/Key;", "sourceSetName", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getSourceSetName", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)Ljava/lang/String;", "addDependency", "", "ideModule", "targetModule", "addImplementedModuleNames", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "dependentModule", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "gradleModel", "Lorg/jetbrains/kotlin/gradle/KotlinGradleModel;", "addTransitiveDependenciesOnImplementedModules", "findModuleById", "moduleId", "getDependencyByFiles", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "files", "", "Ljava/io/File;", "outputToSourceSet", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ExternalSystemSourceType;", "sourceSetByName", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "", "getToolingExtensionsClasses", "populateModuleDependencies", "useModulePerSourceSet", "", "getDependencies", "getSourceSetsMap", "kotlin.jvm.PlatformType", "idea-gradle"})
public final class KotlinGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    @Nullable
    private final com.intellij.openapi.util.Key<?> isAndroidProjectKey = com.intellij.openapi.util.Key.findKeyByName((String)"IS_ANDROID_PROJECT_KEY");
    private final Logger LOG;

    @Nullable
    public final com.intellij.openapi.util.Key<?> isAndroidProjectKey() {
        return this.isAndroidProjectKey;
    }

    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        return SetsKt.setOf((Object[])new Class[]{KotlinGradleModelBuilder.class, Unit.class});
    }

    @NotNull
    public Set<Class<? extends Object>> getExtraProjectModelClasses() {
        return SetsKt.setOf(KotlinGradleModel.class);
    }

    private final boolean useModulePerSourceSet() {
        if (this.isAndroidProjectKey != null && Intrinsics.areEqual((Object)this.resolverCtx.getUserData(this.isAndroidProjectKey), (Object)true)) {
            return false;
        }
        ProjectResolverContext projectResolverContext = this.resolverCtx;
        Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
        return projectResolverContext.isResolveModulePerSourceSet();
    }

    /*
     * WARNING - void declaration
     */
    private final DataNode<GradleSourceSetData> getDependencyByFiles(Collection<? extends File> files2, Map<String, ? extends Pair<String, ExternalSystemSourceType>> outputToSourceSet, Map<String, ? extends Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetByName) {
        void $this$mapTo$iv;
        Iterable iterable = files2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            DataNode dataNode;
            String path2;
            void it;
            File file2 = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)FileUtil.toSystemIndependentName((String)it.getPath()), (String)"FileUtil.toSystemIndependentName(it.path)");
            Map<String, ? extends Pair<String, ExternalSystemSourceType>> map2 = outputToSourceSet;
            if (map2 == null || (map2 = map2.get(path2)) == null || (map2 = (String)((Pair)map2).first) == null) {
                dataNode = null;
            } else {
                Map<String, ? extends Pair<String, ExternalSystemSourceType>> targetSourceSetId = map2;
                Map<String, ? extends Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> map3 = sourceSetByName;
                dataNode = map3 != null && (map3 = map3.get(targetSourceSetId)) != null ? (DataNode)((Pair)map3).first : null;
            }
            DataNode dataNode2 = dataNode;
            collection.add(dataNode2);
        }
        return (DataNode)CollectionsKt.singleOrNull((Iterable)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DataNode<? extends ModuleData>> getDependencies(@NotNull DataNode<? extends ModuleData> $this$getDependencies, DataNode<ProjectData> ideProject) {
        void $this$mapNotNullTo$iv;
        Map cache2;
        Map map2 = KotlinGradleProjectResolverExtensionKt.getDependenciesCache($this$getDependencies);
        if (map2 == null) {
            map2 = cache2 = (Map)new HashMap();
        }
        if (cache2.containsKey(ideProject)) {
            Object v = cache2.get(ideProject);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            return (Collection)v;
        }
        Map outputToSourceSet = (Map)ideProject.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
        Map map3 = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        if (map3 == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"ideProject.getUserData(G\u2026ETS) ?: return emptySet()");
        Map sourceSetByName = map3;
        Pair pair2 = (Pair)sourceSetByName.get(((ModuleData)$this$getDependencies.getData()).getId());
        if (pair2 == null || (pair2 = (ExternalSourceSet)pair2.second) == null) {
            return SetsKt.emptySet();
        }
        Pair externalSourceSet = pair2;
        Collection collection = externalSourceSet.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"externalSourceSet.dependencies");
        Iterable iterable = collection;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DataNode dataNode;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            ExternalDependency dependency = (ExternalDependency)element$iv;
            boolean bl2 = false;
            ExternalDependency externalDependency = dependency;
            if (externalDependency instanceof ExternalProjectDependency) {
                if (Intrinsics.areEqual((Object)((ExternalProjectDependency)dependency).getConfigurationName(), (Object)"default")) {
                    if (ExternalSystemApiUtil.findFirstRecursively(ideProject, (BooleanFunction)new BooleanFunction<DataNode<?>>(dependency){
                        final /* synthetic */ ExternalDependency $dependency;

                        public final boolean fun(DataNode<?> it) {
                            DataNode<?> dataNode = it;
                            Intrinsics.checkExpressionValueIsNotNull(dataNode, (String)"it");
                            Object object = dataNode.getData();
                            if (!(object instanceof ModuleData)) {
                                object = null;
                            }
                            ModuleData moduleData = (ModuleData)object;
                            return Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)((ExternalProjectDependency)this.$dependency).getProjectPath());
                        }
                        {
                            this.$dependency = externalDependency;
                        }
                    }) == null) {
                        dataNode = null;
                    } else {
                        Object v8;
                        block15: {
                            DataNode targetModuleNode2;
                            Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)targetModuleNode2, (Key)GradleSourceSetData.KEY);
                            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
                            Iterable $this$firstOrNull$iv = collection2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv2 : $this$firstOrNull$iv) {
                                DataNode it = (DataNode)element$iv2;
                                boolean bl3 = false;
                                DataNode dataNode2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"it");
                                if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)dataNode2), (Object)"main")) continue;
                                v8 = element$iv2;
                                break block15;
                            }
                            v8 = null;
                        }
                        dataNode = v8;
                    }
                } else {
                    Collection collection3 = ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"dependency.projectDependencyArtifacts");
                    dataNode = this.getDependencyByFiles(collection3, outputToSourceSet, sourceSetByName);
                }
            } else if (externalDependency instanceof FileCollectionDependency) {
                Collection collection4 = ((FileCollectionDependency)dependency).getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"dependency.files");
                dataNode = this.getDependencyByFiles(collection4, outputToSourceSet, sourceSetByName);
            } else {
                dataNode = null;
            }
            if (dataNode == null) continue;
            DataNode dataNode3 = dataNode;
            boolean bl4 = false;
            boolean bl5 = false;
            DataNode it$iv = dataNode3;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet result2 = (LinkedHashSet)destination$iv;
        cache2.put(ideProject, result2);
        KotlinGradleProjectResolverExtensionKt.setDependenciesCache($this$getDependencies, cache2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addTransitiveDependenciesOnImplementedModules(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) {
        Collection collection;
        if (this.useModulePerSourceSet()) {
            Collection collection2 = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
        } else {
            collection = CollectionsKt.listOf(ideModule);
        }
        Collection moduleNodesToProcess = collection;
        block0: for (DataNode currentModuleNode : moduleNodesToProcess) {
            ArrayDeque<DataNode> arrayDeque = new ArrayDeque<DataNode>();
            boolean bl = false;
            boolean bl2 = false;
            ArrayDeque<DataNode> $this$apply22 = arrayDeque;
            boolean bl3 = false;
            $this$apply22.add(currentModuleNode);
            ArrayDeque<DataNode> toProcess = arrayDeque;
            Collection collection3 = new HashSet<DataNode>();
            bl2 = false;
            boolean $this$apply22 = false;
            HashSet<DataNode> $this$apply = collection3;
            boolean bl4 = false;
            $this$apply.add(currentModuleNode);
            HashSet<DataNode> discovered = collection3;
            while (true) {
                Collection<DataNode<? extends ModuleData>> collection4;
                Object object;
                IdeaModule ideaModule;
                IdeaModule ideaModule2;
                DataNode moduleNodeForGradleModel;
                collection3 = toProcess;
                bl2 = false;
                if (!(!collection3.isEmpty())) continue block0;
                DataNode moduleNode = (DataNode)toProcess.pollLast();
                DataNode dataNode = moduleNodeForGradleModel = this.useModulePerSourceSet() ? ExternalSystemApiUtil.findParent((DataNode)moduleNode, (Key)ProjectKeys.MODULE) : moduleNode;
                if (Intrinsics.areEqual((Object)moduleNodeForGradleModel, ideModule) ^ true) {
                    Object object2;
                    block17: {
                        IdeaProject ideaProject = gradleModule.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                        DomainObjectSet domainObjectSet = ideaProject.getModules();
                        Intrinsics.checkExpressionValueIsNotNull((Object)domainObjectSet, (String)"gradleModule.project.modules");
                        Iterable $this$firstOrNull$iv = (Iterable)domainObjectSet;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            DataNode dataNode2;
                            IdeaModule it = (IdeaModule)element$iv;
                            boolean bl5 = false;
                            IdeaModule ideaModule3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ideaModule3, (String)"it");
                            GradleProject gradleProject = ideaModule3.getGradleProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)gradleProject, (String)"it.gradleProject");
                            if (!Intrinsics.areEqual((Object)gradleProject.getPath(), (dataNode2 = moduleNodeForGradleModel) != null && (dataNode2 = (ModuleData)dataNode2.getData()) != null ? dataNode2.getId() : null)) continue;
                            object2 = element$iv;
                            break block17;
                        }
                        object2 = null;
                    }
                    ideaModule2 = (IdeaModule)object2;
                } else {
                    ideaModule2 = ideaModule = gradleModule;
                }
                if ((object = (KotlinGradleModel)this.resolverCtx.getExtraProject(ideaModule, KotlinGradleModel.class)) == null || (object = object.getImplements()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object implementsModuleIds = object;
                Iterator<Object> iterator2 = implementsModuleIds.iterator();
                while (iterator2.hasNext()) {
                    DataNode<ModuleData> targetModule;
                    String implementsModuleId = (String)iterator2.next();
                    if (this.findModuleById(ideProject, gradleModule, implementsModuleId) == null) {
                        continue;
                    }
                    if (this.useModulePerSourceSet()) {
                        void $this$associateByTo$iv$iv;
                        Collection collection5 = ExternalSystemApiUtil.findAll(targetModule, (Key)GradleSourceSetData.KEY);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection5, (String)"ExternalSystemApiUtil\n  \u2026 GradleSourceSetData.KEY)");
                        Iterable $this$associateBy$iv = collection5;
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        Iterable iterable = $this$associateBy$iv;
                        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            void it;
                            DataNode dataNode3 = (DataNode)element$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl6 = false;
                            void v12 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v12);
                            map2.put(string, element$iv$iv);
                        }
                        Map targetSourceSetsByName = destination$iv$iv;
                        DataNode<ModuleData> dataNode4 = (DataNode<ModuleData>)targetSourceSetsByName.get("main");
                        if (dataNode4 == null) {
                            dataNode4 = targetModule;
                        }
                        DataNode<ModuleData> targetMainSourceSet = dataNode4;
                        DataNode dataNode5 = currentModuleNode;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataNode5, (String)"currentModuleNode");
                        DataNode targetSourceSet = (DataNode)targetSourceSetsByName.get(this.getSourceSetName((DataNode<? extends ModuleData>)dataNode5));
                        if (targetSourceSet != null) {
                            this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, (DataNode<? extends ModuleData>)targetSourceSet);
                        }
                        if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)currentModuleNode), (Object)"test") || !(Intrinsics.areEqual(targetMainSourceSet, (Object)targetSourceSet) ^ true)) continue;
                        this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, targetMainSourceSet);
                        continue;
                    }
                    DataNode dataNode6 = currentModuleNode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataNode6, (String)"currentModuleNode");
                    this.addDependency((DataNode<? extends ModuleData>)dataNode6, targetModule);
                }
                if (this.useModulePerSourceSet()) {
                    DataNode dataNode7 = moduleNode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataNode7, (String)"moduleNode");
                    collection4 = this.getDependencies((DataNode<? extends ModuleData>)dataNode7, ideProject);
                } else {
                    IdeaProject ideaProject = gradleModule.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                    collection4 = KotlinGradleModelFacadeKt.getDependencyModules(ideModule, ideaProject);
                }
                Collection<DataNode<? extends ModuleData>> dependencies2 = collection4;
                Iterable $this$filterTo$iv = dependencies2;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    DataNode p1 = (DataNode)element$iv;
                    boolean bl7 = false;
                    if (!discovered.add(p1)) continue;
                    ((Collection)toProcess).add(element$iv);
                }
            }
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)gradleModule, (String)"gradleModule");
            Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
            Intrinsics.checkParameterIsNotNull(ideProject, (String)"ideProject");
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Start populate module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
            }
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
            KotlinMPPGradleModel mppModel = KotlinMPPGradleProjectResolverKt.getMppModel(projectResolverContext, gradleModule);
            if (mppModel == null) break block10;
            Iterable $this$forEach$iv = mppModel.getTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                StringBuilder stringBuilder;
                FUSEventGroups fUSEventGroups;
                KotlinFUSLogger.Companion companion;
                block12: {
                    block11: {
                        KotlinTarget target = (KotlinTarget)element$iv;
                        boolean bl = false;
                        companion = KotlinFUSLogger.Companion;
                        fUSEventGroups = FUSEventGroups.GradleTarget;
                        stringBuilder = new StringBuilder().append("MPP.").append(target.getPlatform().getId());
                        string = target.getPresetName();
                        if (string == null) break block11;
                        String string2 = string;
                        StringBuilder stringBuilder2 = stringBuilder;
                        FUSEventGroups fUSEventGroups2 = fUSEventGroups;
                        KotlinFUSLogger.Companion companion2 = companion;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String it = string2;
                        boolean bl4 = false;
                        String string3 = '.' + it;
                        companion = companion2;
                        fUSEventGroups = fUSEventGroups2;
                        stringBuilder = stringBuilder2;
                        string = string3;
                        if (string != null) break block12;
                    }
                    string = "";
                }
                companion.log(fUSEventGroups, stringBuilder.append((Object)string).toString());
            }
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel == null) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinGradleModel, (String)"resolverCtx.getExtraProj\u2026e, ideModule, ideProject)");
        KotlinGradleModel gradleModel = kotlinGradleModel;
        if (!this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        this.addTransitiveDependenciesOnImplementedModules(gradleModule, ideModule, ideProject);
        KotlinGradleProjectResolverExtensionKt.setResolved(ideModule, true);
        KotlinGradleProjectResolverExtensionKt.setHasKotlinPlugin(ideModule, gradleModel.getHasKotlinPlugin());
        KotlinGradleProjectResolverExtensionKt.setCompilerArgumentsBySourceSet(ideModule, KotlinGradleModelBuilderKt.deepCopy((Map)gradleModel.getCompilerArgumentsBySourceSet()));
        KotlinGradleProjectResolverExtensionKt.setCoroutines(ideModule, gradleModel.getCoroutines());
        KotlinGradleProjectResolverExtensionKt.setPlatformPluginId(ideModule, gradleModel.getPlatformPluginId());
        String string = gradleModel.getKotlinTarget();
        if (string == null) {
            string = "unknown";
        }
        KotlinFUSLogger.Companion.log(FUSEventGroups.GradleTarget, string);
        this.addImplementedModuleNames(gradleModule, ideModule, ideProject, gradleModel);
        if (this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Finish populating module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addImplementedModuleNames(IdeaModule gradleModule, DataNode<ModuleData> dependentModule, DataNode<ProjectData> ideProject, KotlinGradleModel gradleModel) {
        Object $this$map$iv;
        Object dependentSourceSets;
        Iterator iterator2;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = gradleModel.getImplements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.findModuleById(ideProject, gradleModule, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DataNode<ModuleData> it$iv$iv = iterator2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List implementedModules2 = (List)destination$iv$iv;
        if (this.useModulePerSourceSet()) {
            Object object;
            Collection collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            dependentSourceSets = this.getSourceSetsMap(dependentModule);
            $this$map$iv = implementedModules2;
            boolean $i$f$map22 = false;
            Iterable $i$f$mapNotNullTo2 = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                item$iv$iv = iterator3.next();
                element$iv$iv = (DataNode)item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl = false;
                object = this.getSourceSetsMap((DataNode<ModuleData>)it);
                collection.add(object);
            }
            List implementedSourceSetMaps = (List)destination$iv$iv22;
            $this$mapTo$iv$iv = dependentSourceSets;
            boolean destination$iv$iv22 = false;
            Iterator $i$f$map22 = $this$mapTo$iv$iv.entrySet().iterator();
            while ($i$f$map22.hasNext()) {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Object $i$f$mapTo2 = $this$map$iv = $i$f$map22.next();
                boolean bl = false;
                String sourceSetName = (String)$i$f$mapTo2.getKey();
                $i$f$mapTo2 = $this$map$iv;
                bl = false;
                DataNode dependentSourceSet = (DataNode)$i$f$mapTo2.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependentSourceSet, (String)"dependentSourceSet");
                $i$f$mapTo2 = implementedSourceSetMaps;
                boolean $i$f$mapNotNull2 = false;
                item$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo3 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl6 = false;
                    Map it = (Map)element$iv$iv2;
                    boolean bl7 = false;
                    DataNode dataNode = (DataNode)it.get(sourceSetName);
                    if ((dataNode != null && (dataNode = (GradleSourceSetData)dataNode.getData()) != null ? dataNode.getInternalName() : null) == null) continue;
                    string = string;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    String it$iv$iv = string;
                    boolean bl10 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                object = (List)destination$iv$iv3;
                KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames((DataNode<? extends ModuleData>)collection, (List<String>)object);
            }
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv2;
            dependentSourceSets = implementedModules2;
            DataNode<ModuleData> dataNode = dependentModule;
            boolean $i$f$map = false;
            $this$map$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataNode $i$f$mapNotNull2 = (DataNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.data");
                String string = ((ModuleData)object).getInternalName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames(dataNode, (List<String>)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DataNode<GradleSourceSetData>> getSourceSetsMap(@NotNull DataNode<ModuleData> $this$getSourceSetsMap) {
        void $this$associateByTo$iv$iv;
        Collection collection = ExternalSystemApiUtil.getChildren($this$getSourceSetsMap, (Key)GradleSourceSetData.KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026 GradleSourceSetData.KEY)");
        Iterable $this$associateBy$iv = collection;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v1);
            map2.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final String getSourceSetName(@NotNull DataNode<? extends ModuleData> $this$sourceSetName) {
        Object object;
        Object object2 = $this$sourceSetName.getData();
        if (!(object2 instanceof GradleSourceSetData)) {
            object2 = null;
        }
        return (object = (GradleSourceSetData)object2) != null && (object = object.getId()) != null ? StringsKt.substringAfterLast$default((String)object, (char)':', null, (int)2, null) : null;
    }

    private final void addDependency(DataNode<? extends ModuleData> ideModule, DataNode<? extends ModuleData> targetModule) {
        ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ideModule.getData(), (ModuleData)targetModule.getData());
        moduleDependencyData.setScope(DependencyScope.COMPILE);
        moduleDependencyData.setExported(false);
        moduleDependencyData.setProductionOnTestDependency(Intrinsics.areEqual((Object)this.getSourceSetName(targetModule), (Object)"test"));
        ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
    }

    private final DataNode<ModuleData> findModuleById(DataNode<ProjectData> ideProject, IdeaModule gradleModule, String moduleId) {
        Object v8;
        block4: {
            String string;
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
            ProjectImportAction.AllModels allModels = projectResolverContext.getModels();
            Intrinsics.checkExpressionValueIsNotNull((Object)allModels, (String)"resolverCtx.models");
            boolean isCompositeProject = Intrinsics.areEqual((Object)allModels.getIdeaProject(), (Object)gradleModule.getProject()) ^ true;
            if (isCompositeProject && StringsKt.startsWith$default((String)moduleId, (String)":", (boolean)false, (int)2, null)) {
                IdeaProject ideaProject = gradleModule.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                string = ideaProject.getName();
            } else {
                string = "";
            }
            String compositePrefix = string;
            String fullModuleId = compositePrefix + moduleId;
            Collection collection = ideProject.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ideProject.children");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DataNode it = (DataNode)t;
                boolean bl3 = false;
                DataNode dataNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"it");
                Object object = dataNode.getData();
                if (!(object instanceof ModuleData)) {
                    object = null;
                }
                ModuleData moduleData = (ModuleData)object;
                if (!Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)fullModuleId)) continue;
                v8 = t;
                break block4;
            }
            v8 = null;
        }
        return v8;
    }

    public KotlinGradleProjectResolverExtension() {
        Logger logger = Logger.getInstance(PsiPrecedences.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PsiPrecedences::class.java)");
        this.LOG = logger;
    }
}

