/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.LibraryKindSearchScope;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.ProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinAddRequiredModuleFix;
import org.jetbrains.kotlin.idea.util.Java9StructureUtilKt;
import org.jetbrains.kotlin.idea.util.VersioningKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.SuppressNotificationState;
import org.jetbrains.kotlin.idea.vfilefinder.IDEVirtualFileFinder;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a/\u0010\u0017\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0012\u0012\u000e\b\u0001\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u00180\u0018\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010!\u001a\u00020\"\u001a\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0019\u001a\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0019\u001a\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$2\u0006\u0010!\u001a\u00020\"\u001a\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020(0$2\u0006\u0010!\u001a\u00020\"\u001a6\u0010*\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190 0+2\u0006\u0010!\u001a\u00020\"2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140 \u001a\u0010\u0010-\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0007\u001a\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140 2\u0006\u0010!\u001a\u00020\"\u001a\u0010\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u000e\u00101\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u000204\u001a\u000e\u00105\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u00106\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020(\u001a\u000e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020(\u001a\u000e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0007\u001a\u000e\u0010=\u001a\u00020>2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010?\u001a\u00020\u0012*\u00020\u00192\u0006\u00108\u001a\u00020(H\u0002\u001a\u0012\u0010@\u001a\u00020\u0007*\u00020A2\u0006\u0010B\u001a\u00020\u0012\u001a\n\u0010C\u001a\u00020\u0007*\u00020\u0001\u001a\n\u0010D\u001a\u00020\u0007*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0011\u0010\u000f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0003\u00a8\u0006E"}, d2={"DEFAULT_GRADLE_PLUGIN_REPOSITORY", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "getDEFAULT_GRADLE_PLUGIN_REPOSITORY", "()Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "EAP_REPOSITORY", "getEAP_REPOSITORY", "JCENTER", "", "getJCENTER", "()Ljava/lang/String;", "KOTLIN_GROUP_ID", "getKOTLIN_GROUP_ID", "LAST_SNAPSHOT_VERSION", "MAVEN_CENTRAL", "getMAVEN_CENTRAL", "SNAPSHOT_REPOSITORY", "getSNAPSHOT_REPOSITORY", "addStdlibToJavaModuleInfo", "", "module", "Lcom/intellij/openapi/module/Module;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "allConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "kotlin.jvm.PlatformType", "()[Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "devRepository", "version", "findApplicableConfigurator", "getAbleToRunConfigurators", "", "project", "Lcom/intellij/openapi/project/Project;", "getCanBeConfiguredModules", "", "configurator", "getCanBeConfiguredModulesWithKotlinFiles", "getConfigurableModules", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getConfigurableModulesWithKotlinFiles", "getConfigurationPossibilitiesForConfigureNotification", "Lkotlin/Pair;", "excludeModules", "getConfiguratorByName", "name", "getModulesWithKotlinFiles", "getRepositoryForVersion", "hasAnyKotlinRuntimeInScope", "hasKotlinCommonRuntimeInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasKotlinJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isModuleConfigured", "moduleSourceRootGroup", "isNotConfiguredNotificationRequired", "moduleGroup", "isRepositoryConfigured", "repositoriesBlockText", "showConfigureKotlinNotificationIfNeeded", "", "canConfigure", "toGradleCompileScope", "Lcom/intellij/openapi/roots/DependencyScope;", "isAndroidModule", "toGroovyRepositorySnippet", "toKotlinRepositorySnippet", "idea-jvm"})
public final class ConfigureKotlinInProjectUtilsKt {
    @NotNull
    public static final String LAST_SNAPSHOT_VERSION = "1.3-SNAPSHOT";
    @NotNull
    private static final RepositoryDescription SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "https://oss.sonatype.org/content/repositories/snapshots", null, true);
    @NotNull
    private static final RepositoryDescription EAP_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin EAP Repository", "https://dl.bintray.com/kotlin/kotlin-eap", "https://bintray.com/kotlin/kotlin-eap/kotlin/", false);
    @NotNull
    private static final RepositoryDescription DEFAULT_GRADLE_PLUGIN_REPOSITORY = new RepositoryDescription("default.gradle.plugins", "Default Gradle Plugin Repository", "https://plugins.gradle.org/m2/", null, false);
    @NotNull
    private static final String MAVEN_CENTRAL = "mavenCentral()";
    @NotNull
    private static final String JCENTER = "jcenter()";
    @NotNull
    private static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    @NotNull
    public static final RepositoryDescription getSNAPSHOT_REPOSITORY() {
        return SNAPSHOT_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getEAP_REPOSITORY() {
        return EAP_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getDEFAULT_GRADLE_PLUGIN_REPOSITORY() {
        return DEFAULT_GRADLE_PLUGIN_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription devRepository(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new RepositoryDescription("teamcity.kotlin.dev", "Teamcity Repository of Kotlin Development Builds", "https://teamcity.jetbrains.com/guestAuth/app/rest/builds/buildType:(id:Kotlin_dev_Compiler),number:" + version + ",branch:default:any/artifacts/content/maven/", null, false);
    }

    @NotNull
    public static final String getMAVEN_CENTRAL() {
        return MAVEN_CENTRAL;
    }

    @NotNull
    public static final String getJCENTER() {
        return JCENTER;
    }

    @NotNull
    public static final String getKOTLIN_GROUP_ID() {
        return KOTLIN_GROUP_ID;
    }

    public static final boolean isRepositoryConfigured(@NotNull String repositoriesBlockText) {
        Intrinsics.checkParameterIsNotNull((Object)repositoriesBlockText, (String)"repositoriesBlockText");
        return StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)MAVEN_CENTRAL, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)JCENTER, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String toGradleCompileScope(@NotNull DependencyScope $this$toGradleCompileScope, boolean isAndroidModule) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$toGradleCompileScope, (String)"$this$toGradleCompileScope");
        switch (ConfigureKotlinInProjectUtilsKt$WhenMappings.$EnumSwitchMapping$0[$this$toGradleCompileScope.ordinal()]) {
            case 1: {
                string = "compile";
                break;
            }
            case 2: {
                if (isAndroidModule) {
                    string = "compile";
                    break;
                }
                string = "testCompile";
                break;
            }
            case 3: {
                string = "runtime";
                break;
            }
            case 4: {
                string = "compile";
                break;
            }
            default: {
                string = "compile";
            }
        }
        return string;
    }

    @NotNull
    public static final String toGroovyRepositorySnippet(@NotNull RepositoryDescription $this$toGroovyRepositorySnippet) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toGroovyRepositorySnippet, (String)"$this$toGroovyRepositorySnippet");
        return "maven { url '" + $this$toGroovyRepositorySnippet.getUrl() + "' }";
    }

    @NotNull
    public static final String toKotlinRepositorySnippet(@NotNull RepositoryDescription $this$toKotlinRepositorySnippet) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toKotlinRepositorySnippet, (String)"$this$toKotlinRepositorySnippet");
        return "maven { setUrl(\"" + $this$toKotlinRepositorySnippet.getUrl() + "\") }";
    }

    @Nullable
    public static final RepositoryDescription getRepositoryForVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return KotlinRuntimeLibraryUtilKt.isSnapshot(version) ? SNAPSHOT_REPOSITORY : (VersioningKt.isEap(version) ? EAP_REPOSITORY : (VersioningKt.isDev(version) ? ConfigureKotlinInProjectUtilsKt.devRepository(version) : null));
    }

    public static final boolean isModuleConfigured(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
            KotlinProjectConfigurator[] $this$any$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean $i$f$any = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$any$iv;
            int n = kotlinProjectConfiguratorArray.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator element$iv;
                KotlinProjectConfigurator it = element$iv = kotlinProjectConfiguratorArray[j];
                boolean bl2 = false;
                if (!(it.getStatus(moduleSourceRootGroup) == ConfigureKotlinStatus.CONFIGURED)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(project){
            final /* synthetic */ Project $project;

            public final boolean invoke() {
                return !this.$project.isDisposed() && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
            }
            {
                this.$project = project;
                super(0);
            }
        })).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = ProjectStructureUtilKt.allModules(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module module = (Module)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module, project){
                final /* synthetic */ Module $module;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$module = module;
                    this.$project$inlined = project;
                    super(0);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke() {
                    if (this.$project$inlined.isDisposed()) return false;
                    Module module = this.$module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"module");
                    if (module.isDisposed()) return false;
                    if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)this.$module.getModuleScope(true))) return false;
                    return true;
                }
            })).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModulesWithKotlinFiles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return new ModuleSourceRootMap(project).groupByBaseModules(modules);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
        if (!ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(moduleGroup)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project, null, 2, null);
    }

    public static final boolean isNotConfiguredNotificationRequired(@NotNull ModuleSourceRootGroup moduleGroup) {
        Intrinsics.checkParameterIsNotNull((Object)moduleGroup, (String)"moduleGroup");
        return !SuppressNotificationState.Companion.isKotlinNotConfiguredSuppressed(moduleGroup) && !ConfigureKotlinInProjectUtilsKt.isModuleConfigured(moduleGroup);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<ModuleSourceRootGroup> modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModules(project);
        KotlinProjectConfigurator[] $this$filter$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean $i$f$filter = false;
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            boolean bl;
            void element$iv$iv;
            block4: {
                void configurator = element$iv$iv = var7_7[j];
                boolean bl2 = false;
                Iterable $this$any$iv = modules;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv;
                        boolean bl3 = false;
                        if (!(configurator.getStatus(it) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModules(@NotNull Project project) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection $this$ifEmpty$iv = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            collection = new ModuleSourceRootMap(project).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project));
        } else {
            void var1_1;
            collection = var1_1;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Module module) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
        KotlinProjectConfigurator[] $this$filter$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean $i$f$filter = false;
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[j];
            boolean bl = false;
            if (!(it.getStatus(moduleGroup) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        KotlinProjectConfigurator kotlinProjectConfigurator;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            KotlinProjectConfigurator[] $this$firstOrNull$iv = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean $i$f$firstOrNull = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = $this$firstOrNull$iv;
            int n = kotlinProjectConfiguratorArray.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator element$iv;
                KotlinProjectConfigurator it = element$iv = kotlinProjectConfiguratorArray[j];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                kotlinProjectConfigurator = element$iv;
                break block1;
            }
            kotlinProjectConfigurator = null;
        }
        return kotlinProjectConfigurator;
    }

    @NotNull
    public static final KotlinProjectConfigurator[] allConfigurators() {
        Object[] objectArray = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getExtensions\u2026jectConfigurator.EP_NAME)");
        return (KotlinProjectConfigurator[])objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getCanBeConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $this$mapTo$iv$iv;
        ModuleSourceRootGroup it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Iterable $this$filter$iv = new ModuleSourceRootMap(project).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            boolean bl = false;
            if (!ConfigureKotlinInProjectUtilsKt.canConfigure(configurator, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Module module = it.getBaseModule();
            collection.add(module);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canConfigure(@NotNull KotlinProjectConfigurator $this$canConfigure, ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        if ($this$canConfigure.getStatus(moduleSourceRootGroup) != ConfigureKotlinStatus.CAN_BE_CONFIGURED) return false;
        Iterable $this$none$iv = CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])ConfigureKotlinInProjectUtilsKt.allConfigurators()), (Object)$this$canConfigure);
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
            boolean bl2 = false;
            if (it.getStatus(moduleSourceRootGroup) == ConfigureKotlinStatus.CONFIGURED) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getCanBeConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $this$mapTo$iv$iv;
        ModuleSourceRootGroup it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        List<ModuleSourceRootGroup> modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        Iterable $this$filter$iv = modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            boolean bl = false;
            if (!(configurator.getStatus(it) == ConfigureKotlinStatus.CAN_BE_CONFIGURED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Module module = it.getBaseModule();
            collection.add(module);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Pair<Collection<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> getConfigurationPossibilitiesForConfigureNotification(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        List<ModuleSourceRootGroup> modulesWithKotlinFiles = ModuleSourceRootMapKt.exclude(ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project), excludeModules);
        KotlinProjectConfigurator[] configurators = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        boolean bl = false;
        Set runnableConfigurators = new LinkedHashSet();
        boolean bl2 = false;
        List configurableModules = new ArrayList();
        for (ModuleSourceRootGroup moduleSourceRootGroup : modulesWithKotlinFiles) {
            boolean moduleCanBeConfigured = false;
            boolean moduleAlreadyConfigured = false;
            block5: for (KotlinProjectConfigurator configurator : configurators) {
                if (moduleCanBeConfigured && runnableConfigurators.contains(configurator)) continue;
                ConfigureKotlinStatus status2 = configurator.getStatus(moduleSourceRootGroup);
                switch (ConfigureKotlinInProjectUtilsKt$WhenMappings.$EnumSwitchMapping$1[status2.ordinal()]) {
                    case 1: {
                        moduleCanBeConfigured = true;
                        KotlinProjectConfigurator kotlinProjectConfigurator = configurator;
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfigurator, (String)"configurator");
                        runnableConfigurators.add(kotlinProjectConfigurator);
                        continue block5;
                    }
                    case 2: {
                        moduleAlreadyConfigured = true;
                    }
                }
            }
            if (!moduleCanBeConfigured || moduleAlreadyConfigured || SuppressNotificationState.Companion.isKotlinNotConfiguredSuppressed(moduleSourceRootGroup)) continue;
            configurableModules.add(moduleSourceRootGroup);
        }
        return TuplesKt.to((Object)configurableModules, (Object)runnableConfigurators);
    }

    public static /* synthetic */ Pair getConfigurationPossibilitiesForConfigureNotification$default(Project project, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getConfigurationPossibilitiesForConfigureNotification(project, collection);
    }

    @NotNull
    public static final KotlinProjectConfigurator findApplicableConfigurator(@NotNull Module module) {
        KotlinProjectConfigurator kotlinProjectConfigurator;
        KotlinProjectConfigurator kotlinProjectConfigurator2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            boolean bl = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray2 = kotlinProjectConfiguratorArray;
            boolean bl2 = false;
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray3 = kotlinProjectConfiguratorArray2;
            int n = kotlinProjectConfiguratorArray3.length;
            for (int j = 0; j < n; ++j) {
                KotlinProjectConfigurator kotlinProjectConfigurator3;
                KotlinProjectConfigurator it = kotlinProjectConfigurator3 = kotlinProjectConfiguratorArray3[j];
                boolean bl3 = false;
                if (!(it.getStatus(moduleGroup) != ConfigureKotlinStatus.NON_APPLICABLE)) continue;
                kotlinProjectConfigurator2 = kotlinProjectConfigurator3;
                break block2;
            }
            kotlinProjectConfigurator2 = kotlinProjectConfigurator = null;
        }
        if (kotlinProjectConfigurator2 == null) {
            kotlinProjectConfigurator = KotlinJavaModuleConfigurator.Companion.getInstance();
        }
        return kotlinProjectConfigurator;
    }

    public static final boolean hasAnyKotlinRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                if (KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, scope2) != null) return true;
                Project project2 = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
                if (KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project2, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, scope2, JSLibraryKind.INSTANCE))) return true;
                if (!ConfigureKotlinInProjectUtilsKt.hasKotlinCommonRuntimeInScope(scope2)) return false;
                return true;
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                return KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, scope2) != null;
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope globalSearchScope = this.$module.getModuleWithDependenciesAndLibrariesScope(ProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"module.getModuleWithDepe\u2026FilesOnlyInTests(module))");
                GlobalSearchScope scope2 = globalSearchScope;
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                return KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, scope2, JSLibraryKind.INSTANCE));
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinCommonRuntimeInScope(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        IDEVirtualFileFinder iDEVirtualFileFinder = new IDEVirtualFileFinder(scope2);
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return iDEVirtualFileFinder.hasMetadataPackage(fqName2);
    }

    public static final boolean addStdlibToJavaModuleInfo(@NotNull Module module, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Sdk sdk2 = ProjectStructureUtilKt.getSdk(module);
        if (sdk2 == null || (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) == null || !sdk2.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            return false;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        PsiJavaModule psiJavaModule = Java9StructureUtilKt.findFirstPsiJavaModule(module);
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule javaModule = psiJavaModule;
        Boolean success2 = (Boolean)WriteCommandAction.runWriteCommandAction((Project)project2, (Computable)((Computable)new Computable<Boolean>(javaModule){
            final /* synthetic */ PsiJavaModule $javaModule;

            public final boolean compute() {
                return KotlinAddRequiredModuleFix.Companion.addModuleRequirement(this.$javaModule, "kotlin.stdlib");
            }
            {
                this.$javaModule = psiJavaModule;
            }
        }));
        if (!success2.booleanValue()) {
            return false;
        }
        collector2.addMessage("Added kotlin.stdlib requirement to module-info in " + module.getName());
        return true;
    }

    static {
        MAVEN_CENTRAL = MAVEN_CENTRAL;
        JCENTER = JCENTER;
        KOTLIN_GROUP_ID = KOTLIN_GROUP_ID;
    }
}

