/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0019J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/container/ComponentProvider;)V", "bodyResolveCache", "Lorg/jetbrains/kotlin/resolve/BodyResolveCache;", "cache", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "codeFragmentAnalyzer", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "analyze", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getAnalysisResults", "element", "lookUp", "idea-core"})
public final class PerFileAnalysisCache {
    private final GlobalContext globalContext;
    private final ModuleDescriptor moduleDescriptor;
    private final ResolveSession resolveSession;
    private final CodeFragmentAnalyzer codeFragmentAnalyzer;
    private final BodyResolveCache bodyResolveCache;
    private final HashMap<PsiElement, AnalysisResult> cache;
    @NotNull
    private final KtFile file;

    private final AnalysisResult lookUp(KtElement analyzableElement) {
        boolean bl = false;
        ArrayList<PsiElement> descendantsOfCurrent = new ArrayList<PsiElement>();
        boolean bl2 = false;
        HashSet toRemove = new HashSet();
        AnalysisResult result2 = null;
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf((PsiElement)analyzableElement)) {
            AnalysisResult cached = this.cache.get(current);
            if (cached != null) {
                result2 = cached;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            descendantsOfCurrent.add(current);
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AnalysisResult getAnalysisResults(@NotNull KtElement element3) {
        AnalysisResult analysisResult;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        boolean bl = Intrinsics.areEqual((Object)element3.getContainingKtFile(), (Object)this.file);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Wrong file. Expected " + this.file + ", but was " + element3.getContainingKtFile();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtElement analyzableParent = KotlinResolveDataProvider.INSTANCE.findAnalyzableParent(element3);
        PerFileAnalysisCache perFileAnalysisCache = this;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (perFileAnalysisCache) {
            AnalysisResult analysisResult2;
            boolean bl6 = false;
            AnalysisResult cached = this.lookUp(analyzableParent);
            if (cached != null) {
                analysisResult2 = cached;
            } else {
                AnalysisResult result2 = this.analyze(analyzableParent);
                ((Map)this.cache).put(analyzableParent, result2);
                analysisResult2 = result2;
            }
            analysisResult = analysisResult2;
        }
        return analysisResult;
    }

    private final AnalysisResult analyze(KtElement analyzableElement) {
        Project project = analyzableElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"analyzableElement.project");
        Project project2 = project;
        if (DumbService.isDumb((Project)project2)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        try {
            return KotlinResolveDataProvider.INSTANCE.analyze(project2, this.globalContext, this.moduleDescriptor, this.resolveSession, this.codeFragmentAnalyzer, this.bodyResolveCache, analyzableElement);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.internalError(bindingContext2, e);
        }
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public PerFileAnalysisCache(@NotNull KtFile file2, @NotNull ComponentProvider componentProvider) {
        ComponentProvider $this$get$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        this.file = file2;
        ComponentProvider componentProvider2 = componentProvider;
        PerFileAnalysisCache perFileAnalysisCache = this;
        boolean $i$f$get = false;
        Object object = DslKt.getService($this$get$iv, GlobalContext.class);
        perFileAnalysisCache.globalContext = object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, ModuleDescriptor.class);
        perFileAnalysisCache.moduleDescriptor = (ModuleDescriptor)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, ResolveSession.class);
        perFileAnalysisCache.resolveSession = (ResolveSession)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, CodeFragmentAnalyzer.class);
        perFileAnalysisCache.codeFragmentAnalyzer = (CodeFragmentAnalyzer)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, BodyResolveCache.class);
        perFileAnalysisCache.bodyResolveCache = (BodyResolveCache)object;
        this.cache = new HashMap();
    }
}

