/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.actions.NewKotlinFileHook;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0014J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J2\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020\u0014H\u0016\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/actions/NewKotlinFileAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "createFileFromTemplate", "Lcom/intellij/psi/PsiFile;", "name", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "equals", "", "other", "", "getActionName", "newName", "templateName", "hashCode", "", "isAvailable", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "postProcess", "createdElement", "customProperties", "", "startInWriteAction", "Companion", "idea"})
public final class NewKotlinFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    private static final char[] FILE_SEPARATORS;
    private static final char[] FQNAME_SEPARATORS;
    public static final Companion Companion;

    protected void postProcess(@Nullable PsiFile createdElement, @Nullable String templateName, @Nullable Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        PsiFile psiFile = createdElement;
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile));
        if (createdElement instanceof KtFile) {
            KtNamedDeclaration ktClass2;
            Object object;
            if (module != null) {
                for (NewKotlinFileHook hook : (NewKotlinFileHook[])NewKotlinFileHook.Companion.getEP_NAME().getExtensions()) {
                    hook.postProcess((KtFile)createdElement, module);
                }
            }
            if (!((object = CollectionsKt.singleOrNull(((KtFile)createdElement).getDeclarations())) instanceof KtNamedDeclaration)) {
                object = null;
            }
            if ((ktClass2 = (KtNamedDeclaration)object) != null) {
                CreateFromTemplateAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)ktClass2);
            } else {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)((KtFile)createdElement).getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getIns\u2026e(createdElement.project)");
                Editor editor2 = fileEditorManager.getSelectedTextEditor();
                if (editor2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"FileEditorManager.getIns\u2026ectedTextEditor ?: return");
                Editor editor3 = editor2;
                Document document = editor3.getDocument();
                FileViewProvider fileViewProvider = ((KtFile)createdElement).getViewProvider();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"createdElement.viewProvider");
                if (Intrinsics.areEqual((Object)document, (Object)fileViewProvider.getDocument())) {
                    Document document2 = editor3.getDocument();
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editor.document");
                    int lineCount = document2.getLineCount();
                    if (lineCount > 0) {
                        editor3.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineCount - 1, 0));
                    }
                }
            }
        }
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        CreateFileFromTemplateDialog.Builder builder2 = builder.setTitle("New Kotlin File/Class");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        builder2.addKind("File", kotlinFileType.getIcon(), "Kotlin File").addKind("Class", KotlinIcons.CLASS, "Kotlin Class").addKind("Interface", KotlinIcons.INTERFACE, "Kotlin Interface").addKind("Enum class", KotlinIcons.ENUM, "Kotlin Enum").addKind("Object", KotlinIcons.OBJECT, "Kotlin Object");
        builder.setValidator((InputValidator)Companion.NameValidator.INSTANCE);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName2, @NotNull String templateName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        return "Kotlin File/Class";
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (super.isAvailable(dataContext)) {
            boolean bl;
            block4: {
                Object object = LangDataKeys.IDE_VIEW.getData(dataContext);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"LangDataKeys.IDE_VIEW.getData(dataContext)!!");
                IdeView ideView = (IdeView)object;
                Object object2 = PlatformDataKeys.PROJECT.getData(dataContext);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"PlatformDataKeys.PROJECT.getData(dataContext)!!");
                Project project = (Project)object2;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                PsiDirectory[] psiDirectoryArray = ideView.getDirectories();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectoryArray, (String)"ideView.directories");
                PsiDirectory[] $this$any$iv = psiDirectoryArray;
                boolean $i$f$any = false;
                PsiDirectory[] psiDirectoryArray2 = $this$any$iv;
                int n = psiDirectoryArray2.length;
                for (int j = 0; j < n; ++j) {
                    PsiDirectory element$iv;
                    PsiDirectory it = element$iv = psiDirectoryArray2[j];
                    boolean bl2 = false;
                    PsiDirectory psiDirectory = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"it");
                    if (!projectFileIndex2.isInSourceContent(psiDirectory.getVirtualFile())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof NewKotlinFileAction;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name2, @NotNull FileTemplate template2, @NotNull PsiDirectory dir) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return Companion.createFileFromTemplateWithStat(name2, template2, dir);
    }

    public NewKotlinFileAction() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        super("Kotlin File/Class", "Creates new Kotlin file or class", kotlinFileType.getIcon());
    }

    static {
        Companion = new Companion(null);
        FILE_SEPARATORS = new char[]{'/', '\\'};
        FQNAME_SEPARATORS = new char[]{'/', '\\', '.'};
    }

    public static final /* synthetic */ Logger access$getLOG$p$s-1549423502() {
        return CreateFileFromTemplateAction.LOG;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/actions/NewKotlinFileAction$Companion;", "", "()V", "FILE_SEPARATORS", "", "FQNAME_SEPARATORS", "nameValidator", "Lcom/intellij/openapi/ui/InputValidatorEx;", "getNameValidator", "()Lcom/intellij/openapi/ui/InputValidatorEx;", "createFileFromTemplate", "Lcom/intellij/psi/PsiFile;", "name", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "Lcom/intellij/psi/PsiDirectory;", "createFileFromTemplateWithStat", "createFromTemplate", "className", "findOrCreateTarget", "Lkotlin/Pair;", "directorySeparators", "NameValidator", "idea"})
    public static final class Companion {
        @NotNull
        public final InputValidatorEx getNameValidator() {
            return NameValidator.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<String, PsiDirectory> findOrCreateTarget(PsiDirectory dir, String name2, char[] directorySeparators) {
            void targetDir;
            String className2 = StringsKt.substringBeforeLast$default((String)name2, (String)".kt", null, (int)2, null);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = dir;
            for (char splitChar : directorySeparators) {
                if (!StringsKt.contains$default((CharSequence)className2, (char)splitChar, (boolean)false, (int)2, null)) continue;
                String string = className2;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                List names2 = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char[])new char[]{splitChar}, (boolean)false, (int)0, (int)6, null);
                for (String dirName : CollectionsKt.dropLast((List)names2, (int)1)) {
                    PsiDirectory psiDirectory = ((PsiDirectory)targetDir.element).findSubdirectory(dirName);
                    if (psiDirectory == null) {
                        Object t = ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>((Ref.ObjectRef)targetDir, dirName){
                            final /* synthetic */ Ref.ObjectRef $targetDir;
                            final /* synthetic */ String $dirName;

                            @NotNull
                            public final PsiDirectory invoke() {
                                return ((PsiDirectory)this.$targetDir.element).createSubdirectory(this.$dirName);
                            }
                            {
                                this.$targetDir = objectRef;
                                this.$dirName = string;
                                super(0);
                            }
                        });
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"runWriteAction {\n       \u2026                        }");
                        psiDirectory = (PsiDirectory)t;
                    }
                    targetDir.element = psiDirectory;
                }
                className2 = (String)CollectionsKt.last((List)names2);
                break;
            }
            return new Pair((Object)className2, (Object)((PsiDirectory)targetDir.element));
        }

        private final PsiFile createFromTemplate(PsiDirectory dir, String className2, FileTemplate template2) {
            PsiElement element3;
            PsiElement psiElement2;
            Project project = dir.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"dir.project");
            Project project2 = project;
            FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTemplateManager, (String)"FileTemplateManager.getInstance(project)");
            Properties properties2 = fileTemplateManager.getDefaultProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)properties2, (String)"FileTemplateManager.getI\u2026roject).defaultProperties");
            Properties defaultProperties = properties2;
            Properties properties3 = new Properties(defaultProperties);
            try {
                psiElement2 = new CreateFromTemplateDialog(project2, dir, template2, new AttributesDefaults(className2).withFixedName(true), properties3).create();
            }
            catch (IncorrectOperationException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                NewKotlinFileAction.access$getLOG$p$s-1549423502().error((Throwable)e);
                return null;
            }
            PsiElement psiElement3 = element3 = psiElement2;
            return psiElement3 != null ? psiElement3.getContainingFile() : null;
        }

        @Nullable
        public final PsiFile createFileFromTemplateWithStat(@NotNull String name2, @NotNull FileTemplate template2, @NotNull PsiDirectory dir) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            String string = template2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template.name");
            KotlinFUSLogger.Companion.log(FUSEventGroups.NewFileTemplate, string);
            return this.createFileFromTemplate(name2, template2, dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final PsiFile createFileFromTemplate(@NotNull String name2, @NotNull FileTemplate template2, @NotNull PsiDirectory dir) {
            DumbService service;
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)template2, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            char[] directorySeparators = Intrinsics.areEqual((Object)template2.getName(), (Object)"Kotlin File") ? FILE_SEPARATORS : FQNAME_SEPARATORS;
            Pair<String, PsiDirectory> pair2 = this.findOrCreateTarget(dir, name2, directorySeparators);
            String string = (String)pair2.component1();
            PsiDirectory targetDir = (PsiDirectory)pair2.component2();
            DumbService dumbService = service = DumbService.getInstance((Project)dir.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"service");
            dumbService.setAlternativeResolveEnabled(true);
            try {
                void className2;
                PsiFile psiFile = this.createFromTemplate(targetDir, (String)className2, template2);
                if (psiFile instanceof KtFile) {
                    KtClass singleClass;
                    Object object = CollectionsKt.singleOrNull(((KtFile)psiFile).getDeclarations());
                    if (!(object instanceof KtClass)) {
                        object = null;
                    }
                    if ((singleClass = (KtClass)object) != null && !singleClass.isEnum() && !singleClass.isInterface() && StringsKt.contains$default((CharSequence)name2, (CharSequence)"Abstract", (boolean)false, (int)2, null)) {
                        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(singleClass){
                            final /* synthetic */ KtClass $singleClass;

                            public final void invoke() {
                                this.$singleClass.addModifier(KtTokens.ABSTRACT_KEYWORD);
                            }
                            {
                                this.$singleClass = ktClass2;
                                super(0);
                            }
                        });
                    }
                }
                PsiFile psiFile2 = psiFile;
                return psiFile2;
            }
            finally {
                service.setAlternativeResolveEnabled(false);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/actions/NewKotlinFileAction$Companion$NameValidator;", "Lcom/intellij/openapi/ui/InputValidatorEx;", "()V", "canClose", "", "inputString", "", "checkInput", "getErrorText", "idea"})
        private static final class NameValidator
        implements InputValidatorEx {
            public static final NameValidator INSTANCE;

            @Nullable
            public String getErrorText(@NotNull String inputString) {
                boolean bl;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                    CharSequence charSequence = inputString;
                    boolean bl2 = false;
                    charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                    bl2 = false;
                    if (charSequence.length() == 0) {
                        return "Name can't be empty";
                    }
                    char[] cArray = FQNAME_SEPARATORS;
                    List parts = StringsKt.split$default((CharSequence)inputString, (char[])Arrays.copyOf(cArray, cArray.length), (boolean)false, (int)0, (int)6, null);
                    Iterable $this$any$iv = parts;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            CharSequence charSequence2 = it;
                            boolean bl4 = false;
                            String string = charSequence2;
                            if (string == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            charSequence2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            bl4 = false;
                            if (!(charSequence2.length() == 0)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return "Name can't have empty parts";
                }
                return null;
            }

            public boolean checkInput(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return true;
            }

            public boolean canClose(@NotNull String inputString) {
                Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }

            private NameValidator() {
            }

            static {
                NameValidator nameValidator2;
                INSTANCE = nameValidator2 = new NameValidator();
            }
        }
    }
}

