/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinActionKt;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinActionKt$sam$java_lang_Runnable$0;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.JavaToKotlinConverterFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u001a\u001a\u00020\u0014*\u00020\tH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allJavaFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "isAnyJavaFileSelected", "", "files", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isEnabled", "selectedJavaFiles", "update", "isSuitableDirectory", "Companion", "idea"})
public final class JavaToKotlinAction
extends AnAction {
    @NotNull
    private static final String title = "Convert Java to Kotlin";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiErrorElement firstSyntaxError2;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List javaFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter(this.selectedJavaFiles(e), (Function1)actionPerformed.javaFiles.1.INSTANCE));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CommonDataKeys.PROJECT.getData(e.dataContext)!!");
        Project project = (Project)object;
        if (javaFiles2.isEmpty()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Nothing to convert:<br>No writable Java files found", MessageType.ERROR, null).createBalloon();
            StatusBar statusBar2 = statusBar;
            Intrinsics.checkExpressionValueIsNotNull((Object)statusBar2, (String)"statusBar");
            balloon.showInCenterOf(statusBar2.getComponent());
        }
        if ((firstSyntaxError2 = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles2), (Function1)actionPerformed.firstSyntaxError.1.INSTANCE))) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = javaFiles2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            int count = $this$filter$iv.size();
            StringBuilder stringBuilder = new StringBuilder();
            PsiFile psiFile = firstSyntaxError2.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"firstSyntaxError.containingFile");
            String question = stringBuilder.append(psiFile.getName()).append(count > 1 ? " and " + (count - 1) + " more Java files" : " file").append(" contain syntax errors, the conversion result may be incorrect").toString();
            String okText = "Investigate Errors";
            String cancelText = "Proceed with Conversion";
            if (Messages.showOkCancelDialog((Project)project, (String)question, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)firstSyntaxError2.getNavigationElement());
                return;
            }
        }
        org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.convertFiles$default(Companion, javaFiles2, project, false, false, 12, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        if (CidrUtil.isRunningInCidrIde()) {
            return false;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"e.getData(CommonDataKeys\u2026LE_ARRAY) ?: return false");
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return false");
        Project project2 = project;
        return this.isAnyJavaFileSelected(project2, virtualFiles);
    }

    private final boolean isAnyJavaFileSelected(Project project, VirtualFile[] files2) {
        boolean bl;
        block4: {
            boolean bl2;
            int n;
            block3: {
                VirtualFile[] $this$any$iv = files2;
                boolean $i$f$any = false;
                VirtualFile[] virtualFileArray = $this$any$iv;
                int n2 = virtualFileArray.length;
                for (n = 0; n < n2; ++n) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = virtualFileArray[n];
                    boolean bl3 = false;
                    if (!this.isSuitableDirectory(it)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager manager = psiManager;
            VirtualFile[] $this$any$iv = files2;
            boolean $i$f$any = false;
            VirtualFile[] virtualFileArray = $this$any$iv;
            n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray[j];
                boolean bl4 = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"java") && manager.findFile(it) instanceof PsiJavaFile && it.isWritable())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSuitableDirectory(@NotNull VirtualFile $this$isSuitableDirectory) {
        return $this$isSuitableDirectory.isDirectory() && !($this$isSuitableDirectory.getFileType() instanceof ArchiveFileType) && $this$isSuitableDirectory.isWritable();
    }

    private final Sequence<PsiJavaFile> selectedJavaFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"e.getData(CommonDataKeys\u2026Y) ?: return sequenceOf()");
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return sequenceOf()");
        Project project2 = project;
        return this.allJavaFiles(virtualFiles, project2);
    }

    private final Sequence<PsiJavaFile> allJavaFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager manager = psiManager;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof PsiJavaFile)) {
                    psiFile = null;
                }
                return (PsiJavaFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (VirtualFile file2 : filesOrDirs) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    static {
        title = title;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Companion;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "javaFiles", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertedTexts", "uniqueKotlinFileName", "javaFile", "idea"})
    public static final class Companion {
        private final String uniqueKotlinFileName(VirtualFile javaFile) {
            String string = javaFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaFile.path");
            File ioFile = new File(StringsKt.replace$default((String)string, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
            int i2 = 0;
            String fileName;
            while (FilesKt.resolveSibling((File)ioFile, (String)(fileName = javaFile.getNameWithoutExtension() + (i2 > 0 ? Integer.valueOf(i2) : "") + ".kt")).exists()) {
                ++i2;
            }
            return fileName;
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles2, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair2 : CollectionsKt.zip((Iterable)javaFiles2, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile = (PsiJavaFile)pair2.component1();
                String text2 = (String)pair2.component2();
                try {
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument((PsiFile)psiFile);
                    if (document == null) {
                        MessagesEx.error((Project)psiFile.getProject(), (String)("Failed to save conversion result: couldn't find document for " + psiFile.getName())).showLater();
                        continue;
                    }
                    document.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile2 = psiFile.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile2)) {
                        PerFileMappings mapping2;
                        ScratchFileService scratchFileService = ScratchFileService.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)scratchFileService, (String)"ScratchFileService.getInstance()");
                        Intrinsics.checkExpressionValueIsNotNull((Object)scratchFileService.getScratchesMapping(), (String)"ScratchFileService.getInstance().scratchesMapping");
                        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
                        mapping2.setMapping(virtualFile2, (Object)kotlinFileType.getLanguage());
                        continue;
                    }
                    VirtualFile virtualFile3 = virtualFile2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                    String fileName = this.uniqueKotlinFileName(virtualFile3);
                    JavaToKotlinActionKt.setPathBeforeJ2K(virtualFile2, virtualFile2.getPath());
                    virtualFile2.rename((Object)this, fileName);
                }
                catch (IOException e) {
                    Project project = psiFile.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project, (String)string).showLater();
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> javaFiles2, @NotNull Project project, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing) {
            void externalCodeUpdate;
            void converterResult;
            Intrinsics.checkParameterIsNotNull(javaFiles2, (String)"javaFiles");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0<Unit> $fun$convert$1 = new Function0<Unit>(project, (Ref.ObjectRef)converterResult, javaFiles2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Ref.ObjectRef $converterResult;
                final /* synthetic */ List $javaFiles;

                public final void invoke() {
                    JavaToKotlinConverter converter = JavaToKotlinConverterFactory.INSTANCE.createJavaToKotlinConverter(this.$project, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
                    PostProcessor postProcessor = JavaToKotlinConverterFactory.INSTANCE.createPostProcessor(true);
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    if (progressIndicator == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$converterResult.element = converter.filesToKotlin(this.$javaFiles, postProcessor, progressIndicator);
                }
                {
                    this.$project = project;
                    this.$converterResult = objectRef;
                    this.$javaFiles = list2;
                    super(0);
                }
            };
            Function0 function0 = (Function0)new Function0<Unit>($fun$convert$1){
                final /* synthetic */ convertFiles.1 $convert$1;

                public final void invoke() {
                    this.$convert$1.invoke();
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "convert";
                }

                public final String getSignature() {
                    return "invoke()V";
                }
                {
                    this.$convert$1 = var1_1;
                    super(0);
                }
            };
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)new JavaToKotlinActionKt$sam$java_lang_Runnable$0(function0), this.getTitle(), true, project)) {
                return CollectionsKt.emptyList();
            }
            function0 = new Ref.ObjectRef();
            function0.element = null;
            if (enableExternalCodeProcessing) {
                FilesResult filesResult = (FilesResult)converterResult.element;
                if (filesResult == null) {
                    Intrinsics.throwNpe();
                }
                if (filesResult.getExternalCodeProcessing() != null) {
                    String question = "Some code in the rest of your project may require corrections after performing this conversion. Do you want to find such code and correct it too?";
                    if (!askExternalCodeProcessing || Messages.showYesNoDialog((Project)project, (String)question, (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0) {
                        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Ref.ObjectRef)externalCodeUpdate, (Ref.ObjectRef)converterResult){
                            final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;
                            final /* synthetic */ Ref.ObjectRef $converterResult;

                            public final void run() {
                                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ convertFiles.3 this$0;

                                    public final void invoke() {
                                        Ref.ObjectRef objectRef = this.this$0.$externalCodeUpdate;
                                        FilesResult filesResult = (FilesResult)this.this$0.$converterResult.element;
                                        if (filesResult == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        ExternalCodeProcessing externalCodeProcessing2 = filesResult.getExternalCodeProcessing();
                                        if (externalCodeProcessing2 == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        ProgressManager progressManager = ProgressManager.getInstance();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                                        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                                        if (progressIndicator == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        objectRef.element = externalCodeProcessing2.prepareWriteOperation(progressIndicator);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }
                                });
                            }
                            {
                                this.$externalCodeUpdate = objectRef;
                                this.$converterResult = objectRef2;
                            }
                        }, this.getTitle(), true, project);
                    }
                }
            }
            return (List)ApplicationUtilsKt.executeWriteCommand(project, "Convert files from Java to Kotlin", null, (Function0)new Function0<List<? extends KtFile>>(project, javaFiles2, (Ref.ObjectRef)converterResult, (Ref.ObjectRef)externalCodeUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $javaFiles;
                final /* synthetic */ Ref.ObjectRef $converterResult;
                final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<KtFile> invoke() {
                    void $this$mapTo$iv$iv;
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                    FilesResult filesResult = (FilesResult)this.$converterResult.element;
                    if (filesResult == null) {
                        Intrinsics.throwNpe();
                    }
                    List newFiles = org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.access$saveResults(JavaToKotlinAction.Companion, this.$javaFiles, filesResult.getResults());
                    Function0 function0 = (Function0)this.$externalCodeUpdate.element;
                    if (function0 != null) {
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                    PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                    VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull((List)newFiles);
                    if (virtualFile2 != null) {
                        VirtualFile virtualFile3 = virtualFile2;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile3;
                        boolean bl3 = false;
                        FileEditorManager.getInstance((Project)this.$project).openFile(it, true);
                    }
                    Iterable $this$map$iv = newFiles;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        VirtualFile virtualFile4 = (VirtualFile)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile((VirtualFile)it, this.$project);
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        }
                        KtFile ktFile2 = (KtFile)psiFile;
                        collection.add(ktFile2);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$project = project;
                    this.$javaFiles = list2;
                    this.$converterResult = objectRef;
                    this.$externalCodeUpdate = objectRef2;
                    super(0);
                }
            });
        }

        public static /* synthetic */ List convertFiles$default(Companion companion, List list2, Project project, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            return companion.convertFiles(list2, project, bl, bl2);
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$saveResults(Companion $this, List javaFiles2, List convertedTexts) {
            return $this.saveResults(javaFiles2, convertedTexts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

