/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ide.konan.decompiler;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ide.konan.KotlinNativePluginUtilKt;
import org.jetbrains.kotlin.ide.konan.decompiler.FileWithMetadata;
import org.jetbrains.kotlin.ide.konan.decompiler.KotlinNativeMetadataDecompilerBaseKt;
import org.jetbrains.kotlin.ide.konan.decompiler.KotlinNativeMetadataStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.konan.platform.KonanPlatform;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.konan.NullFlexibleTypeDeserializer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ide/konan/decompiler/KotlinNativeMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/ide/konan/decompiler/FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lkotlin/jvm/functions/Function1;)V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "idea-native"})
public class KotlinNativeMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    private final FileType fileType;
    private final SerializerExtensionProtocol serializerProtocol;
    private final Function1<VirtualFile, FileWithMetadata> readFile;

    public int getStubVersion() {
        return 22 + this.version;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        PsiFileStub<?> psiFileStub;
        FileWithMetadata file2;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile2 = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"content.file");
        VirtualFile virtualFile3 = virtualFile2;
        boolean bl = Intrinsics.areEqual((Object)virtualFile3.getFileType(), (Object)this.fileType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinNativeMetadataStubBuilder$buildFileStub$22 = false;
            String $i$a$-assert-KotlinNativeMetadataStubBuilder$buildFileStub$22 = "Unexpected file type " + virtualFile3.getFileType();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-KotlinNativeMetadataStubBuilder$buildFileStub$22));
        }
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)virtualFile3);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata fileWithMetadata2 = file2 = fileWithMetadata;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            psiFileStub = ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        } else if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            DescriptorRenderer renderer2 = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)buildFileStub.renderer.1.INSTANCE));
            DecompiledText ktFileText = KotlinNativeMetadataDecompilerBaseKt.decompiledText((FileWithMetadata.Compatible)file2, KonanPlatform.INSTANCE, this.serializerProtocol, NullFlexibleTypeDeserializer.INSTANCE, renderer2);
            Project project = content2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"content.project");
            psiFileStub = KotlinNativePluginUtilKt.createFileStub(project, ktFileText.getText());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiFileStub;
    }

    public KotlinNativeMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull SerializerExtensionProtocol serializerProtocol, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        Intrinsics.checkParameterIsNotNull((Object)serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkParameterIsNotNull(readFile, (String)"readFile");
        this.version = version;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }
}

