/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor;", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "arguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Ljava/util/List;)V", "process", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$Result;", "MappingStatus", "Result", "State", "resolve"})
public final class FirCallArgumentsProcessor {
    private final FirFunction function;
    private final List<FirExpression> arguments;

    @NotNull
    public final Result process() {
        State currentState = new State.PositionalOnly(this.function.getValueParameters());
        for (FirExpression argument2 : this.arguments) {
            MappingStatus status2;
            if (argument2 instanceof FirWrappedArgumentExpression) {
                currentState = new State.PositionalThenNamed(this.function.getValueParameters(), currentState.getArgumentMap(), currentState.getUsedParameters());
            }
            if ((status2 = currentState.processArgument(argument2)) == MappingStatus.SUCCESS) continue;
            return new Result(currentState.getArgumentMap(), false);
        }
        for (FirValueParameter valueParameter : this.function.getValueParameters()) {
            if (currentState.getUsedParameters().contains(valueParameter) || valueParameter.isVararg() || valueParameter.getDefaultValue() != null) continue;
            return new Result(currentState.getArgumentMap(), false);
        }
        return new Result(currentState.getArgumentMap(), currentState.getArgumentMap().size() == this.arguments.size());
    }

    public FirCallArgumentsProcessor(@NotNull FirFunction function2, @NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        this.function = function2;
        this.arguments = arguments2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$Result;", "", "argumentMapping", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "isSuccess", "", "(Ljava/util/Map;Z)V", "getArgumentMapping", "()Ljava/util/Map;", "()Z", "resolve"})
    public static final class Result {
        @NotNull
        private final Map<FirExpression, FirValueParameter> argumentMapping;
        private final boolean isSuccess;

        @NotNull
        public final Map<FirExpression, FirValueParameter> getArgumentMapping() {
            return this.argumentMapping;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        public Result(@NotNull Map<FirExpression, ? extends FirValueParameter> argumentMapping, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull(argumentMapping, (String)"argumentMapping");
            this.argumentMapping = argumentMapping;
            this.isSuccess = isSuccess;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$MappingStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "ERROR", "resolve"})
    private static final class MappingStatus
    extends Enum<MappingStatus> {
        public static final /* enum */ MappingStatus SUCCESS;
        public static final /* enum */ MappingStatus ERROR;
        private static final /* synthetic */ MappingStatus[] $VALUES;

        static {
            MappingStatus[] mappingStatusArray = new MappingStatus[2];
            MappingStatus[] mappingStatusArray2 = mappingStatusArray;
            mappingStatusArray[0] = SUCCESS = new MappingStatus();
            mappingStatusArray[1] = ERROR = new MappingStatus();
            $VALUES = mappingStatusArray;
        }

        public static MappingStatus[] values() {
            return (MappingStatus[])$VALUES.clone();
        }

        public static MappingStatus valueOf(String string) {
            return Enum.valueOf(MappingStatus.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B;\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H&R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "", "valueParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "argumentMap", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "usedParameters", "", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Set;)V", "getArgumentMap", "()Ljava/util/Map;", "getUsedParameters", "()Ljava/util/Set;", "getValueParameters", "()Ljava/util/List;", "processArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$MappingStatus;", "argument", "PositionalOnly", "PositionalThenNamed", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State$PositionalOnly;", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State$PositionalThenNamed;", "resolve"})
    private static abstract class State {
        @NotNull
        private final List<FirValueParameter> valueParameters;
        @NotNull
        private final Map<FirExpression, FirValueParameter> argumentMap;
        @NotNull
        private final Set<FirValueParameter> usedParameters;

        @NotNull
        public abstract MappingStatus processArgument(@NotNull FirExpression var1);

        @NotNull
        public final List<FirValueParameter> getValueParameters() {
            return this.valueParameters;
        }

        @NotNull
        public final Map<FirExpression, FirValueParameter> getArgumentMap() {
            return this.argumentMap;
        }

        @NotNull
        public final Set<FirValueParameter> getUsedParameters() {
            return this.usedParameters;
        }

        private State(List<? extends FirValueParameter> valueParameters2, Map<FirExpression, FirValueParameter> argumentMap, Set<FirValueParameter> usedParameters2) {
            this.valueParameters = valueParameters2;
            this.argumentMap = argumentMap;
            this.usedParameters = usedParameters2;
        }

        /* synthetic */ State(List list2, Map map2, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            boolean bl;
            if ((n & 2) != 0) {
                bl = false;
                map2 = new LinkedHashMap();
            }
            if ((n & 4) != 0) {
                bl = false;
                set2 = new LinkedHashSet();
            }
            this(list2, map2, set2);
        }

        public /* synthetic */ State(List valueParameters2, Map argumentMap, Set usedParameters2, DefaultConstructorMarker $constructor_marker) {
            this(valueParameters2, argumentMap, usedParameters2);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State$PositionalOnly;", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "valueParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Ljava/util/List;)V", "currentParameter", "getCurrentParameter", "()Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "currentParameterIndex", "", "getCurrentParameterIndex", "()I", "setCurrentParameterIndex", "(I)V", "nextParameter", "", "processArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$MappingStatus;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolve"})
        public static final class PositionalOnly
        extends State {
            private int currentParameterIndex;

            public final int getCurrentParameterIndex() {
                return this.currentParameterIndex;
            }

            public final void setCurrentParameterIndex(int n) {
                this.currentParameterIndex = n;
            }

            @Nullable
            public final FirValueParameter getCurrentParameter() {
                return (FirValueParameter)CollectionsKt.getOrNull(this.getValueParameters(), (int)this.currentParameterIndex);
            }

            public final void nextParameter() {
                FirValueParameter firValueParameter2 = this.getCurrentParameter();
                if (firValueParameter2 == null) {
                    return;
                }
                FirValueParameter currentParameter = firValueParameter2;
                if (currentParameter.isVararg()) {
                    return;
                }
                Collection collection = this.getUsedParameters();
                boolean bl = false;
                collection.add(currentParameter);
                int n = this.currentParameterIndex;
                this.currentParameterIndex = n + 1;
            }

            @Override
            @NotNull
            public MappingStatus processArgument(@NotNull FirExpression argument2) {
                Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
                boolean bl = !(argument2 instanceof FirNamedArgumentExpression);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Positional-only argument processor state should not receiver " + FirRendererKt.render(argument2);
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                FirValueParameter firValueParameter2 = this.getCurrentParameter();
                if (firValueParameter2 == null) {
                    return MappingStatus.ERROR;
                }
                FirValueParameter currentParameter = firValueParameter2;
                this.getArgumentMap().put(argument2, currentParameter);
                this.nextParameter();
                return MappingStatus.SUCCESS;
            }

            public PositionalOnly(@NotNull List<? extends FirValueParameter> valueParameters2) {
                Intrinsics.checkParameterIsNotNull(valueParameters2, (String)"valueParameters");
                super(valueParameters2, null, null, 6, null);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State$PositionalThenNamed;", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "valueParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "argumentMap", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "usedParameters", "", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Set;)V", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "getNameToParameter", "()Ljava/util/Map;", "map", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$MappingStatus;", "parameter", "argument", "processArgument", "resolve"})
        public static final class PositionalThenNamed
        extends State {
            @NotNull
            private final Map<Name, FirValueParameter> nameToParameter;

            @NotNull
            public final Map<Name, FirValueParameter> getNameToParameter() {
                return this.nameToParameter;
            }

            private final MappingStatus map(FirValueParameter parameter, FirExpression argument2) {
                if (this.getUsedParameters().contains(parameter)) {
                    return MappingStatus.ERROR;
                }
                this.getArgumentMap().put(argument2, parameter);
                Collection collection = this.getUsedParameters();
                boolean bl = false;
                collection.add(parameter);
                return MappingStatus.SUCCESS;
            }

            @Override
            @NotNull
            public MappingStatus processArgument(@NotNull FirExpression argument2) {
                Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
                FirExpression firExpression2 = argument2;
                if (firExpression2 instanceof FirNamedArgumentExpression) {
                    Name name2 = ((FirNamedArgumentExpression)argument2).getName();
                    FirValueParameter firValueParameter2 = this.nameToParameter.get(name2);
                    if (firValueParameter2 == null) {
                        return MappingStatus.ERROR;
                    }
                    FirValueParameter parameter = firValueParameter2;
                    return this.map(parameter, argument2);
                }
                if (firExpression2 instanceof FirLambdaArgumentExpression) {
                    FirValueParameter firValueParameter3 = (FirValueParameter)CollectionsKt.lastOrNull(this.getValueParameters());
                    if (firValueParameter3 == null) {
                        return MappingStatus.ERROR;
                    }
                    FirValueParameter lastParameter = firValueParameter3;
                    return this.map(lastParameter, argument2);
                }
                return MappingStatus.ERROR;
            }

            /*
             * WARNING - void declaration
             */
            public PositionalThenNamed(@NotNull List<? extends FirValueParameter> valueParameters2, @NotNull Map<FirExpression, FirValueParameter> argumentMap, @NotNull Set<FirValueParameter> usedParameters2) {
                Map map2;
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Intrinsics.checkParameterIsNotNull(valueParameters2, (String)"valueParameters");
                Intrinsics.checkParameterIsNotNull(argumentMap, (String)"argumentMap");
                Intrinsics.checkParameterIsNotNull(usedParameters2, (String)"usedParameters");
                super(valueParameters2, argumentMap, usedParameters2, null);
                Iterable iterable = valueParameters2;
                PositionalThenNamed positionalThenNamed = this;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var7_8 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    FirValueParameter firValueParameter2 = (FirValueParameter)element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    Name name2 = it.getName();
                    map2.put(name2, element$iv$iv);
                }
                positionalThenNamed.nameToParameter = map2 = destination$iv$iv;
            }
        }
    }
}

