/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.HistoryUpdateListener;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0013J\u0011\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\fH\u0086\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u00020\b`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "Lkotlin/collections/ArrayList;", "listeners", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "getListeners", "()Ljava/util/ArrayList;", "<set-?>", "", "processedEntriesCount", "getProcessedEntriesCount", "()I", "size", "getSize", "addEntry", "", "entry", "entryProcessed", "get", "i", "lastUnprocessedEntry", "Entry", "idea"})
public final class CommandHistory {
    private final ArrayList<Entry> entries;
    private int processedEntriesCount;
    @NotNull
    private final ArrayList<HistoryUpdateListener> listeners;

    public final int getProcessedEntriesCount() {
        return this.processedEntriesCount;
    }

    @NotNull
    public final ArrayList<HistoryUpdateListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Entry get(int i2) {
        Entry entry = this.entries.get(i2);
        Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"entries[i]");
        return entry;
    }

    public final void addEntry(@NotNull Entry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        this.entries.add(entry);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistoryUpdateListener it = (HistoryUpdateListener)element$iv;
            boolean bl = false;
            it.onNewEntry(entry);
        }
    }

    @Nullable
    public final Entry lastUnprocessedEntry() {
        return this.processedEntriesCount < this.getSize() ? this.get(this.processedEntriesCount) : null;
    }

    public final void entryProcessed() {
        int n = this.processedEntriesCount;
        this.processedEntriesCount = n + 1;
    }

    public final int getSize() {
        return this.entries.size();
    }

    public CommandHistory() {
        CommandHistory commandHistory = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        commandHistory.entries = arrayList;
        commandHistory = this;
        bl = false;
        arrayList = new ArrayList();
        commandHistory.listeners = arrayList;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "", "entryText", "", "rangeInHistoryDocument", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getEntryText", "()Ljava/lang/String;", "getRangeInHistoryDocument", "()Lcom/intellij/openapi/util/TextRange;", "idea"})
    public static final class Entry {
        @NotNull
        private final String entryText;
        @NotNull
        private final TextRange rangeInHistoryDocument;

        @NotNull
        public final String getEntryText() {
            return this.entryText;
        }

        @NotNull
        public final TextRange getRangeInHistoryDocument() {
            return this.rangeInHistoryDocument;
        }

        public Entry(@NotNull String entryText, @NotNull TextRange rangeInHistoryDocument) {
            Intrinsics.checkParameterIsNotNull((Object)entryText, (String)"entryText");
            Intrinsics.checkParameterIsNotNull((Object)rangeInHistoryDocument, (String)"rangeInHistoryDocument");
            this.entryText = entryText;
            this.rangeInHistoryDocument = rangeInHistoryDocument;
        }
    }
}

