/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\tJ\b\u0010 \u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\tJ\u0010\u0010%\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u000e\u0010&\u001a\u00020$2\u0006\u0010\"\u001a\u00020\tJ\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u000fH\u0002R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "allocatedHandles", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "Lkotlin/collections/HashMap;", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "initialMaxLocals", "", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "allocateNewHandle", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreStackMarkers", "saveStackMarker", "savedStackValues", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "allocateVariablesForBeforeInlineMarker", "beforeInlineMarker", "allocateVariablesForSaveStackMarker", "createReturnValueVariable", "returnValue", "getBeforeInlineDescriptor", "afterInlineMarker", "getFirstUnusedLocalVariableIndex", "getSavedStackDescriptor", "restoreStackMarker", "markAfterInlineMarkerEmitted", "", "markEmitted", "markRestoreStackMarkerEmitted", "updateMaxLocals", "newValue", "AllocatedHandle", "backend"})
public final class LocalVariablesManager {
    private final int initialMaxLocals;
    private final HashMap<AbstractInsnNode, AllocatedHandle> allocatedHandles;
    @NotNull
    private final FixStackContext context;
    @NotNull
    private final MethodNode methodNode;

    private final void updateMaxLocals(int newValue) {
        int n;
        int n2 = this.methodNode.maxLocals;
        MethodNode methodNode = this.methodNode;
        boolean bl = false;
        methodNode.maxLocals = n = Math.max(n2, newValue);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForSaveStackMarker(@NotNull AbstractInsnNode saveStackMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull((Object)saveStackMarker, (String)"saveStackMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, (String)"savedStackValues");
        List<AbstractInsnNode> list2 = this.context.getRestoreStackMarkersForSaveMarker().get(saveStackMarker);
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        int numRestoreStackMarkers = list2.size();
        return this.allocateNewHandle(numRestoreStackMarkers, saveStackMarker, savedStackValues);
    }

    private final SavedStackDescriptor allocateNewHandle(int numRestoreStackMarkers, AbstractInsnNode saveStackMarker, List<? extends BasicValue> savedStackValues) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = savedStackValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BasicValue it = (BasicValue)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)((Object)new AssertionError((Object)("Uninitialized value on stack at " + this.methodNode.instructions.indexOf(saveStackMarker))));
        }
        int firstUnusedLocalVarIndex = this.getFirstUnusedLocalVariableIndex();
        SavedStackDescriptor savedStackDescriptor = new SavedStackDescriptor(savedStackValues, firstUnusedLocalVarIndex);
        this.updateMaxLocals(savedStackDescriptor.getFirstUnusedLocalVarIndex());
        AllocatedHandle allocatedHandle = new AllocatedHandle(savedStackDescriptor, numRestoreStackMarkers);
        ((Map)this.allocatedHandles).put(saveStackMarker, allocatedHandle);
        return savedStackDescriptor;
    }

    @NotNull
    public final SavedStackDescriptor getSavedStackDescriptor(@NotNull AbstractInsnNode restoreStackMarker) {
        Intrinsics.checkParameterIsNotNull((Object)restoreStackMarker, (String)"restoreStackMarker");
        AbstractInsnNode saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        Map map2 = this.allocatedHandles;
        boolean bl = false;
        Object v = map2.get(saveStackMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    private final int getFirstUnusedLocalVariableIndex() {
        void $this$fold$iv;
        Collection<AllocatedHandle> collection = this.allocatedHandles.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"allocatedHandles.values");
        Iterable iterable = collection;
        int initial$iv = this.initialMaxLocals;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void handle2;
            AllocatedHandle allocatedHandle = (AllocatedHandle)element$iv;
            int index2 = accumulator$iv;
            boolean bl = false;
            int n = handle2.getSavedStackDescriptor().getFirstUnusedLocalVarIndex();
            boolean bl2 = false;
            accumulator$iv = Math.max(index2, n);
        }
        return accumulator$iv;
    }

    public final void markRestoreStackMarkerEmitted(@NotNull AbstractInsnNode restoreStackMarker) {
        AbstractInsnNode saveStackMarker;
        Intrinsics.checkParameterIsNotNull((Object)restoreStackMarker, (String)"restoreStackMarker");
        AbstractInsnNode abstractInsnNode = saveStackMarker = this.context.getSaveStackMarkerForRestoreMarker().get(restoreStackMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        this.markEmitted(abstractInsnNode);
    }

    @NotNull
    public final SavedStackDescriptor allocateVariablesForBeforeInlineMarker(@NotNull AbstractInsnNode beforeInlineMarker, @NotNull List<? extends BasicValue> savedStackValues) {
        Intrinsics.checkParameterIsNotNull((Object)beforeInlineMarker, (String)"beforeInlineMarker");
        Intrinsics.checkParameterIsNotNull(savedStackValues, (String)"savedStackValues");
        return this.allocateNewHandle(1, beforeInlineMarker, savedStackValues);
    }

    @NotNull
    public final SavedStackDescriptor getBeforeInlineDescriptor(@NotNull AbstractInsnNode afterInlineMarker) {
        Intrinsics.checkParameterIsNotNull((Object)afterInlineMarker, (String)"afterInlineMarker");
        AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        Map map2 = this.allocatedHandles;
        boolean bl = false;
        Object v = map2.get(beforeInlineMarker);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return ((AllocatedHandle)v).getSavedStackDescriptor();
    }

    public final void markAfterInlineMarkerEmitted(@NotNull AbstractInsnNode afterInlineMarker) {
        AbstractInsnNode beforeInlineMarker;
        Intrinsics.checkParameterIsNotNull((Object)afterInlineMarker, (String)"afterInlineMarker");
        AbstractInsnNode abstractInsnNode = beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(afterInlineMarker);
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        this.markEmitted(abstractInsnNode);
    }

    private final void markEmitted(AbstractInsnNode saveStackMarker) {
        AllocatedHandle allocatedHandle = this.allocatedHandles.get(saveStackMarker);
        if (allocatedHandle == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)allocatedHandle, (String)"allocatedHandles[saveStackMarker]!!");
        AllocatedHandle allocatedHandle2 = allocatedHandle;
        allocatedHandle2.markRestoreNodeEmitted();
        if (allocatedHandle2.isFullyEmitted()) {
            this.allocatedHandles.remove(saveStackMarker);
        }
    }

    public final int createReturnValueVariable(@NotNull BasicValue returnValue) {
        Intrinsics.checkParameterIsNotNull((Object)returnValue, (String)"returnValue");
        int returnValueIndex = this.getFirstUnusedLocalVariableIndex();
        this.updateMaxLocals(returnValueIndex + returnValue.getSize());
        return returnValueIndex;
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public LocalVariablesManager(@NotNull FixStackContext context2, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        this.context = context2;
        this.methodNode = methodNode;
        this.initialMaxLocals = this.methodNode.maxLocals;
        LocalVariablesManager localVariablesManager = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        localVariablesManager.allocatedHandles = hashMap;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager$AllocatedHandle;", "", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "numRestoreMarkers", "", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;I)V", "getNumRestoreMarkers", "()I", "setNumRestoreMarkers", "(I)V", "getSavedStackDescriptor", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "isFullyEmitted", "", "markRestoreNodeEmitted", "", "backend"})
    private static final class AllocatedHandle {
        @NotNull
        private final SavedStackDescriptor savedStackDescriptor;
        private int numRestoreMarkers;

        public final boolean isFullyEmitted() {
            return this.numRestoreMarkers == 0;
        }

        public final void markRestoreNodeEmitted() {
            int n = this.numRestoreMarkers > 0 ? 1 : 0;
            boolean bl = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl2 = false;
                String string = "Emitted more restore markers than expected for " + this.savedStackDescriptor;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = this.numRestoreMarkers;
            this.numRestoreMarkers = n + -1;
        }

        @NotNull
        public final SavedStackDescriptor getSavedStackDescriptor() {
            return this.savedStackDescriptor;
        }

        public final int getNumRestoreMarkers() {
            return this.numRestoreMarkers;
        }

        public final void setNumRestoreMarkers(int n) {
            this.numRestoreMarkers = n;
        }

        public AllocatedHandle(@NotNull SavedStackDescriptor savedStackDescriptor, int numRestoreMarkers) {
            Intrinsics.checkParameterIsNotNull((Object)savedStackDescriptor, (String)"savedStackDescriptor");
            this.savedStackDescriptor = savedStackDescriptor;
            this.numRestoreMarkers = numRestoreMarkers;
        }
    }
}

